c
c       
      subroutine x_txt2r1 (xval,
     +                     line,
     +                     abort)    
c
c action: read a double precision number off line
c author: w.g.bardsley, university of manchester, u.k., 27/10/2010
c         11/08/2011 added facility to strip out blanks
c     
      implicit none
c
c arguments
c      
      double precision,    intent (inout) :: xval
      character (len = *), intent (inout) :: line
      logical,             intent (out)   :: abort
c
c locals
c      
      integer    i, ios, itemp, j, k, l, num_dot, num_e
      double precision xtemp
      character (len = 25) copy_25
      character (len = 1 ) letter
      character (len = 1 ) blank, comma, dot, minus, plus
      parameter (blank = ' ', comma = ',', dot = '.',
     +           minus = '-', plus = '+')      
      intrinsic  adjustl, dble, ichar, index
c
c initialise, check for blank line, then make a left justified copy 
c      
      abort = .true.
      if (line.eq.blank) return
      copy_25 = line
      copy_25 = adjustl(copy_25)
      k = len_trim(copy_25)
      
c
c check singular case with just one character
c     
      if (k.eq.1) then
         letter = copy_25(1:1)
         l = ichar(letter)
         if (l.lt.48 .or. l.gt.57) return
         read (letter,'(i1)',iostat=ios) itemp
         if (ios.eq.0) then
            abort = .false.
            xval = dble(itemp)
            line = copy_25
         endif  
         return    
      endif
c
c strip out intermediate blanks
c      
      j = index(copy_25(1:k),blank)
      do while (j.gt.1)
         do i = j, k - 1
            copy_25(i:i) = copy_25(i + 1:i + 1)
         enddo
         copy_25(k:k) = blank
         k = len_trim(copy_25)
         j = index(copy_25(1:k),blank)  
      enddo
c
c replace single comma then check if there are any more
c             
      j = index(copy_25,comma)
      if (j.gt.0) then
         copy_25(j:j) = dot
         j = index(copy_25,comma)
         if (j.gt.0) return  
      endif     
c
c check for non-integer characters
c
      num_dot = 0
      num_e = 0
      j = 0
      do while (j.lt.k)
         j = j + 1
         letter = copy_25(j:j)
         if (letter.eq.dot) then
            num_dot = num_dot + 1
         elseif (letter.eq.'e' .or. letter.eq.'E' .or.
     +           letter.eq.'d' .or. letter.eq.'D') then
            num_e = num_e + 1
         endif  
         if (num_dot.gt.1 .or. num_e.gt.1) return    
      enddo 
c
c check individual characters
c      
      j = 0   
      do while (j.lt.k)
         j = j + 1
         letter = copy_25(j:j)
         l = ichar(letter)
         if (j.eq.1) then
            if (letter.eq.plus .or. letter.eq.minus) then
               letter = copy_25(2:2)
               if (letter.eq.'0') then
                  if(num_dot.eq.0 .or. k.eq.2) return
                  letter = copy_25(3:3)
                  if (letter.ne.dot) return
               endif   
            elseif (l.eq.48) then
               if (num_dot.eq.0) return 
               letter = copy_25(2:2)
               if (letter.ne.dot) return     
            elseif (l.lt.48 .or. l.gt.57) then
               if (letter.ne.dot) return
            endif
         else
            if (letter.eq.'e' .or. letter.eq.'E' .or.
     +          letter.eq.'d' .or. letter.eq.'D') then
               if (j.eq.k) return 
            elseif (letter.eq.minus .or. letter.eq.plus) then 
               if (j.eq.k) return  
               letter = copy_25(j - 1:j - 1)   
               if (letter.ne.'e' .and. letter.ne.'E' .and.
     +             letter.ne.'d' .and. letter.ne.'D') return                                          
            elseif (l.lt.48 .or. l.gt.57) then
               if (letter.ne.dot) return
            endif   
         endif
      enddo  
      read (copy_25,*,iostat=ios) xtemp
      if (ios.eq.0) then
         abort = .false.
         xval = xtemp
         line = copy_25
      endif
      end
c
c      