c
c
      subroutine x_txtcfg (nfsize, nxwide, nyhigh,
     +                     font,
     +                     store)
      use module_clearwin, only : eb_editor, eb_viewer, refresh_eb 
      implicit none
      include <windows.ins>
c
c action: configure the Simfit text editor
c author: w.g.bardsley, university of manchester, u.k., 18/06/2020
c         08/07/2020 set refresh_eb = .true. if  new_file = .true.
c         18/02/2021 changed defaults from 90, 26 to 100 columns and 30 rows
c
      
c
c arguments
c     
      integer,             intent (out) :: nfsize, nxwide, nyhigh  
      character (len = *), intent (out) :: font
      logical,             intent (in)  :: store  
c
c locals
c      
      integer i, icount, ios, j, l, ntemp, nunit                
      integer nfsize_sav, nxwide_sav, nyhigh_sav
      
      integer nmax
      parameter (nmax = 20)
      integer numopt, numtxt
      integer icolor, ixl, iyl, lshade, numsta
      parameter (icolor = 7, ixl = 0, iyl = 0, lshade = 0)
      integer numbld(nmax), numpos(nmax) 
      integer kvalue(nmax)
      integer kvlim_1(nmax), kvlim_2(nmax)
      
      double precision zero, five
      parameter (zero = 0.0d+00, five = 5.0d+00) 
      double precision xvalue(nmax)
      
      character (len = 1024) path
      character (len = 100 ) line
      character (len = 14  ) font_sav, temp

      character (len = 100) text_in(nmax)  
      character (len = 100) svalue(nmax)
      character (len = 1  ) blank
      parameter (blank = ' ')
      
      logical first, new_file, there 

      logical fixed, full, high
      parameter (fixed = .false., full = .false., high = .true.)
      
      external w_v7path, w_getnou, x_putadv, w_get00x
        
      data nfsize_sav, nxwide_sav, nyhigh_sav / 12, 100, 30 /
      data font_sav /  'Courier New' /
      data first / .true. / 
      data path / ' ' /
c      
c initialise
c         
      font = font_sav
      nfsize = nfsize_sav
      nxwide = nxwide_sav
      nyhigh = nyhigh_sav
      refresh_eb = .false.
      
      if (first) then
c
c the special case first = .true.
c        
         first = .false.
         call w_v7path (l,
     +                  'cfg', path)
         if (path(l:l).ne.'\') then
            l = l + 1
            path(l:l) = '\'
         endif
         l = l + 1
         path(l:l + 11) = 'w_txtcfg.cfg'
         inquire (file = path, exist = there, iostat = ios)
         if (.not.there) then   
c
c create the missing file w_txtcfg
c           
            call w_getnou (nunit)
            open (unit = nunit, file = path, iostat = ios)
            write (nunit,200,iostat=ios) font_sav, nfsize_sav,
     +                                   nxwide_sav, nyhigh_sav
            close (unit = nunit)
         endif 
      endif   
c
c initialise using the file w_txtcfg.cfg if it exists either new or pre-existing
c          
      inquire (file = path, exist = there, iostat = ios)
      if (there) then
         j = 0
         call w_getnou (nunit)
         open (unit = nunit, file = path, iostat = ios)
         if (ios.eq.0) read (nunit,'(a)',iostat = ios) temp
         if (ios.eq.0) then
            j = j + 1
            font_sav = temp
         endif   
         if (ios.eq.0) read (nunit,*,iostat = ios) ntemp
         if (ios.eq.0) then
            j = j + 1
            nfsize_sav = ntemp
         endif   
         if (ios.eq.0) read (nunit,*,iostat = ios) ntemp
         if (ios.eq.0) then
            j = j + 1
            nxwide_sav = ntemp 
         endif   
         if (ios.eq.0) read (nunit,*,iostat = ios) ntemp
         if (ios.eq.0) then
            j = j + 1
            nyhigh_sav = ntemp
         endif   
         close (unit = nunit)  
         if (ios.ne.0) then
            write (line,100) j
            call x_putadv (line)
            return
         endif 
         close (unit = nunit)
      endif  
      if (.not.store) then
c
c use the current saved parameters then return
c        
          font = font_sav
          nfsize = nfsize_sav
          nxwide = nxwide_sav
          nyhigh = nyhigh_sav
          return
      endif 
c
c otherwise intialise data for the call to w_get00x
c 
      do i = 1, nmax
         numbld(i) = 0
         numpos(i) = 0 
         kvalue(i) = 0
         kvlim_1(i) = -1
         kvlim_2(i) = 1
         xvalue(i) = zero
         text_in(i) = blank 
         svalue(i) = blank
      enddo
        
      icount = 1
      text_in(icount) = 
     +'Configuring the Simfit text editor' 
      numbld(icount) = 4
      numpos(icount) = 8
      
      icount = icount + 1
      text_in(icount) = blank
      numpos(icount) = 8
c
c setup the font selection details then print a blank line
c      
      icount = icount + 1
      text_in(icount) = 'Consolas'
      numpos(icount) = 6
      if (font_sav.eq.text_in(icount)) kvalue(icount) = 1
      
      icount = icount + 1
      text_in(icount) = 'Courier New'
      numpos(icount) = 6
      if (font_sav.eq.text_in(icount)) kvalue(icount) = 1
      
      icount = icount + 1
      text_in(icount) = 'Lucida Console' 
      numpos(icount) = 6
      if (font_sav.eq.text_in(icount)) kvalue(icount) = 1

      icount = icount + 1
      text_in(icount) = blank
      numpos(icount) = 8
c
c setup the font size details then print a blank line
c
      icount = icount + 1
      text_in(icount) = 'Text size (Default = 12)'
      kvlim_1(icount) = 8
      kvlim_2(icount) = 16
      numpos(icount) = 9
      kvalue(icount) = 12
      do i = kvlim_1(icount), kvlim_2(icount)
        if (i.eq.nfsize_sav) then
           kvalue(icount) = i
           exit
        endif   
      enddo    

      icount = icount + 1
      text_in(icount) = blank
      numpos(icount) = 8
c
c setup up the number of rows details then print a blank line
c
      icount = icount + 1
      text_in(icount) = 'Number of rows (Default = 30)'
      kvlim_1(icount) = 18
      kvlim_2(icount) = 40
      numpos(icount) = 10
      xvalue(icount) = 2.0d+00
      kvalue(icount) = 30
      do i = kvlim_1(icount), kvlim_2(icount), 2
        if (i.eq.nyhigh_sav) then
           kvalue(icount) = i
           exit
        endif   
      enddo 

      icount = icount + 1
      text_in(icount) = blank
      numpos(icount) = 8
c
c setup the number of column details then print a blank line
c
      icount = icount + 1
      text_in(icount) = 'Number of columns (Default = 100)'
      kvlim_1(icount) = 70
      kvlim_2(icount) = 140
      numpos(icount) = 10
      xvalue(icount) = five
      kvalue(icount) = 100
      do i = kvlim_1(icount), kvlim_2(icount), 5
        if (i.eq.nxwide_sav) then
           kvalue(icount) = i
           exit
        endif   
      enddo 

      icount = icount + 1
      text_in(icount) = blank
      numpos(icount) = 8
c
c add closing text
c      
      icount = icount + 1
      text_in(icount) = 
     +'Simfit uses the editor to view test/results files or'
     +//' to create user-defined models.'
      numpos(icount) = 8
       
      icount = icount + 1
      text_in(icount) = 
     +'The appearance can be adjusted if required by changing the'
     +//' above values.' 
      numpos(icount) = 8 
      

      numtxt = icount
      numsta = 1
      numopt = icount
      
      call w_get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +               lshade, numbld, numopt, numpos, numsta,
     +               numtxt,
     +               xvalue,
     +               svalue, text_in,
     +               fixed, full, high)
c
c check out the ganged group
c     
      new_file = .false.
      do i = 3, 5
         if (kvalue(i).eq.1) then
            if (font_sav.ne.text_in(i)) then
               new_file = .true.
               font_sav = text_in(i)(1:14)
            endif  
         endif    
      enddo
c
c check out the font size
c      
      if (nfsize_sav.ne.kvalue(7)) then
         new_file = .true.
         nfsize_sav = kvalue(7)
      endif   
c
c check out the rows
c      
      if (nyhigh_sav.ne.kvalue(9)) then
         new_file = .true.
         nyhigh_sav = kvalue(9)
      endif   
c
c check out the columns
c      
      if (nxwide_sav.ne.kvalue(11)) then
         new_file = .true.
         nxwide_sav = kvalue(11)
      endif  
c
c create a new configuration file if required and set refresh_eb = .true. 
c   
      if (new_file) then
         call w_getnou(nunit)
         open (unit = nunit, file = path, iostat=ios)
         if (ios.eq.0) write (nunit,200,iostat=ios) font_sav,
     +nfsize_sav, nxwide_sav, nyhigh_sav 
         close (unit = nunit)
c
c this next code can be edited to allow extension to subroutines other than w_edittx and w_viewer if required
c the calls to temporary_yield@ may not be necessary but seem to be required maybe because of the close (unit = nunit)
c       
         call temporary_yield@() 
         if (eb_editor) then
            refresh_eb = .true.
         elseif (eb_viewer)  then
            refresh_eb = .true.
         endif   
         call temporary_yield@()
      else
         refresh_eb = .false.
      endif     
c  
c format statements
c 
  100 format ('W_TXTCFG cannot read w_txtcfg.cfg at line',i2)
  200 format (
     +a                 
     +/i3
     +/i3
     +/i3
     +/
     +/
     +/
     +/
     +/'Meaning of the parameters to be used by the Simfit text editor'
     +/'=============================================================='
     +/'Line 1: Fixed font, Default = Courier New'   
     +/'Line 2: Font size, Default = 11'   
     +/'Line 3: Number of columns of characters, Default = 100'   
     +/'Line 4: Number of rows of characters, Default = 30')  
      end
c
c
