c
c
      subroutine x_vutext (isend)
c
c action: view/print simfit ASCII text files
c author: w.g.bardsley, university of manchester, u.k., 11/10/2004
c         29/11/2006 added call to simdir to set the path
c         19/01/2006 checked before using simfit prefix 
c         29/01/2007 derived from vutext 
c         15/07/2007 edited for version 6
c         20/01/2011 added calls to help_install and help_config
c
c         isend: (input/unchanged) as follows:
c                 isend = 0: use menu for first choice
c                 isend = 1: readme files
c                 isend = 2: test data files
c                 isend = 3: library files
c                 isend = 4: user-defined models
c                 isend = 5: differential equations
c                 isend = 6: parameter limits files
c                 isend = 7: configuration files
c                 isend = 8: arbitrary text files
c                 isend = 9: installation
c                 isend = 10: configuration
c
      implicit none
c
c arguments
c
      integer, intent (in) :: isend
c
c locals
c
      integer    icolor, ix, iy, lshade, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 29,
     +           numtxt = 21)
      integer    numbld(numtxt) 
      integer    ksend, n, ntext
      parameter (ksend = 3, n = 2, ntext = 2)
      integer    igoto(10), kvalue(n)
      integer    icount, jsend, l, numdec 
      double precision xvalue(n)
      character  fname*1024, path*1024, pattern*100, text(40)*100
      character  path_cfg*1024, path_dem*1024, path_doc*1024,
     +           path_res*1024, path_sim*1024
      character  query(2)*100, wcard*20, wpath*1024, x_sim256*1024 
      character  svalue(n)*1024
      logical    first, repeet
      logical    border, titles
      parameter (border = .false., titles = .true.)
      external   x_lview2, w_patch1, w_viewer, x_getany, x_simdir, 
     +           x_demdir, x_docdir, x_resdir, x_readme, x_cfgdir,
     +           x_sim256 
      external   help_install, help_config
      save       first, wcard, wpath
      data       first / .true. /
      data       igoto / 2, 4, 17, 18, 21, 22, 23, 24, 25, 26 /
      data       numbld / numtxt*0 /
      data       wcard / 'kmeans.*' /
c
c check isend
c
      if (isend.lt.0 .or. isend.gt.10) return
c
c get the simfit directories (with backslash) 
c                                         
      call x_simdir (l,
     +               path_sim) 
      call x_docdir (l,
     +               path_doc)
      call x_demdir (l,
     +               path_dem) 
      call x_resdir (l,
     +               path_res) 
      call x_cfgdir (l,
     +               path_cfg)      
      if (first) then
          first = .false.
          wpath = path_res
      endif    
           
c
c main loop
c
      icount = 0
      repeet = .true.
      do while (repeet)
         if (isend.eq.4 .and. icount.eq.1) then
c
c special action to view *.mod after usermod?.tf?
c
            numdec = 19
         elseif (isend.eq.0 .or. icount.gt.0) then
c
c provide menu options
c
            write (text,100) wcard
            numdec = numopt - 1
            call x_lview2 (ix, iy, numdec, numopt,
     +                     text,
     +                     titles)
            if (numdec.eq.numopt) return
         else
c
c shortcut first time if called with isend not equal to 0
c
            numdec = igoto(isend)
         endif
         if (numdec.lt.numopt - 1) icount = icount + 1
         if (numdec.eq.1) then
c
c index of readme files
c
            jsend = 1
            fname = x_sim256('w_readme.0')
            path = path_doc
         elseif (numdec.eq.2) then
c
c browse readme files
c
            call x_readme
         elseif (numdec.eq.3) then
c
c index of test files
c
            jsend = 1
            fname = x_sim256('w_readme.f4')
            path = path_doc
         elseif (numdec.eq.4) then
c
c browse test files
c
            jsend = 2
            pattern = '*.tf?'
            path = path_dem
         elseif (numdec.eq.5) then
c
c browse test files ... vector
c
            jsend = 2
            pattern = 'vector.*'
            path = path_dem
         elseif (numdec.eq.6) then
c
c browse test files ... matrix
c
            jsend = 2
            pattern = 'matrix.*'
            path = path_dem
         elseif (numdec.eq.7) then
c
c browse test files ... curve fit
c
            jsend = 2
            pattern = 'exfit.tf?'
            path = path_dem
         elseif (numdec.eq.8) then
c
c browse test files ... anova
c
            jsend = 2
            pattern = 'anova?.*'
            path = path_dem
         elseif (numdec.eq.9) then
c
c browse test files ... manova
c
            jsend = 2
            pattern = 'manova?.*'
            path = path_dem
         elseif (numdec.eq.10) then
c
c browse test files ... glm
c
            jsend = 2
            pattern = 'glm.*'
            path = path_dem
         elseif (numdec.eq.11) then
c
c browse test files ... binomial
c
            jsend = 2
            pattern = 'binomial.tf?'
            path = path_dem
         elseif (numdec.eq.12) then
c
c browse test files ... meta analysis
c
            jsend = 2
            pattern = 'meta.*'
            path = path_dem
         elseif (numdec.eq.13) then
c
c browse test files ... survival analysis
c
            jsend = 2
            pattern = 'survive.*'
            path = path_dem
         elseif (numdec.eq.14) then
c
c browse test files ... regression
c
            jsend = 2
            pattern = 'linfit.tf?'
            path = path_dem
         elseif (numdec.eq.15) then
c
c browse test files ... regression
c
            jsend = 2
            pattern = 'ld50.*'
            path = path_dem
         elseif (numdec.eq.16) then
c
c browse test files ... regression
c
            jsend = 2
            pattern = 'cluster.*'
            path = path_dem
         elseif (numdec.eq.17) then
c
c browse library files
c
            jsend = 2
            pattern = '*.tfl'
            path = path_dem
         elseif (numdec.eq.18) then
c
c browse user-defined models of type usermod?_e*.tf?
c
            jsend = 2
            pattern = 'usermod?_e.tf?'
            path = path_dem
         elseif (numdec.eq.19) then
c
c browse user-defined models of type *_e.mod
c
            jsend = 2
            pattern = '*_e.mod'
            path = path_dem
         elseif (numdec.eq.20) then
c
c view commands.txt
c
            jsend = 1
            fname = x_sim256('commands.txt')
            path = path_doc
         elseif (numdec.eq.21) then
c
c browse differential equations
c
            jsend = 2
            pattern = 'deq????.tf?'
            path = path_dem
         elseif (numdec.eq.22) then
c
c browse parameter limits files
c
            jsend = 2
            pattern = '*.plf'
            path = path_dem
         elseif (numdec.eq.23) then
c
c browse configuration files
c
            jsend = 2
            pattern = '*.cfg'
            path = path_cfg
         elseif (numdec.eq.24) then
c
c browse text files
c
            jsend = 2
            pattern = '*.txt'
            path = path_doc
         elseif (numdec.eq.25) then
c
c installation
c
            call help_install ('install')
         elseif (numdec.eq.26) then
c
c configuration
c
            call help_config ('config')
         elseif (numdec.eq.27) then
c
c user defined wild card
c
            write (query,200) 
            svalue(1) = wcard(1:20)
            svalue(2) = wpath(1:20)
            call x_getany (ksend, kvalue, n, ntext,
     +                     xvalue,
     +                     svalue, query)
            wcard = svalue(1)(1:20)
            wpath = svalue(2)(1:20)            
            jsend = 2
            pattern = wcard
            path = wpath
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,300)
            numbld(1) = 1
            numbld(10) = 1
            numbld(13) = 1
            numbld(17) = 1
            numbld(19) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                     text,
     +                     border)
         endif
c
c call viewer to browse/print
c
         if (numdec.lt.numopt - 1 .and. numdec.ne.2 .and. 
     +       numdec.ne.25 .and. numdec.ne.26) call w_viewer (jsend,
     +                                        fname, path, pattern)
         if (isend.eq.4 .and. icount.eq.1) then
            repeet = .true.
         elseif (isend.ne.0) then
            repeet = .false.
         endif
      enddo                 
c
c format statements
c      
  100 format (
     + 'Simfit ASCII text file types `Wild cards'    !0 = heading
     +/'Readme files [Index]         `w_readme.0'    !1
     +/'Readme files [Browse]        `w_readme.*'    !2
     +/'Test data [Index]            `w_readme.f4'   !3
     +/'Test data [Browse]           `*.tf?'         !4
     +/'Test data [Vector]           `vector.*'      !5
     +/'Test data [Matrix]           `matrix.*'      !6
     +/'Test data [Curve fit]        `exfit.tf?'     !7
     +/'Test data [ANOVA]            `anova?.*'      !8
     +/'Test data [MANOVA]           `manova?.*'     !9
     +/'Test data [GLM]              `glm.*'         !10
     +/'Test data [Proportions]      `binomial.tf?'  !11
     +/'Test data [Meta Analysis]    `meta.*'        !12
     +/'Test data [Survival analysis]`survive.*'     !13
     +/'Test data [Regression]       `linfit.tf?'    !14
     +/'Test data [LD50]             `ld50.*'        !15
     +/'Test data [Cluster analysis] `cluster.*'     !16
     +/'Library files                `*.tfl'         !17
     +/'User defined models (1)      `usermod?*.tf?' !18
     +/'User defined models (2)      `*.mod'         !19 
     +/'User defined models (3)      `commands.txt'  !20
     +/'Differential equations       `deq???.tf?'    !21
     +/'Parameter limits files       `*.plf'         !22
     +/'Configuration files          `*.cfg'         !23
     +/'Miscellaneous text files     `*.txt'         !24
     +/'Installation details         `install.txt'   !25
     +/'Configuration details        `configure.txt' !26
     +/'You choose wild card         `',a            !27
     +/'Help                         `...'           !28
     +/'Quit                         `Exit file viewing') !29
  200 format (
     + 'Wildcard required, e.g., plots.*, *.txt, etc.'
     +/'Path required, e.g., c:\my_plots, \my_files, etc.')
  300 format (
     + 'Simfit ASCII text files'
     +/
     +/'The main source for help is the reference manual which contains'
     +/'worked examples for all Simfit procedures, using test data sets'
     +/'and examples of user-defined models. More condensed help can be'
     +/'found from the Simfit help program, tutorials for each program,'
     +/'and from dedicated help pages selected from individual menus.'
     +/
     +/'Additional information can be found from text files as follows.'
     +/'Readme files'
     +/'These contain both summaries and notes on advanced techniques.'
     +/'The index to these readme files is in the file w_readme.0.'
     +/'Test data'
     +/'Browse these to observe details of data formatting. The index'
     +/'to all test data, library files, user-defined models, parameter'
     +/'limits, and configuration files is in the file w_readme.f4.'
     +/'Library files'
     +/'These define collections of files for fitting, plotting, etc.'
     +/'User defined models'
     +/'The related readme files and examples must be consulted before'
     +/'attempting to write your own models.')
      end
c
c
