C 
C                                          
      DOUBLE PRECISION FUNCTION X_WGBCFG(ISEND)
C
C ACTION: Communicate PS parameters to the graph plotting routines
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 21/02/2000
C         31/10/2000 edited to create w_ps.cfg if missing 
C         23/04/2007 added INTENTS
C         20/10/2013 IDEV now sets windows line width
C
C This must be identical functionally to WGBCF$ in w_graphics.dll
C 
C   NOTE: this function reads values off w_ps.cfg and returns
C         stored values. It creates a default w_ps.cfg.
C
C         ISEND = K: Return argument number K from W_PS.CFG
C
C         ISEND = 0: Try to read arguments off W_PS.CFG
C         ISEND = 1: IDEV ... Windows line thickness
C         ISEND = 2: IVAL
C         ISEND = 3: THICK ... Postscript line thickness
C         ISEND = 4: SIZE
C         ISEND = 5: XOFF PORTAIT
C         ISEND = 6: YOFF PORTRAIT
C         ISEND = 7: SCALE PORTRAIT
C         ISEND = 8: XOFF LANDSCAPE
C         ISEND = 9: YOFF LANDSCAPE
C         ISEND = 10: SCALE LANDSCAPE
C         ISEND = 11: NFONT
C         ISEND = 12: NCOLOR
C
      IMPLICIT   NONE
C
C Argument
C
      INTEGER, INTENT (IN) :: ISEND
C
C Locals
C
      INTEGER    IDEV, IVAL
      INTEGER    NFONT, NCOL
      INTEGER    N0, N1, N72
      PARAMETER (N0 = 0, N1 = 1, N72 = 72)
      DOUBLE PRECISION SIZES, THICK
      DOUBLE PRECISION XINCH(N0:N1), YINCH(N0:N1), ZSCALE(N0:N1)
      DOUBLE PRECISION XOFFP, YOFFP, SCALP
      DOUBLE PRECISION XOFFL, YOFFL, SCALL
      DOUBLE PRECISION RED(N72), GREEN(N72), BLUE(N72)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      EXTERNAL   X_PUTFAT, X_WPSCFG
      INTRINSIC  DBLE
      SAVE       IDEV, IVAL, SIZES, THICK
      SAVE       NFONT, NCOL
      SAVE       XOFFP, YOFFP, SCALP
      SAVE       XOFFL, YOFFL, SCALL
      SAVE       RED, GREEN, BLUE
      X_WGBCFG = ONE
      IF (ISEND.EQ.0) THEN
C
C Try to read parameters off w_ps.cfg
C
         CALL X_WPSCFG(N0, N72,
     +                 IDEV, IVAL, THICK, SIZES, XINCH, YINCH, ZSCALE,
     +                 NFONT, NCOL, RED, GREEN, BLUE)
         XOFFP = XINCH(N0)
         YOFFP = YINCH(N0)
         SCALP = ZSCALE(N0)
         XOFFL = XINCH(N1)
         YOFFL = YINCH(N1)
         SCALL = ZSCALE(N1)
      ELSEIF (ISEND.EQ.1) THEN
C
C IDEV
C
         X_WGBCFG = DBLE(IDEV)
      ELSEIF (ISEND.EQ.2) THEN
C
C IVAL
C
         X_WGBCFG = DBLE(IVAL)
      ELSEIF (ISEND.EQ.3) THEN
C
C THICK
C
         X_WGBCFG = THICK
      ELSEIF (ISEND.EQ.4) THEN
C
C SIZE
C
         X_WGBCFG = SIZES
      ELSEIF (ISEND.EQ.5) THEN
C
C XOFF
C
         X_WGBCFG = XOFFP
      ELSEIF (ISEND.EQ.6) THEN
C
C YOFF
C
         X_WGBCFG = YOFFP
      ELSEIF (ISEND.EQ.7) THEN
C
C SCALE
C
         X_WGBCFG = SCALP
      ELSEIF (ISEND.EQ.8) THEN
C
C XOFF
C
         X_WGBCFG = XOFFL
      ELSEIF (ISEND.EQ.9) THEN
C
C YOFF
C
         X_WGBCFG = YOFFL
      ELSEIF (ISEND.EQ.10) THEN
C
C SCALE
C
         X_WGBCFG = SCALL
      ELSEIF (ISEND.EQ.11) THEN
C
C NFONT
C
         X_WGBCFG = DBLE(NFONT)
      ELSEIF (ISEND.EQ.12) THEN
C
C NCOLOR
C
         X_WGBCFG = DBLE(NCOL)
      ELSE
C
C Out of range
C
         CALL X_PUTFAT ('ISEND out of range in call to X_WGBCFG')
         RETURN
      ENDIF
      END
C   
C

