C
C X_WPSCFG: Write/Read the PS configuration file w_ps.cfg
C
      SUBROUTINE X_WPSCFG (ISEND, NMAX, IDEV_C, IVAL_C,
     +                     THICK_C, SIZE_C, XINCH_C, YINCH_C, ZSCALE_C,
     +                     NFONT_C, NCOLOR_C,
     +                     RED_C, GREEN_C, BLUE_C)
C
C ACTION : Configure w_ps.cfg
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 07/12/2000
C          17/01/2003 reversed BLUE_C and GREEN_C in argument list and
C                     changed defaults for 25, 32, 33, 41, 48, 51 and
C                     introduced IERROR
C          22/10/2004 changed defaults for 60 to 71
C          27/10/2004 introduced PCENT_D, PCENT_T, NTYPE_D, and NTYPE_T
C          23/01/2007 introduced FULL_PATH and SIM256
C          01/02/2007 replaced SIM256 by X_SIM256
C          11/12/2007 silenced advisory messages when w_ps.cfg does not exist
C          26/06/2010 added call to x_infofl
C          20/10/2013 altered meaning of IDEV to Windows line thickness 
C                     and NTYPE_D to 3 
C          13/12/2013 restored NTYPE_D to 1 and tested IDEV_T and THICK_T 
C
C          ISEND = 0: Initialise everything to defaults then try to read the
C                     current values off w_ps.cfg. Finally, use the current
C                     values to overwrite the values in the argument list.
C                     This always happens first time wpscfg is called
C                     and always initialises to sensible current values.
C                     Re-set PSCOLR$
C          ISEND = 1: Copy the argument list into the current values then
C                     try to write the current values to w_ps.cfg
C                     This always happens if a failure has occurred with
C                     ISEND = 0
C                     Re-set PSCOLR$
C          ISEND = 2: Just return with arguments equal to the current values
C          ISEND = 3: Just return with arguments equal to the default values
C          ISEND = 4: Just set current values equal to arguments supplied
C          ISEND = 5: Just set current values equal to the default values
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, NMAX
      INTEGER,          INTENT (INOUT) :: IDEV_C, IVAL_C, NCOLOR_C,
     +                                    NFONT_C
      DOUBLE PRECISION, INTENT (INOUT) :: BLUE_C(NMAX), GREEN_C(NMAX),
     +                                    RED_C(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: SIZE_C, THICK_C, XINCH_C(0:1),
     +                                    YINCH_C(0:1), ZSCALE_C(0:1)
C
C Locals
C            
      INTEGER    IDEV, IVAL, NCOLOR, NFONT
      INTEGER    IDEV_T, IVAL_T, NCOLOR_T, NFONT_T
      INTEGER    IDEV_D, IVAL_D, NCOLOR_D, NFONT_D
      PARAMETER (IDEV_D = 1, IVAL_D = 0, NCOLOR_D = 72, NFONT_D = 5)
      INTEGER    I, IERROR, IOS, NOUT
      INTEGER    NTYPE_D, NTYPE_T
      PARAMETER (NTYPE_D = 1)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N13, N72
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N13 = 13, N72 = 72)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION THICK
      DOUBLE PRECISION SIZE_1, SIZE_D, SIZE_T
      PARAMETER (SIZE_D = 1.0D+00)
      DOUBLE PRECISION THICK_T
      DOUBLE PRECISION THICK_D, THICK_MIN
      PARAMETER (THICK_D = 1.0D+00, THICK_MIN = 0.1D+00)
      DOUBLE PRECISION XINCH(0:1), YINCH(0:1), ZSCALE(0:1)
      DOUBLE PRECISION XINCH_D(0:1), YINCH_D(0:1), ZSCALE_D(0:1)
      DOUBLE PRECISION XINCH_T(0:1), YINCH_T(0:1), ZSCALE_T(0:1)
      DOUBLE PRECISION BLUE(N72), GREEN(N72), RED(N72)
      DOUBLE PRECISION BLUE_D(N72), GREEN_D(N72), RED_D(N72)
      DOUBLE PRECISION BLUE_T(N72), GREEN_T(N72), RED_T(N72)
      CHARACTER  WORD4*4, LINE*100 
      CHARACTER  FULL_PATH*1024, X_SIM256*1024
      CHARACTER  PCENT_D*1, PCENT_T*1
      PARAMETER (PCENT_D = '%')
      CHARACTER  PS_CFG*8
      PARAMETER (PS_CFG = 'w_ps.cfg')
      LOGICAL    ABORT, FIRST
      LOGICAL    READ_ONLY, THERE
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   X_PSCOL1
      EXTERNAL   X_PUTADV, X_ATTRIB, W_DELEET, W_GETNOU,
     +           X_SIM256, X_INFOFL
      INTRINSIC  MIN
C
C Variables to be saved
C
      SAVE       FIRST
      SAVE       IDEV, IVAL, THICK, SIZE_1, XINCH, YINCH, ZSCALE,
     +           NFONT, NCOLOR, RED, GREEN, BLUE
      SAVE       XINCH_D, YINCH_D, ZSCALE_D, RED_D, GREEN_D, BLUE_D
C
C Default values
C
      DATA     FIRST / .TRUE. /
      DATA     XINCH_D / 1.0D+00,  7.5D+00 /
      DATA     YINCH_D / 3.5D+00,  1.25D+00 /
      DATA     ZSCALE_D / 0.7D+00,  1.0D+00 /
      DATA     RED_D / 0.0000D+00, 0.0000D+00, 0.0000D+00, 0.0000D+00,
     +                 0.6667D+00, 0.6667D+00, 0.6667D+00, 0.7000D+00,
     +                 0.4500D+00, 0.3333D+00, 0.3333D+00, 0.3333D+00,
     +                 1.0000D+00, 1.0000D+00, 1.0000D+00, 1.0000D+00,

     +                 0.5000D+00, 0.5500D+00, 0.6000D+00, 0.6500D+00,
     +                 0.7333D+00, 0.8000D+00, 0.8667D+00, 0.9333D+00,

     +                 0.6000D+00, 0.0000D+00, 0.0000D+00, 0.0000D+00,
     +                 1.0000D+00, 1.0000D+00, 1.0000D+00, 0.0000D+00,
     +                 0.0000D+00, 0.6667D+00, 0.6667D+00, 0.6667D+00,
     +                 1.0000D+00, 1.0000D+00, 1.0000D+00, 1.0000D+00,

     +                 0.0000D+00, 0.0000D+00, 0.0000D+00, 0.0000D+00,
     +                 0.0000D+00, 0.0000D+00, 0.0000D+00, 0.5000D+00,
     +                 0.3333D+00, 0.3333D+00, 0.5000D+00, 0.3333D+00,
     +                 0.3333D+00, 0.3333D+00, 0.3333D+00, 0.3333D+00,

     +                 0.3333D+00, 0.3333D+00, 0.7000D+00, 0.6667D+00,

     +                 1.0000D+00, 1.0000D+00, 1.0000D+00, 1.0000D+00,
     +                 1.0000D+00, 0.7500D+00, 0.6667D+00, 0.4000D+00,
     +                 0.0000D+00, 0.0000D+00, 0.0000D+00, 0.4500D+00/

      DATA   GREEN_D / 0.0000D+00, 0.0000D+00, 0.6667D+00, 0.6667D+00,
     +                 0.0000D+00, 0.0000D+00, 0.3333D+00, 0.7000D+00,
     +                 0.4500D+00, 0.3333D+00, 1.0000D+00, 1.0000D+00,
     +                 0.3333D+00, 0.3333D+00, 1.0000D+00, 1.0000D+00,

     +                 0.5000D+00, 0.5500D+00, 0.6000D+00, 0.6500D+00,
     +                 0.7333D+00, 0.8000D+00, 0.8667D+00, 0.9333D+00,

     +                 0.0000D+00, 0.0000D+00, 1.0000D+00, 0.8500D+00,
     +                 0.0000D+00, 0.0000D+00, 1.0000D+00, 0.5500D+00,
     +                 0.0000D+00, 0.6667D+00, 1.0000D+00, 1.0000D+00,
     +                 0.6667D+00, 0.6667D+00, 1.0000D+00, 0.6667D+00,

     +                 0.5000D+00, 0.3333D+00, 0.3333D+00, 0.6667D+00,
     +                 0.6667D+00, 0.8500D+00, 1.0000D+00, 0.0000D+00,
     +                 0.0000D+00, 0.0000D+00, 0.5000D+00, 0.3333D+00,
     +                 0.6667D+00, 0.6667D+00, 0.6667D+00, 0.6667D+00,

     +                 1.0000D+00, 0.8500D+00, 0.0000D+00, 0.0000D+00,

     +                 1.0000D+00, 0.7500D+00, 0.6500D+00, 0.5000D+00,
     +                 0.0000D+00, 0.0000D+00, 0.0000D+00, 0.0000D+00,
     +                 0.0000D+00, 0.6500D+00, 1.0000D+00, 0.8500D+00/

      DATA    BLUE_D / 0.0000D+00, 0.6667D+00, 0.0000D+00, 0.6667D+00,
     +                 0.0000D+00, 0.6667D+00, 0.0000D+00, 0.7000D+00,
     +                 0.4500D+00, 1.0000D+00, 0.3333D+00, 1.0000D+00,
     +                 0.3333D+00, 1.0000D+00, 0.3333D+00, 1.0000D+00,

     +                 0.5000D+00, 0.5500D+00, 0.6000D+00, 0.6500D+00,
     +                 0.7333D+00, 0.8000D+00, 0.8667D+00, 0.9333D+00,

     +                 0.0000D+00, 1.0000D+00, 0.0000D+00, 0.8500D+00,
     +                 0.0000D+00, 1.0000D+00, 0.0000D+00, 0.0000D+00,
     +                 0.6000D+00, 1.0000D+00, 0.6667D+00, 1.0000D+00,
     +                 0.6667D+00, 1.0000D+00, 0.6667D+00, 0.0000D+00,

     +                 0.5000D+00, 0.6667D+00, 1.0000D+00, 0.3333D+00,
     +                 1.0000D+00, 0.3333D+00, 0.6667D+00, 0.5000D+00,
     +                 0.6667D+00, 1.0000D+00, 0.0000D+00, 0.6667D+00,
     +                 0.0000D+00, 0.3333D+00, 0.6667D+00, 1.0000D+00,

     +                 0.6667D+00, 1.0000D+00, 0.3333D+00, 1.0000D+00,

     +                 0.0000D+00, 0.0000D+00, 0.0000D+00, 0.0000D+00,
     +                 0.0000D+00, 0.2500D+00, 0.6667D+00, 0.5500D+00,
     +                 1.0000D+00, 0.6000D+00, 0.0000D+00, 0.0000D+00/

C
C Initialise ... Set ABORT = .FALSE., IERROR = -2, and define FULL_PATH
C
      ABORT = .FALSE.
      IERROR = -N2
      FULL_PATH = X_SIM256(PS_CFG)
C
C......................................................................
C
      IF (FIRST .OR. ISEND.EQ.N0) THEN
C
C Initialise current values to the default values
C
         FIRST = .FALSE.
         IDEV = IDEV_D
         IVAL = IVAL_D
         THICK = THICK_D
         SIZE_1 = SIZE_D
         XINCH(0) = XINCH_D(0)
         XINCH(1) = XINCH_D(1)
         YINCH(0) = YINCH_D(0)
         YINCH(1) = YINCH_D(1)
         ZSCALE(0) = ZSCALE_D(0)
         ZSCALE(1) = ZSCALE_D(1)
         NFONT = NFONT_D
         NCOLOR = NCOLOR_D
         DO I = N1, NCOLOR_D
            RED(I) = RED_D(I)
            BLUE(I) = BLUE_D(I)
            GREEN(I) = GREEN_D(I)
         ENDDO
C
C Initialise argument values to the default values
C
         IDEV_C = IDEV_D
         IVAL_C = IVAL_D
         THICK_C = THICK_D
         SIZE_C = SIZE_D
         XINCH_C(0) = XINCH_D(0)
         XINCH_C(1) = XINCH_D(1)
         YINCH_C(0) = YINCH_D(0)
         YINCH_C(1) = YINCH_D(1)
         ZSCALE_C(0) = ZSCALE_D(0)
         ZSCALE_C(1) = ZSCALE_D(1)
         NFONT_C = NFONT_D
         NCOLOR_C = MIN(NCOLOR_D,NMAX)
         DO I = N1, NCOLOR_C
            RED_C(I) = RED_D(I)
            BLUE_C(I) = BLUE_D(I)
            GREEN_C(I) = GREEN_D(I)
         ENDDO
C
C Try to read values off the file w_ps.cfg
C
         CALL X_ATTRIB (FULL_PATH,
     +                  THERE, READ_ONLY)
C
C If there set ABORT = .TRUE. and attempt to read from it
C
         IERROR = -N1
         ABORT = .TRUE.
         IF (THERE) THEN
            CALL W_GETNOU (NOUT)
            IERROR = N0
            OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
            IF (IOS.NE.N0) GOTO 20
C
C Read temporary values off the file
C
            IERROR = N1
            READ (NOUT,*,END=20,ERR=20,IOSTAT=IOS) IDEV_T, IVAL_T,
     +            THICK_T, SIZE_T, PCENT_T, NTYPE_T
            IF (IOS.NE.N0) GOTO 20
            IF (IDEV_T.LT.N1) GOTO 20  
            IF (THICK_T.LT.THICK_MIN) GOTO 20
            IF (SIZE_T.LT.ZERO) GOTO 20
            IF (PCENT_T.NE.PCENT_D) GOTO 20
            IF (NTYPE_T.NE.NTYPE_D) GOTO 20
            IERROR = N2
            READ (NOUT,*,END=20,ERR=20,IOSTAT=IOS)
     +                          XINCH_T(0), YINCH_T(0), ZSCALE_T(0),
     +                          XINCH_T(1), YINCH_T(1), ZSCALE_T(1),
     +                          NFONT_T, NCOLOR_T
            IF (IOS.NE.N0) GOTO 20
            IF (NFONT_T.LT.N1 .OR. NFONT_T.GT.N13) GOTO 20
            IF (ZSCALE_T(0).LT.ZERO .OR. ZSCALE_T(1).LT.ZERO) GOTO 20
            IF (NCOLOR_T.LT.NCOLOR_D) GOTO 20
            IERROR = N4
            DO I = N1, N72
               IERROR = IERROR + N1
               READ (NOUT,*,END=20,ERR=20,IOSTAT=IOS)
     +               RED_T(I), GREEN_T(I), BLUE_T(I)
               IF (IOS.NE.N0) GOTO 20
               IF (  RED_T(I).LT.ZERO .OR.   RED_T(I).GT.ONE .OR.
     +             GREEN_T(I).LT.ZERO .OR. GREEN_T(I).GT.ONE .OR.
     +              BLUE_T(I).LT.ZERO .OR.  BLUE_T(I).GT.ONE) GOTO 20
            ENDDO
C
C Copy the parameters read off ps.cfg into the current values
C
            IDEV = IDEV_T
            IVAL = IVAL_T
            SIZE_1 = SIZE_T
            THICK = THICK_T
            DO I = N0, N1
              XINCH(I) = XINCH_T(I)
              YINCH(I) = YINCH_T(I)
              ZSCALE(I) = ZSCALE_T(I)
            ENDDO
            DO I = N1, N72
               RED(I) = RED_T(I)
               BLUE(I) = BLUE_T(I)
               GREEN(I) = GREEN_T(I)
            ENDDO
            NFONT = NFONT_T
            NCOLOR = NCOLOR_T
C
C Copy the new values into the argument list supplied
C
            IDEV_C = IDEV_T
            IVAL_C = IVAL_T
            SIZE_C = SIZE_T
            THICK_C = THICK_T
            DO I = N0, N1
              XINCH_C(I) = XINCH_T(I)
              YINCH_C(I) = YINCH_T(I)
              ZSCALE_C(I) = ZSCALE_T(I)
            ENDDO
            DO I = N1, N72
               RED_C(I) = RED_T(I)
               BLUE_C(I) = BLUE_T(I)
               GREEN_C(I) = GREEN_T(I)
            ENDDO
            NFONT_C = NFONT_T
            NCOLOR_C = NCOLOR_T
C
C Parameters have all been read successfully so set ABORT = .FALSE.
C
            ABORT = .FALSE.
C
C Label 20: Crash point. Here directly only if there is a crash reading w_ps.cfg
C =========
C
   20       CONTINUE
            CLOSE (UNIT = NOUT)
         ENDIF
C
C Make sure PSCOLR$ has the current palette
C
         CALL X_PSCOL1 (N2,
     +                  BLUE, GREEN, RED)
      ENDIF
C
C......................................................................
C
      IF (ABORT .OR. ISEND.EQ.N1) THEN
C
C first copy the arguments supplied into the local values
C
         IDEV = IDEV_C
         IVAL = IVAL_C
         THICK = THICK_C
         SIZE_1 = SIZE_C
         XINCH(0) = XINCH_C(0)
         XINCH(1) = XINCH_C(1)
         YINCH(0) = YINCH_C(0)
         YINCH(1) = YINCH_C(1)
         ZSCALE(0) = ZSCALE_C(0)
         ZSCALE(1) = ZSCALE_C(1)
         NFONT = NFONT_C
         NCOLOR = NCOLOR_C
         DO I = N1, NCOLOR_C
            RED(I) = RED_C(I)
            BLUE(I) = BLUE_C(I)
            GREEN(I) = GREEN_C(I)
         ENDDO
C
C Overwrite w_ps.cfg
C
         IF (ABORT) THEN
            IF (THERE .AND. IERROR.EQ.N0) THEN
               CALL X_PUTADV (  
     +'Simfit failed to open the file w_ps.cfg')               
            ELSEIF (IERROR.EQ.N1) THEN
               CALL X_PUTADV (
     +'Simfit will try to correct errors in w_ps.cfg at line 1')
            ELSEIF (IERROR.EQ.N2) THEN
               CALL X_PUTADV (
     +'Simfit will try to correct errors in w_ps.cfg at line 2, 3,or 4')
            ELSEIF (IERROR.GT.N0) THEN
               WRITE (WORD4,'(I4)') IERROR
               LINE =
     +'Simfit failed to read data from w_ps.cfg at line'//WORD4
               CALL X_PUTADV (LINE)
            ENDIF
         ENDIF
         CALL W_DELEET (FULL_PATH,
     +                  ASKIF, THERE)
         IF (THERE) CALL X_INFOFL (N6,
     +                             FULL_PATH)            
         IF (.NOT.THERE) THEN
            CALL W_GETNOU (NOUT)
            OPEN (UNIT = NOUT, FILE = FULL_PATH)
            WRITE (NOUT,100) IDEV, IVAL, THICK, SIZE_1,
     +                       PCENT_D, NTYPE_D,
     +                       XINCH(0), YINCH(0), ZSCALE(0),
     +                       XINCH(1), YINCH(1), ZSCALE(1),
     +                       NFONT, NCOLOR
            DO I = N1, N72
               WRITE (NOUT,200) RED(I), GREEN(I), BLUE(I)
            ENDDO
            WRITE (NOUT,300)
            WRITE (NOUT,400)
            CLOSE (UNIT = NOUT)
         ENDIF
C
C Make sure PSCOLR$ has the current palette
C
         CALL X_PSCOL1 (N2,
     +                  BLUE, GREEN, RED)
      ENDIF
C
C......................................................................
C
      IF (ISEND.EQ.N2) THEN
C
C Just return with the current values
C
         IDEV_C = IDEV
         IVAL_C = IVAL
         THICK_C = THICK
         SIZE_C = SIZE_1
         XINCH_C(0) = XINCH(0)
         XINCH_C(1) = XINCH(1)
         YINCH_C(0) = YINCH(0)
         YINCH_C(1) = YINCH(1)
         ZSCALE_C(0) = ZSCALE(0)
         ZSCALE_C(1) = ZSCALE(1)
         NFONT_C = NFONT
         NCOLOR_C = NCOLOR
         DO I = N1, MIN(NCOLOR_D,NMAX)
            RED_C(I) = RED(I)
            BLUE_C(I) = BLUE(I)
            GREEN_C(I) = GREEN(I)
         ENDDO
      ELSEIF (ISEND.EQ.N3) THEN
C
C Just return with the defaults
C
         IDEV_C = IDEV_D
         IVAL_C = IVAL_D
         THICK_C = THICK_D
         SIZE_C = SIZE_D
         XINCH_C(0) = XINCH_D(0)
         XINCH_C(1) = XINCH_D(1)
         YINCH_C(0) = YINCH_D(0)
         YINCH_C(1) = YINCH_D(1)
         ZSCALE_C(0) = ZSCALE_D(0)
         ZSCALE_C(1) = ZSCALE_D(1)
         NFONT_C = NFONT_D
         NCOLOR_C = NCOLOR_D
         DO I = N1, MIN(NCOLOR_D,NMAX)
            RED_C(I) = RED_D(I)
            BLUE_C(I) = BLUE_D(I)
            GREEN_C(I) = GREEN_D(I)
         ENDDO
      ELSEIF (ISEND.EQ.N4) THEN
C
C Just reset the current values to the argument list
C
         IDEV = IDEV_C
         IVAL = IVAL_C
         THICK = THICK_C
         SIZE_1 = SIZE_C
         XINCH(0) = XINCH_C(0)
         XINCH(1) = XINCH_C(1)
         YINCH(0) = YINCH_C(0)
         YINCH(1) = YINCH_C(1)
         ZSCALE(0) = ZSCALE_C(0)
         ZSCALE(1) = ZSCALE_C(1)
         DO I = N1, MIN(NCOLOR_D,NMAX)
            RED(I) = RED_C(I)
            BLUE(I) = BLUE_C(I)
            GREEN(I) = GREEN_C(I)
         ENDDO
      ELSEIF (ISEND.EQ.N5) THEN
C
C Just reset the current values to the defaults
C
         IDEV = IDEV_D
         IVAL = IVAL_D
         THICK = THICK_D
         SIZE_1 = SIZE_D
         XINCH(0) = XINCH_D(0)
         XINCH(1) = XINCH_D(1)
         YINCH(0) = YINCH_D(0)
         YINCH(1) = YINCH_D(1)
         ZSCALE(0) = ZSCALE_D(0)
         ZSCALE(1) = ZSCALE_D(1)
         DO I = N1, MIN(NCOLOR_D,NMAX)
            RED(I) = RED_D(I)
            BLUE(I) = BLUE_D(I)
            GREEN(I) = GREEN_D(I)
         ENDDO
      ENDIF   
C
C Format statements
C      
  100 FORMAT (
     + 2I8,2F8.2,2X,A1,I3
     +/3F8.2
     +/3F8.2
     +/2I8)
  200 FORMAT (F7.4,',',F7.4,',',F7.4)
  300 FORMAT (
     +/'Meaning of the above parameters at SIMFIT Version 7:'
     +/'win_wide :Windows line width in pixels'
     +/'ival     :0 (portrait), 1 (landscape)'
     +/'eps_wide :PostScript line width in scaled PS units'
     +/'size     :Global font size'
     +/'type     : e.g. % 3 means configuration type 3'
     +/'portrait :X_offset, Y_offset, XY_scaling factor'
     +/'landscape:X_offset, Y_offset, XY_scaling factor'
     +/'nfont    :Font type 1, 2, ..., 13'
     +/'ncolor   :number of colours'
     +/'Advice   :item 1 sets Windows line width'
     +/'          item 3 sets PostScript line width'  
     +/'          Offsets are in inches as follows:'
     +/'          Portrait: left and bottom margins'
     +/'          Landscape: margins before anticlockwise rotation.'
     +/'          Colours: 0 to 15 must be close to VGA colours, the'
     +/'          others are arbitrary but should define a grey scale,'
     +/'          colours 0 to 59 should not be changed very much, but'
     +/'          colours 60 to 71 can be freely re-defined.')
  400 FORMAT (
     + 'A possible 4-point colour palette for the 16 VGA colours:'
     +/'   red    green  blue'
     +/'0  0.0000 0.0000 0.0000 black'
     +/'1  0.0000 0.0000 0.6667 blue'
     +/'2  0.0000 0.6667 0.0000 green'
     +/'3  0.0000 0.6667 0.6667 cyan'
     +/'4  0.6667 0.0000 0.0000 red'
     +/'5  0.6667 0.0000 0.6667 magenta'
     +/'6  0.6667 0.3333 0.0000 brown'
     +/'7  0.6667 0.6667 0.6667 white'
     +/'8  0.3333 0.3333 0.3333 dark grey'
     +/'9  0.3333 0.3333 1.0000 light blue'
     +/'10 0.3333 1.0000 0.3333 light green'
     +/'11 0.3333 1.0000 1.0000 light cyan'
     +/'12 1.0000 0.3333 0.3333 light red'
     +/'13 1.0000 0.3333 1.0000 light magenta'
     +/'14 1.0000 1.0000 0.3333 light yellow'
     +/'15 1.0000 1.0000 1.0000 bright white')
      END
C
C
