c            
c
      subroutine x_xfonts()
c
c action: illustrate the simfit font substitution schemes
c author: w.g.bardsley, university of manchester, u.k.
c         12/09/2011 developed from xfonts$
c
c Note: This version is not exactly the same as xfonts$ in w_graphics.dll.
c       It calls the routine w_fntmap for the keyboard map and examples 
c       so that it can be used from within w_clearwin.dll without causing
c       any of the problems associated with nout_ps in pltstr$ etc.
c
      implicit   none
      integer    isend, jsend, nchar
      integer    icolor, numopt, numtxt
      parameter (icolor = 9, numopt = 12)
      integer    numbld(30)
      character  text(30)*100
      logical    again, frame, next, updown
      parameter (frame = .false., updown = .true.)
      external   x_listbx, x_tutor1
      external   w_accent, w_fntmap
      data       numbld / 30*0 /
c
c initialise then calculate positions xm, xt, ym, yt
c
      again = .true.
      do while (again)
         write (text,100)
         isend = numopt - 1
         call x_listbx (isend, numopt, 
     +                  text)
         if (isend.le.5) then
            if (isend.eq.1) then
               jsend = 8
            elseif (isend.eq.2) then
               jsend = 20
            elseif (isend.eq.3) then
               jsend = 3
            elseif (isend.eq.4) then
               jsend = 7
            elseif (isend.eq.5) then
               jsend = 9
            endif
            nchar = 32
            call w_accent (jsend, nchar)
         elseif (isend.le.10) then
            jsend = isend - 5
            call w_fntmap (jsend)
         elseif (isend.eq.numopt - 1) then
            again = .true.
            write (text,200)
            numtxt = 23
            numbld(1) = 1
            numbld(14) = 1
            numbld(20) = 1
            next = .true.
            call x_tutor1 (icolor, numbld, numtxt,
     +                     text,
     +                     frame, next, updown)
            numbld(1) = 0
            numbld(14) = 0
            numbld(20) = 0
            write (text,300)
            numtxt = 22
            numbld(1) = 1
            numbld(21) = 1
            numbld(22) = 1
            next = .true.
            call x_tutor1 (icolor, numbld, numtxt,
     +                     text,
     +                     frame, next, updown)
            numbld(1) = 0
            numbld(21) = 0
            numbld(22) = 0
            write (text,400)
            numtxt = 22
            numbld(1) = 1
            numbld(15) = 1
            next = .true.
            call x_tutor1 (icolor, numbld, numtxt,
     +                     text,
     +                     frame, next, updown)
            numbld(1) = 0
            numbld(15) = 0
            write (text,500)
            numtxt = 22
            numbld(1) = 1
            numbld(9) = 1
            next = .false.
            call x_tutor1 (icolor, numbld, numtxt,
     +                     text,
     +                     frame, next, updown)
            numbld(1) = 0
            numbld(9) = 0
         else
             again = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'Character map: Latin    `Click to select'
     +/'Character map: Symbol   `Click to select'
     +/'Character map: Maths    `Click to select'
     +/'Character map: WingDings`Click to select'
     +/'Character map: Webdings `Click to select'
     +/'Keyboard map: Maths     `Information only'
     +/'Keyboard map: Symbol    `Information only'
     +/'Keyboard map: WingDings `Information only'
     +/'Keyboard map: Webdings  `Information only'
     +/'Examples                `Demonstration'
     +/'Help                    `Tutorial '
     +/'Cancel                  ` ')
  200 format (
     + 'Getting Simfit to plot non-standard characters'
     +/
     +/'If you select accented or other non-standard characters from a'   
     +/'keyboard or character map, PostScript output will be identical'   
     +/'to the Windows output except for characters and fonts where'   
     +/'Windows characters differ from the PostScript characters, e.g.'  
     +/'Wingdings in Windows selects ZapfDingbats in Postscript.'   
     +/
     +/'However scientific graphs often require subscripts for indices,'    
     +/'superscripts for powers, hats for estimates, bars for means, or'   
     +/'special maths characters, so Simfit has a simple technique that'   
     +/'will often work, and an advanced technique with greater power.'   
     +/   
     +/'Simple technique'   
     +/'Select the character from the top line of the advanced editing'   
     +/'control, then click on the new character required from the'    
     +/'appropriate character map. This will automatically adjust the'   
     +/'character and also the character control key in the lower row.'   
     +/   
     +/'Advanced technique'   
     +/'Consult the keyboard map for information, then replace the'   
     +/'character in the top row and the corresponding character in'   
     +/'the bottom row. Further details follow.')   
  300 format (
     + 'Plotting special characters and maths symbols'
     +/
     +/'In Simfit graphics every individual letter plotted has'
     +/'the following attributes:'
     +/
     +/'1) a character-number (i.e. the order in the font encoding)'
     +/'2) a size and orientation'
     +/'3) a colour'
     +/'4) a typeface family (e.g. Times, Arial)'
     +/'5) the font encoding required (e.g. IsoLatin1)'
     +/'6) an index-key for overprinting accents, etc.'
     +/
     +/'Size, angle for rotation, colour, and typeface selection are'
     +/'easily done interactively and should cause no problems. However'
     +/'difficulties may be encountered when wanting to use an accented'
     +/'character for which there is no dedicated key on the keyboard,'
     +/'or when trying to create a composite character, such as a bold'
     +/'theta with an overbar, which may not exist in the font set. To'
     +/'find out how to do such things the next information is vital to'
     +/'appreciate how a character appears when it is plotted:'
     +/'Associated with every string of characters is a corresponding'
     +/'set of index-keys to inform Simfit how to plot each character.')
  400 format (
     + 'Accented characters when there is no dedicated keyboard key'
     +/
     +/'Characters < 127 are defined by the ASCII 7-bit standard but'
     +/'this has no accented characters. Characters > 127 are defined'
     +/'by the IsoLatin1 standard, which is similar to Windows coding.'
     +/'For accented characters you select one and change the Simfit'
     +/'index-key from Standard to IsoLatin1 in one of these ways:'
     +/'1)`Select directly from the Simfit numeric keypad map control'
     +/'  `This is only available from the advanced editing option'
     +/'2)`Input the character number using the numeric keypad'
     +/'  `This easy but requires practise'
     +/'3)`Input the corresponding octal code'
     +/'  `This technique is only for PostScript experts'
     +/
     +/'Using numeric keypad codes to input accented characters'
     +/
     +/'For example, you will see from the Simfit Latin keypad map'
     +/'that character 241 is n-tilde. First engage Num Lock, then'
     +/'hold down Alt and then input the code (preceded by 0) using the'
     +/'number pad, i.e. Alt+0241. Simfit will automatically set the'
     +/'corresponding character control index to 8 for IsoLatin1 for'
     +/'any values > 127, but this can then be changed interactively.')
  500 format (
     + 'Simfit character maps and index-keys for special characters'
     +/
     +/'You may wish to plot symbols, or maths operators, or even add'
     +/'accents to characters that are not usually accented, e.g. bars'
     +/'for sample mean, or hats for estimated parameters. To do this'
     +/'you select advanced editing and edit the character or index-key'
     +/'for which you want to add accents or substitute maths, etc.'
     +/
     +/'PostScript octal codes, special macros, and LaTeX/PSFrag'
     +/
     +/'Octal codes can be used for characters > 127, but this is more'
     +/'difficult than the number pad technique. Note that accented'
     +/'characters look better using octal codes than after adding the'
     +/'accents independently but, if you use \260 for degrees, \351'
     +/'for e-acute, \361 for n-tilde, etc. you must select index-key 8'
     +/'for IsoLatin1 encoding, and remember that octal code \abc is a'
     +/'single byte in Postscript, which requires a single index-key.'
     +/'Accents,maths,and Symbols can be used in PostScript or Windows,'
     +/'but index-key 7 sets ZapfDingbats in PostScript, but WingDings'
     +/'in Windows, while index-key 9 invokes user-defined fonts in'
     +/'PostScript but WebDings in Windows. PS-experts can use macros'
     +/'(specials) and LaTeX users have PSFrag to do almost anything.')
      end
c 
c
