c
c file: editsvg_driver contains
c -----------------------------
c epssvg
c editsvg_driver
c isvg01   
c f$simfit_tmp 
c
  
      subroutine epssvg
c
c action: call editps_driver and editsvg_driver
c author: w.g.bardsley, university of manchester, u.k., 30/12/2018
c       
      implicit none     
      integer    numopt, numsta, numtxt
      parameter (numopt = 3, numsta = 13, numtxt = numsta + numopt - 1)
      integer    numbld(numtxt), numdec
      character (len = 100) text(numtxt) 
      logical    repeet
      external   lstbox, editsvg_driver, editps_driver
      data       numbld / numtxt*0 /
      numdec = numopt 
      repeet = .true.
      do while (repeet) 
         write (text,100)
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         if (numdec.eq.1) then
            call editps_driver
         elseif (numdec.eq.2) then
            call editsvg_driver
         else
            repeet = .false.
         endif      
      enddo   
c
c format statement
c
  100 format (
     + 'Simfit EPS/SVG interface to vector graphics programs'
     +/
     +/'Vector graphics files are the best format for archiving'
     +/'scientific graphs as they are device independent. That is,'  
     +/'data are stored as commands to draw them so they can be' 
     +/'displayed at any resolution without pixellating.'
     +/
     +/'Encapsulated PostScript files (*.eps) are best for LaTeX'
     +/'but scalable vector graphics (*.svg) are best for the'
     +/'internet, and either can be imported into document'
     +/'preparation programs.'
     +/
     +/'Open EditPS'
     +/'Open EditSVG'
     +/'Exit ... The Simfit EPS/SVG interface')
      end
c
c----------------------------------------------------------------------------      
c
      subroutine editsvg_driver
c
c action: front end to displaysvg and editsvg
c author: w.g.bardsley, university of manchester, u.k., 30/12/2018
c
c      
      implicit   none
      integer    iprev
      integer    numdec, numopt, nstart, numtxt
      parameter (numopt = 8, nstart = 10, numtxt = nstart + numopt - 1)
      integer    icolor, ix, itype, iy, lshade, nin, nout, nsmall
      parameter (icolor = 7, ix = 0, itype = 8, iy = 0, lshade = 0, 
     +           nin = 3, nout = 11, nsmall = 100)
      integer    numbld(30), numpos(30)
      integer    nfiles
      integer    isend, jsend
      parameter (isend = 1, jsend = 3)
      character (len = 1024) fname, fsav(nsmall)
      character (len = 100 ) text(30)
      character (len = 24  ) type1 
      parameter (type1 = 'Scalable vector graphics')
      character (len = 3   ) ext
      parameter (ext = 'svg')
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    abort, accept(nsmall)
      logical    repeet, yes
      logical    allow_blanks, allow_isvg
      parameter (allow_isvg = .false.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   getl01, isvg01, pfiles, svglib, help_editsvg
      external   w_lbox01, w_getfil, w_svgdis, w_svgedi, ofiles
      external   f$simfit_tmp
      data       numbld, numpos / 30*0, 30*1 /
      data       iprev / 0 / 
      call f$simfit_tmp ('editsvg')
      numbld(1) = 4
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
         write (text,100)
         CALL W_LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC,
     +                  NUMOPT, NUMPOS, NSTART, NUMTXT,
     +                  TEXT,
     +                  BORDER, FLASH, HIGH)
          if (numdec.eq.1) then
c
c numdec = 1: call displaysvg 
c
c            call w_getfil (isend,
c     +                     ext, fname, type1,
c     +                     abort)
            close (unit = nout)
            call ofiles (jsend, nout,
     +                   fname,
     +                   abort)  
            close (unit = nout)             
            if (.not.abort) call w_svgdis (fname) 
         elseif (numdec.eq.2) then
c
c numdec = 2: call editsvg in default mode
c
               fname = blank
               allow_blanks = .true.
               call w_svgedi (fname,
     +                        allow_blanks, allow_isvg)              
         elseif (numdec.eq.3) then
c
c numdec = 3: call editsvg
c         
c            call w_getfil (isend,
c     +                     ext, fname, type1,
c     +                     abort)
            close (unit = nout)
            call ofiles (jsend, nout,
     +                   fname,
     +                   abort)  
            close (unit = nout)  
            if (.not.abort) then
               allow_blanks = .false.
               call w_svgedi (fname,
     +                        allow_blanks, allow_isvg) 
            endif             
         elseif (numdec.eq.4) then
c
c numdec = 4: input a library file
c    
            close (unit = nin)
            nfiles = 0
            call svglib (nfiles, nin, nsmall, 
     +                   fsav,
     +                   abort)
            close (unit = nin) 
            if (.not.abort .and. nfiles.gt.0) then  
               call isvg01 (nfiles, nout,
     +                      fsav)               
            endif             
         elseif (numdec.eq.5) then
c
c numdec = 5: individual files
c
            nfiles = 0
            abort = .false.
            do while (.not.abort)
               call w_getfil (isend,
     +                        ext, fname, type1,
     +                        abort)
               if (.not.abort) then
                  nfiles = nfiles + 1
                  fsav(nfiles) = fname
                  yes = .false.
                  call getl01 ('Select another SVG file',   
     +                          yes) 
                  abort = .not.yes
               endif   
            enddo  
            if (nfiles.gt.0) then  
               call isvg01 (nfiles, nout,
     +                     fsav)
            endif     
         elseif (numdec.eq.6) then 
c
c numdec = 6: project archive
c         
            close (unit = nin)
            close (unit = nout)
            nfiles = 0
            call pfiles (iprev, itype, nfiles, nin, nsmall, nout, 
     +                   fsav,
     +                   accept) 
            close (unit = nin)
            close (unit = nout) 
            if (nfiles.gt.0) then  
               call isvg01 (nfiles, nout,
     +                      fsav)
            endif          
         elseif (numdec.eq.7) then
c
c numdec = 7: help
c          
            call help_editsvg ('editsvg') 
         else
c
c numdec = 8: quit
c      
            repeet = .false.
         endif        
      enddo
c
c format statements
c      
  100 format (
     + 'The Simfit EditSVG/DisplaySVG interface'
     +/
     +/'This interface only displays or edits SVG files created by the' 
     +/'Simfit or Simdem packages. It can also create collages from'
     +/'multiple SVG files, or generate SVG files from TEX files.'
     +/
     +/'The SVG and PNG files created by this utility are acceptable'
     +/'to any programs that can use SVG or PNG files.'
     +/
     +/'Open DisplaySVG to view 1 SVG file'
     +/'Open EditSVG with 0 SVG file (interactive use)' 
     +/'Open EditSVG with 1 SVG file'
     +/'Open EditSVG with n SVG files (library file)'    
     +/'Open EditSVG with n SVG files (interactively)'
     +/'Open EditSVG with n SVG files (project archive)'
     +/'Help'
     +/'Exit ... EditSVG/DisplaySVG interface')
      end     
c
c-----------------------------------------------------------------------------------
c
      subroutine isvg01 (nfiles, nout, 
     +                   files)
c
c action: call editsvg with an isvg file
c author: w.g.bardsley, university of manchester, u.k, 30/12/2018
c
     
      implicit none
c
c arguments
c      
      integer,             intent (in) :: nfiles, nout
      character (len = *), intent (in) :: files(nfiles)   
c
c locals
c 
      integer    i, ios, k
      double precision scale, x, y
      double precision clip, delta
      parameter (clip = 0.0d+00, delta = 30.0d+00)
      double precision one, smin
      parameter (one = 1.0d+00, smin = 0.25d+00)
      character (len = 1024) path
      character (len = 31  ) temp_file                          !A) make sure dimensions also agree at B and C  
      character (len = 1   ) bslash, dquote                     
      parameter (bslash = '\', dquote = char(34))
      parameter (temp_file = 'Simfit_temporary_isvg_file.isvg') !B) make sure dimensions also agree at A and C
      logical    allow_blanks, allow_isvg
      parameter (allow_blanks = .false., allow_isvg = .true.)
      external   w_v7path, w_svgedi, x_putadv
      intrinsic  trim, char, max
      if (nfiles.lt.1) return
      close (unit = nout)
      call w_v7path (k,
     +               'tmp', path)  
      if (path(k:k).ne.bslash) then
         k = k + 1
         path(k:k) = bslash
      endif   
      path(k + 1:k + 31) = temp_file(1:31)                       !C) make sure dimensions also agree at A and B
      open (unit = nout, file = path, iostat = ios)
      if (ios.eq.0) then
         write (nout,100,iostat=ios) 
         x = one
         y = one
         scale = max(one/abs(nfiles),smin)
         do i = 1, nfiles
            k = len_trim(files(i))
            if (ios.eq.0) write (nout,200,iostat=ios) x, y, scale, 
     +                           clip, dquote//trim(files(i))//dquote
            x = x + delta
            y = y + delta
         enddo  
      endif  
      close (unit = nout)
      if (ios.eq.0) then
         call w_svgedi (path,
     +                  allow_blanks, allow_isvg) 
      else
         call x_putadv ('Failure to create ISVG file')
      endif 
c
c format statements ... required by editsvg and must not be changed 
c      
  100 format (
     +';Simfit temporary isvg file')   
  200 format (
     +'X=',f8.1,',Y=',f8.1,',Scale=',f8.6,',Clipped=',f5.1,',File=',a)   
      end
c
c-------------------------------------------------------------------------------
c
      subroutine f$simfit_tmp (pname)
c
c action: check/create f$simfit.tmp 
c
      implicit   none
c
c argument
c      
      character (len = *), intent (in) :: pname
c
c locals
c      
      integer    ios, nout
      character (len = 1024) aux256, temp
      character (len = 8   ) title
      character (len = 12  ) fname
      parameter (fname = 'f$simfit.tmp')
      logical    askif, there
      parameter (askif = .false.)
      external   aux256, getnou, deleet
c
c check the current program identifier if there is one
c     
      temp = aux256(fname)
      inquire (file = temp, exist = there, iostat = ios) 
      if (ios.eq.0 .and. there) then
         call getnou (nout)
         open (unit = nout, file = temp)
         read (nout,'(a)',iostat=ios) title
         close (unit = nout)
         if (ios.eq.0 .and. title.eq.pname) then
            return
         else
            call deleet (temp,
     +                   askif, there)
         endif              
      endif     
c
c Create the identifier file f$simfit.tmp so the [Demo] button will work
c      
      call getnou (nout)
      open (unit = nout, file = temp)
      write (nout,'(a)',iostat=ios) pname
      close (unit = nout)
      end      