C
C
      SUBROUTINE AFRAME$(ICOLOR,
     +                   FRAME, PS)
C
C ACTION : Draw a frame
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/9/95
C          12/05/2007 added INTENTS
C
      IMPLICIT  NONE
C
C Argument list
C
      INTEGER, INTENT (INOUT) :: ICOLOR
      LOGICAL, INTENT (IN)    :: FRAME, PS
C
C Locals
C
      INTEGER    N0, N4
      PARAMETER (N0 = 0, N4 = 4)
      DOUBLE PRECISION X1, X2, Y1, Y2
      DOUBLE PRECISION XFRAME(N4), YFRAME(N4)
      DOUBLE PRECISION FOUR, ONE, ZERO
      PARAMETER (FOUR = 4.0D+00, ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XTIC, YTIC
      PARAMETER (XTIC = 0.01D+00, YTIC = 0.0075D+00)
C
C Externals
C
      EXTERNAL PSPOLY$, SOLID_LINE$, GSELNT$
      CALL GSELNT$(N0)
      IF (FRAME) THEN
         X1 = ZERO + YTIC/FOUR
         X2 = ONE - YTIC/FOUR
         Y1 = ZERO + XTIC/FOUR
         Y2 = ONE - XTIC/FOUR
         IF (PS) THEN
            XFRAME(1) = X1
            XFRAME(2) = X2
            XFRAME(3) = X2
            XFRAME(4) = X1
            YFRAME(1) = Y1
            YFRAME(2) = Y1
            YFRAME(3) = Y2
            YFRAME(4) = Y2
            CALL PSPOLY$(ICOLOR, N4, XFRAME, YFRAME, 'pc')
         ELSE
            CALL SOLID_LINE$(X1, Y1, X2, Y1, ICOLOR)
            CALL SOLID_LINE$(X2, Y2, X1, Y2, ICOLOR)
            CALL SOLID_LINE$(X2, Y1, X2, Y2, ICOLOR)
            CALL SOLID_LINE$(X1, Y2, X1, Y1, ICOLOR)
         ENDIF
      ENDIF
      END
C
C