C 
C BARBAR$
C BARCHT_3D$ 
C
      SUBROUTINE BARBAR$(ICOLOR, IFILL, K, LCTEMP,
     +                   DELTA, FACTOR, WIDE, WIDE1,
     +                   X, XMAX, XMIN, YMAX, YMIN,
     +                   Y1, Y2, Y3, Y4, Y5,
     +                   BARCAP, PS)
C
C ACTION : Draw a shadow bar for 3-D perspective effect
C AUTHOR : W.G.Bardsley, University of Manchester
C          Derived from BARCHT$ 08/09/2001
C          03/12/2004 added IHUE  
C          19/05/2007 added INTENTS
C          11/03/2011 added background fill-in to obliterate lines underneath
C          23/05/2014 uses PSPOLY$ with N6 and 'pl' instead of 'pc' to force round line joins  
C
      IMPLICIT   NONE    
C
C Arguments
C                                             
      INTEGER,          INTENT (IN)    :: K, LCTEMP
      INTEGER,          INTENT (INOUT) :: ICOLOR, IFILL
      DOUBLE PRECISION, INTENT (IN)    :: WIDE, WIDE1, X, XMAX, XMIN,
     +                                    YMAX, YMIN, Y1, Y2, Y3, Y4, Y5  
      DOUBLE PRECISION, INTENT (INOUT) :: DELTA, FACTOR
      LOGICAL,          INTENT (IN)    :: BARCAP, PS
C
C Locals
C      
      INTEGER    N0, N1, N4, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N4 = 4, N5 = 5, N6 = 6)
      INTEGER    IHUE, COLOUR_INDEX
      DOUBLE PRECISION U(N6), V(N6), WX(N6), WY(N6), XDELTA, XX1, XX2,
     +                 YDELTA, YY1, YY2
      DOUBLE PRECISION ZERO, PNT25, PNT5, ONE
      PARAMETER (ZERO = 0.0D+00, PNT25 = 0.25D+00, PNT5 = 0.5D+00,
     +           ONE = 1.0D+000)
      EXTERNAL   PSPOLY$, SOLID_LINE$
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$
      EXTERNAL   FILL_POLYGON$, POLYLINE$
C
C Return if IFILL = 0
C
      IF (IFILL.EQ.0) RETURN
C
C Check that ICOLOR, IFILL, DELTA and FACTOR makes sense
C
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) THEN
         ICOLOR = 15
      ENDIF
      IF (IFILL.LT.0 .OR. IFILL.GT.10) THEN
         IFILL = 1
      ENDIF
      IF (DELTA.LT.ZERO) THEN
         DELTA = ZERO
      ENDIF
      IF (FACTOR.LT.ZERO .OR. FACTOR.GT.ONE) THEN
         FACTOR = ONE
      ENDIF
      CALL GSELNT$(K)
      CALL GSLN$(N1)
C
C Define U, V (This code must be exactly the same as in BARCHT$
C
      COLOUR_INDEX = ICOLOR
      IF (IFILL.EQ.2) THEN
         IHUE = N0
      ELSE
         IHUE = COLOUR_INDEX
      ENDIF
      U(1) = X - PNT5*DELTA*FACTOR
      U(2) = X + PNT5*DELTA*FACTOR
      U(3) = U(2)
      U(4) = U(1)
      U(5) = U(1)
      V(1) = Y2
      V(2) = Y2
      V(3) = Y4
      V(4) = Y4
      V(5) = V(1)
C
C Define XDELTA, YDELTA
C
      XDELTA = 0.025D+00*(XMAX - XMIN)
      YDELTA = 0.025D+00*(YMAX - YMIN)
C
C If Y2 > Y1 draw the bottom error bar
C
      IF (Y2.GT.Y1) THEN
         CALL GSLWSC$(WIDE1)
         IF (BARCAP) THEN
            WX(1) = X + PNT25*DELTA*FACTOR
            WX(2) = X - PNT25*DELTA*FACTOR
            WX(3) = WX(2) + XDELTA
            WX(4) = WX(1) + XDELTA
            WX(5) = WX(1)
            WX(6) = WX(2)
            WY(1) = Y1
            WY(2) = WY(1)
            WY(3) = WY(1) + YDELTA
            WY(4) = WY(3)
            WY(5) = WY(1)
            WY(6) = WY(2)
            IF (PS) THEN
               CALL PSPOLY$(LCTEMP, N4, WX, WY, 'pf')
               CALL PSPOLY$(IHUE, N6, WX, WY, 'pl')
            ELSE
               CALL FILL_POLYGON$(N5, WX, WY, LCTEMP)
               CALL POLYLINE$(N6, WX, WY, IHUE)
            ENDIF
         ENDIF
         WX(1) = X
         WX(2) = WX(1)
         WX(3) = WX(2) + XDELTA
         WX(4) = WX(3)
         WX(5) = WX(1)
         WX(6) = WX(2)
         WY(1) = Y1
         WY(2) = Y2
         WY(3) = WY(2) + YDELTA
         WY(4) = WY(1) + YDELTA
         WY(5) = WY(1)
         WY(6) = WY(2)
         IF (PS) THEN
            CALL PSPOLY$(LCTEMP, N4, WX, WY, 'pf')
            CALL PSPOLY$(IHUE, N6, WX, WY, 'pl')
         ELSE
            CALL FILL_POLYGON$(N5, WX, WY, LCTEMP)
            CALL POLYLINE$(N6, WX, WY, IHUE)
         ENDIF
      ENDIF
C
C If Y4 > Y2 draw a box
C
      IF (Y4.GT.Y2) THEN
         CALL GSLWSC$(WIDE)
         WX(1) = U(2)
         WX(2) = U(1)
         WX(3) = WX(2) + XDELTA
         WX(4) = WX(1) + XDELTA
         WX(5) = WX(1)
         WX(6) = WX(2)
         WY(1) = Y4
         WY(2) = WY(1)
         WY(3) = WY(2) + YDELTA
         WY(4) = WY(3)
         WY(5) = WY(1)
         WY(6) = WY(2)
         IF (PS) THEN
            CALL PSPOLY$(LCTEMP, N4, WX, WY, 'pf')
            CALL PSPOLY$(IHUE, N6, WX, WY, 'pl')
         ELSE
            CALL FILL_POLYGON$(N5, WX, WY, LCTEMP)
            CALL POLYLINE$(N6, WX, WY, IHUE)
         ENDIF
         WX(1) = U(2)
         WX(2) = WX(1)
         WX(3) = WX(2) + XDELTA
         WX(4) = WX(3)
         WX(5) = WX(1)
         WX(6) = WX(2)
         WY(1) = Y2
         WY(2) = Y4
         WY(3) = WY(2) + YDELTA
         WY(4) = WY(1) + YDELTA
         WY(5) = WY(1)
         WY(6) = WY(2)
         IF (PS) THEN
            CALL PSPOLY$(LCTEMP, N4, WX, WY, 'pf')
            CALL PSPOLY$(IHUE, N6, WX, WY, 'pl')
         ELSE
            CALL FILL_POLYGON$(N5, WX, WY, LCTEMP)
            CALL POLYLINE$(N6, WX, WY, IHUE)
         ENDIF
      ENDIF
C
C If Y3 > Y2 and Y4 > Y3 draw the median bar
C
      IF (Y3.GT.Y2 .AND. Y4.GT.Y3) THEN
         CALL GSLWSC$(WIDE)
         XX1 = U(2)
         XX2 = U(2) + XDELTA
         YY1 = Y3
         YY2 = Y3 + YDELTA
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
      ENDIF
C
C If Y5 > Y4 draw the top error bar
C
      IF (Y5.GT.Y4) THEN
         CALL GSLWSC$(WIDE1)
         WX(1) = X
         WX(2) = WX(1)
         WX(3) = WX(2) + XDELTA
         WX(4) = WX(3)
         WX(5) = WX(1)
         WX(6) = WX(2)
         WY(1) = Y4
         WY(2) = Y5
         WY(3) = WY(2) + YDELTA
         WY(4) = WY(1) + YDELTA
         WY(5) = WY(1)
         WY(6) = WY(2)
         IF (PS) THEN
            CALL PSPOLY$(LCTEMP, N4, WX, WY, 'pf')
            CALL PSPOLY$(IHUE, N6, WX, WY, 'pl')
         ELSE
            CALL FILL_POLYGON$(N5, WX, WY, LCTEMP)
            CALL POLYLINE$(N6, WX, WY, IHUE)
         ENDIF
         IF (BARCAP) THEN
            WX(1) = X + PNT25*DELTA*FACTOR
            WX(2) = X - PNT25*DELTA*FACTOR
            WX(3) = WX(2) + XDELTA
            WX(4) = WX(1) + XDELTA
            WX(5) = WX(1)
            WX(6) = WX(2)
            WY(1) = Y5
            WY(2) = WY(1)
            WY(3) = WY(1) + YDELTA
            WY(4) = WY(3)
            WY(5) = WY(1)
            WY(6) = WY(2)
            IF (PS) THEN
               CALL PSPOLY$(LCTEMP, N4, WX, WY, 'pf')
               CALL PSPOLY$(IHUE, N6, WX, WY, 'pl')
            ELSE
               CALL FILL_POLYGON$(N5, WX, WY, LCTEMP)
               CALL POLYLINE$(N6, WX, WY, IHUE)
            ENDIF
         ENDIF
      ENDIF
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE BARCHT_3D$(ICOLOR, IFILL, K, L, LCTEMP, NHATCH,
     +                      DELTA, FACTOR, WIDE, WIDE1,
     +                      X, XMAX, XMIN, YMAX, YMIN,
     +                      Y1, Y2, Y3, Y4, Y5,
     +                      BARCAP, PS, SIDE)
C
C ACTION : Draw a bar chart marker for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 9/6/95
C          14/07/1997 win32 version
C          09/01/2003 added WIDE1 for error bar line width and NHATCH
C          03/12/2004 added IHUE 
C          19/05/2007 added INTENTS 
C          22/03/2010 changed IFILL = 1 to outline
C          11/03/2011 added background fill-in to obliterate lines underneath
C          23/05/2014 uses PSPOLY$ with N6 and 'pl' instead of 'pc' to force round line joins  
C
C          ICOLOR = colour
C          IFILL = fill style: 0=none,1=empty,2=full
C          DELTA = maximum width
C          FACTOR = fraction of width used for bar
C          X = x-value
C          Y1 = bottom of error bar (whisker)
C          Y2 = bottom of box (upper quartile)
C          Y3 = median bar
C          Y4 = top of box (upper quartile)
C          Y5 = top of error bar (whisker)
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: K, L, LCTEMP, NHATCH
      INTEGER,          INTENT (INOUT) :: ICOLOR, IFILL
      DOUBLE PRECISION, INTENT (IN)    :: WIDE, WIDE1, X, XMAX, XMIN,
     +                                    YMAX, YMIN, Y1, Y2, Y3, Y4, Y5  
      DOUBLE PRECISION, INTENT (INOUT) :: DELTA, FACTOR
      LOGICAL,          INTENT (IN)    :: BARCAP, PS, SIDE
C
C Locals
C      
      INTEGER    NMAX, N0, N1, N4, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N4 = 4, N5 = 5, N6 = 6)
      INTEGER    I, IHUE
      INTEGER    COLOUR_INDEX
      DOUBLE PRECISION ALPHA, BETA, U(N6), V(N6), XDELTA, XX1, XX2,
     +                 YDELTA, YDIFF, YY1, YY2
      DOUBLE PRECISION ZERO, PNT25, PNT5, ONE, TWO, THREE, FOUR
      PARAMETER (ZERO = 0.0D+00, PNT25 = 0.25D+00, PNT5 = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00)
      EXTERNAL   PSPOLY$, SOLID_LINE$
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$
      EXTERNAL   FILL_POLYGON$, POLYLINE$, STRIPE$
      INTRINSIC  DBLE
C
C Return if IFILL = 0
C
      IF (IFILL.EQ.0) RETURN
C
C Check that ICOLOR, IFILL, DELTA and FACTOR makes sense
C
      IF (NHATCH.LT.80) THEN
         NMAX = 80
      ELSE
         NMAX = NHATCH
      ENDIF
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) THEN
         ICOLOR = 15
      ENDIF
      IF (IFILL.LT.0 .OR. IFILL.GT.10) THEN
         IFILL = 1
      ENDIF
      IF (DELTA.LT.ZERO) THEN
         DELTA = ZERO
      ENDIF
      IF (FACTOR.LT.ZERO .OR. FACTOR.GT.ONE) THEN
         FACTOR = ONE
      ENDIF
      CALL GSELNT$(K)
      CALL GSLN$(N1)
C
C Define U, V
C
      COLOUR_INDEX = ICOLOR
      IF (IFILL.EQ.2) THEN
         IHUE = N0
      ELSE
         IHUE = COLOUR_INDEX
      ENDIF
      U(1) = X - PNT5*DELTA*FACTOR
      U(2) = X + PNT5*DELTA*FACTOR
      U(3) = U(2)
      U(4) = U(1)
      U(5) = U(1)
      V(1) = Y2
      V(2) = Y2
      V(3) = Y4
      V(4) = Y4
      V(5) = V(1)
C
C If Y2 > Y1 draw the bottom error bar
C
      IF (Y2.GT.Y1) THEN
         CALL GSLWSC$(WIDE1)
         XX1 = X
         XX2 = X
         YY1 = Y1
         YY2 = Y2
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         IF (BARCAP) THEN
            XX1 = X - PNT25*DELTA*FACTOR
            XX2 = X + PNT25*DELTA*FACTOR
            YY2 = Y1
            CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         ENDIF
      ENDIF
C
C If Y4 > Y2 draw a box
C
      IF (Y4.GT.Y2) THEN
         U(6) = U(2)
         V(6) = V(2)
         CALL GSLWSC$(WIDE)
         IF (PS) THEN
            CALL PSPOLY$(LCTEMP, N4, U, V, 'pf')
            IF (IFILL.EQ.2) THEN
               CALL PSPOLY$(COLOUR_INDEX, N4, U, V, 'pf')
            ELSEIF (IFILL.NE.1) THEN
               CALL PSPOLY$(COLOUR_INDEX, N4, U, V, 'pe')
            ENDIF
            CALL PSPOLY$(IHUE, N6, U, V, 'pl')
         ELSE
            CALL FILL_POLYGON$(N5, U, V, LCTEMP) 
            IF (IFILL.EQ.2) THEN
               CALL FILL_POLYGON$(N5, U, V, COLOUR_INDEX)
            ELSEIF (IFILL.NE.1) THEN
               CALL FILL_POLYGON$(N5, U, V, LCTEMP)
            ENDIF
            CALL POLYLINE$(N6, U, V, IHUE)
         ENDIF
         IF (IFILL.GT.2) THEN
            IF (IFILL.GT.7) CALL GSLN$(L)
            CALL GSLWSC$(PNT25)
            XDELTA = (XMAX - XMIN)/DBLE(NMAX)
            YDIFF = YMAX - YMIN
            YDELTA = TWO*YDIFF/DBLE(NMAX)
         ENDIF
         IF (IFILL.EQ.3 .OR. IFILL.EQ.5 .OR. IFILL.GT.7) THEN
            ALPHA = YMIN - THREE*YDIFF
            IF (SIDE) THEN
               BETA = YDIFF/(XMAX - XMIN)
            ELSE
               BETA = (FOUR/THREE)*YDIFF/(XMAX - XMIN)
            ENDIF
            DO I = 1, 6*NMAX
               ALPHA = ALPHA + YDELTA
               CALL STRIPE$(COLOUR_INDEX, IFILL, ALPHA, BETA, U, V)
            ENDDO
         ENDIF
         IF (IFILL.EQ.4 .OR. IFILL.EQ.5) THEN
            ALPHA = YMIN - YDIFF
            IF (SIDE) THEN
               BETA = YDIFF/(XMIN - XMAX)
            ELSE
               BETA = (FOUR/THREE)*YDIFF/(XMIN - XMAX)
            ENDIF
            DO I = 1, 6*NMAX
               ALPHA = ALPHA + YDELTA
               CALL STRIPE$(COLOUR_INDEX, IFILL, ALPHA, BETA, U, V)
            ENDDO
         ENDIF
         IF (IFILL.EQ.6) THEN
            XX1 = U(1)
            XX2 = U(2)
            YY1 = YMIN - YDIFF
            YDELTA = (THREE/FOUR)*YDELTA
            DO I = 1, 4*NMAX
               YY1 = YY1 + YDELTA
               IF (YY1.GT.Y2 .AND. YY1.LT.Y4) THEN
                  YY2 = YY1
                  CALL SOLID_LINE$(XX1, YY1, XX2, YY2, COLOUR_INDEX)
               ENDIF
            ENDDO
         ENDIF
         IF (IFILL.EQ.7) THEN
            YY1 = Y2
            YY2 = Y4
            XX1 = XMIN - 10.0*XDELTA
            DO I = 1, 4*NMAX
               XX1 = XX1 + XDELTA
               IF (XX1.GT.U(1) .AND. XX1.LT.U(2)) THEN
                  XX2 = XX1
                  CALL SOLID_LINE$(XX1, YY1, XX2, YY2, COLOUR_INDEX)
               ENDIF
            ENDDO
         ENDIF
         IF (IFILL.GT.2) THEN
            IF (IFILL.GT.7) CALL GSLN$(N1)
            CALL GSLWSC$(WIDE)
         ENDIF
      ENDIF
C
C If Y5 > Y4 draw the top error bar
C
      IF (Y5.GT.Y4) THEN
         CALL GSLWSC$(WIDE1)
         XX1 = X
         XX2 = X
         YY1 = Y4
         YY2 = Y5
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         IF (BARCAP) THEN
            XX1 = X - PNT25*DELTA*FACTOR
            XX2 = X + PNT25*DELTA*FACTOR
            YY1 = Y5
            CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         ENDIF
      ENDIF
C
C If Y3 > Y2 and Y4 > Y3 draw the median bar
C
      IF (Y3.GT.Y2 .AND. Y4.GT.Y3) THEN
         CALL GSLWSC$(WIDE)
         XX1 = U(1)
         XX2 = U(2)
         YY1 = Y3
         YY2 = Y3
         IF (COLOUR_INDEX.EQ.0) IHUE = 0
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
      ENDIF
      END
C
C