C
C
      SUBROUTINE BARCHT$(ICOLOR, IFILL_IN, K, L, LCTEMP, NHATCH,
     +                   DELTA_IN, FACTOR_IN, WIDE, WIDE1,
     +                   X, XMAX, XMIN, YMAX, YMIN,
     +                   Y1, Y2, Y3, Y4, Y5,
     +                   BARCAP, PS, SIDE)
C
C ACTION : Draw a bar chart marker for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 9/6/95
C          14/07/1997 win32 version
C          09/01/2003 added WIDE1 for error bar line width and NHATCH
C          03/12/2004 added IHUE 
C          19/05/2007 added INTENTS 
C          22/03/2010 changed IFILL = 1 to outline
C          11/03/2011 added background fill-in to obliterate lines underneath
C          25/08/2014 uses MITER_POLYLINE$ to force miter joins 
C          13/11/2016 removed background fill-in for IFILL_IN = 1 to make OUTLINE mean outline_only 
C                     added new variables so all arguments are now INTENT (IN) and changed maximum DELTA to 10
C          02/12/2016 added an outline in black for the special case of a solid box with no error bars
C                     
C          ICOLOR = colour
C          IFILL = fill style: 1=none,2=full, etc.
C          DELTA = maximum width
C          FACTOR = fraction of width used for bar
C          X = x-value
C          Y1 = bottom of error bar (whisker)
C          Y2 = bottom of box (upper quartile)
C          Y3 = median bar
C          Y4 = top of box (upper quartile)
C          Y5 = top of error bar (whisker)
C
C Note: at 13/11/2016 the colour scheme is as follows:
C       The case ICOLOR .NE. LCTEMP
C          IHUE = ICOLOR 
C          IFILL = 1: outline in IHUE, interior not filled   
C          IFILL = 2: outline and interior in IHUE   
C                O/W: outline in IHUE interior in LCTEMP
C       The case ICOLOR.EQ.LCTEMP 
C           IHUE = 0
C           IFILL = 1: outline in IHUE, interior not filled
C                 O/W: outline in IHUE, interior filled with LCTEMP 
C                  

      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: K, L, LCTEMP, NHATCH
      INTEGER,          INTENT (IN)    :: ICOLOR, IFILL_IN
      DOUBLE PRECISION, INTENT (IN)    :: WIDE, WIDE1, X, XMAX, XMIN,
     +                                    YMAX, YMIN, Y1, Y2, Y3, Y4, Y5  
      DOUBLE PRECISION, INTENT (IN)    :: DELTA_IN, FACTOR_IN
      LOGICAL,          INTENT (IN)    :: BARCAP, PS, SIDE
C
C Locals
C      
      INTEGER    NMAX, N0, N1, N4, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N4 = 4, N5 = 5, N6 = 6)
      INTEGER    I, IFILL, IHUE, JHUE, LCBACK
      DOUBLE PRECISION DELTA, FACTOR
      DOUBLE PRECISION ALPHA, BETA, U(N6), V(N6), XDELTA, XX1, XX2,
     +                 YDELTA, YDIFF, YY1, YY2
      DOUBLE PRECISION ZERO, PNT25, PNT5, ONE, TWO, THREE, FOUR, TEN, 
     +                 TENSQD
      PARAMETER (ZERO = 0.0D+00, PNT25 = 0.25D+00, PNT5 = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, TEN = 10.0D+00, TENSQD = TEN*TEN)
      EXTERNAL   PSPOLY$, SOLID_LINE$
      EXTERNAL   GSELNT$, GSLN$, GSLWSC$
      EXTERNAL   FILL_POLYGON$, MITER_POLYLINE$, STRIPE$
      INTRINSIC  DBLE, ABS
C
C Return if IFILL = 0
C
      IF (IFILL_IN.EQ.0) RETURN
C
C Check that ICOLOR, IFILL, DELTA and FACTOR makes sense
C
      DELTA = DELTA_IN
      FACTOR = FACTOR_IN
      IF (NHATCH.LT.80) THEN
         NMAX = 80
      ELSE
         NMAX = NHATCH
      ENDIF
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71 .OR. ICOLOR.EQ.LCTEMP) THEN
         IHUE = N0
         JHUE = LCTEMP
      ELSE   
         IHUE = ICOLOR
         JHUE = ICOLOR
      ENDIF
      LCBACK = LCTEMP
      IF (IFILL_IN.LT.0 .OR. IFILL_IN.GT.10) THEN
         IFILL = 1
      ELSE
         IFILL = IFILL_IN   
      ENDIF
C
C The special case of outlining a solid box with no error bars in black
C      
      IF (IFILL.EQ.2 .AND. IHUE.NE.N0 .AND. LCBACK.NE.N0) THEN
         YDIFF = (Y5 - Y1)/TENSQD
         IF (ABS(Y2 - Y1).LT.YDIFF .AND.
     +       ABS(Y5 - Y4).LT.YDIFF) IHUE = N0
      ENDIF  
      IF (DELTA.LT.ZERO) THEN
         DELTA = ZERO
      ENDIF
      IF (FACTOR.LT.ZERO .OR. FACTOR.GT.TEN) THEN
         FACTOR = ONE
      ENDIF
      CALL GSELNT$(K)
      CALL GSLN$(N1)
C
C Define U, V
C
      U(1) = X - PNT5*DELTA*FACTOR
      U(2) = X + PNT5*DELTA*FACTOR
      U(3) = U(2)
      U(4) = U(1)
      U(5) = U(1)
      V(1) = Y2
      V(2) = Y2
      V(3) = Y4
      V(4) = Y4
      V(5) = V(1)
C
C If Y2 > Y1 draw the bottom error bar
C
      IF (Y2.GT.Y1) THEN
         CALL GSLWSC$(WIDE1)
         XX1 = X
         XX2 = X
         YY1 = Y1
         YY2 = Y2
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         IF (BARCAP) THEN
            XX1 = X - PNT25*DELTA*FACTOR
            XX2 = X + PNT25*DELTA*FACTOR
            YY2 = Y1
            CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         ENDIF
      ENDIF
C
C If Y4 > Y2 draw a box
C
      IF (Y4.GT.Y2) THEN
         U(6) = U(2)
         V(6) = V(2)
         CALL GSLWSC$(WIDE)
         IF (PS) THEN
            IF (IFILL.EQ.2) THEN
               CALL PSPOLY$(JHUE, N4, U, V, 'pf')
            ELSEIF (IFILL.NE.1) THEN
               CALL PSPOLY$(LCBACK, N4, U, V, 'pf')
            ENDIF
            CALL PSPOLY$(IHUE, N4, U, V, 'pc')
         ELSE
            IF (IFILL.EQ.2) THEN
               CALL FILL_POLYGON$(N5, U, V, JHUE)
            ELSEIF (IFILL.NE.1) THEN
               CALL FILL_POLYGON$(N5, U, V, LCBACK)
            ENDIF
            CALL MITER_POLYLINE$(N6, U, V, IHUE)
         ENDIF
         IF (IFILL.GT.2) THEN
            IF (IFILL.GT.7) CALL GSLN$(L)
            CALL GSLWSC$(PNT25)
            XDELTA = (XMAX - XMIN)/DBLE(NMAX)
            YDIFF = YMAX - YMIN
            YDELTA = TWO*YDIFF/DBLE(NMAX)
         ENDIF
         IF (IFILL.EQ.3 .OR. IFILL.EQ.5 .OR. IFILL.GT.7) THEN
            ALPHA = YMIN - THREE*YDIFF
            IF (SIDE) THEN
               BETA = YDIFF/(XMAX - XMIN)
            ELSE
               BETA = (FOUR/THREE)*YDIFF/(XMAX - XMIN)
            ENDIF
            DO I = 1, 6*NMAX
               ALPHA = ALPHA + YDELTA
               CALL STRIPE$(IHUE, IFILL, ALPHA, BETA, U, V)
            ENDDO
         ENDIF
         IF (IFILL.EQ.4 .OR. IFILL.EQ.5) THEN
            ALPHA = YMIN - YDIFF
            IF (SIDE) THEN
               BETA = YDIFF/(XMIN - XMAX)
            ELSE
               BETA = (FOUR/THREE)*YDIFF/(XMIN - XMAX)
            ENDIF
            DO I = 1, 6*NMAX
               ALPHA = ALPHA + YDELTA
               CALL STRIPE$(IHUE, IFILL, ALPHA, BETA, U, V)
            ENDDO
         ENDIF
         IF (IFILL.EQ.6) THEN
            XX1 = U(1)
            XX2 = U(2)
            YY1 = YMIN - YDIFF
            YDELTA = (THREE/FOUR)*YDELTA
            DO I = 1, 4*NMAX
               YY1 = YY1 + YDELTA
               IF (YY1.GT.Y2 .AND. YY1.LT.Y4) THEN
                  YY2 = YY1
                  CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
               ENDIF
            ENDDO
         ENDIF
         IF (IFILL.EQ.7) THEN
            YY1 = Y2
            YY2 = Y4
            XX1 = XMIN - 10.0*XDELTA
            DO I = 1, 4*NMAX
               XX1 = XX1 + XDELTA
               IF (XX1.GT.U(1) .AND. XX1.LT.U(2)) THEN
                  XX2 = XX1
                  CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
               ENDIF
            ENDDO
         ENDIF
         IF (IFILL.GT.2) THEN
            IF (IFILL.GT.7) CALL GSLN$(N1)
            CALL GSLWSC$(WIDE)
         ENDIF
      ENDIF
C
C If Y5 > Y4 draw the top error bar
C
      IF (Y5.GT.Y4) THEN
         CALL GSLWSC$(WIDE1)
         XX1 = X
         XX2 = X
         YY1 = Y4
         YY2 = Y5
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         IF (BARCAP) THEN
            XX1 = X - PNT25*DELTA*FACTOR
            XX2 = X + PNT25*DELTA*FACTOR
            YY1 = Y5
            CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
         ENDIF
      ENDIF
C
C If Y3 > Y2 and Y4 > Y3 draw the median bar
C
      IF (Y3.GT.Y2 .AND. Y4.GT.Y3) THEN
         CALL GSLWSC$(WIDE)
         XX1 = U(1)
         XX2 = U(2)
         YY1 = Y3
         YY2 = Y3
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, IHUE)
      ENDIF
      END
C
C