C 
C
      SUBROUTINE BCKEYS$(ISEND, IFILL_1, IHUE_1, LCTEMP, MCOLOR, NCFONT,
     +                   NOUT_PS, NPTS_1,
     +                   SIDE_X, SIDE_Y, WIDE, WIDE1, XPC, Y_SCALE,
     +                   PLINE, PSYMB,
     +                   HARD_COPY, HPGL, MONO, PS, SIDE, VIDEO)
C
C
C ACTION : Panel/key for simplot BARCHART
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/6/95
C          23/09/1996 Added PLTSTR$ and VECTOR
C          20/02/1997 Added BARCAP_TEMP
C          14/07/1997 win32 version
C          25/10/2001 introduced IFILL_1, IHUE_1, NPTS_1
C          08/01/2003 extensive editing to use THERE(i,j) and added WIDE1
C          19/10/2004 added ITYPE, XSIZE, STORE, and FSIZES$
C          26/10/2004 Edited to allow ISEND = 4 
C          19/05/2007 added INTENTS
C          06/12/2010 added PLINE and PSYMB to arguments 
C          14/05/2011 added MODULE_SAVEGKS and BCPANL$ and increased max. bottom panel to 8 
C
C          ISEND = 0: Initialise for new data
C          ISEND = 1: Plot
C          ISEND = 2: Edit
C          ISEND = 3: Respond to mouse drag and drop
C          ISEND = 4: Refresh the panel fill styles and colours
C
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,             INTENT (IN)    :: NPTS_1, IFILL_1(NPTS_1),
     +                                       IHUE_1(NPTS_1)
      INTEGER,             INTENT (IN)    :: ISEND, LCTEMP, MCOLOR,
     +                                       NCFONT, NOUT_PS
      DOUBLE PRECISION,    INTENT (IN)    :: SIDE_X, SIDE_Y, WIDE,
     +                                       WIDE1, XPC, Y_SCALE
      CHARACTER (LEN = *), INTENT (INOUT) :: PLINE(20), PSYMB(20)
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, MONO, PS,
     +                                       SIDE, VIDEO
C
C Locals
C
      INTEGER    ITYPE, NGKS, NHATCH
      PARAMETER (ITYPE = 10, NGKS = 0, NHATCH = 100)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N15, N20,
     +           N72
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N15 = 15, N20 = 20, 
     +           N72 = 72)
      INTEGER    ICOLOR(N20), IFILL(N20), KCOLOR
      INTEGER    I, J, K, L, NBARS, NFONT, NGROUP
      INTEGER    NBAR_1, NGROUP_1
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION X1, X2, X3
      PARAMETER (X1 = 0.725D+00, X2 = 0.77D+00, X3 = 0.85D+00)
      DOUBLE PRECISION XX1, XX2, XX3
      PARAMETER (XX1 = 0.075D+00, XX2 = 0.4D+00, XX3 = 0.725D+00)
      DOUBLE PRECISION ZZ1, ZZ2, ZZ3, ZZ4
      PARAMETER (ZZ1 = 0.05D+00, ZZ2 = 0.3D+00, ZZ3 = 0.55D+00,
     +           ZZ4 = 0.8D+00)
      DOUBLE PRECISION WW1, WW2, WW3, WW4, WW5
      PARAMETER (WW1 = 0.05D+00, WW2 = 0.25D+00, WW3 = 0.45D+00,
     +           WW4 = 0.65D+00, WW5 = 0.85D+00)     
      DOUBLE PRECISION YY1, YY2
      PARAMETER (YY1 = 0.02D+00, YY2 = 0.06D+00)
      DOUBLE PRECISION XBOT, XTOP
      PARAMETER (XBOT = 0.05D+00, XTOP = 0.95D+00)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YBOT = 0.25D+00, YTOP = 0.95D+00)
      DOUBLE PRECISION YMAX, YMIN, PNT04, PNT06
      PARAMETER (YMAX = 0.85D+00, YMIN = 0.05D+00, PNT04 = 0.04D+00,
     +           PNT06 = 0.06D+00)
      DOUBLE PRECISION FACTOR(N20), DTEMP
      DOUBLE PRECISION XDELTA, XSIZE, XTEMP, YDELTA, YTEMP, Y1, Y2
      DOUBLE PRECISION PNT25, PNT5, PNT8
      PARAMETER (PNT25 = 0.25D+00, PNT5 = 0.5D+00, PNT8 = 0.8D+00)
      DOUBLE PRECISION SLANT, XSTART, YSTART
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    BARCAP, SIDE1, STORE
      PARAMETER (BARCAP = .FALSE., SIDE1 = .FALSE.)
      LOGICAL    FIRST, THERE(N10,N72)
      EXTERNAL   PLTSTR$, BCPANL$, BARCHT$, WGBFNT$, FSIZES$, SAVINT$
      EXTERNAL   SAVBCK$
      INTRINSIC  DBLE, MIN
      SAVE       FACTOR, XSTART, YSTART
      SAVE       ICOLOR, IFILL
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      DATA       XSTART, YSTART / X3, YMAX /
C
C Initialise
C      
      STORE = .FALSE.
      CALL SAVINT$(N3, N3, NBAR_1,
     +             STORE)  
      CALL SAVINT$(N4, N4, NGROUP_1,
     +             STORE)  
C
C Further action depends on ISEND
C         
      IF (ISEND.EQ.N0) THEN
C
C ISEND = 0 or 4: Initialise for new data to set up defaults or refresh
C
         DO J = N1, N72
            DO I = N1, N10
               THERE(I,J) = .FALSE.
            ENDDO
         ENDDO
         DO I = N1, N20
            ICOLOR(I) = N0
            IFILL(I) = N0
            IF (FIRST) THEN
               FACTOR(I) = ONE
            ENDIF
         ENDDO
         FIRST = .FALSE.
         NBARS = N0
         IF (NGROUP_1.EQ.1) THEN
C
C Only 1 group so make all panel items count
C           
           
            DO I = N1, MIN(NPTS_1,N20)
               NBARS = NBARS + N1
               IFILL(NBARS) = IFILL_1(I)
               ICOLOR(NBARS) = IHUE_1(I)
               J = IFILL_1(I)
               K = IHUE_1(I) + N1
               THERE(J,K) = .TRUE.
            ENDDO   
         ELSE
C
C Choose panel on unique fill style and colour
C             
            DO I = N1, NPTS_1
               J = IFILL_1(I)
               K = IHUE_1(I) + N1
               IF (J.GE.N1 .AND. J.LE.N10 .AND. NBARS.LT.N20 .AND.
     +             K.GE.N1 .AND. K.LE.N72) THEN
                  IF (.NOT.THERE(J,K) .AND. NBARS.LT.N20) THEN
C
C A new colour and fill style has been encountered so add a panel item
C
                     NBARS = NBARS + N1
                     THERE(J,K) = .TRUE.
                     IFILL(NBARS) = IFILL_1(I)
                     ICOLOR(NBARS) = IHUE_1(I)
                  ENDIF
               ENDIF
            ENDDO
         ENDIF
         IF (NBARS.LT.N20) THEN
            DO I = NBARS + N1, N20
               IFILL(I) = N0
               PLINE(I) = BLANK
            ENDDO
         ENDIF      
         STORE = .TRUE.
         CALL SAVBCK$(IFILL, ICOLOR, NBARS,
     +                STORE)         
         IF (ISEND.EQ.N0) THEN
C
C Calculate coordinates for panel
C
            YDELTA = (YMAX - YMIN)/DBLE(N20)
            XSTART = X3
            YSTART = YMAX - DBLE(N20 - NBARS)*YDELTA/TWO
         ENDIF
      ELSEIF (ISEND.EQ.N1) THEN
C
C Plot the labels on PANEL/KEY ........................................
C
         STORE = .FALSE. 
         CALL SAVBCK$(IFILL, ICOLOR, N20,
     +                STORE)       
         CALL FSIZES$(ITYPE, 
     +                XSIZE, 
     +                STORE)
         IF (PS) WRITE (NOUT_PS,100) XSIZE
         CALL WGBFNT$(I, NFONT, SLANT)
         IF (SIDE) THEN
C
C Panel at side
C           
            IF (XSTART.LT.XBOT) XSTART = XBOT
            IF (XSTART.GT.XTOP) XSTART = XTOP
            IF (YSTART.LT.YBOT) YSTART = YBOT
            IF (YSTART.GT.YTOP) YSTART = YTOP
            XDELTA = X2 - X1
            YDELTA = (YMAX - YMIN)/DBLE(N20)
            Y1 = YSTART
            DO I = N1, N20
               IF (IFILL(I).NE.N0 .AND. PLINE(I).NE.BLANK) THEN
                  Y1 = Y1 - YDELTA
                  Y2 = Y1 + PNT8*YDELTA
                  IF (MONO) THEN
                     IF (VIDEO) THEN
                        KCOLOR = N0
                     ELSE
                        KCOLOR = N15
                     ENDIF
                  ELSE
                     KCOLOR = ICOLOR(I)
                  ENDIF
                  CALL PLTSTR$(MCOLOR, NCFONT, NFONT, NGKS,
     +                         NOUT_PS, ZERO, XSIZE*XPC, ZERO, XSTART,
     +                         Y1 + PNT25*YDELTA, Y_SCALE,
     +                         BLANK, PLINE(I), PSYMB(I), 'left',
     +                         HARD_COPY, HPGL, PS)
                  IF (IFILL(I).LE.N7) THEN
                     L = N1
                  ELSEIF (IFILL(I).EQ.N8) THEN
                     L = N2
                  ELSEIF (IFILL(I).EQ.N9) THEN
                     L = N3
                  ELSEIF (IFILL(I).EQ.N10) THEN
                     L = N4
                  ENDIF
                  CALL BARCHT$(KCOLOR, IFILL(I), N2, L, LCTEMP, NHATCH,
     +                         XDELTA, FACTOR(I), WIDE, WIDE1,
     +                         XSTART - PNT04, YMAX, YMIN, YMAX, YMIN,
     +                         Y1, Y1, Y1, Y2, Y2,
     +                         BARCAP, PS, SIDE1)
               ENDIF
            ENDDO
         ELSE
C
C Panel at bottom
C           
            NBARS = N0
            DO I = N1, N20
               IF (IFILL(I).NE.N0 .AND. PLINE(I).NE.BLANK)
     +             NBARS = NBARS + N1
            ENDDO
            IF (NBARS.LE.N6) THEN
C
C Action for up to 6 items
C              
               XDELTA = PNT25*(XX2 - XX1)
               YDELTA = PNT25*(YY2 - YY1)
               K = N0
               DO I = N1, N20
                  IF (NBARS.LE.N3) THEN
                     YTEMP = YY1
                  ELSE
                     IF (K.LE.N2) THEN
                        YTEMP = YY2
                     ELSE
                        YTEMP = YY1
                     ENDIF
                  ENDIF
                  IF (K.LT.N6 .AND. IFILL(I).NE.N0 .AND.
     +                PLINE(I).NE.BLANK) THEN
                     K = K + N1
                     IF (K.EQ.N1 .OR. K.EQ.N4) THEN
                        XTEMP = XX1
                     ELSEIF (K.EQ.N2 .OR. K.EQ.N5) THEN
                        XTEMP = XX2
                     ELSE
                        XTEMP = XX3
                     ENDIF
                     Y1 = YTEMP - PNT25*YDELTA
                     Y2 = YTEMP + TWO*YDELTA + PNT25*YDELTA
                     IF (MONO) THEN
                        IF (VIDEO) THEN
                           KCOLOR = N0
                        ELSE
                           KCOLOR = N15
                        ENDIF
                     ELSE
                        KCOLOR = ICOLOR(I)
                     ENDIF
                     CALL PLTSTR$(MCOLOR, NCFONT, NFONT, NGKS,
     +                            NOUT_PS, ZERO, XSIZE*XPC, ZERO,
     +                            XTEMP + PNT5*XDELTA, YTEMP, Y_SCALE,
     +                            BLANK, PLINE(I), PSYMB(I), 'left',
     +                            HARD_COPY, HPGL, PS)
                     IF (IFILL(I).LE.N7) THEN
                        L = N1
                     ELSEIF (IFILL(I).EQ.N8) THEN
                        L = N2
                     ELSEIF (IFILL(I).EQ.N9) THEN
                       L = N3
                     ELSEIF (IFILL(I).EQ.N10) THEN
                        L = N4
                     ENDIF   
                     DTEMP = PNT5*XDELTA
                     CALL BARCHT$(KCOLOR, IFILL(I), N2, L, LCTEMP,
     +                            NHATCH,
     +                            DTEMP, FACTOR(I), WIDE, WIDE1,
     +                            XTEMP, YMAX, YMIN, YMAX, YMIN,
     +                            Y1, Y1, Y1, Y2, Y2, 
     +                            BARCAP, PS, SIDE1)
                  ENDIF
               ENDDO
            ELSEIF (NBARS.LE.N8) THEN
C
C Action for up to 8 items
C              
               XDELTA = PNT25*(ZZ2 - ZZ1)
               YDELTA = PNT25*(YY2 - YY1)
               K = N0
               DO I = N1, N20
                  IF (K.LE.N3) THEN
                     YTEMP = YY2
                  ELSE
                     YTEMP = YY1
                  ENDIF
                  IF (K.LT.N8 .AND. IFILL(I).NE.N0 .AND.
     +                PLINE(I).NE.BLANK) THEN
                     K = K + N1
                     IF (K.EQ.N1 .OR. K.EQ.N5) THEN
                        XTEMP = ZZ1
                     ELSEIF (K.EQ.N2 .OR. K.EQ.N6) THEN
                        XTEMP = ZZ2
                     ELSEIF (K.EQ.N3 .OR. K.EQ.N7) THEN
                        XTEMP = ZZ3   
                     ELSE
                        XTEMP = ZZ4
                     ENDIF
                     Y1 = YTEMP - PNT25*YDELTA
                     Y2 = YTEMP + TWO*YDELTA + PNT25*YDELTA
                     IF (MONO) THEN
                        IF (VIDEO) THEN
                           KCOLOR = N0
                        ELSE
                           KCOLOR = N15
                        ENDIF
                     ELSE
                        KCOLOR = ICOLOR(I)
                     ENDIF
                     CALL PLTSTR$(MCOLOR, NCFONT, NFONT, NGKS,
     +                            NOUT_PS, ZERO, XSIZE*XPC, ZERO,
     +                            XTEMP + PNT5*XDELTA, YTEMP, Y_SCALE,
     +                            BLANK, PLINE(I), PSYMB(I), 'left',
     +                            HARD_COPY, HPGL, PS)
                     IF (IFILL(I).LE.N7) THEN
                        L = N1
                     ELSEIF (IFILL(I).EQ.N8) THEN
                        L = N2
                     ELSEIF (IFILL(I).EQ.N9) THEN
                        L = N3
                     ELSEIF (IFILL(I).EQ.N10) THEN
                        L = N4
                     ENDIF   
                     DTEMP = PNT5*XDELTA
                     CALL BARCHT$(KCOLOR, IFILL(I), N2, L, LCTEMP,
     +                            NHATCH,
     +                            DTEMP, FACTOR(I), WIDE, WIDE1,
     +                            XTEMP, YMAX, YMIN, YMAX, YMIN,
     +                            Y1, Y1, Y1, Y2, Y2, 
     +                            BARCAP, PS, SIDE1)
                  ENDIF
               ENDDO
           ELSE
C
C Action for up to 10 items
C              
               XDELTA = 0.2D+00*(ZZ2 - ZZ1)
               YDELTA = PNT25*(YY2 - YY1)
               K = N0
               DO I = N1, N20
                  IF (K.LE.N4) THEN
                     YTEMP = YY2
                  ELSE
                     YTEMP = YY1
                  ENDIF
                  IF (K.LT.N10 .AND. IFILL(I).NE.N0 .AND.
     +                PLINE(I).NE.BLANK) THEN
                     K = K + N1
                     IF (K.EQ.N1 .OR. K.EQ.N6) THEN
                        XTEMP = WW1
                     ELSEIF (K.EQ.N2 .OR. K.EQ.N7) THEN
                        XTEMP = WW2
                     ELSEIF (K.EQ.N3 .OR. K.EQ.N8) THEN
                        XTEMP = WW3   
                     ELSEIF (K.EQ.N4 .OR. K.EQ.N9) THEN
                        XTEMP = WW4      
                     ELSE
                        XTEMP = WW5
                     ENDIF
                     Y1 = YTEMP - PNT25*YDELTA
                     Y2 = YTEMP + TWO*YDELTA + PNT25*YDELTA
                     IF (MONO) THEN
                        IF (VIDEO) THEN
                           KCOLOR = N0
                        ELSE
                           KCOLOR = N15
                        ENDIF
                     ELSE
                        KCOLOR = ICOLOR(I)
                     ENDIF
                     CALL PLTSTR$(MCOLOR, NCFONT, NFONT, NGKS,
     +                            NOUT_PS, ZERO, XSIZE*XPC, ZERO,
     +                            XTEMP + PNT5*XDELTA, YTEMP, Y_SCALE,
     +                            BLANK, PLINE(I), PSYMB(I), 'left',
     +                            HARD_COPY, HPGL, PS)
                     IF (IFILL(I).LE.N7) THEN
                        L = N1
                     ELSEIF (IFILL(I).EQ.N8) THEN
                        L = N2
                     ELSEIF (IFILL(I).EQ.N9) THEN
                        L = N3
                     ELSEIF (IFILL(I).EQ.N10) THEN
                        L = N4
                     ENDIF   
                     DTEMP = PNT5*XDELTA
                     CALL BARCHT$(KCOLOR, IFILL(I), N2, L, LCTEMP,
     +                            NHATCH,
     +                            DTEMP, FACTOR(I), WIDE, WIDE1,
     +                            XTEMP, YMAX, YMIN, YMAX, YMIN,
     +                            Y1, Y1, Y1, Y2, Y2, 
     +                            BARCAP, PS, SIDE1)
                  ENDIF
               ENDDO
            ENDIF  
         ENDIF
         IF (PS) WRITE (NOUT_PS,100) ONE/XSIZE
      ELSEIF (ISEND.EQ.N2) THEN
C
C Edit the panel labels
C
         IF (NGROUP_1.EQ.N1) THEN
            NGROUP = MIN(NBAR_1, N20)
         ELSE
            NGROUP = MIN(NGROUP_1, N20)
         ENDIF      
         CALL BCPANL$(NGROUP,
     +                PLINE, PSYMB)
      ELSEIF (ISEND.EQ.N3) THEN
C
C Move the panel
C
         XSTART = SIDE_X + PNT06
         YSTART = SIDE_Y
      ENDIF   
C
C Format statement (THIS MUST NOT BE TRANSLATED)
C      
  100 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')
      END
C 
C