
C
C
      SUBROUTINE BCPLOT$(ISEND, NCOL, NRMAX, NROW,
     +                   XMAT,
     +                   LABELS_TRUE, TITLES)
C
C ACTION  : Supply a matrix then create a bar chart by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Derived from PCPLOT$ 29/05/2001
C           07/01/2003 redimensioned WIDE(5*NGRAFS)
C           21/10/2004 added call to SYMBOL
C           14/02/2005 increased array size in call to SYMBOL
C           11/07/2005 increased NMAX from 1000 to 2000 
C           19/05/2007 added INTENTS
C           01/01/2008 added NXTRA 
C           15/01/2008 redimensioned NMAX = 10000, NXTRA = NWORDS = 2000
C           18/01/2008 added 'begin{labels} ... end{labels}'
C           28/01/2008 removed X, ..., YT from call to GKSGRF$  
C           29/06/2009 also deleted FILEX as FSAV(1) and FSAV1(1) may be redefined 
C           02/11/2010 added SIZE and WIDE to argument list to SYMBOL 
C           01/12/2010 added call to LABELS
C           31/12/2010 added call to TXTKEY
C           23/04/2011 now calls LABELS with dimension = 20
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C
C           ISEND: (input/unchanged) controls labels as follows:
C                  ISEND = 1: use SIMPLOT configuration labels
C                  ISEND = 2: use labels from argument list
C            NCOL: (input/unchanged) no. columns
C           NRMAX: (input/unchanged) leading dimension
C            NROW: (input/unchanged) no. rows
C            XMAT: (input/unchanged) matrix of values
C     LABELS_TRUE: (input/unchanged) used as labels if ISEND = 2
C          TITLES: (input/unchanged) as follows:
C                   title, x-legend, y-legend, z-legend(unused)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ISEND, NCOL, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (IN) :: XMAT(NRMAX,NCOL)
      CHARACTER (LEN = *), INTENT (IN) :: LABELS_TRUE(NROW), TITLES(4)
C
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4,
     +           NIN, NMAX, NMAX1, NWORDS, NXTRA
      PARAMETER (NIN = 3, NGRAFS = 300, NGRAF2 = 2*NGRAFS,
     +           NGRAF3 = 3*NGRAFS, NGRAF4 = 4*NGRAFS, NMAX = 2000,
     +           NWORDS = 2000, KPANEL = NGRAFS, NXTRA = NWORDS)
      INTEGER    JSEND
      PARAMETER (JSEND = 1)
      INTEGER    N0, N1, N2, N20, N40
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N20 = 20, N40 = 40)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS),
     +           KCOLOR(NGRAFS), L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    I, IFAIL, IOS, J, NOUT
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS),
     +                 WIDE(5*NGRAFS)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  FILEX*1024
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40
      CHARACTER  LABELS_TEMP(20)*40, VECTORS(60)*40
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ASKIF, STORE, THERE
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE.)
      EXTERNAL   GKSGRF$, DELEET, GETTMP, GETNOU, SYMBOL, LABELS, TXTKEY
      EXTERNAL   DEFGKS$, PLTOBJ$, PUTFAT$
C
C Check the data supplied
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT$('ISEND out of range in call to BCPLOT$')
         RETURN
      ENDIF
      IF (NCOL.LT.N1 .OR. NROW.LT.1) THEN
         CALL PUTFAT$('Must have at least 1 item for a bar chart')
         RETURN
      ENDIF
      IF (NCOL.GT.20) THEN
         CALL PUTFAT$('Cannot create a bar chart from > 20 columns')
         RETURN
      ENDIF
      IF (NCOL*NROW.GT.NWORDS) THEN
         CALL PUTFAT$('Matrix too large for a bar chart (> 2000 items)')
         RETURN
      ENDIF
C
C Initialise gks and graphical objects
C
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Initialise all the array variables even though some are not to be used
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N0
         M(I) = N0
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
C
C Get the default values
C
      CALL LABELS (JSEND, IHUE, IFILL,
     +             LABELS_TEMP, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO    
      CALL SYMBOL (JSEND, JCOLOR, KCOLOR, L, M,
     +             SIZE, WIDE)
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE) 
C
C Create a temporary matrix file for GKSGRF$ to plot as a bar chart
C
      CALL GETTMP (IFAIL,
     +             FILEX)
      IF (IFAIL.NE.N0) RETURN
      CALL GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      WRITE (NOUT,'(A)') TITLES(1)
      WRITE (NOUT,'(2I6)') NROW, NCOL
      DO I = N1, NROW
         WRITE (NOUT,'(1P,20E11.3)') (XMAT(I,J), J = N1, NCOL)
      ENDDO
C
C Add labels to file if ISEND = 2 then close file
C
      IF (ISEND.EQ.N1) THEN
         WRITE (NOUT,'(I6)') N1
         WRITE (NOUT,'(A)') 'Default line'
      ELSE
         WRITE (NOUT,'(I6)') NROW + 2
         WRITE (NOUT,'(A)') 'begin{labels}'
         DO I = N1, NROW
            WRITE (NOUT,'(A)') LABELS_TRUE(I)
         ENDDO
         WRITE (NOUT,'(A)') 'end{labels}'
      ENDIF
      CLOSE (UNIT = NOUT)
C
C Set the important scalars then call GKSGRF$
C
      NFILE1 = N1
      FSAV(1) = FILEX
      FSAV1(1) = FILEX
      BAR_CHART = .TRUE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .FALSE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.
      
      NMAX1 = NMAX
      
      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE,
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete the temporary files used for plotting
C
      CALL DELEET (FILEX,
     +             ASKIF, THERE)
      CALL DELEET (FSAV(N1),
     +             ASKIF, THERE)
      CALL DELEET (FSAV1(N1),
     +             ASKIF, THERE)
      END
C
C
