C
C
      SUBROUTINE BLABEL$(ICOLOR, KANGLE, KCOLOR, MXDROP, MXTIC, NCFONT,
     +                   NGROUP, NKCOL, NOUT_PS, NPTS,
     +                   CHEIGHT, EHEIGHT, EXTRA1, EXTRA2, THICK,
     +                   X, XA, XB, XEND,
     +                   XMAX, XMIN, XPC, XSTART, XTIC,
     +                   YBEGIN, YDROP, YEND, Y_SCALE, YSTART,
     +                   LABELS, SYMBOL,
     +                   BOXIT, HARD_COPY, HPGL, MONO, OFFSET,
     +                   PS, ROTATE, SHOW_XAXIS)
C
C
C ACTION : X-legend/label for simplot BARCHART
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/6/95
C ADVICE : Added:   NPTS, X, LABELS
C          Removed: NXMAG, XGRID, XTOINT
C          30/09/1996 Overhaul
C          14/07/1997 win32 version
C          09/11/1998 Added NGROUP and rationalised the labelling system
C          10/04/1999 Corrected colour for axes and ticks using JCOLOR
C          24/07/2001 added SHOW_XAXIS
C          19/08/2001 added XSIZE, MXDROP, YDROP
C          13/10/2004 added ITYPE, FSIZES$, STORE
C          11/07/2005 added NWORDS and NPT1 
C          19/05/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NKCOL, NPTS
      INTEGER,             INTENT (IN)    :: KANGLE, KCOLOR(NKCOL),
     +                                       MXDROP, MXTIC, NCFONT,
     +                                       NGROUP, NOUT_PS  
      INTEGER,             INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION,    INTENT (IN)    :: CHEIGHT, EHEIGHT, EXTRA1,
     +                                       EXTRA2, THICK, X(NPTS), XA,
     +                                       XB, XEND, XMAX, XMIN, XPC,
     +                                       XSTART, XTIC, YBEGIN,
     +                                       YDROP, YEND, Y_SCALE,
     +                                       YSTART
      CHARACTER (LEN = *), INTENT (IN)    :: LABELS(NPTS), SYMBOL(NPTS)
      LOGICAL,             INTENT (IN)    :: BOXIT, HARD_COPY, HPGL,
     +                                       MONO, OFFSET, PS, ROTATE,
     +                                       SHOW_XAXIS
C
C Locals
C
      INTEGER    ITYPE, K0, NWORDS
      PARAMETER (ITYPE = 8, K0 = 0, NWORDS = 1000)
      INTEGER    I, IADD1, ICOUNT, JCOLOR, NFONT, NPT1, NTICK
      DOUBLE PRECISION EPSI, HALF, ONE, FIVE, ZERO
      PARAMETER (EPSI = 1.0D-10, HALF = 0.5D+00, ONE = 1.0D+00,
     +           FIVE = 5.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION XBAR, XSIZE, XTEMP, YTEMP, YTEMP1
      DOUBLE PRECISION ANGLE, BOT, TOP
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  TYPE1*4
      LOGICAL    DROPY
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   PLTSTR$, SOLID_LINE$, WGBFNT$, FSIZES$
      INTRINSIC  ABS, DBLE, MOD, MIN
C
C Extra variables that may be needed again so left in argument list
C
      IF (BOXIT) THEN!to silence ftn95
         I = MXTIC
         ANGLE = EHEIGHT
         ANGLE = EXTRA1
         ANGLE = EXTRA2
         ANGLE = THICK
         ANGLE = XMAX
         ANGLE = XMIN
         ANGLE = YEND
      ENDIF
C
C Adjust the font size if necessary
C
      NTICK = NPTS/NGROUP
      CALL FSIZES$(ITYPE, XSIZE, STORE)
      IF (NTICK.GT.20) THEN
C
C Shrink the labels font if the tick marks > 20
C
         XTEMP = (180.0D+00 - DBLE(MXTIC))/180.0D+00
         IF (XTEMP.LT.0.2D+00) XTEMP = 0.2D+00
         XSIZE = XSIZE*XTEMP
         IF (XSIZE.LT.0.2D+00) THEN
            XSIZE = 0.2D+00
         ELSEIF (XSIZE.GT.5.0D+00) THEN
            XSIZE = 5.0D+00
         ENDIF
      ENDIF
      IF (PS) THEN
C
C Adjust PS font size for X-axis labels
C
         WRITE (NOUT_PS,100) XSIZE
         WRITE (NOUT_PS,200) XSIZE
      ENDIF
C
C Set up fonts for labels on X-axis ....................................
C
      CALL WGBFNT$(I, NFONT, ANGLE)
      ANGLE = ZERO
      IF (ROTATE) THEN
         YTEMP = YSTART - CHEIGHT/FIVE - XTIC
         IF (KANGLE.EQ.2) THEN
            TYPE1 = 'ro45'
         ELSEIF (KANGLE.EQ.3) THEN
            TYPE1 = 'ro60'
         ELSEIF (KANGLE.EQ.4) THEN
            TYPE1 = 'ro75'
         ELSEIF (KANGLE.EQ.5) THEN
            TYPE1 = 'td'
         ELSEIF (KANGLE.EQ.6) THEN
            TYPE1 = 'tu'
         ELSEIF (KANGLE.EQ.7) THEN
            TYPE1 = 're75'
         ELSEIF (KANGLE.EQ.8) THEN
            TYPE1 = 're60'
         ELSEIF (KANGLE.EQ.9) THEN
            TYPE1 = 're45'
         ENDIF
      ELSE
         YTEMP = YSTART - CHEIGHT - CHEIGHT/FIVE - XTIC
         TYPE1 = 'tc'
      ENDIF
C
C Draw the X-axis
C
      IF (.NOT.MONO) THEN
         JCOLOR = KCOLOR(2)
      ELSE
         JCOLOR = ICOLOR
      ENDIF
      IF (SHOW_XAXIS) THEN
         IF (OFFSET .AND. ABS(YBEGIN - YSTART).GT.EPSI) THEN
            CALL SOLID_LINE$(XSTART, YBEGIN, XEND, YBEGIN, JCOLOR)
         ELSE
            CALL SOLID_LINE$(XA, YBEGIN, XB, YBEGIN, JCOLOR)
         ENDIF
      ENDIF
C
C Draw labels on X-axis
C
      BOT = X(NPTS) - X(1) + ONE
      TOP = XB - XA
      NPT1 = MIN(NPTS, NWORDS)
      IF (NGROUP.LE.1) THEN
C
C Draw every label
C
         IF (.NOT.MONO) ICOLOR = KCOLOR(3)
         DO I = 1, NPT1
            IF (LABELS(I).NE.BLANK) THEN
               XTEMP = (X(I) - HALF)*TOP/BOT + XA
               YTEMP1 = YTEMP
               IF (NTICK.GT.MXDROP) THEN
                  IF (MOD(I,2).EQ.0) YTEMP1 = YTEMP - YDROP
               ENDIF
               IF (SHOW_XAXIS) CALL SOLID_LINE$(XTEMP, YBEGIN, XTEMP,
     +                         YBEGIN - XTIC, JCOLOR)
               CALL PLTSTR$(ICOLOR, NCFONT, NFONT, K0, NOUT_PS,
     +                      ANGLE, XSIZE*XPC, ZERO, XTEMP, YTEMP1,
     +                      Y_SCALE,
     +                      BLANK, LABELS(I), SYMBOL(I), TYPE1,
     +                      HARD_COPY, HPGL, PS)
            ENDIF
         ENDDO
      ELSE
C
C Draw 1 label for each group
C
         IADD1 = 0
         ICOUNT = 0
         XBAR = ZERO
         IF (.NOT.MONO) ICOLOR = KCOLOR(3)
         DROPY = .FALSE.
         DO I = 1, NPT1
            IADD1 = IADD1 + 1
            XTEMP = (X(I) - HALF)*TOP/BOT + XA
            XBAR = XBAR + XTEMP
            IF (IADD1.EQ.NGROUP) THEN
               IADD1 = 0
               ICOUNT = ICOUNT + 1
               XTEMP = XBAR/DBLE(NGROUP)
               XBAR = ZERO
               IF (LABELS(ICOUNT).NE.BLANK) THEN
                  IF (SHOW_XAXIS) CALL SOLID_LINE$(XTEMP, YBEGIN, XTEMP,
     +                                             YBEGIN - XTIC,
     +                                             JCOLOR)
                  YTEMP1 = YTEMP
                  IF (DROPY) YTEMP1 = YTEMP1 - YDROP
                  IF (NTICK.GT.MXDROP) DROPY = .NOT.DROPY
                  CALL PLTSTR$(ICOLOR, NCFONT, NFONT, K0, NOUT_PS,
     +                         ANGLE, XSIZE*XPC, ZERO, XTEMP, YTEMP1,
     +                         Y_SCALE,
     +                         BLANK, LABELS(ICOUNT), SYMBOL(ICOUNT),
     +                         TYPE1, HARD_COPY, HPGL, PS)
               ENDIF
            ENDIF
         ENDDO
      ENDIF
      IF (PS) THEN
C
C Adjust PS font size for X-axis labels
C
         WRITE (NOUT_PS,100) ONE/XSIZE
         WRITE (NOUT_PS,200) ONE/XSIZE
      ENDIF 
C
C Format statements (THESE MUST NOT BE TRANSLATED)
C      
  100 FORMAT ('/td-size td-size',1X,f7.3,1X,'mul def')
  200 FORMAT ('/tc-size tc-size',1X,f7.3,1X,'mul def')
      END
C
C
