C
C Calls bwplot$
C
      SUBROUTINE BWPLOT (ISEND, NOBS, NSET, NVEC,
     +                   XVEC,
     +                   LABELS, TITLES)
C
C ACTION  : Supply a vector then create a box and whisker plot
C           by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.  
C           19/05/2007 added INTENTS
C
C           ISEND: (input/unchanged) controls labels as follows:
C                  ISEND = 1: use SIMPLOT configuration labels
C                  ISEND = 2: use labels from argument list
C            NOBS: (input/unchanged) observations per set(i), NOBS(i) >= 4
C            NSET: (input/unchanged) no. of sets of data
C            NVEC: (input/unchanged) total no. of items, NVEC >= sum NOBS(i)
C            XVEC: (input/unchanged) vector of values i = 1, NVEC
C          LABELS: (input/unchanged) used as labels if ISEND = 2
C          TITLES: (input/unchanged) as follows:
C                  title, x-legend, y-legend, z-legend(unused)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NSET, NVEC
      INTEGER,             INTENT (IN) :: ISEND, NOBS(NSET)
      DOUBLE PRECISION,    INTENT (IN) :: XVEC(NVEC)
      CHARACTER (LEN = *), INTENT (IN) :: LABELS(NSET), TITLES(4)
C
C Locals
C      
      EXTERNAL   BWPLOT$
      CALL BWPLOT$(ISEND, NOBS, NSET, NVEC,
     +             XVEC,
     +             LABELS, TITLES)
      END
C
C
