C
C
      SUBROUTINE BWPLUS (ISEND, NOBS, NSET, NVEC,
     +                   XVEC,
     +                   LABELS_IN, TITLES)
C
C ACTION  : Supply a vector then create a box and whisker plot
C           plus additional data by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Derived from BWPLOT$ 25/08/2016
C
C           ISEND: (input/unchanged) controls labels as follows:
C                  ISEND = 1: use SIMPLOT configuration labels
C                  ISEND = 2: use labels from argument list
C            NOBS: (input/unchanged) observations per set(i), NOBS(i) >= 4
C            NSET: (input/unchanged) no. of sets of data
C            NVEC: (input/unchanged) total no. of items, NVEC >= sum NOBS(i)
C            XVEC: (input/unchanged) vector of values i = 1, NVEC
C       LABELS_IN: (input/unchanged) used as labels if ISEND = 2
C          TITLES: (input/unchanged) as follows:
C                  title, x-legend, y-legend, z-legend(unused)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NSET, NVEC
      INTEGER,             INTENT (IN) :: ISEND, NOBS(NSET)
      DOUBLE PRECISION,    INTENT (IN) :: XVEC(NVEC)
      CHARACTER (LEN = *), INTENT (IN) :: LABELS_IN(NSET), TITLES(4)    
C      
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4, NIN,
     +           NMAX, NWORDS, NXTRA
      PARAMETER (NIN = 3, NGRAFS = 300, NGRAF2 = 2*NGRAFS,
     +           NGRAF3 = 3*NGRAFS, NGRAF4 = 4*NGRAFS,
     +           NMAX = 2000, 
     +           NWORDS = 2000, KPANEL = NGRAFS, NXTRA = NWORDS)
      INTEGER    N0, N1, N2, N4, N9, N20, N40
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N9 = 9, N20 = 20, 
     +           N40 = 40)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS), K(20), 
     +           L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    I, ICOUNT, IFAIL, IOS, J, KZ, MZ, NMAX1, NOUT, NZ
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS), WIDE(5*NGRAFS),
     +                 Z(5*NMAX), ZLH, ZMAX, ZMED, ZMIN, ZUH
      DOUBLE PRECISION ONE, TWO, HALF, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, HALF = 0.5D+00,
     +           ZERO = 0.0D+00)
      CHARACTER  FILEX*1024
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40,
     +           VECTORS(60)*40
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ASKIF, STORE, THERE
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE.)
      EXTERNAL   GKSGRF$, DELEET, GETTMP, GETNOU, NXSORT$
      EXTERNAL   DEFGKS$, PLTOBJ$, PUTFAT$
      EXTERNAL   LABELS, SYMBOL, TXTKEY
      INTRINSIC  MOD, DBLE
C
C Check the data supplied
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT$(
     +'ISEND out of range in call to BWPLOT$')
         RETURN
      ENDIF
      IF (NSET.LT.N1 .OR. NVEC.LT.N4) THEN
         CALL PUTFAT$(
     +'Must have at least 1 item for a box and whisker plot')
         RETURN
      ENDIF
      IF (NSET.GT.NWORDS) THEN
         CALL PUTFAT$(
     +'Too many boxes for a box and whisker plot (> 2000 items)')
         RETURN
      ENDIF
      ICOUNT = N0
      DO I = N1, NSET
         ICOUNT = ICOUNT + NOBS(I)
         IF (NOBS(I).LT.N4) THEN
            CALL PUTFAT$(
     +'Must have at least 4 items/sample for a box and whisker plot')
            RETURN
         ENDIF
      ENDDO
      IF (ICOUNT.GT.NVEC) THEN
         CALL PUTFAT$(
     +'NSET, NOBS, and NVEC inconsistent in call to BWPLUS')
         RETURN
      ENDIF
C
C Initialise gks and objects
C
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Initialise all the array variables even though they are not to be used
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N0
         M(I) = N0
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
      CALL LABELS (N1, IHUE, IFILL,
     +             LABEL1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO    
      CALL SYMBOL (N1, JCOLOR, K, L, M,
     +             SIZE, WIDE)
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE)       
C
C Create a box and whisker type file
C
      CALL GETTMP (IFAIL,
     +             FILEX)
      IF (IFAIL.NE.N0) RETURN
      CALL GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.N0) RETURN
      WRITE (NOUT,'(A)') TITLES(1)
      WRITE (NOUT,'(2I6)') NSET, N9
      ICOUNT = N0
      DO I = N1, NSET
         NZ = NOBS(I)
         DO J = N1, NZ
            ICOUNT = ICOUNT + N1
            Z(J) = XVEC(ICOUNT)
         ENDDO
         CALL NXSORT$(NZ,
     +                Z)
         ZMIN = Z(N1)
         ZMAX = Z(NZ)
         IF (MOD(NZ,N2).EQ.N0) THEN
            MZ = NZ/N2
            KZ = MZ/N2
            ZLH = (Z(KZ) + Z(KZ + N1))/TWO
            ZMED = (Z(MZ) + Z(MZ + N1))/TWO
            ZUH = (Z(NZ - KZ) + Z(NZ - KZ + N1))/TWO
         ELSE
            MZ = (NZ + N1)/N2
            KZ = (MZ + N1)/N2
            ZLH = Z(KZ)
            ZMED = Z(MZ)
            ZUH = Z(NZ - KZ + N1)
         ENDIF
         WRITE (NOUT,'(1P,9E11.3)') DBLE(I), ZMIN, ZLH, ZMED, ZUH,
     +                              ZMAX, ONE, HALF, ZERO
      ENDDO
C
C Add labels to file if ISEND = 2 then close the file
C
      IF (ISEND.EQ.N1) THEN
         WRITE (NOUT,'(I6)') NSET + 2
         WRITE (NOUT,'(A)') 'begin{labels}'
         DO I = N1, NSET  
            IF (I.LE.15) THEN
               WRITE (NOUT,'(A)') LABEL1(I)
            ELSEIF (I.LE.99) THEN    
               WRITE (NOUT,'(I2)') I
            ELSE    
               WRITE (NOUT,'(I4)') I
            ENDIF   
         ENDDO
         WRITE (NOUT,'(A)') 'end{labels}'
      ELSE
         WRITE (NOUT,'(I6)') NSET + 2
         WRITE (NOUT,'(A)') 'begin{labels}'
         DO I = N1, NSET
            WRITE (NOUT,'(A)') LABELS_IN(I)
         ENDDO
         WRITE (NOUT,'(A)') 'end{labels}'
      ENDIF
      CLOSE (UNIT = NOUT)
C
C Add an additional file with the scatter data
C
      CALL GETTMP (IFAIL,
     +             FSAV(2))
      OPEN (UNIT = NOUT, FILE = FSAV(2), IOSTAT = IOS)
      J = N0
      DO I = 1, NSET
         J = J + NOBS(I)
      ENDDO
      WRITE (NOUT,'(A)',IOSTAT=IOS) 'Temporary file'
      WRITE (NOUT,'(2I6)') J, N2
      ICOUNT = N0
      DO I = 1, NSET
         DO J = 1, NOBS(I)
            ICOUNT = ICOUNT + N1
            WRITE (NOUT,'(2E13.5)') DBLE(I), XVEC(ICOUNT)
         ENDDO
      ENDDO
      CLOSE (UNIT = NOUT)
      FSAV1(2) = FSAV(2)       
C
C Set the important variables then call GKSGRF$
C Note NFILE1 = 2 instructs GKSGRF$ to read the additional data file
C
      NFILE1 = N2
      FSAV(1) = FILEX
      FSAV1(1) = FILEX
      BAR_CHART = .TRUE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .FALSE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.

      NMAX1 = NMAX
      
      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE, 
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete the temporary files used for plotting
C
      CALL DELEET (FILEX,
     +             ASKIF, THERE)
      CALL DELEET (FSAV(N1),
     +             ASKIF, THERE)
      CALL DELEET (FSAV1(N1),
     +             ASKIF, THERE)  
      CALL DELEET (FSAV(N2),
     +             ASKIF, THERE)
      CALL DELEET (FSAV1(N2),
     +             ASKIF, THERE)  
      END
C
C
