C
C
      SUBROUTINE CHECKS$(NXMAG, NYMAG, NZMAG,
     +                   XMAX, XMIN, YMAX, YMIN, ZMAX, ZMIN,
     +                   ABORT, TWO_PLOTS)
C
C ACTION : Check size of numbers before plotting
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          14/07/1997 win32 version ... changed NMAX from 35 to 300
C          28/11/1997 Changed NMX to 301 and redefined 0.99999rpt 
C          19/05/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (OUT)   :: NXMAG, NYMAG, NZMAG 
      DOUBLE PRECISION, INTENT (INOUT) :: XMAX, XMIN, YMAX, YMIN, ZMAX,
     +                                    ZMIN
      LOGICAL,          INTENT (IN)    :: TWO_PLOTS  
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C
      
      INTEGER    NMAX, N1
      PARAMETER (NMAX = 301, N1 = 1)
      DOUBLE PRECISION P9REP, TEN, HUGE1
      PARAMETER (TEN = 10.0D+00, HUGE1 = 1.0D+300,
     +           P9REP = 1.0D+00 - 1.0D-15)
      DOUBLE PRECISION XTEMP, YTEMP, ZTEMP
      EXTERNAL   PUTFAT$
      INTRINSIC  ABS, MAX 
C
C Initialise
C      
      ABORT = .TRUE. 
      NXMAG = N1
      NYMAG = N1
      NZMAG = N1
C
C Find magnitude of numbers on X-Axis. Return if too small or large ...
C Store the result in NXMAG
C     
      IF (XMAX.GT.HUGE1) XMAX = HUGE1
      IF (XMIN.LT. - HUGE1) XMIN = - HUGE1
      XTEMP = MAX(ABS(XMAX), ABS(XMIN))
      DO NXMAG = - NMAX, NMAX
        IF (XTEMP/(TEN**NXMAG).LT.P9REP) GOTO 20
      ENDDO
      GOTO 80
   20 CONTINUE
      NXMAG = NXMAG - N1
C
C Find magnitude of numbers on Y-Axis. Return if too small or large ...
C Store the result in NYMAG
C                                     
      IF (YMAX.GT.HUGE1) YMAX = HUGE1
      IF (YMIN.LT. - HUGE1) YMIN = - HUGE1
      YTEMP = MAX(ABS(YMAX), ABS(YMIN))
      DO NYMAG = - NMAX, NMAX
        IF (YTEMP/(TEN**NYMAG).LT.P9REP) GOTO 40
      ENDDO
      GOTO 80
   40 CONTINUE
      NYMAG = NYMAG - N1
C
C Find magnitude of numbers on Z-Axis. Return if too small or large ...
C Store the result in NZMAG
C
      IF (TWO_PLOTS) THEN    
         IF (ZMAX.GT.HUGE1) ZMAX = HUGE1
         IF (ZMIN.LT. - HUGE1) ZMIN = - HUGE1
         ZTEMP = MAX(ABS(ZMAX), ABS(ZMIN))
         DO NZMAG = - NMAX, NMAX
           IF (ZTEMP/(TEN**NZMAG).LT.P9REP) GOTO 60
         ENDDO
         GOTO 80
   60    CONTINUE
         NZMAG = NZMAG - N1
      ENDIF
      ABORT = .FALSE.
      RETURN
C
C Error: Here if numbers are too large to plot
C
   80 CONTINUE
      ABORT = .TRUE.
      CALL PUTFAT$('Numbers too large for accurate display')
      END
C
C
