C
C
      SUBROUTINE CON003$(ICOLOR, KMODE, 
     +                   AXES, TICKS)
C
C ACTION : Axes
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.24/8/95
C          20/05/2007 added INTENTS
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER, INTENT (IN) :: ICOLOR, KMODE 
      LOGICAL, INTENT (IN) :: AXES, TICKS(*) 
C
C Locals
C      
      INTEGER    N2, N3, N5
      PARAMETER (N2 = 2, N3 = 3, N5 = 5)
      INTEGER    COLOUR_INDEX
      DOUBLE PRECISION XT(N5), YT(N5)
      DOUBLE PRECISION ZERO, ONE, PNT05
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT05 = 0.05D+00)
      EXTERNAL   GSELNT$, POLYLINE$, XYZ2XY$
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) RETURN
      COLOUR_INDEX = ICOLOR
      CALL GSELNT$(N3)
C
C X, Y axes
C
      IF (AXES) THEN
         IF (KMODE.EQ.2) THEN
            XT(1) = ZERO
            XT(2) = ONE
            XT(3) = ONE
            XT(4) = ZERO
            XT(5) = ZERO
            YT(1) = ZERO
            YT(2) = ZERO
            YT(3) = ONE
            YT(4) = ONE
            YT(5) = ZERO
            CALL POLYLINE$(N5, XT, YT, COLOUR_INDEX)
         ELSEIF (KMODE.EQ.3) THEN
            CALL XYZ2XY$(ZERO, XT(1), ZERO, YT(1), ZERO)
            CALL XYZ2XY$(ONE,  XT(2), ZERO, YT(2), ZERO)
            CALL XYZ2XY$(ONE,  XT(3), ONE,  YT(3), ZERO)
            CALL XYZ2XY$(ZERO, XT(4), ONE,  YT(4), ZERO)
            CALL XYZ2XY$(ZERO, XT(5), ZERO, YT(5), ZERO)
            CALL POLYLINE$(N5, XT, YT, COLOUR_INDEX)
            IF (TICKS(1)) THEN
               CALL XYZ2XY$(ZERO, XT(1), ONE, YT(1), ZERO)
               CALL XYZ2XY$(ZERO, XT(2), ONE + PNT05, YT(2), ZERO)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
               CALL XYZ2XY$(ONE, XT(1), ONE, YT(1), ZERO)
               CALL XYZ2XY$(ONE, XT(2), ONE + PNT05, YT(2), ZERO)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDIF
            IF (TICKS(2)) THEN
               CALL XYZ2XY$(ONE, XT(1), ZERO, YT(1), ZERO)
               CALL XYZ2XY$(ONE + PNT05, XT(2), ZERO, YT(2), ZERO)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
               CALL XYZ2XY$(ONE, XT(1), ONE, YT(1), ZERO)
               CALL XYZ2XY$(ONE + PNT05, XT(2), ONE, YT(2), ZERO)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDIF
         ENDIF
      ENDIF
      END
C
C