C 
C
      SUBROUTINE CONCCC$(ICOLOR, ITHETA, NCON, NOUT_PS, NXTEXT, NYTEXT,
     +                   HTS, XMAX, XMIN, YMAX, YMIN, Y_SCALE,
     +                   XTEXT, XTEXT1, YTEXT, YTEXT1,
     +                   CONVAL, HARD_COPY, HPGL, LABELS, NUMBER, PS,
     +                   X2INT, Y2INT)
C
C ACTION : X, Y values and contour table for contour plot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/9/95
C          24/10/96 Added PLNUMB$ and removed TEXT$  
C          20/05/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ITHETA, NCON, NOUT_PS,
     +                                       NXTEXT, NYTEXT
      INTEGER,             INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION,    INTENT (IN)    :: HTS(NCON), XMAX, XMIN,
     +                                       YMAX, YMIN, Y_SCALE
      CHARACTER (LEN = *), INTENT (IN)    :: XTEXT(NXTEXT),
     +                                       XTEXT1(NXTEXT),
     +                                       YTEXT(NYTEXT),
     +                                       YTEXT1(NXTEXT)
      LOGICAL,             INTENT (IN)    :: CONVAL, HARD_COPY, HPGL,
     +                                       LABELS(*), NUMBER(*), PS
      LOGICAL,             INTENT (INOUT) :: X2INT, Y2INT
C
C Locals
C
      INTEGER    NTFONT, N2
      PARAMETER (NTFONT = 106, N2 = 2)
      INTEGER    I, J, NFONT, NGKS
      DOUBLE PRECISION ZERO, FSCALE, PNT9, ONE
      PARAMETER (ZERO = 0.0D+00, FSCALE = 0.75D+00, PNT9 = 0.9D+00,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION XPT
      PARAMETER (XPT = 1.3D+00)
      DOUBLE PRECISION R2BIG
      PARAMETER (R2BIG = 0.999999D+05)
      DOUBLE PRECISION XPS(4), YPS(4)
      DOUBLE PRECISION SIZE1, SLANT, WSTART, XSTART, YSTART, ZSTART
      CHARACTER  BLANK*1, FONT*8, LINE4*4, SYMBOL(4)*45, TYPE1*4,
     +           VALUE(4)*45
      CHARACTER (LEN = 15) HEADER, TRAILR
      PARAMETER (BLANK = ' ', FONT = '/Courier')
C
C Externals
C
      EXTERNAL   PSNUMB$, PLNUMB$, PLTSTR$, GSELNT$, WGBFNT$, EXPFLT$  
      INTRINSIC  ABS
      DATA       XPS / 0.205D+00, 0.205D+00, 0.781D+00, 0.219D+00 /
      DATA       YPS / 0.125D+00, 0.875D+00, 0.060D+00, 0.060D+00 /
      IF (.NOT.NUMBER (1) .AND. .NOT. NUMBER(2)) RETURN
C
C Check
C
       IF (X2INT .AND. XMAX.GT.R2BIG) X2INT = .FALSE.
       IF (X2INT .AND. XMIN.LT. - R2BIG) X2INT = .FALSE.
       IF (Y2INT .AND. YMAX.GT.R2BIG) Y2INT = .FALSE.
       IF (Y2INT .AND. YMIN.LT. - R2BIG) Y2INT = .FALSE.
C
C Define the label values. First the defaults.
C
      CALL WGBFNT$(I, NFONT,
     +             SLANT)
      DO I = 1, 4
         VALUE(I) = BLANK
         SYMBOL(I) = '00000000000000000000'
      ENDDO
C
C Write the X, Y numbers if valid
C
      IF (ITHETA.EQ.0) THEN
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(1),200) XMAX
            WRITE (VALUE(2),200) XMIN
            CALL EXPFLT$(VALUE(1),
     +                   X2INT)            
            CALL EXPFLT$(VALUE(2),
     +                   X2INT)             
         ELSEIF (LABELS(1)) THEN
            VALUE(1) = XTEXT(NXTEXT)
            SYMBOL(1) = XTEXT1(NXTEXT)
            VALUE(2) = XTEXT(1)
            SYMBOL(2) = XTEXT1(1)
         ENDIF
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(3),200) YMAX
            WRITE (VALUE(4),200) YMIN
            CALL EXPFLT$(VALUE(3),
     +                   Y2INT)            
            CALL EXPFLT$(VALUE(4),
     +                   Y2INT)     
         ELSEIF (LABELS(2)) THEN
            VALUE(3) = YTEXT(NYTEXT)
            SYMBOL(3) = YTEXT1(NYTEXT)
            VALUE(4) = YTEXT(1)
            SYMBOL(4) = YTEXT1(1)
         ENDIF
      ELSEIF (ITHETA.EQ.90) THEN
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(1),200) YMIN
            WRITE (VALUE(2),200) YMAX
            CALL EXPFLT$(VALUE(1),
     +                   Y2INT)            
            CALL EXPFLT$(VALUE(2),
     +                   Y2INT)   
         ELSEIF (LABELS(2)) THEN
            VALUE(1) = YTEXT(1)
            SYMBOL(1) = YTEXT1(1)
            VALUE(2) = YTEXT(NYTEXT)
            SYMBOL(2) = YTEXT1(NYTEXT)
         ENDIF
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(3),200) XMAX
            WRITE (VALUE(4),200) XMIN
            CALL EXPFLT$(VALUE(3),
     +                   X2INT)            
            CALL EXPFLT$(VALUE(4),
     +                   X2INT)   
         ELSEIF (LABELS(1)) THEN
            VALUE(3) = XTEXT(NXTEXT)
            SYMBOL(3) = XTEXT1(NXTEXT)
            VALUE(4) = XTEXT(1)
            SYMBOL(4) = XTEXT1(1)
         ENDIF
      ELSEIF (ITHETA.EQ.180) THEN
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(1),200) XMIN
            WRITE (VALUE(2),200) XMAX
            CALL EXPFLT$(VALUE(1),
     +                   X2INT)            
            CALL EXPFLT$(VALUE(2),
     +                   X2INT)  
         ELSEIF (LABELS(1)) THEN
            VALUE(1) = XTEXT(1)
            SYMBOL(1) = XTEXT1(1)
            VALUE(2) = XTEXT(NXTEXT)
            SYMBOL(2) = XTEXT1(NXTEXT)
         ENDIF
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(3),200) YMIN
            WRITE (VALUE(4),200) YMAX
            CALL EXPFLT$(VALUE(3),
     +                   Y2INT)            
            CALL EXPFLT$(VALUE(4),
     +                   Y2INT)  
         ELSEIF (LABELS(2)) THEN
            VALUE(3) = YTEXT(1)
            SYMBOL(3) = YTEXT1(1)
            VALUE(4) = YTEXT(NYTEXT)
            SYMBOL(4) = YTEXT1(NYTEXT)
         ENDIF
      ELSEIF (ITHETA.EQ.270) THEN
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(1),200) YMAX
            WRITE (VALUE(2),200) YMIN
            CALL EXPFLT$(VALUE(1),
     +                   Y2INT)            
            CALL EXPFLT$(VALUE(2),
     +                   Y2INT)  
         ELSEIF (LABELS(2)) THEN
            VALUE(1) = YTEXT(NYTEXT)
            SYMBOL(1) = YTEXT1(NYTEXT)
            VALUE(2) = YTEXT(1)
            SYMBOL(2) = YTEXT1(1)
         ENDIF
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(3),200) XMIN
            WRITE (VALUE(4),200) XMAX
            CALL EXPFLT$(VALUE(3),
     +                   X2INT)            
            CALL EXPFLT$(VALUE(4),
     +                   X2INT)  
         ELSEIF (LABELS(1)) THEN
            VALUE(3) = XTEXT(1)
            SYMBOL(3) = XTEXT1(1)
            VALUE(4) = XTEXT(NXTEXT)
            SYMBOL(4) = XTEXT1(NXTEXT)
         ENDIF
      ENDIF

C
C Draw the LABELS
C
      CALL GSELNT$(N2)
      NGKS = N2
C
C The Y axes
C
      SIZE1 = XPT
      TYPE1 = 'ty'
      DO I = 1, 2
         IF (ITHETA.EQ.  0 .AND. NUMBER(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ. 90 .AND. NUMBER(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.180 .AND. NUMBER(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.270 .AND. NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      XPS(I), YPS(I),
     +                      VALUE(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, NTFONT, NGKS,
     +                      SIZE1, XPS(I), YPS(I), Y_SCALE, TYPE1,
     +                      VALUE(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ELSE
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS, 
     +                   ZERO, SIZE1, ZERO, XPS(I), YPS(I), Y_SCALE,
     +                   FONT, VALUE(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDIF
      ENDDO
C
C The X axes
C
      TYPE1 = 'tc'
      DO I = 3, 4
         IF (ITHETA.EQ.  0 .AND. NUMBER(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ. 90 .AND. NUMBER(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.180 .AND. NUMBER(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.270 .AND. NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      XPS(I), YPS(I), 
     +                      VALUE(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, NTFONT, NGKS, 
     +                      SIZE1, XPS(I), YPS(I), Y_SCALE, TYPE1,
     +                      VALUE(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ELSE
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS, 
     +                   ZERO, SIZE1, ZERO, XPS(I), YPS(I), Y_SCALE,
     +                   FONT, VALUE(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDIF
      ENDDO
C
C List the contour values
C
      IF (CONVAL) THEN
         XSTART = 0.785D+00
         YSTART = 0.885D+00
         TYPE1 = 'tl'
         SIZE1 = FSCALE*XPT
         HEADER = BLANK
         TRAILR = BLANK
         IF (PS) THEN
            WSTART = XSTART
            ZSTART = XSTART 
            HEADER = 'Key   Contour'
            TRAILR = '0000000000000'
         ELSE
            WSTART = XSTART + 0.02D+00
            ZSTART = XSTART + 0.01D+00
            HEADER = 'Key    Contour'
            TRAILR = '00000000000000'
         ENDIF     
         CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS, 
     +                ZERO, SIZE1, ZERO, ZSTART, YSTART, Y_SCALE,
     +                FONT, HEADER, TRAILR, TYPE1,
     +                HARD_COPY, HPGL, PS)
         SIZE1 = PNT9*FSCALE*XPT
         IF (PS) WRITE (NOUT_PS,400) FSCALE
         XSTART = XSTART + 0.005D+00
         ZSTART = ZSTART + 0.005D+00
         IF (NCON.LT.23) THEN
            J = NCON
         ELSE
            J = 20
         ENDIF
         TYPE1 = 'left'
         DO I = 1, J
            YSTART = YSTART - 0.035D+00
            WRITE (LINE4,100) I
            IF (ABS(HTS(I)).LT.0.1D+00 .OR.
     +          ABS(HTS(I)).GT.100.0D+00) THEN
               WRITE (VALUE(1),200) HTS(I)
            ELSE
               WRITE (VALUE(1),300) HTS(I)
            ENDIF
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS,
     +                   ZERO, SIZE1, ZERO, WSTART, YSTART, Y_SCALE,
     +                   FONT, LINE4, '0000', TYPE1,
     +                   HARD_COPY, HPGL, PS)
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      XSTART + 0.055D+00, YSTART,
     +                      VALUE(1), 'tl')
            ELSE
               CALL PLNUMB$(ICOLOR, NTFONT, NGKS, SIZE1,
     +                      ZSTART + 0.055D+00, YSTART, Y_SCALE,
     +                      'tl', VALUE(1),
     +                      HARD_COPY, HPGL)
            ENDIF
         ENDDO
         IF (NCON.GT.22) THEN
            YSTART = YSTART - 0.04D+00
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS, ZERO,
     +                   SIZE1, ZERO, WSTART, YSTART, Y_SCALE,
     +                   FONT, '    ...', '0000000', TYPE1,
     +                   HARD_COPY, HPGL, PS)
            WRITE (LINE4,100) NCON
            IF (ABS(HTS(NCON)).LT.0.1D+00 .OR.
     +          ABS(HTS(NCON)).GT.100.0D+00) THEN
               WRITE (VALUE(1),200) HTS(NCON)
            ELSE
               WRITE (VALUE(1),300) HTS(NCON)
            ENDIF
            YSTART = YSTART - 0.04D+00
            CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS, ZERO,
     +                   SIZE1, ZERO, WSTART, YSTART, Y_SCALE,
     +                   FONT, LINE4, '0000', TYPE1,
     +                   HARD_COPY, HPGL, PS)
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR, XSTART + 0.055D+00, YSTART,
     +                      VALUE(1), 'tl')
            ELSE
               CALL PLNUMB$(ICOLOR, NTFONT, NGKS, SIZE1,
     +                      ZSTART + 0.050D+00, YSTART, Y_SCALE,
     +                      TYPE1, VALUE(1),
     +                      HARD_COPY, HPGL)
            ENDIF
         ENDIF
         IF (PS) WRITE (NOUT_PS,400) ONE/FSCALE
      ENDIF 
C
C Format statements (THESE MUST NOT BE TRANSLATED)
C      
  100 FORMAT (2X,I2)
  200 FORMAT (1P,E11.4)
  300 FORMAT (F8.4)
  400 FORMAT ('% scale the font sizes',
     +       /'/tl-size tl-size ',F4.2,' mul def')
      END
C 
C