C
C CONFYG$ : Create/Read a configuration file
C
      SUBROUTINE CONFYG$(IFILL, IHUE, ISHAPE,
     +                   JCOLOR,
     +                   KANGLE, KCOLOR, KPANEL, KTIC,
     +                   L, LCOLOR,
     +                   M, MTRANS, MXTIC, MYTIC, MZTIC,
     +                   NCLIP, NFILES, NGROUP, NIN, NKCOL, NLOG,
     +                   NPTS, NSPLIT, NWORDS, NXTRA,
     +                   ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   FACTOR, SIZE, THICK, WIDE,
     +                   XCLIP, XCOORD, XMAX, XMIN, XPDRAG, XSPLIT,
     +                   YCLIP, YCOORD, YMAX, YMAX3, YMAX4, YMIN,
     +                   YMIN3, YMIN4, YPDRAG, YSPLIT,
     +                   ZCOORD, ZMAX, ZMIN, ZSCALE,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   FSAV1,
     +                   LABELS, LABVEC, PLINE, PSYMB, PTITLE,
     +                   QTITLE, WORDX, WORDY, XTITLE, YTITLE, ZTITLE,
     +                   BARCAP, BARCAP_1, BAR_CHART, BORDER, BOXIT,
     +                   CENTRE, DENDRO_GRAM, EXTEND_LINES,
     +                   FRAME, GRATICULE, LOWER, MONO, NATLOG, NUMBRX,
     +                   OFFSET, PANEL, PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ, PIE_CHART,
     +                   PLOT_TITLE, PLOTX, PLOTY, PLOTZ,
     +                   POWERX, POWERY, POWERZ,
     +                   RESTORE_RANGE, ROTATE,
     +                   SHOW_BACKGROUND, SIDE, SHOW_QUADRANTS,
     +                   SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                   SWAP_YZ, THREE_D,
     +                   TWO_PLOTS, UPPER, VECTOR_FIELD, VIDEO,
     +                   XGRID, XTOINT, YAXIS, YGRID, YTOINT, ZTOINT)
C
C ACTION : Read/Write a configuration file for SIMPLOT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 19/10/96
C          14/07/1997 win32 version
C          28/11/1997 Revised
C          15/03/1999 Added tick marks and colours
C          06/04/1999 Added NPTS, IHUE, IFILL, LABELS, LABVEC, BAR_CHART, PIE_CHART
C          28/10/2000 extensive revision
C          20/12/2000 added shape parameters
C          10/04/2001 checked for KCOLOR(6) = KCOLOR(7) = 0 indicating a cfg
C                     file from before border and graticule implementation
C          05/06/2002 added VU2CHK
C          13/01/2003 changed STRING to STRNG and added WORD3
C          28/10/2004 added DENDRO_GRAM and warning about the need to undo
C          20/11/2004 renamed as CONFYG$
C          08/02/2005 added CHECKF  
C          19/05/2007 added INTENTS 
C          01/01/2008 added NXTRA
C          28/06/2011 increased NKTEMP to 21 as NKCOL is now 20 
C          15/05/2013 added ability to create meta-file and call to SIMPLOT_METAFILE_3
C                     Note: Config and meta files must both have the two ciphers
C                           '%simplot configuration file' and '%end of simplot configuration file'
C                           Metafiles musr have the two additional ciphers
C                           '%start of simplot metafile data' and '%end of simplot metafile data'  
C                           The call to SIMPLOT_METAFILE_3 will only lead to ACTION = .TRUE. if there
C                           has been an immediately preceeding call to SIMPLOT_METAFILE_3 with
C                           STORE = .TRUE. to install a valid configuration file 
C          16/01/2014 added call to SAVQUE$ 
C          05/01/2016 added SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS 
C          07/01/2016 added RESTORE_RANGE to allow configuration files to act as templates
C          20/06/2016 begin{vfield} ... end{vfield} now writes all values to the metafile not just 1 
C
C Note: N_ARROW, N_OBJ, and N_TEXT must agree with parameters in OBJECTS subroutines
C
C
      IMPLICIT   NONE
C
C Arguments
C                                 
      INTEGER,             INTENT (IN)    :: KPANEL, NCLIP, NFILES, NIN,
     +                                       NLOG, NSPLIT, NWORDS, NXTRA 
      INTEGER,             INTENT (INOUT) :: KTIC, LCOLOR, MTRANS,
     +                                       MXTIC, MYTIC, MZTIC,
     +                                       NGROUP, NKCOL, NPTS, 
     +                                       IFILL(NXTRA),
     +                                       IHUE(NXTRA), ISHAPE,
     +                                       JCOLOR(NFILES), KANGLE,
     +                                       KCOLOR(NKCOL), L(NFILES),
     +                                       M(NFILES)
      DOUBLE PRECISION,    INTENT (INOUT) :: ASYMP, DRAGTI, DRAGXL,
     +                                       DRAGYL, DRAGZL,
     +                                       FACTOR(NXTRA),
     +                                       SIZE(NFILES), THICK,
     +                                       WIDE(NFILES)
      DOUBLE PRECISION,    INTENT (INOUT) :: XCLIP(NCLIP), XCOORD,
     +                                       XMAX, XMIN, XPDRAG,
     +                                       XSPLIT(NSPLIT),
     +                                       YCLIP(NCLIP), YCOORD,
     +                                       YMAX, YMAX3, YMAX4, YMIN,
     +                                       YMIN3, YMIN4, YPDRAG, 
     +                                       YSPLIT(NSPLIT), ZCOORD,
     +                                       ZMAX, ZMIN, ZSCALE
      CHARACTER (LEN = *), INTENT (IN)    :: FSAV1(NFILES)
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAYQ, ARRAYT, ARRAYX,
     +                                       ARRAYY, ARRAYZ,
     +                                       LABELS(NWORDS), 
     +                                       LABVEC(NWORDS),
     +                                       PLINE(KPANEL), 
     +                                       PSYMB(KPANEL), PTITLE,
     +                                       QTITLE, WORDX(NWORDS),
     +                                       WORDY(NWORDS),
     +                                       XTITLE, YTITLE, ZTITLE
      LOGICAL,             INTENT (INOUT) :: BARCAP(NFILES), BARCAP_1,
     +                                       BAR_CHART, BORDER, BOXIT, 
     +                                       CENTRE, DENDRO_GRAM,
     +                                       EXTEND_LINES, FRAME,
     +                                       GRATICULE, LOWER(NFILES),
     +                                       MONO, NATLOG(NLOG), NUMBRX,
     +                                       OFFSET, PANEL, PCENTX, 
     +                                       PCENTY, PCENTZ, PHIGHX,
     +                                       PHIGHY, PHIGHZ, PIE_CHART,
     +                                       PLOT_TITLE, PLOTX(NWORDS),
     +                                       PLOTY(NWORDS),
     +                                       PLOTZ(NWORDS), POWERX,
     +                                       POWERY, POWERZ,
     +                                       RESTORE_RANGE, ROTATE,
     +                                       SHOW_BACKGROUND,
     +                                       SHOW_QUADRANTS,
     +                                       SHOW_XAXIS, SHOW_YAXIS,
     +                                       SHOW_ZAXIS, SIDE,
     +                                       SWAP_YZ, THREE_D,
     +                                       TWO_PLOTS, UPPER(NFILES),
     +                                       VECTOR_FIELD, VIDEO, XGRID,
     +                                       XTOINT, YAXIS(NFILES), 
     +                                       YGRID, YTOINT,
     +                                       ZTOINT   
     
C
C Locals
C
     
C
C Arrows...............................................................
C
      INTEGER    N_ARROW
      PARAMETER (N_ARROW = 200)
      INTEGER    IARROW(N_ARROW), IKOLOR(N_ARROW)
      DOUBLE PRECISION HEAD(N_ARROW), X1(N_ARROW), X2(N_ARROW),
     +                 Y1(N_ARROW), Y2(N_ARROW)
C
C Objects..............................................................
C
      INTEGER    N_OBJ
      PARAMETER (N_OBJ = 200)
      INTEGER    JCOLOR_OBJ(N_OBJ), M_OBJ(N_OBJ)
      DOUBLE PRECISION SIZE_OBJ(N_OBJ), WIDE_OBJ(N_OBJ),
     +                 X_OBJ(N_OBJ), Y_OBJ(N_OBJ)
C
C Text.................................................................
C
      INTEGER    N_TEXT
      PARAMETER (N_TEXT = 200)
      INTEGER    JKOLOR(N_TEXT), ISTRNG(N_TEXT)
      DOUBLE PRECISION HSTRNG(N_TEXT), SPS(N_TEXT), XPS(N_TEXT),
     +                 XSTRNG(N_TEXT), YSTRNG(N_TEXT)
      CHARACTER  FONT(N_TEXT)*80, STRNG(N_TEXT)*100,
     +           SYMBOL(N_TEXT)*100, TYPE1(N_TEXT)*100
C
C Local variables.......................................................
C
      INTEGER    ISEND, IOS, KEYS, NTEMP
      INTEGER    I, IADD1, J, J1, K, K1, L1, M1, N1
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT,
     +           NSTART, NTEXT, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 6,
     +           NSTART = 18, NTEXT = NSTART + NUMOPT - 1, NUMTXT = 24)
      INTEGER    NUMBLD(NUMTXT), NUMPOS(NUMOPT)
      INTEGER    NKTEMP
      PARAMETER (NKTEMP = 21)
      INTEGER    KTEMP(NKTEMP)
      DOUBLE PRECISION S1, W1, XX1, XX2, YY1, YY2
      DOUBLE PRECISION XTEMP(NKTEMP)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 1024) ADJLAB, FNAME, LABFIL, SIM256, VFFILE
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER  BLANK*1, DEFOLT*27, ENDER*34, WORD3*3, WORD4*4,
     +           WORD5*5, WORD6*6, WORD7*7, WORD8*8
      PARAMETER (BLANK = ' ',
     +           DEFOLT = '%simplot configuration file',
     +           ENDER = '%end of simplot configuration file'  )
      CHARACTER (LEN = 1   ) F, T
      PARAMETER (F = 'F', T = 'T')
      CHARACTER (LEN = 100 ) LINE, TEXT(NUMTXT)
      LOGICAL    ABORT, ACTION, ADD_DATA, OP, STORE, THERE, YES
      LOGICAL    PLOT_ADJLAB, PLOT_LABELS, PLOT_VFFILE, QUERY_EXIT
      LOGICAL    BORDER1, FLASH, HIGH
      PARAMETER (BORDER1 = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   OFILES$, PUTFAT$, GETTXT$, PUTADV$, SAVARR$, SAVOBJ$,
     +           SAVTXT$, ADDDAT$, SAVQUE$
      EXTERNAL   LBOX01, TRIML1, LCASE1, CHECKF, PATCH1, VU2CHK, GETIOS,
     +           YESNO1, SIM256, GETNOU
      EXTERNAL   SIMPLOT_METAFILE_3
      INTRINSIC  MIN, MAX, TRIM
      DATA   NUMBLD / NUMTXT*0 /
      DATA   NUMPOS / NUMOPT*1 /
C
C Check if a metafile has been installed
C      
      RESTORE_RANGE = .FALSE.
      STORE = .FALSE.
      CALL SIMPLOT_METAFILE_3 (FNAME,
     +                         ACTION, STORE)
      IF (BAR_CHART .OR. PIE_CHART) THEN
          KEYS = NPTS
      ELSE 
         KEYS = NFILES
      ENDIF
      IF (SIDE .AND. KEYS.GT.20) THEN
         KEYS = 20
      ELSEIF (KEYS.GT.12) THEN
         KEYS = 12
      ENDIF   

  20  CONTINUE
      IF (ACTION) THEN
C
C There is a current active metafile so proceed
C        
         NUMDEC = 2
      ELSE          
C
C Declare the options (close NIN every time...this a branch point)
C
         NUMBLD(1) = 1
         CLOSE (UNIT = NIN)
         WRITE (TEXT,100)
         NUMDEC = NUMOPT - 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER1, FLASH, HIGH)
C
C Preliminary action based on NUMDEC
C
         
         IF (NUMDEC.EQ.1) THEN
            ISEND = 1
            ADD_DATA = .FALSE.
         ELSEIF (NUMDEC.EQ.2 .OR. NUMDEC.EQ.3) THEN
            WRITE (TEXT,200)
            DO I = 1, 5
               TEXT(I) = TEXT(19 + I)
            ENDDO
            LINE =
     +     'First save a configuration file to undo/restore'
            YES = .TRUE.
            I = 0
            J = 5
            CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, I, I, J,
     +                   LINE, TEXT,
     +                   BORDER1, FLASH, HIGH, YES)
            IF (YES) GOTO 20
            IF (NUMDEC.EQ.3) THEN
               RESTORE_RANGE = .TRUE.
            ELSE
               RESTORE_RANGE = .FALSE.
            ENDIF  
            ISEND = 3
         ELSEIF (NUMDEC.EQ.4) THEN
            ISEND = 1
            ADD_DATA = .TRUE.   
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(8) = 1
            NUMBLD(20) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER1)
            NUMBLD(1) = 0
            NUMBLD(8) = 0
            NUMBLD(20) = 0
            GOTO 20
         ELSE
            RETURN
         ENDIF
      ENDIF   
C
C Get the current values
C
      STORE = .FALSE.
      CALL SAVARR$(IARROW, IKOLOR, N_ARROW, HEAD, X1, X2, Y1, Y2,
     +             STORE)
      STORE = .FALSE.
      CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, SIZE_OBJ, WIDE_OBJ,
     +             X_OBJ, Y_OBJ, STORE)
      STORE = .FALSE.
      CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, HSTRNG, SPS, XPS, XSTRNG,
     +             YSTRNG, FONT, STRNG, SYMBOL, TYPE1, STORE)
C
C Open a file
C
      CLOSE (UNIT = NIN)
      IF (ACTION) THEN
         OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
         IF (IOS.NE.0) THEN
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF   
      ELSE    
         CALL OFILES$(ISEND, NIN,
     +                FNAME,
     +                ABORT)
         IF (FNAME.EQ.BLANK) ABORT = .TRUE.
         IF (ABORT) THEN
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF   
      ENDIF 
C
C***************************************************************************************************
C***************************************************************************************************
C          
      IF (NUMDEC.EQ.1 .OR. NUMDEC.EQ.4) THEN
         STORE = .TRUE.
         QUERY_EXIT = .FALSE.
         CALL SAVQUE$(QUERY_EXIT, STORE)
C
C *******************************************
C Start writing the output configuration file
C *******************************************C
         PLOT_ADJLAB = .FALSE.
         PLOT_LABELS = .FALSE.
         PLOT_VFFILE = .FALSE.
         ADJLAB = SIM256('f$rotate.tmp')
         LABFIL = SIM256('f$labels.tmp')
         VFFILE = SIM256('f$vfield.tmp')
         INQUIRE (FILE = ADJLAB, EXIST = THERE, OPENED = OP,
     +            IOSTAT = IOS)
         IF (THERE .AND. IOS.EQ.0 .AND. .NOT.OP) PLOT_ADJLAB = .TRUE.
         INQUIRE (FILE = LABFIL, EXIST = THERE, OPENED = OP,
     +            IOSTAT = IOS)
         IF (THERE .AND. IOS.EQ.0 .AND. .NOT.OP) PLOT_LABELS = .TRUE.
         INQUIRE (FILE = VFFILE, EXIST = THERE, OPENED = OP,
     +            IOSTAT = IOS)
         IF (THERE .AND. IOS.EQ.0 .AND. .NOT.OP) PLOT_VFFILE = .TRUE. 
        
         IF (ADD_DATA) THEN
            CALL GETTXT$('A title for this SIMPLOT metafile', TITLE)
         ELSE   
            CALL GETTXT$('A title for this SIMPLOT configuration file',
     +                   TITLE)
         ENDIF  
          
         WRITE (NIN,'(A)') TITLE
         WRITE (NIN,'(A)') DEFOLT
C
C Type
C
         WRITE (NIN,'(A)') '%type'
         IF (TWO_PLOTS) THEN
            WRITE (NIN,'(A)') 'two-plots'
         ELSEIF (BAR_CHART) THEN
            WRITE (NIN,'(A)') 'bar-chart'
         ELSEIF (PIE_CHART) THEN
            WRITE (NIN,'(A)') 'pie-chart'
         ELSEIF (VECTOR_FIELD) THEN
            WRITE (NIN,'(A)') 'vector-field'
         ELSEIF (DENDRO_GRAM) THEN
            WRITE (NIN,'(A)') 'dendro-gram'
         ELSEIF (PLOT_LABELS) THEN
            WRITE (NIN,'(A)') 'plot-labels'   
         ELSE
            WRITE (NIN,'(A)') 'normal-xy'
         ENDIF
C
C Transformation
C
         WRITE (NIN,'(A)') '%transformation'
         WRITE (NIN,'(I5)') MTRANS
C
C Title and legends
C
         WRITE (NIN,'(A)') '%title'
         WRITE (NIN,'(A)') TRIM(PTITLE)
         WRITE (NIN,'(A)') TRIM(ARRAYT)
         WRITE (NIN,'(A)') '%second title'
         WRITE (NIN,'(A)') TRIM(QTITLE)
         WRITE (NIN,'(A)') TRIM(ARRAYQ)
         WRITE (NIN,'(A)') '%xlegend'
         WRITE (NIN,'(A)') TRIM(XTITLE)
         WRITE (NIN,'(A)') TRIM(ARRAYX)
         WRITE (NIN,'(A)') '%ylegend'
         WRITE (NIN,'(A)') TRIM(YTITLE)
         WRITE (NIN,'(A)') TRIM(ARRAYY)
         WRITE (NIN,'(A)') '%elegend'
         WRITE (NIN,'(A)') TRIM(ZTITLE)
         WRITE (NIN,'(A)') TRIM(ARRAYZ)
C
C Limits
C
         WRITE (NIN,'(A)') '%limits'
         WRITE (NIN,'(2I5)') NCLIP, NSPLIT
         WRITE (NIN,'(1P,6E11.3)') (XCLIP(I), I = 1, NCLIP)
         WRITE (NIN,'(1P,3E11.3)')  XCOORD, XMAX, XMIN
         WRITE (NIN,'(1P,6E11.3)') (XSPLIT(I), I = 1, NSPLIT)
         WRITE (NIN,'(1P,6E11.3)') (YCLIP(I), I = 1, NCLIP)
         WRITE (NIN,'(1P,7E11.3)')  YCOORD, YMAX, YMAX3, YMAX4,
     +                              YMIN, YMIN3, YMIN4
         WRITE (NIN,'(1P,6E11.3)') (YSPLIT(I), I = 1, NSPLIT)
         WRITE (NIN,'(1P,4E11.3)')  ZCOORD, ZMAX, ZMIN, ZSCALE
C
C Shape
C
         WRITE (NIN,'(A)') '%shape'
         WRITE (NIN,'(3I5)') ISHAPE, KANGLE, NGROUP
         WRITE (NIN,'(1P,8E11.3)') ASYMP, DRAGTI, DRAGXL, DRAGYL,
     +                             DRAGZL, THICK, XPDRAG, YPDRAG
         LINE = BLANK
         DO I = 1, 36
            LINE(I:I) = F
         ENDDO
         IF (BARCAP_1)   LINE(1:1) = T
         IF (BOXIT)      LINE(2:2) = T
         IF (CENTRE)     LINE(3:3) = T
         IF (FRAME)      LINE(4:4) = T
         IF (MONO)       LINE(5:5) = T
         IF (NUMBRX)     LINE(6:6) = T
         IF (OFFSET)     LINE(7:7) = T
         IF (PANEL)      LINE(8:8) = T
         IF (PCENTX)     LINE(9:9) = T
         IF (PCENTY)     LINE(10:10) = T
         IF (PCENTZ)     LINE(11:11) = T
         IF (PHIGHX)     LINE(12:12) = T
         IF (PHIGHY)     LINE(13:13) = T
         IF (PHIGHZ)     LINE(14:14) = T
         IF (PLOT_TITLE) LINE(15:15) = T
         IF (POWERX)     LINE(16:16) = T
         IF (POWERY)     LINE(17:17) = T
         IF (POWERZ)     LINE(18:18) = T
         IF (ROTATE)     LINE(19:19) = T
         IF (SIDE)       LINE(20:20) = T
         IF (SWAP_YZ)    LINE(21:21) = T
         IF (THREE_D)    LINE(22:22) = T
         IF (VIDEO)      LINE(23:23) = T
         IF (XGRID)      LINE(24:24) = T
         IF (XTOINT)     LINE(25:25) = T
         IF (YGRID)      LINE(26:26) = T
         IF (YTOINT)     LINE(27:27) = T
         IF (ZTOINT)     LINE(28:28) = T
         IF (BORDER)          LINE(29:29) = T  
         IF (EXTEND_LINES)    LINE(30:30) = T  
         IF (GRATICULE)       LINE(31:31) = T  
         IF (SHOW_BACKGROUND) LINE(32:32) = T  
         IF (SHOW_QUADRANTs)  LINE(33:33) = T  
         IF (SHOW_XAXIS)      LINE(34:34) = T  
         IF (SHOW_YAXIS)      LINE(35:35) = T
         IF (SHOW_ZAXIS)      LINE(36:36) = T     
         WRITE (NIN,'(A)') TRIM(LINE)
C
C Ticks
C
         WRITE (NIN,'(A)') '%ticks'
         WRITE (NIN,'(4I5)') KTIC, MXTIC, MYTIC, MZTIC
C
C Colours
C
         WRITE (NIN,'(A)') '%colours'
         WRITE (NIN,'(I5)') NKCOL + 1
         WRITE (NIN,'(15I5)') (KCOLOR(I), I = 1, NKCOL), LCOLOR
C
C Lines and symbols
C
         DO I = 1, NFILES
            WRITE (NIN,300) I, L(I), WIDE(I), M(I), SIZE(I), JCOLOR(I)
         ENDDO
C
C Arrows
C
         DO I = 1, N_ARROW
            IF (IARROW(I).GT.0)
     +      WRITE (NIN,400) I, IARROW(I), HEAD(I), X1(I), X2(I),
     +                      Y1(I), Y2(I), IKOLOR(I)
         ENDDO
C
C Text
C
         DO I = 1, N_TEXT
            IF (STRNG(I).NE.BLANK)
     +      WRITE (NIN,500) I, ISTRNG(I), SPS(I), XPS(I), XSTRNG(I),
     +                      YSTRNG(I), JKOLOR(I),
     +                      TRIM(FONT(I)), TRIM(STRNG(I)),
     +                      TRIM(SYMBOL(I)), TRIM(TYPE1(I))
         ENDDO
C
C Keys
C         
         DO I = 1, KEYS
            WORD7 = PLINE(I)(1:7)
            WORD3 = PLINE(I)(1:3)
            CALL LCASE1 (WORD3)
            CALL LCASE1 (WORD7)
            IF (WORD3.NE.'key' .AND. WORD7.NE.'edit me') THEN
               WRITE (NIN,600) I, TRIM(PLINE(I)), TRIM(PSYMB(I))
            ENDIF
         ENDDO
C
C Objects
C
         DO I = 1, N_OBJ
            IF (M_OBJ(I).GT.0) THEN
               WRITE (NIN,700) I, M_OBJ(I), SIZE_OBJ(I), WIDE_OBJ(I),
     +                         X_OBJ(I), Y_OBJ(I), JCOLOR_OBJ(I)
            ENDIF
         ENDDO
C
C Error bars
C
         DO I = 1, NFILES
            J1 = 0
            K1 = 0
            L1 = 0
            IF (BARCAP(I)) J1 = 1
            IF (LOWER(I)) K1 = 1
            IF (UPPER(I)) L1 = 1
            WRITE (NIN,800) I, J1, K1, L1
         ENDDO
C
C Bars/segments
C
         IF (BAR_CHART .OR. PIE_CHART) THEN
            WRITE (NIN,'(A)') '%bar/pie (fill,colour,factor,label,code)'
            WRITE (NIN,'(I5)') NPTS
            DO I = 1, NPTS
               WRITE (NIN,'(2I5,F8.4)') IFILL(I), IHUE(I), FACTOR(I)
               WRITE (NIN,'(A)') TRIM(LABELS(I))
               WRITE (NIN,'(A)') TRIM(LABVEC(I))
            ENDDO
         ENDIF
C
C Words
C
          IF (MXTIC.GT.-1) THEN
             WRITE (NIN,'(A)') '%words'
             WRITE (NIN,'(I5)') MXTIC + 1
             DO I = 1, MXTIC + 1
                WRITE (NIN,'(A)') TRIM(WORDX(I))
                WRITE (NIN,'(A)') TRIM(WORDY(I))
             ENDDO
          ENDIF
C
C Plotxyz
C
          IF (MXTIC.GT.-1 .OR. MYTIC.GT.-1 .OR. MZTIC.GT.-1) THEN
              WRITE (NIN,'(A)') '%plotxyz'
              J = MAX(MXTIC,MYTIC,MZTIC) + 1
              IF (J.GT.NWORDS) J = NWORDS
              WRITE (NIN,'(I5)') J
              DO I = 1, J
                 J1 = 0
                 K1 = 0
                 L1 = 0
                 IF (PLOTX(I)) J1 = 1
                 IF (PLOTY(I)) K1 = 1
                 IF (PLOTZ(I)) L1 = 1
                 WRITE (NIN,'(3I5)') J1, K1, L1
             ENDDO
          ENDIF
C
C logs
C
          IF (NLOG.GT.0) THEN
             WRITE (NIN,'(A)') '%logs'
             WRITE (NIN,'(I5)') NLOG
             LINE = BLANK
             DO I = 1, NLOG
                IF (NATLOG(I)) THEN
                   LINE(I:I) = T
                ELSE
                   LINE(I:I) = F
                ENDIF
             ENDDO
             WRITE (NIN,'(A)') TRIM(LINE)
          ENDIF
C
C adjlab
C       
         IF (PLOT_ADJLAB) THEN
            CALL GETNOU (NTEMP)
            OPEN (UNIT = NTEMP, FILE = ADJLAB, IOSTAT=IOS)
            IF (IOS.EQ.0) WRITE (NIN,'(A)') '%adjlab' 
            DO WHILE (IOS.EQ.0)
               READ (NTEMP,'(A)',IOSTAT=IOS) LINE
               IF (IOS.EQ.0) WRITE (NIN,'(A)') TRIM(LINE)
            ENDDO
            CLOSE (UNIT = NTEMP)       
            WRITE (NIN,'(A)') '%donotreadanymorelines'
         ENDIF
C
C labels
C       
         IF (PLOT_LABELS) THEN
            CALL GETNOU (NTEMP)
            OPEN (UNIT = NTEMP, FILE = LABFIL, IOSTAT=IOS)
            IF (IOS.EQ.0) WRITE (NIN,'(A)') '%labels' 
            DO WHILE (IOS.EQ.0)
               READ (NTEMP,'(A)',IOSTAT=IOS) LINE
               IF (IOS.EQ.0) WRITE (NIN,'(A)') TRIM(LINE)
            ENDDO
            CLOSE (UNIT = NTEMP)       
            WRITE (NIN,'(A)') '%donotreadanymorelines'
         ENDIF            
C
C vffile
C       
         IF (PLOT_VFFILE) THEN
            CALL GETNOU (NTEMP)
            OPEN (UNIT = NTEMP, FILE = VFFILE, IOSTAT=IOS)
            IF (IOS.EQ.0) WRITE (NIN,'(A)') '%vffile' 
            DO WHILE (IOS.EQ.0)
               READ (NTEMP,'(A)',IOSTAT=IOS) LINE
               IF (IOS.EQ.0) WRITE (NIN,'(A)') TRIM(LINE)
            ENDDO
            CLOSE (UNIT = NTEMP)       
            WRITE (NIN,'(A)') '%donotreadanymorelines'
         ENDIF  
C
C yaxis
C
        IF (TWO_PLOTS) THEN
           WRITE (NIN,'(A)') '%yaxis'
           LINE = BLANK
           DO I = 1, MIN(NFILES,100)
              IF (YAXIS(I)) THEN
                 LINE(I:I) = T
              ELSE
                 LINE(I:I) = F
              ENDIF
           ENDDO
           WRITE (NIN,'(A)') TRIM(LINE)
        ENDIF             
                   
C
c*********************************************
C Stop writing the output cfg file then return
C*********************************************
C
         WRITE (NIN,'(A)') ENDER
         IF (ADD_DATA) CALL ADDDAT$(IFILL, IHUE, NFILES, NIN, NXTRA,
     +                              FACTOR,     
     +                              FSAV1,
     +                              DENDRO_GRAM, PLOT_LABELS,
     +                              VECTOR_FIELD)           
         CLOSE (UNIT = NIN)
         RETURN
C
C***************************************************************************************************
C***************************************************************************************************
C         
      ELSEIF (NUMDEC.EQ.2 .OR. NUMDEC.EQ.3) THEN
         STORE = .TRUE.
         QUERY_EXIT = .TRUE.
         CALL SAVQUE$(QUERY_EXIT, STORE)
C
C ********************************
C Start reading the input cfg file
C ********************************
C
         PLOT_LABELS = .FALSE.
         IADD1 = 1
         READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 40
C
C Disconnect, check, then re-connect and wind on
C
         CLOSE (UNIT = NIN)
         IF (ACTION) THEN
            ABORT = .FALSE.
         ELSE   
            CALL CHECKF (FNAME, TITLE,
     +                   ABORT)
         ENDIF
         IF (ABORT) THEN
            GOTO 20
         ELSE
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TITLE
            IF (IOS.NE.0) GOTO 40
         ENDIF
         IADD1 = IADD1 + 1
         READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 40
         CALL TRIML1 (TITLE)
         CALL LCASE1 (TITLE)
         IF (TITLE.NE.DEFOLT) THEN
            CLOSE (UNIT = NIN)
            CALL PUTFAT$(
     +     'Error at line 2 ... Not a valid simplot configuration file')
            CALL VU2CHK (FNAME)
            GOTO 20
         ENDIF
      ENDIF
C
C File seems OK so try to read it
C
      IOS = 0
      DO WHILE (IOS.EQ.0)
C
C Try to read in the next key word then check IOS for EOF
C
         IADD1 = IADD1 + 1
         READ (NIN,'(A)',IOSTAT=IOS) LINE
         IF (IOS.LT.0) THEN
C
C End of file: Stop reading the input cfg file
C ============================================
C
            CLOSE (UNIT = NIN)
C
C Save the current values
C
            STORE = .TRUE.
            CALL SAVARR$(IARROW, IKOLOR, N_ARROW, HEAD, X1, X2, Y1, Y2,
     +                   STORE)
            STORE = .TRUE.
            CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, SIZE_OBJ, WIDE_OBJ,
     +                   X_OBJ, Y_OBJ, STORE)
            STORE = .TRUE.
            CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, HSTRNG, SPS, XPS,
     +                   XSTRNG, YSTRNG, FONT, STRNG, SYMBOL, TYPE1,
     +                   STORE)
            RETURN
         ELSEIF (IOS.EQ.0) THEN
C
C OK ... carry on
C
            IOS = 0!to silence ftn95...originally CONTINUE
         ELSEIF (IOS.GT.0) THEN
C
C ERROR ... go to crash
C
            GOTO 40
         ENDIF
         CALL TRIML1 (LINE)
         CALL LCASE1 (LINE)
         WORD4 = LINE(1:4)
         WORD5 = LINE(1:5)
         WORD6 = LINE(1:6)
         WORD7 = LINE(1:7)
         WORD8 = LINE(1:8)
C
C Try to interpret the next key word
C
         IF (WORD5.EQ.'%type') THEN
C
C %type
C
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            CALL TRIML1 (LINE)
            CALL LCASE1 (LINE)
            IF (TWO_PLOTS) THEN
               IF (LINE(1:9).NE.'two-plots') THEN
                  CALL PUTFAT$('Not a valid two_plot type cfg file')
                  GOTO 40
               ENDIF
            ELSEIF (BAR_CHART) THEN
               IF (LINE(1:9).NE.'bar-chart') THEN
                  CALL PUTFAT$('Not a valid bar_chart type cfg file')
                  GOTO 40
               ENDIF
            ELSEIF (PIE_CHART) THEN
               IF (LINE(1:9).NE.'pie-chart') THEN
                  CALL PUTFAT$('Not a valid pie_chart type cfg file')
                  GOTO 40
               ENDIF
            ELSEIF (VECTOR_FIELD) THEN
               IF (LINE(1:12).NE.'vector-field') THEN
                  CALL PUTFAT$('Not a valid vector_field type cfg file')
                  GOTO 40
               ENDIF
            ELSEIF (DENDRO_GRAM) THEN
               IF (LINE(1:11).NE.'dendro-gram') THEN
                  CALL PUTFAT$('Not a valid dendrogram type cfg file')
                  GOTO 40
               ENDIF
            ELSEIF (LINE(1:11).EQ.'plot-labels') THEN
               PLOT_LABELS = .TRUE.   
            ELSEIF (LINE(1:9).NE.'normal-xy') THEN
               CALL PUTFAT$('Not a valid normal-xy type cfg file')
               GOTO 40
            ENDIF
         ELSEIF (WORD6.EQ.'%trans') THEN
C
C %trans
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) K
            IF (IOS.NE.0) GOTO 40
            IF (K.LT.0 .OR. K.GT.15) THEN
               CALL PUTFAT$('Illegal transformation')
               GOTO 40
            ENDIF
            IF (K.EQ.0) THEN
               MTRANS = K
            ELSE
               IF (BAR_CHART .OR. PIE_CHART .OR. TWO_PLOTS .OR.
     +             VECTOR_FIELD) THEN
                  CALL PUTFAT$(
     +   'Cannot transform double/bar/pie/vector-field plots')
               ELSE
                  MTRANS = K
               ENDIF
            ENDIF
         ELSEIF (WORD6.EQ.'%title') THEN
C
C %title
C
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            PTITLE = LINE
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            ARRAYT = LINE
         ELSEIF (WORD7.EQ.'%second') THEN
C
C %second title
C
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            QTITLE = LINE
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            ARRAYQ = LINE
         ELSEIF (WORD8.EQ.'%xlegend') THEN
C
C %xlegend
C
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            XTITLE = LINE
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            ARRAYX = LINE
         ELSEIF (WORD8.EQ.'%ylegend') THEN
C
C %ylegend
C
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            YTITLE = LINE
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            ARRAYY = LINE
         ELSEIF (WORD8.EQ.'%elegend') THEN
C
C %elegend
C
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            ZTITLE = LINE
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            ARRAYZ = LINE
         ELSEIF (WORD7.EQ.'%limits') THEN
C
C %limits
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J, K
            IF (IOS.NE.0) GOTO 40
            IF (J.LT.2 .OR. J.GT.NKTEMP) THEN
               CALL PUTFAT$('NCLIP out of range')
               GOTO 40
            ENDIF
            IF (K.LT.2 .OR. K.GT.NKTEMP) THEN
               CALL PUTFAT$('NSPLIT out of range')
               GOTO 40
            ENDIF
            IF (J.EQ.NCLIP .AND. K.EQ.NSPLIT) THEN
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,J)
               IF (IOS.NE.0) GOTO 40
               DO I = 1, J
                  XCLIP(I) = XTEMP(I)
               ENDDO
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,3)
               IF (IOS.NE.0) GOTO 40
               XCOORD = XTEMP(1)
               XMAX = XTEMP(2)
               XMIN = XTEMP(3)
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,K)
               IF (IOS.NE.0) GOTO 40
               DO I = 1, K
                  XSPLIT(I) = XTEMP(I)
               ENDDO
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,J)
               IF (IOS.NE.0) GOTO 40
               DO I = 1, J
                  YCLIP(I) = XTEMP(I)
               ENDDO
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,7)
               IF (IOS.NE.0) GOTO 40
               YCOORD = XTEMP(1)
               YMAX = XTEMP(2)
               YMAX3 = XTEMP(3)
               YMAX4 = XTEMP(4)
               YMIN = XTEMP(5)
               YMIN3 = XTEMP(6)
               YMIN4 = XTEMP(7)
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,K)
               IF (IOS.NE.0) GOTO 40
               DO I = 1, K
                  YSPLIT(I) = XTEMP(I)
               ENDDO
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I=1,4)
               IF (IOS.NE.0) GOTO 40
               ZCOORD = XTEMP(1)
               ZMAX = XTEMP(2)
               ZMIN = XTEMP(3)
               ZSCALE = XTEMP(4)
            ENDIF
         ELSEIF (WORD6.EQ.'%shape') THEN
C
C %shape
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J1, K1, L1
            IF (IOS.NE.0) GOTO 40
            IF (J1.GE.0 .AND. J1.LE.4) ISHAPE = J1
            IF (K1.GE.1 .AND. K1.LE.9) KANGLE = K1
            IF (L1.GE.0) NGROUP = L1
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (XTEMP(I),I = 1, 8)
            IF (IOS.NE.0) GOTO 40
            ASYMP = XTEMP(1)
            DRAGTI = XTEMP(2)
            DRAGXL = XTEMP(3)
            DRAGYL = XTEMP(4)
            DRAGZL = XTEMP(5)
            THICK = XTEMP(6)
            XPDRAG = XTEMP(7)
            YPDRAG = XTEMP(8)
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            CALL TRIML1 (LINE)
            BARCAP_1    = .FALSE.
            BOXIT       = .FALSE.
            CENTRE      = .FALSE.
            FRAME       = .FALSE.
            MONO        = .FALSE.
            NUMBRX      = .FALSE.
            OFFSET      = .FALSE.
            PANEL       = .FALSE.
            PCENTX      = .FALSE.
            PCENTY      = .FALSE.
            PCENTZ      = .FALSE.
            PHIGHX      = .FALSE.
            PHIGHY      = .FALSE.
            PHIGHZ      = .FALSE.
            PLOT_TITLE  = .FALSE.
            POWERX      = .FALSE.
            POWERY      = .FALSE.
            POWERZ      = .FALSE.
            ROTATE      = .FALSE.
            SIDE        = .FALSE.
            SWAP_YZ     = .FALSE.
            THREE_D     = .FALSE.
            VIDEO       = .FALSE.
            XGRID       = .FALSE.
            XTOINT      = .FALSE.
            YGRID       = .FALSE.
            YTOINT      = .FALSE.
            ZTOINT      = .FALSE.
            IF (LEN_TRIM(LINE).GE.36) THEN
                SHOW_XAXIS = .FALSE.
                SHOW_YAXIS = .FALSE.
                SHOW_ZAXIS = .FALSE.
            ENDIF    
            IF (LINE(1:1).EQ.T)   BARCAP_1    = .TRUE.
            IF (LINE(2:2).EQ.T)   BOXIT       = .TRUE.
            IF (LINE(3:3).EQ.T)   CENTRE      = .TRUE.
            IF (LINE(4:4).EQ.T)   FRAME       = .TRUE.
            IF (LINE(5:5).EQ.T)   MONO        = .TRUE.
            IF (LINE(6:6).EQ.T)   NUMBRX      = .TRUE.
            IF (LINE(7:7).EQ.T)   OFFSET      = .TRUE.
            IF (LINE(8:8).EQ.T)   PANEL       = .TRUE.
            IF (LINE(9:9).EQ.T)   PCENTX      = .TRUE.
            IF (LINE(10:10).EQ.T) PCENTY      = .TRUE.
            IF (LINE(11:11).EQ.T) PCENTZ      = .TRUE.
            IF (LINE(12:12).EQ.T) PHIGHX      = .TRUE.
            IF (LINE(13:13).EQ.T) PHIGHY      = .TRUE.
            IF (LINE(14:14).EQ.T) PHIGHZ      = .TRUE.
            IF (LINE(15:15).EQ.T) PLOT_TITLE  = .TRUE.
            IF (LINE(16:16).EQ.T) POWERX      = .TRUE.
            IF (LINE(17:17).EQ.T) POWERY      = .TRUE.
            IF (LINE(18:18).EQ.T) POWERZ      = .TRUE.
            IF (LINE(19:19).EQ.T) ROTATE      = .TRUE.
            IF (LINE(20:20).EQ.T) SIDE        = .TRUE.
            IF (LINE(21:21).EQ.T) SWAP_YZ     = .TRUE.
            IF (LINE(22:22).EQ.T) THREE_D     = .TRUE.
            IF (LINE(23:23).EQ.T) VIDEO       = .TRUE.
            IF (LINE(24:24).EQ.T) XGRID       = .TRUE.
            IF (LINE(25:25).EQ.T) XTOINT      = .TRUE.
            IF (LINE(26:26).EQ.T) YGRID       = .TRUE.
            IF (LINE(27:27).EQ.T) YTOINT      = .TRUE.
            IF (LINE(28:28).EQ.T) ZTOINT      = .TRUE.
            WORD5 = LINE(29:33)
            IF (WORD5.NE.BLANK) THEN
C
C Extra shape parameters 20/05/2013
C              
               BORDER          = .FALSE.
               EXTEND_LINES    = .FALSE.
               GRATICULE       = .FALSE.
               SHOW_BACKGROUND = .FALSE.
               SHOW_QUADRANTS  = .FALSE.
               IF (WORD5(1:1).EQ.T) BORDER          = .TRUE.
               IF (WORD5(2:2).EQ.T) EXTEND_LINES    = .TRUE.
               IF (WORD5(3:3).EQ.T) GRATICULE       = .TRUE.
               IF (WORD5(4:4).EQ.T) SHOW_BACKGROUND = .TRUE.
               IF (WORD5(5:5).EQ.T) SHOW_QUADRANTS  = .TRUE.
            ENDIF    
            IF (LEN_TRIM(LINE).GE.36) THEN
C
C Show x, y, z axes 05/01/2016
C              
               WORD3 = LINE(34:36)
               IF (WORD3.NE.BLANK) THEN
                  IF(WORD3(1:1).EQ.T) SHOW_XAXIS = .TRUE. 
                  IF(WORD3(2:2).EQ.T) SHOW_YAXIS = .TRUE. 
                  IF(WORD3(3:3).EQ.T) SHOW_ZAXIS = .TRUE. 
               ENDIF  
            ENDIF     
         ELSEIF (WORD6.EQ.'%ticks') THEN
C
C %ticks
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (KTEMP(I), I = 1, 4)
            IF (IOS.NE.0) GOTO 40
            KTIC = KTEMP(1)
            MXTIC = KTEMP(2)
            MYTIC = KTEMP(3)
            MZTIC = KTEMP(4)
         ELSEIF (WORD8.EQ.'%colours' .OR. WORD7.EQ.'%colors') THEN
C
C %colours
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) K
            IF (IOS.NE.0 .OR. K.LT.1 .OR. K.GT.NKTEMP) GOTO 40
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) (KTEMP(I), I = 1, K)
            IF (IOS.NE.0) GOTO 40
            DO I = 1, K
               IF (KTEMP(I).LT.0 .OR. KTEMP(I).GT.71) THEN
                  CALL PUTFAT$('colour out of range')
                  GOTO 40
               ENDIF
               IF (I.LE.NKCOL) THEN
                  KCOLOR(I) = KTEMP(I)
               ELSEIF (I.EQ.K) THEN
                  LCOLOR = KTEMP(I)
               ENDIF
            ENDDO
C
C Check for border and graticule being both black (old style cfg file)
C
            IF (KCOLOR(6).EQ.0 .AND. KCOLOR(7).EQ.0) THEN
               KCOLOR(6) = LCOLOR
               KCOLOR(7) = LCOLOR
            ENDIF
         ELSEIF (WORD5.EQ.'%file') THEN
C
C %file
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) N1, L1, W1, M1, S1, J1
            IF (IOS.NE.0 .OR. N1.LT.0) GOTO 40
            IF (N1.LE.NFILES) THEN
               IF (L1.LT.0) THEN
                  CALL PUTFAT$('line-type out of range')
                  GOTO 40
               ELSEIF (W1.LT.ZERO) THEN
                  CALL PUTFAT$('line-width out of range')
                  GOTO 40
               ELSEIF (M1.LT.0) THEN
                  CALL PUTFAT$('symbol-type out of range')
                  GOTO 40
               ELSEIF (S1.LT.ZERO) THEN
                  CALL PUTFAT$('symbol-size out of range')
                  GOTO 40
               ELSEIF (J1.LT.0 .OR. J1.GT.71) THEN
                  CALL PUTFAT$('colour out of range')
                  GOTO 40
               ENDIF
C
C All seems well so assign line and symbol types
C
               JCOLOR(N1) = J1
               L(N1) = L1
               M(N1) = M1
               SIZE(N1) = S1
               WIDE(N1) = W1
            ENDIF
         ELSEIF (WORD6.EQ.'%arrow') THEN
C
C %arrow
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) N1, L1, S1, XX1, XX2,
     +                                            YY1, YY2, J1
            IF (IOS.NE.0) GOTO 40
            IF (N1.GT.0 .AND. N1.LE.N_ARROW .AND. L1.NE.0) THEN
               IF (L1.LT.0) THEN
                  CALL PUTFAT$('arrow-type out of range')
                  GOTO 40
               ELSEIF (S1.LT.ZERO) THEN
                  CALL PUTFAT$('arrow-size out of range')
                  GOTO 40
               ELSEIF (XX1.LT.ZERO .OR. XX2.LT.ZERO .OR.
     +                 XX1.GT.ONE  .OR. XX2.GT.ONE  .OR.
     +                 YY1.LT.ZERO .OR. YY2.LT.ZERO .OR.
     +                 YY1.GT.ONE  .OR. YY2.GT.ONE) THEN
                  CALL PUTFAT$('arrow-coordinates out of range')
                  GOTO 40
               ELSEIF (J1.LT.0 .OR. J1.GT.71) THEN
                  CALL PUTFAT$('arrow-colour out of range')
                  GOTO 40
               ENDIF
C
C All seems well so assign the arrow configuration
C
               IARROW(N1) = L1
               HEAD(N1) = S1
               X1(N1) = XX1
               X2(N1) = XX2
               Y1(N1) = YY1
               Y2(N1) = YY2
               IKOLOR(N1) = J1
            ENDIF
         ELSEIF (WORD5.EQ.'%text') THEN
C
C %text
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) N1, L1, XX1, XX2,
     +                                            YY1, YY2, J1
            IF (IOS.NE.0) GOTO 40
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TEXT(1)
            IF (IOS.NE.0) GOTO 40
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TEXT(2)
            IF (IOS.NE.0) GOTO 40
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TEXT(3)
            IF (IOS.NE.0) GOTO 40
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TEXT(4)
            IF (IOS.NE.0) GOTO 40
            IF (N1.GT.0 .AND. N1.LE.N_TEXT .AND. TEXT(2).NE.BLANK) THEN
               IF (L1.LT.0 .OR. L1.GT.14) THEN
                  CALL PUTFAT$('font-type out of range')
                  GOTO 40
               ELSEIF (XX1.LT.-360.0D+00 .OR. XX1.GT.360.0D+00) THEN
                  CALL PUTFAT$('text-angle out of range')
                  GOTO 40
               ELSEIF (XX2.LT.ZERO) THEN
                  CALL PUTFAT$('text-size out of range')
                  GOTO 40
               ELSEIF (YY1.LT.ZERO .OR. YY1.GT.ONE .OR.
     +                 YY2.LT.ZERO .OR. YY2.GT.ONE) THEN
                  CALL PUTFAT$('text-coordinates out of range')
                  GOTO 40
               ELSEIF (J1.LT.0 .OR. J1.GT.71) THEN
                  CALL PUTFAT$('text-colour out of range')
                  GOTO 40
               ENDIF
C
C All seems well so assign the text configuration
C
               ISTRNG(N1) = L1
               SPS(N1) = XX1
               XPS(N1) = XX2
               XSTRNG(N1) = YY1
               YSTRNG(N1) = YY2
               FONT(N1) = TEXT(1)(1:80)
               STRNG(N1) = TEXT(2)
               SYMBOL(N1) = TEXT(3)
               TYPE1(N1) = TEXT(4)
               JKOLOR(N1) = J1
            ENDIF
         ELSEIF (WORD4.EQ.'%key') THEN
C
C %key
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) N1
            IF (N1.GT.0 .AND. N1.LE.KEYS) THEN
               IADD1 = IADD1 + 1
               READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TEXT(1)
               IF (IOS.NE.0) GOTO 40
               IADD1 = IADD1 + 1
               READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) TEXT(2)
               IF (IOS.NE.0) GOTO 40
C
C All seems well so assign PLINE and PSYMB
C
               PLINE(N1) = TEXT(1)
               PSYMB(N1) = TEXT(2)
            ENDIF
         ELSEIF (WORD7.EQ.'%object') THEN
C
C %object
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) N1, L1, S1, W1, XX1,
     +                                            YY1, J1
            IF (IOS.NE.0) GOTO 40
            IF (N1.GT.0 .AND. N1.LE.N_OBJ .AND. L1.NE.0) THEN
               IF (L1.LT.0) THEN
                  CALL PUTFAT$('object-type out of range')
                  GOTO 40
               ELSEIF (S1.LT.ZERO) THEN
                  CALL PUTFAT$('object-size out of range')
                  GOTO 40
               ELSEIF (W1.LT.ZERO) THEN
                  CALL PUTFAT$('object-width out of range')
                  GOTO 40
               ELSEIF (XX1.LT.ZERO .OR. XX1.GT.ONE .OR.
     +                 YY1.LT.ZERO .OR. YY1.GT.ONE) THEN
                  CALL PUTFAT$('object-coordinates out of range')
                  GOTO 40
               ELSEIF (J1.LT.0 .OR. J1.GT.71) THEN
                  CALL PUTFAT$('object-colour out of range')
                GOTO 40
               ENDIF
C
C All seems well so assign the object configuration
C
               M_OBJ(N1) = L1
               SIZE_OBJ(N1) = S1
               WIDE_OBJ(N1) = W1
               X_OBJ(N1) = XX1
               Y_OBJ(N1) = YY1
               JCOLOR_OBJ(N1) = J1
            ENDIF
         ELSEIF (WORD6.EQ.'%error') THEN
C
C %error-bars
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) I, J1, K1, L1
            IF (IOS.NE.0) GOTO 40
            IF (I.GE.1 .AND. I.LE.NFILES) THEN
               BARCAP(I) = .FALSE.
               LOWER(I) = .FALSE.
               UPPER(I) = .FALSE.
               IF (J1.EQ.1) BARCAP(I) = .TRUE.
               IF (K1.EQ.1) LOWER(I) = .TRUE.
               IF (L1.EQ.1) UPPER(I) = .TRUE.
            ENDIF
         ELSEIF (WORD8.EQ.'%bar/pie') THEN
C
C %bar/pie
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) K
            IF (IOS.NE.0 .OR. K.LE.0) GOTO 40
            IF (K.LT.NPTS) THEN
               CALL PUTADV$('insufficent bar/pie-chart details')
            ELSEIF (K.GT.NPTS) THEN
               CALL PUTADV$('too many bar/pie-chart details')
            ENDIF
            DO I = 1, MIN(NPTS,K)
               IADD1 = IADD1 + 1
               READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) L1, M1, S1
               IF (IOS.NE.0) GOTO 40
               IF (L1.LT.0 .OR. L1.GT.10) THEN
                  CALL PUTFAT$('fill-style out of range')
                  GOTO 40
               ENDIF
               IF (M1.LT.0 .OR. M1.GT.71) THEN
                  CALL PUTFAT$('colour out of range')
                  GOTO 40
               ENDIF
               IF (S1.LT.ZERO .OR. S1.GT.ONE) THEN
                  CALL PUTFAT$('factor out of range')
                  GOTO 40
               ENDIF
C
C All seems well so assign the fill-style, colour and factor
C
               IF (BAR_CHART .OR. PIE_CHART) THEN
                  IFILL(I) = L1
                  IHUE(I) = M1
                  FACTOR(I) = S1
                ENDIF
C
C Now read the labels
C
               IADD1 = IADD1 + 1
               READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
               IF (IOS.NE.0) GOTO 40
               IF (BAR_CHART .OR. PIE_CHART) LABELS(I) = LINE
               IADD1 = IADD1 + 1
               READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
               IF (IOS.NE.0) GOTO 40
               IF (BAR_CHART .OR. PIE_CHART) LABVEC(I) = LINE
            ENDDO
            IF (K.GT.NPTS) THEN
               DO I = 1, K - NPTS
                  IADD1 = IADD1 + 1
                  READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) L1, M1, S1
                  IF (IOS.NE.0) GOTO 40
                  IADD1 = IADD1 + 1
                  READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
                  IF (IOS.NE.0) GOTO 40
                  IADD1 = IADD1 + 1
                  READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
                  IF (IOS.NE.0) GOTO 40
               ENDDO
            ENDIF
         ELSEIF (WORD6.EQ.'%words') THEN
C
C %words
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J1
            IF (IOS.NE.0) GOTO 40
            IF (J1.GE.1 .AND. J1.LE.NWORDS) THEN
               DO I = 1, J1
                  IADD1 = IADD1 + 1
                  READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
                  IF (IOS.NE.0) GOTO 40
                  WORDX(I) = LINE
                  IADD1 = IADD1 + 1
                  READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
                  IF (IOS.NE.0) GOTO 40
                  WORDY(I) = LINE
               ENDDO
            ENDIF
         ELSEIF (WORD8.EQ.'%plotxyz') THEN
C
C %plotxyz
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J
            IF (IOS.NE.0) GOTO 40
            IF (J.GE.1 .AND. J.LE.NWORDS) THEN
               DO I = 1, J
                  IADD1 = IADD1 + 1
                  READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J1, K1, L1
                  IF (IOS.NE.0) GOTO 40
                  PLOTX(I) = .FALSE.
                  PLOTY(I) = .FALSE.
                  PLOTZ(I) = .FALSE.
                  IF (J1.EQ.1) PLOTX(I) = .TRUE.
                  IF (K1.EQ.1) PLOTY(I) = .TRUE.
                  IF (L1.EQ.1) PLOTZ(I) = .TRUE.
               ENDDO
            ENDIF
         ELSEIF (WORD5.EQ.'%logs') THEN
C
C %logs
C
            IADD1 = IADD1 + 1
            READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) J1
            IF (IOS.NE.0) GOTO 40
            IADD1 = IADD1 + 1
            READ (NIN,'(A)',END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            CALL TRIML1 (LINE)
            DO I = 1, MIN(J1,NLOG)
               IF (LINE(I:I).EQ.T) THEN
                  NATLOG(I) = .TRUE.
               ELSE
                  NATLOG(I) = .FALSE.
               ENDIF
            ENDDO
         ELSEIF (WORD4.EQ.'%end') THEN
C
C %end: Usual exit point
C ======================
C
C Save the current values
C
            STORE = .TRUE.
            CALL SAVARR$(IARROW, IKOLOR, N_ARROW, HEAD, X1, X2, Y1, Y2,
     +                   STORE)
            STORE = .TRUE.
            CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, SIZE_OBJ, WIDE_OBJ,
     +                   X_OBJ, Y_OBJ, STORE)
            STORE = .TRUE.
            CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, HSTRNG, SPS, XPS,
     +                   XSTRNG, YSTRNG, FONT, STRNG, SYMBOL, TYPE1,
     +                   STORE)
            IOS = - 1
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
      ENDDO
C
C This point should not normally be reached since exit should occur at EOF
C However, if here for some reason then skip the error action and return
C
      CLOSE (UNIT = NIN)
      RETURN
C
C LABEL 40: Crash
C =========
C
   40 CONTINUE
      CLOSE (UNIT = NIN)
      WRITE (WORD6,'(I6)') IADD1
      CALL TRIML1 (WORD6)
      WRITE (LINE,900) WORD6
      CALL PUTFAT$(LINE)
      IF (IOS.NE.0) THEN
         CALL GETIOS (IOS, LINE)
         CALL PUTADV$(LINE)
      ENDIF
      CALL VU2CHK (FNAME)
C
C Format statements
C              
  100 FORMAT (
     + 'SIMPLOT configuration and meta files'
     +/
     +/'You can now create a configuration file to save'
     +/'symbols, colours, tick marks, titles, legends,'
     +/'arrows, error bars types, etc. for future use.'
     +/'If you read in a such a configuration file it'
     +/'will over-ride current settings, but not data.'
     +/
     +/'Reading in a configuration file in comprehensive'
     +/'mode re-sets the data ranges to those when it was'
     +/'created. Ignoring data ranges is more versatile as'
     +/'it allows the configuration file to be used as a'
     +/'template for data sets with different data ranges.'
     +/
     +/'Metafiles also save data and can just configure or'
     +/'even restore complete graphs using program SIMPLOT.'
     +/
     +/'Save parameters to a CFG file'
     +/'Input a CFG file: comprehensive (use all details)'
     +/'Input a CFG file: as a template (ignore data ranges)'
     +/'Create a Simplot metafile'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'Simfit configuration files and metafiles'
     +/
     +/'Configuration files save all feature of a graph except data.'
     +/'So, after creating a graph, such files are just short cuts to'
     +/'restore titles, legends, colurs, etc. Metafiles also save data'
     +/'and can configure or even re-create graphs using Simplot.'
     +/
     +/'Using configuration files as templates'
     +/
     +/'Configuration files re-set ranges, tick marks, panels, labels,'
     +/'transformation, etc. to values current when created, so you'
     +/'must be aware of anomalies with incompatible data/configuration'
     +/'files. In particular, if data ranges are not identical you must'
     +/'re-set the range interactively. To get round this you can store'
     +/'compatible pairs of a data sets and configuration files as with'
     +/'simfig1.TFL and w_simfig1.cfg, or use metafiles. It is best to'
     +/'input configuration files without changing data ranges, i.e. as'
     +/'plotting templates where there are inconsistent data ranges.'
     +/
     +/'Warning: Recovering from an inappropriate configuration file'
     +/
     +/'Installing an incompatible configuration file can ruin your'
     +/'graph so, before reading in a configuration file, consider'
     +/'saving a satisfactory configuration, in case you need to undo.')
  300 FORMAT (
     +'%file line   width symbol    size colour'
     +/I5,I5,F8.3,I7,F8.3,I7)
  400 FORMAT (
     +'%arrow/line/box size  ...',6X,'coordinates',7X,'... colour'
     +/I5,I5,5F8.3,I7)
  500 FORMAT (
     +'%text font    angle    size       x       y colour'
     +/2I5,F9.3,3F8.3,I7/A/A/A/A)
  600 FORMAT ('%key'/I4/A/A)
  700 FORMAT (
     +'%object type  size   width  coordinates  colour'
     +/I5,I5,4F8.3,I5)
  800 FORMAT (
     +'%error-bars: file, cap, lower, upper (0=.false., 1=.true.)'
     +/4I5)
  900 FORMAT ('Error in configuration file at line number',1X,A)
      END
C
C
      SUBROUTINE ADDDAT$(IFILL, IHUE, NFILES, NOUT, NXTRA,
     +                   FACTOR,  
     +                   FILES,
     +                   DENDRO_GRAM, PLOT_LABELS, VECTOR_FIELD)
C
C ACTION: add data to a configuration file to make a metafile
C AUTHOR: w.g.bardsley, university of manchester, u.k., 15/05/2013
C 
C This subroutines adds the plotting file data to the configuration 
C data to create metafile i.e. metafile = (configuration + coordinate files)
C     
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: NFILES, NOUT, NXTRA
      INTEGER,             INTENT (IN) :: IFILL(NXTRA), IHUE(NXTRA) 
      DOUBLE PRECISION,    INTENT (IN) :: FACTOR(NXTRA) 
      CHARACTER (LEN = *), INTENT (IN) :: FILES(NFILES)
      LOGICAL,             INTENT (IN) :: DENDRO_GRAM, PLOT_LABELS,
     +                                    VECTOR_FIELD
C
C locals
C      
      INTEGER    I, IOS, J, K, L, NIN, NROWS 
      INTEGER    N3
      PARAMETER (N3 = 3)
      DOUBLE PRECISION X(9)
      CHARACTER (LEN = 256) LINE
      CHARACTER (LEN = 80 ) TITLE
      CHARACTER (LEN = 22 ) DTITLE, LTITLE
      PARAMETER (DTITLE = '%simfitdendrogramfile%',
     +           LTITLE = '%simfitplotlabelsfile%')  
      CHARACTER (LEN = 30 ) HEADER
      PARAMETER (HEADER = '%simplot metafile data number ')
      CHARACTER (LEN = 31) TOP
      PARAMETER (TOP = '%start of simplot metafile data')
      CHARACTER (LEN = 29 ) BOT
      PARAMETER (BOT = '%end of simplot metafile data') 
      EXTERNAL   GETNOU
      INTRINSIC  TRIM
      NIN = 0
C
C Write the header
C      
      WRITE (NOUT,'(A)',IOSTAT=IOS) TOP
      IF (IOS.NE.0) RETURN
      WRITE (NOUT,'(A,I4)',IOSTAT=IOS) '%number of data sets', NFILES
      IF (IOS.NE.0) RETURN
C
C Loop over the current files
C        
      DO I = 1, NFILES
         CALL GETNOU (NIN)
         OPEN (UNIT = NIN, FILE = FILES(I), IOSTAT = IOS)
         IF (IOS.NE.0) GOTO 20
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20    
         IF (DENDRO_GRAM .AND. I.EQ.1) THEN  
            WRITE (NOUT,'(A)',IOSTAT = IOS) DTITLE
         ELSEIF (PLOT_LABELS .AND. I.EQ.1) THEN
            WRITE (NOUT,'(A)',IOSTAT=IOS) LTITLE   
         ELSE     
            TITLE = HEADER!to silence nagfor
            WRITE (NOUT,'(A,I3)',IOSTAT = IOS) TITLE(1:30), I 
         ENDIF 
         IF (IOS.NE.0) GOTO 20    
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NROWS, K
         IF (IOS.NE.0) GOTO 20    
         WRITE (NOUT,'(2I6)',IOSTAT=IOS) NROWS, K
         IF (IOS.NE.0) GOTO 20
         IF (VECTOR_FIELD .AND. I.EQ.1 .AND. K.EQ.9) THEN
            DO J = 1, NROWS
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) (X(L), L = 1, 9)
               IF (IOS.NE.0) GOTO 20
               WRITE (NOUT,100,IOSTAT=IOS) (X(L), L = 1, 6),
     +                                      IFILL(J), FACTOR(J), IHUE(J) 
            ENDDO   
         ELSE    
            DO J = 1, NROWS     
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
               IF (IOS.NE.0) GOTO 20
               WRITE (NOUT,'(A)',IOSTAT=IOS) TRIM(LINE)
               IF (IOS.NE.0) GOTO 20
           ENDDO
        ENDIF  
        IF (VECTOR_FIELD .AND. I.EQ.1 .AND. K.EQ.4) THEN
           WRITE (NOUT,'(I4)',IOSTAT=IOS) N3
           IF (IOS.NE.0) GOTO 20
           WRITE (NOUT,'(A)',IOSTAT=IOS) 'begin{vfield}'
           IF (IOS.NE.0) GOTO 20
           DO J = 1, NROWS   
              WRITE (NOUT,200,IOSTAT=IOS) IFILL(J), FACTOR(J), IHUE(J)
              IF (IOS.NE.0) GOTO 20
           ENDDO     
           WRITE (NOUT,'(A)',IOSTAT=IOS) 'end{vfield}'
           IF (IOS.NE.0) GOTO 20
        ENDIF    
        CLOSE (UNIT = NIN)
      ENDDO  
      WRITE (NOUT,'(A)',IOSTAT=IOS) BOT 
      RETURN
C
C Here if failure to read files
C      
   20 CONTINUE
      CLOSE (UNIT = NIN)  
  100 FORMAT (1P,6E13.5,I4,E13.5,I4) 
  200 FORMAT (I4,1P,E13.5,I4)           
      END           
C
C
               
           
       
      
            