
c      
c
c*********************************************************************
c Code developed for Simfit from the obsolete NAG J06 graphics library
c*********************************************************************
c
c 29/04/2018 introduced epsi in contr1$ to check for a closed contour
c
c Simfit code as follows:
c module_j06sav ... replaces common blocks in the original j06 code
c                   also defines x02ajf_j06 and x02akf_j06 
c contr1$ ... replaces n, x, y, by nsav, xsav, ysav
c j06cfg ... configure j06
c
c Modified j06 code as follows:
c j06ccf ... calls J06CDY 
c j06cdy ... calls J06CDW, J06CDZ, J06YAF, J06YCF 
c j06yaf ... these routines do not do what the NAG ones do
c j06ycf ... J06YCF calls J06YAF to build up a polyline
c            xsav(nsav), ysav(nsav) stored in the module  
c j06cdw ... calls j06yaf, j06ycf
c j06cdz ... 
C j06cdx ... 
c the common blocks removed and transferred to module_j06sav are:
c           /AJ06CD/XA, XB, XC, X1, X2, YA, YB, YC, Y1, Y2,
c     *             GXA, GXB, GXC, GX1, GX2, GYA, GYB, GYC, GY1,
c     *             GY2, TP, TQ
c           /BJ06CD/METH, MA, MB, MC, M1, NPT
c           /CJ06CD/T1, T2, GAP, ICODE1, ICODE2, KK
c
c---------------------------------------------------------------------
c start of module to store NAG j06 chapter plot controlling parameters
c---------------------------------------------------------------------
c
      module module_j06sav
      implicit none
c
c 09/06/2016 w.g.b. made meth = 0 the default instead of meth = 2 and
c            added rtol to j06cdw to prevent division by zero
c      
c
c The important parameters are:
c
c   nmax: limits the largest possible polyline
c   nsav: must be initialised to 0 then increments to fill in the smoothed polyline 
c   meth: meth = 0 ... no smoothing
c         meth = 1 ... Butland method      (open curve, -1 for closed)
c         meth = 2 ... McConalogues method (open curve, -2 for closed)
c itolf:  smoothing factor ... default 2000
c
      integer    ierror 
      integer    icode1, icode2, kk, meth, npt
      integer    ma, mb, mc, m1
      integer    itolf, margn, ngmarg, nsav
      INTEGER    NGPEN(4,3), NGTOLF, NGCQU, NGCQOH
      integer    nmax
      parameter (nmax = 6000)
      
      DOUBLE PRECISION  X02AJF_J06, X02AKF_J06
      PARAMETER (X02AJF_J06 = 1.111307226798D-016,
     +           X02AKF_J06 = 2.574667400493D-308)
     
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      double precision xmax, xmin, ymax, ymin
      double precision xsav(nmax), ysav(nmax)
      double precision t1, t2
      DOUBLE PRECISION GX1, GX2, GXA, GXB, GXC, GY1, GY2, GYA, GYB,
     +                 GYC, TP, TQ, X1, X2, XA, XB, XC, Y1, Y2,
     +                 YA, YB, YC
      DOUBLE PRECISION GA, GB, GC, SENSE
      DOUBLE PRECISION ZGXMIN, ZGXMAX, ZGYMIN, ZGYMAX, ZGSCW, ZGCSCH,
     +                 ZGAMSC, ZGCSCW  
      
      logical gap
      logical intflg(2)

      save ngpen, ngtolf, ngcqu, ngcqoh, ngmarg
      save intflg
      save ierror
      save icode1, icode2, kk, meth
      save ma, mb, mc, m1
      save itolf, margn, nsav
      save xmax, xmin, ymax, ymin
      save xsav, ysav
      save t1, t2
      SAVE GX1, GX2, GXA, GXB, GXC, GY1, GY2, GYA, GYB,
     +     GYC, TP, TQ, X1, X2, XA, XB, XC, Y1, Y2,
     +     YA, YB, YC
      SAVE GA, GB, GC, SENSE
      save ZGXMIN, ZGXMAX, ZGYMIN, ZGYMAX, ZGCSCW, ZGCSCH,
     +     ZGAMSC 
      save gap

      data ngtolf, ngcqu, ngcqoh, ngmarg /0, 0, 0, 0 /
      data intflg / .true., .true. / 
      data ierror / 0 /
      data icode1, icode2, kk, meth, npt / 0, 0, 0, 0, 0 /
      data ma, mb, mc, m1 / 0, 0, 0, 0 /
      data itolf, margn, nsav / 2000, 0, 0 /
      data xmax, xmin, ymax, ymin / one, zero, one, zero /    
      data xsav, ysav / nmax*one, nmax*one / 
      data t1, t2 / one, one /
      data ga, gb, sense / zero, zero, zero / 
      data ZGXMIN, ZGXMAX, ZGYMIN, ZGYMAX, ZGCSCW, ZGCSCH,
     +     ZGAMSC / 7*zero / 
      data gap / .false. /
      end module module_j06sav
c
c---------------------------------------------------------------------
c end of module to store j06 parameters
c---------------------------------------------------------------------
c

c 
c---------------------------------------------------------------------------
c        
      subroutine contr1$ (n, nmax1,
     +                    x, y)
c
c action: input a polyline length n then a return it smoothed of length nsav
c author: w.g.bardsley, university of manchester, u.k., 14/10/2013
c     
     
      use module_j06sav, only : meth, nsav,
     +                          xmax, xmin, ymax, ymin, 
     +                          xsav, ysav
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: nmax1
      integer,          intent (inout) :: n
      double precision, intent (inout) :: x(nmax1), y(nmax1)
c
c locals
c      
      integer    i, ifail, mtemp
      double precision epsi
      parameter (epsi = 1.0d-06)
      external   j06ccf
      if (n.lt.2 .or. meth.eq.0) return
c
c initialise nsav to start a new smoothed polyline 
c        
      nsav = 0  
c
c calculate the range
c      
      xmax = x(1)
      xmin = x(1)
      ymax = y(1)
      ymin = y(1)
      do i = 2, n
         if (x(i).gt.xmax) xmax = x(i)
         if (x(i).lt.xmin) xmin = x(i)    
         if (y(i).gt.ymax) ymax = y(i)
         if (y(i).lt.ymin) ymin = y(i) 
      enddo
c
c call j06ccf to calculate nsav, xsav, ysav
c      
      if (abs(x(1) - x(n))/(abs(xmax - xmin) + epsi).le.epsi .and.
     +    abs(y(1) - y(n))/(abs(ymax - ymin) + epsi).le.epsi) then  
         mtemp = - meth  
         call j06ccf (x, y, n, mtemp, ifail)
      else   
         call j06ccf (x, y, n, meth, ifail)
      endif   
      if (ifail.ne.0) return
c
c overwrite the original n, x, y by nsav, xsav, ysav
c        
      n = min(nmax1,nsav)
      do i = 1, n
         x(i) = xsav(i)
         y(i) = ysav(i)
      enddo   
      end       
c
c
c-----------------------------------------------------------------
c
      subroutine j06cfg (isend, itolf_1, meth_1)
c
c action : configure j06
c author: w.g.bardsley, university of manchester, u.k., 14/10/2013
c      
      use module_j06sav, only : itolf, meth
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend
      integer, intent (inout) :: itolf_1, meth_1
c
c locals
c      
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 6, numsta = 6)
      integer    numbld(30)
      integer    itolf_max, itolf_min
      parameter (itolf_max = 5000, itolf_min = 100)
      character (len = 100) text(30)
      character (len = 30 ) cipher 
      logical    repeet
      external   lstbox, getjm1, patch2
      data       numbld / 30*0 /
      if (isend.eq.1) then
c
c set the defaults directly
c        
         if (itolf_1.ge.itolf_min .and.
     +       itolf_1.le.itolf_max) then
            itolf = itolf_1
         else
            itolf = 2000
         endif          
         if (meth_1.ge.0 .and. meth_1.le.2) then
            meth = meth_1
         else
            meth = 0
         endif
         return
      endif               
c
c check current parameters
c      
      if (itolf.lt.itolf_min .or. itolf.gt.itolf_max) itolf = 2000
      if (meth.lt.-2 .or. meth.gt.2) meth = 0
c
c make temporary changes
c        
      repeet = .true.
      do while (repeet)
         if (meth.eq.0) then 
            cipher = 'No smoothing'
         elseif (meth.eq.1) then
            cipher = 'Butland smoothing'
         else
            cipher = 'McConalogue smoothing'
         endif          
         write (text,100) cipher, itolf
         numdec = numopt
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0         
         if (numdec.eq.1) then
            meth = 0
         elseif (numdec.eq.2) then
            meth = 1
         elseif (numdec.eq.3) then
            meth = 2
         elseif (numdec.eq.4) then
            call getjm1 (itolf_min, itolf, itolf_max, 'ITOLF required')
         elseif (numdec.eq.5) then  
            write (text,200)
            numbld(1) = 1
            numbld(11) = 1
            numbld(14) = 1          
            numbld(17) = 1          
            numbld(20) = 1 
            numtxt = 21
            call patch2 (numbld, numtxt,
     +                   text)           
            numbld(1) = 0
            numbld(11) = 0
            numbld(14) = 0          
            numbld(17) = 0          
            numbld(19) = 0      
         else
            repeet = .false.
         endif       
      enddo
c
c return the new values
c      
      itolf_1 = itolf
      meth_1 = meth      
c
c format statements
c  
  100 format (
     + 'Parameteric smoothing parameters'
     +/
     +/'Current Method:',1x,a
     +/'Current ITOLF:', i6
     +/
     +/'No smoothing'
     +/'Butland method'
     +/'McConalogue method'
     +/'Change ITOLF'
     +/'Help'
     +/'Apply')
  200 format (
     + 'The smoothing options'
     +/
     +/'The default options should suffice for most applications where'
     +/'polylines are to be replaced by smooth parametric curves, which'
     +/'could be closed. Sometimes, for instance with very complicated'
     +/'contour diagrams, it may be useful to make temporary changes to'
     +/'the default parameters in order see what is really going on.'
     +/'This is most likely to be required when contour diagrams have'
     +/'been drawn using insufficient grid points, say < 10.'
     +/
     +/'No smoothing'
     +/'The contour will consist of joined line segments.'
     +/ 
     +/'The Butland method'
     +/'This fits closely but may underestimate contour bending.'
     +/
     +/'The McConalogue method (The default)'
     +/'This fits loosely but may overestimate contour bending.'
     +/
     +/'ITOLF (Default = 2000)'
     +/'Reduce for a rougher curve, or increase for a smoother curve.')
      end  
      

c
c-----------------------------------------------------------------
c
      subroutine j06cfg_1 (isend, itolf_1, meth_1)
c
c action : configure j06
c author: w.g.bardsley, university of manchester, u.k. 02/06/2018  
c      
      use module_j06sav, only : itolf, meth, ngtolf
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend
      integer, intent (inout) :: itolf_1, meth_1
c
c locals
c      
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 6, numsta = 6)
      integer    numbld(30)
      integer    itolf_max, itolf_min
      parameter (itolf_max = 5000, itolf_min = 100)
      character (len = 100) text(30)
      character (len = 30 ) cipher 
      logical    repeet
      external   lstbox, getjm1, patch2
      data       numbld / 30*0 /
      if (isend.eq.1) then
c
c set the defaults directly
c        
         if (itolf_1.ge.itolf_min .and.
     +       itolf_1.le.itolf_max) then
            itolf = itolf_1
         else
            itolf = 2000
         endif          
         ngtolf = itolf
         if (meth_1.ge.0 .and. meth_1.le.2) then
            meth = meth_1
         else
            meth = 0
         endif
         return
      endif         
c
c check current parameters
c      
      if (itolf.lt.itolf_min .or. itolf.gt.itolf_max) itolf = 2000
      ngtolf = itolf  
      if (meth.lt.-2 .or. meth.gt.2) meth = 0
c
c make temporary changes
c        
      repeet = .true.
      do while (repeet)
         if (meth.eq.0) then 
            cipher = 'No smoothing'
         elseif (meth.eq.1) then
            cipher = 'Piecewise monotonic smoothing'
         else
            cipher = 'Cubic Bessel smoothing'
         endif          
         write (text,100) cipher, itolf
         numdec = numopt
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0         
         if (numdec.eq.1) then
            meth = 0
         elseif (numdec.eq.2) then
            meth = 1
         elseif (numdec.eq.3) then
            meth = 2
         elseif (numdec.eq.4) then
            call getjm1 (itolf_min, itolf, itolf_max, 'ITOLF required')
            ngtolf = itolf
         elseif (numdec.eq.5) then  
            write (text,200)
            numbld(1) = 1
            numbld(11) = 1
            numbld(14) = 1          
            numbld(17) = 1          
            numbld(20) = 1 
            numtxt = 21
            call patch2 (numbld, numtxt,
     +                   text)           
            numbld(1) = 0
            numbld(11) = 0
            numbld(14) = 0          
            numbld(17) = 0          
            numbld(19) = 0      
         else
            repeet = .false.
         endif       
      enddo
c
c return the new values
c      
      itolf_1 = itolf
      meth_1 = meth
c
c format statements
c  
  100 format (
     + 'Smooth interpolation parameters'
     +/
     +/'Current Method:',1x,a
     +/'Current ITOLF:', i6
     +/
     +/'No smoothing'
     +/'Piecewise monotonic method'
     +/'Cubic Bessel method'
     +/'Change ITOLF'
     +/'Help'
     +/'Apply')
  200 format (
     + 'The smoothing options'
     +/
     +/'The default options should suffice for most applications where'
     +/'polylines are to be replaced by smooth continuous curves, which'
     +/'are single valued. Sometimes, for instance with very sharp and'
     +/'narrow peaks, it may be useful to make temporary changes to'
     +/'the default parameters in order see what is really going on.'
     +/'This is most likely to be required when model equations have'
     +/'been drawn using insufficient points, say < 100.'
     +/
     +/'No smoothing'
     +/'The curve will consist of joined line segments.'
     +/ 
     +/'The Piecwise momotonic method'
     +/'This fits closely but may underestimate local curvature.'
     +/
     +/'The Cubic Bessel method (The default)'
     +/'This fits loosely and may overestimate local curvature.'
     +/
     +/'ITOLF (Default = 2000)'
     +/'Reduce for a rougher curve, or increase for a smoother curve.')
      end  
c
c*******************************************************************************      
c
c simfit version of j06ccf
c
      SUBROUTINE J06CCF(AX,AY,N,METHOD,IFAIL)
      use module_j06sav, only : itolf, 
     +                          xmax, xmin, ymax, ymin,
     +                          gap    
      implicit none
C
C     DRAWS A MULTIVALUED CURVE THROUGH THE DATA POINTS (AX(I),
C     AY(I)),I=1,N.  THE CURVE MAY BE OPEN (METHOD.GT.0) OR
C     CLOSED (METHOD.LT.0).  THE TECHNIQUE USED IS TO CONSTRUCT
C     A PARAMETRIC PIECEWISE CUBIC (X(T),Y(T)) PASSING THROUGH
C     THE DATA POINTS.  THIS PARAMETRIC CUBIC IS APPROXIMATED BY
C     STRAIGHT LINE SEGMENTS WHICH ARE THEN PASSED TO THE PLOTTING
C     SOFTWARE.  THE USER HAS A CHOICE OF TWO METHODS FOR DEFINING
C     THE PARAMETRIC CUBIC - SEE METHOD BELOW.
C
C     ROUTINE CREATED - SEPTEMBER 1979
C     AUTHOR - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C         AX,AY - ON ENTRY, AX(I),AY(I) HOLD THE COORDINATES OF THE
C                 ITH DATA POINT.
C
C         N - ON ENTRY, N SPECIFIES NUMBER OF DATA POINTS.
C
C         METHOD - ON ENTRY, METHOD SPECIFIES METHOD USED TO DEFINE
C                  PARAMETRIC CUBIC, AND WHETHER CURVE IS OPEN OR
C                  CLOSED -
C                  METHOD= 1  -  OPEN CURVE, BUTLAND METHOD
C                  METHOD= 2  -  OPEN CURVE MCCONALOGUE METHOD
C                  METHOD=-1  -  CLOSED CURVE, BUTLAND METHOD
C                  METHOD=-2  -  CLOSED CURVE, MCCONALOGUE METHOD
C
C         IFAIL - NAG ERROR PARAMETER
C
C     NOTES -
C
C         IF TWO SUCCESSIVE POINTS ARE EQUAL, THE SECOND POINT
C         IS IGNORED.
C
C     .. Scalar Arguments ..
      INTEGER, INTENT (INOUT) :: IFAIL
      INTEGER, INTENT (IN)    :: METHOD, N
C     .. Array Arguments ..
      DOUBLE PRECISION, INTENT (IN) :: AX(N), AY(N)
C     .. Local Scalars ..
      DOUBLE PRECISION  DELTAX, DELTAY, DUM, TOL
      INTEGER           I, ICODE, IERROR
C     .. External Subroutines ..
      EXTERNAL          J06CDY
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, DBLE
C     .. Executable Statements ..
C
C     Validate input parameters
C
      IERROR = 0
      IFAIL = 0
      IF (N.LT.2) THEN
         IFAIL = 1
         RETURN
      ELSE IF (ABS(METHOD).NE.1 .AND. ABS(METHOD).NE.2) THEN
         IFAIL = 2
         RETURN
      END IF
C
      IF (IERROR.EQ.0) THEN
C
C        COMPUTATION
C        -----------
C
C        SET ERROR TOLERANCES (DELTAX,DELTAY) AND GAP IN COORDS
C        CONSIDERED INSIGNIFICANT (TOL)
C
         DELTAX = ABS(XMAX-XMIN)/DBLE(ITOLF)
         DELTAY = ABS(YMAX-YMIN)/DBLE(ITOLF)
         TOL = 0.0D0
C
C        SET GAP TO .FALSE. TO ENSURE NO GAP LEFT
C
         GAP = .FALSE.
C
C        DRAW CURVE ONE POINT AT A TIME
C
         ICODE = METHOD
         DO 20 I = 1, N
            IF (I.EQ.N) ICODE = 9
            CALL J06CDY(AX(I),AY(I),ICODE,DUM,DUM,TOL,TOL,DELTAX,DELTAY)
            ICODE = 0
   20    CONTINUE
C
      END IF
      RETURN
      END
C
C*************************************************************************************
C
c simfit version of j06cdy

      SUBROUTINE J06CDY(X,Y,ICODE,GX,GY,TOLX,TOLY,DELTAX,DELTAY)
      use module_j06sav, only : icode1, icode2, kk, meth, npt,
     +                          gap,
     +                          XA, XB, XC, X1, X2, YA, YB, YC, Y1, Y2,
     +                          GXA, GXB, GXC, GX1, GX2, GYA, GYB, GYC,
     +                          GY1, GY2
      implicit none
C
C     DRAWS A MULTIVALUED CURVE THROUGH A SET OF DATA POINTS, THE
C     ROUTINE BEING CALLED ONCE FOR EACH DATA POINT (X,Y).  THE
C     TECHNIQUE USED IS TO CONSTRUCT A PARAMETRIC PIECEWISE CUBIC
C     (X(T),Y(T)) PASSING THROUGH THE DATA POINTS.  THE USER HAS
C     A CHOICE OF TWO DIFFERENT METHODS FOR ESTIMATING THE SLOPE
C     (DX/DT,DY/DT) AT (X,Y), OR HE CAN SUPPLY THE SLOPE EXPLICITLY.
C     THE CURVE CAN BE OPEN OR CLOSED.  THE PARAMETER ICODE SPECIFIES
C     INFORMATION ABOUT (X,Y) TO THE ROUTINE - SEE BELOW FOR DETAILS.
C
C     THE ROUTINE J06CDZ IS CALLED TO ESTIMATE THE SLOPE AT A DATA
C     POINT, AND THUS TO PROGRESSIVELY DEFINE A PARAMETRIC PIECEWISE
C     CUBIC INTERPOLANT.  THE ROUTINE J06CDW IS CALLED TO DRAW THE
C     PARAMETRIC CUBIC IN ANY PARTICULAR INTERVAL BETWEEN DATA POINTS.
C
C     ROUTINE CREATED - SEPTEMBER 1979
C     LATEST UPDATE   -
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C         X,Y - ON ENTRY, X,Y SPECIFY THE COORDS OF THE NEXT DATA POINT.
C
C         ICODE - ON ENTRY, ICODE SPECIFIES INFORMATION CONCERNING THE
C                 POINT (X,Y).
C                 IF (X,Y) IS THE FIRST PT, ICODE SPECIFIES THE METHOD
C                 OF CURVE DRAWING TO BE USED, WHETHER THE SLOPE AT THE
C                 FIRST POINT IS TO BE ESTIMATED OR SUPPLIED EXPLICITLY
C                 BY THE USER, AND WHETHER THE CURVE IS OPEN OR CLOSED.
C                 THE VALUES OF ICODE AND THEIR MEANINGS ARE-
C                 ICODE=1    BUTLAND METHOD, SLOPE TO BE ESTIMATED.
C                 ICODE=2    MCCONALOGUE METHOD, SLOPE TO BE ESTIMATED.
C                 ICODE=11   BUTLAND METHOD, SLOPE GIVEN EXPLICITLY.
C                 ICODE=12   MCCONALOGUE METHOD, SLOPE GIVEN EXPLICITLY.
C                 THE ABOVE VALUES IMPLY AN OPEN CURVE - FOR A CLOSED
C                 CURVE THE SIGN OF ICODE SHOULD BE REVERSED.
C
C                 IF (X,Y) IS AN INTERMEDIATE POINT, ICODE SHOULD BE SET
C                 0 (IF SLOPE IS TO BE ESTIMATED) OR 10 (IF SLOPE IS TO
C                 BE GIVEN EXPLICITLY).
C
C                 IF (X,Y) IS THE LAST POINT, ICODE SHOULD BE SET TO 9
C                 (IF SLOPE IS TO BE ESTIMATED) OR 19 (IF SLOPE IS TO
C                 BE GIVEN EXPLICITLY).
C
C         GX,GY - ON ENTRY, IF ABS(ICODE).GE.10,  GX,GY SHOULD CONTAIN
C                 USER-SUPPLIED VALUES OF DX/DT, DY/DT RESPECTIVELY.
C
C         TOLX,TOLY - ON ENTRY, TOLX,TOLY SPECIFY THE DIFFERENCE IN
C                     X- AND Y-COORDINATES REGARDED AS INSIGNIFICANT.
C                     IF THE X- AND Y-COORDS DIFFER BY LESS THAN
C                     TOLX AND TOLY RESPECTIVELY FROM THOSE OF THE
C                     PREVIOUS POINT, THEN (X,Y) IS IGNORED.
C
C         DELTAX,DELTAY - ON ENTRY, DELTAX,DELTAY SPECIFY THE ACCURACY
C                         OF THE STRAIGHT LINE APPROXIMATION TO
C                         THE PARAMETRIC CUBIC.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  DELTAX, DELTAY, GX, GY, TOLX, TOLY, X, Y
      INTEGER           ICODE
C     .. External Subroutines ..
      EXTERNAL          J06CDW, J06CDZ, J06YAF, J06YCF
C     .. Intrinsic Functions ..
      INTRINSIC         ABS
C     .. Executable Statements ..
C
C     DECIPHER ICODE
C
      ICODE1 = ABS(ICODE)/10
      ICODE2 = ABS(ICODE) - 10*ICODE1
      IF (ICODE.LT.0) ICODE2 = -ICODE2
C
C     INTERPOLATION
C     -------------
C
      CALL J06CDZ(X,Y,GX,GY,TOLX,TOLY)
C
C     GRAPHICAL OUTPUT
C     ----------------
C
C     IF POINT IS FIRST POINT ON CURVE, NO PLOTTING NEEDED
C
      IF (NPT.EQ.1) GO TO 100
C
C     IF POINT IS SECOND POINT, NO PLOTTING NEEDED UNLESS IT
C     IS ALSO LAST POINT, IN WHICH CASE A STRAIGHT LINE IS DRAWN
C
      IF (NPT.GT.2) GO TO 20
      IF (ICODE2.NE.9) GO TO 100
      CALL J06YAF(XB,YB)
      CALL J06YCF(XC,YC)
      GO TO 100
   20 CONTINUE
C
C     THE LAST POINT OF A CLOSED CURVE IS A SPECIAL CASE.
C     FOUR CURVE PIECES HAVE TO BE DRAWN - BETWEEN THE THIRD LAST
C     AND SECOND LAST POINTS, SECOND LAST AND LAST, LAST AND
C     FIRST AND FIRST AND SECOND.  THE FIRST TWO OF THESE
C     PIECES ARE DRAWN HERE.
C
C     NOTE THAT THE FIRST PIECE IS NOT DRAWN IF THE POINTS
C     ARE IDENTICAL, OR IF THE PIECE HAS ALREADY BEEN DRAWN (KK=1)
C
      IF (METH.GT.0 .OR. ICODE2.NE.9) GO TO 60
      IF (ABS(X1-X2).LE.TOLX .AND. ABS(Y1-Y2).LE.TOLY) GO TO 40
      IF (KK.EQ.1) GO TO 40
      CALL J06CDW(X1,Y1,X2,Y2,METH,GX1,GY1,GX2,GY2,DELTAX,DELTAY)
   40 CONTINUE
      KK = 0
      IF ( .NOT. GAP) CALL J06CDW(X2,Y2,XA,YA,METH,GX2,GY2,GXA,GYA,
     *                            DELTAX,DELTAY)
      GAP = .FALSE.
   60 CONTINUE
C
C     FOR THIRD AND SUBSEQUENT POINTS, CURVE IS DRAWN IN PREVIOUS
C     INTERVAL. (EXCEPTION IS THIRD POINT OF A CLOSED CURVE,
C     IN WHICH CASE DRAWING IN FIRST INTERVAL IS DELAYED UNTIL
C     CURVE COMPLETED)
C
C     AGAIN NOTE THAT NO DRAWING IS DONE IF PIECE HAS ALREADY
C     BEEN DRAWN (KK=1) OR IF A GAP IS EXPLICITLY REQUIRED
C     (GAP=.TRUE.)
C
      IF (NPT.EQ.3 .AND. METH.LT.0 .AND. ICODE2.NE.9) GO TO 80
      IF ( .NOT. GAP .AND. KK.NE.1) CALL J06CDW(XA,YA,XB,YB,METH,GXA,
     *    GYA,GXB,GYB,DELTAX,DELTAY)
   80 CONTINUE
C
C     IF POINT IS LAST POINT ON CURVE, THE DRAWING IS COMPLETED.
C
      IF (ICODE2.NE.9) GO TO 100
      CALL J06CDW(XB,YB,XC,YC,METH,GXB,GYB,GXC,GYC,DELTAX,DELTAY)
  100 CONTINUE
      RETURN
      END
c      
c********************************************************************************      
c
c simfit version of j06yaf

      subroutine j06yaf (x, y)
c      
c action: start a polyline or add to an existing one
c author: w.g.bardsley, university of manchester, u.k., 14/10/2013
c      
      use module_j06sav, only : nmax, nsav, xsav, ysav
      implicit none
      double precision, intent (in) :: x, y
      if (nsav.lt.nmax) then
         nsav = nsav + 1
         xsav(nsav) = x
         ysav(nsav) = y
      endif
      end
c
c********************************************************************************
c
c simfit version of j06ycf

      subroutine j06ycf (x,y) 
c
c action: add to a polyline
c author: w.g.bardsley, university of manchester, u.k., 14/10/2013
c      
      implicit none
      double precision, intent (in) :: x, y
      external j06yaf
      call j06yaf (x, y)
      end
c
c*************************************************************************
c
c simfit version of j06cdw     

      SUBROUTINE J06CDW(XA,YA,XB,YB,METH,GXA,GYA,GXB,GYB,DELTAX,DELTAY)
      use module_j06sav, only : x02akf_j06
      implicit none
c
c 09/06/2016 w.g.b introduced rtol to prevent division by zero
c      

C     DRAWS A PARAMETRIC CUBIC IN THE INTERVAL BETWEEN (XA,YA) AND
C     (XB,YB), GIVEN THE SLOPES (IE DX/DT, DY/DT) AT THE TWO POINTS
C     AS (GXA,GYA) AND (GXB,GYB).  THE BUTLAND PARAMETRIC METHOD
C     (METH=1) AND THE MCCONALOGUE METHOD (METH=2) ARE AVAILABLE.
C
C     ROUTINE CREATED - SEPTEMBER 1979
C     LATEST UPDATE   - MARCH 1980
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C         XA,XB,YA,YB - ON ENTRY, SPECIFY COORDS OF END-POINTS OF
C                       INTERVAL
C
C         METH - ON ENTRY METH SPECIFIES METHOD TO BE USED-
C                METH = 1  -  BUTLAND METHOD
C                METH = 2  -  MCCONALOGUE METHOD
C
C         GXA,GYA,GXB,GYB - ON ENTRY SPECIFY SLOPES AT END-POINTS.
C
C         DELTAX,DELTAY - ON ENTRY SPECIFY ACCURACY OF STRAIGHT LINE
C                         APPROXIMATION TO CURVE IN X- AND Y-DIRECTIONS.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  DELTAX, DELTAY, GXA, GXB, GYA, GYB, XA, XB, YA,
     *                  YB
      INTEGER           METH
C     .. Local Scalars ..
      DOUBLE PRECISION  C, CA, CB, DX, DXT, DY, DYT, R, R1, SA, SB,
     *                  SDERX, SDERY, SX3, SX4, SY3, SY4, T, TINC, TSQ,
     *                  TSTEP, U, UX, UY, X, Y, ZA, ZB
      INTEGER           J, M, MM1
      double precision  rtol
      parameter (rtol = 1.0d+09*x02akf_j06)
C     .. External Subroutines ..
      EXTERNAL          J06YAF, J06YCF
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, DBLE, INT, MAX, SQRT
C     .. Executable Statements ..
C
      DX = XB - XA
      DY = YB - YA
      IF (ABS(METH).EQ.2) GO TO 20
C
C     BUTLAND PARAMETRIC METHOD
C     PARAMETER LENGTH T SET TO 1.0.  DERIVATIVES LEFT UNNORMALIZED.
C
      T = 1.0D0
      CA = GXA
      SA = GYA
      CB = GXB
      SB = GYB
      GO TO 40
C
C     CUBIC BESSEL PARAMETRIC METHOD (MCCONALOGUES METHOD)
C     NORMALIZE DERIVATIVES AND CALCULATE PARAMETER LENGTH T
C     WHICH APPROXIMATES ARC LENGTH BETWEEN POINTS.
C
   20 CONTINUE
      ZA = 1.0D0/SQRT(GXA*GXA+GYA*GYA)
      ZB = 1.0D0/SQRT(GXB*GXB+GYB*GYB)
      CA = GXA*ZA
      SA = GYA*ZA
      CB = GXB*ZB
      SB = GYB*ZB
      R = DX*(CA+CB) + DY*(SA+SB)
      C = DX*DX + DY*DY
      R1 = SQRT(R*R-2.0D0*C*(CA*CB+SA*SB-7.0D0))
      T = 6.0D0*C/(R+R1)
      T = MAX(T,SQRT(100.0D0*X02AKF_J06))
C
C     CALCULATE PARAMETRIC CUBICS
C
   40 CONTINUE
      TSQ = T*T
      DXT = DX/T
      DYT = DY/T
      SX3 = 2.0D0*(3.0D0*DXT-2.0D0*CA-CB)/T
      SX4 = 6.0D0*(CA+CB-2.0D0*DXT)/TSQ
      SY3 = 2.0D0*(3.0D0*DYT-2.0D0*SA-SB)/T
      SY4 = 6.0D0*(SA+SB-2.0D0*DYT)/TSQ
C
C     CALCULATE NUMBER OF STRAIGHT LINE PIECES NEEDED TO APPROXIMATE
C     PARAMETRIC CUBIC TO REQUIRED ACCURACY
C
      SDERX = SX3 + T*SX4
      UX = MAX(ABS(SX3),ABS(SDERX),rtol)
      SDERY = SY3 + T*SY4
      UY = MAX(ABS(SY3),ABS(SDERY),rtol)
      U = MAX(UX/(DELTAX + rtol),UY/(DELTAY + rtol))
      M = INT(SQRT((U*TSQ)/8.0D0)+1.0D0)
      TINC = T/DBLE(M)
C
C     PLOT PARAMETRIC CUBIC
C
      SX3 = SX3/2.0D0
      SX4 = SX4/6.0D0
      SY3 = SY3/2.0D0
      SY4 = SY4/6.0D0
      CALL J06YAF(XA,YA)
      MM1 = M - 1
      IF (MM1.EQ.0) GO TO 80
      DO 60 J = 1, MM1
         TSTEP = DBLE(J)*TINC
         X = XA + TSTEP*(CA+TSTEP*(SX3+TSTEP*SX4))
         Y = YA + TSTEP*(SA+TSTEP*(SY3+TSTEP*SY4))
         CALL J06YCF(X,Y)
   60 CONTINUE
   80 CONTINUE
      CALL J06YCF(XB,YB)
      RETURN
      END
C
C*************************************************************************
C  
c simfit version of j06cdz
          
      SUBROUTINE J06CDZ(X,Y,GX,GY,TOLX,TOLY)
      use module_j06sav, only : METH, MA, MB, MC, M1, NPT, 
     +                          T1, T2, ICODE1, ICODE2, KK, 
     +                          GX1, GX2, GXA, GXB, GXC, GY1, GY2, GYA,
     +                          GYB, GYC, TP, TQ, X1, X2, XA, XB, XC,
     +                          Y1, Y2, YA, YB, YC,
     +                          X02AKF_J06
      implicit none
 
C     Ensure that a new slope estimate is always made for the last
C     point, even when this point coincides with the last but one.
C
C     ESTIMATES SLOPE OF CURVE AT DATA POINT PREVIOUS TO (X,Y).
C     THE CALCULATION IS CARRIED OUT USING INFORMATION AT
C     (X,Y) - STORED AS (XC,YC) - AND AT TWO PREVIOUS POINTS -
C     STORED AS (XA,YA) AND (XB,YB).  THE SLOPE AT (XB,YB) IS
C     EXPRESSED AS A VECTOR (GXB,GYB) WHERE GXB=DX/DT AND
C     GYB=DY/DT.
C
C     TWO METHODS ARE AVAILABLE FOR ESTIMATING THE SLOPE AT (XB,YB).
C     THE BUTLAND METHOD (METH=1) AND THE MCCONALOGUE METHOD (METH=2),
C     THE ACTUAL SLOPE BEING CALCULATED BY J06CDX.
C
C     ALTERNATIVELY THE USER HIMSELF CAN SPECIFY THE SLOPE AT
C     (X,Y) IN THE VARIABLES GX,GY, THE VALUE OF ICODE1 IN /CJ06CD/
C     HAVING BEEN SET TO 1.  GX,GY ARE STORED FIRST IN GXC,GYC AND
C     USED ON THE NEXT CALL OF THE ROUTINE IN PLACE OF THE ESTIMATED
C     VALUES.
C
C     THE PARAMETER T IS CALCULATED DIFFERENTLY FOR THE TWO METHODS.
C     FOR THE BUTLAND METHOD, THE PARAMETER LENGTH BETWEEN SUCCESSIVE
C     POINTS IS 1.0. FOR THE MCCONALOGUE METHOD, IT IS TAKEN AS THE
C     CHORD LENGTH BETWEEN THE POINTS.
C
C     SPECIAL ACTION IS TAKEN AT THE END-POINTS.  CONSIDER FIRST THE
C     CASE OF AN OPEN CURVE.  IF (X1,Y1), (X2,Y2), (X3,Y3) ARE THE
C     FIRST THREE POINTS WITH ASSOCIATED PARAMETER VALUES T1,T2,T3,
C     AN EXTRA POINT (X0,Y0) WITH PARAMETER VALUE T0 IS CALCULATED.
C     T0 IS SUCH THAT
C            T1-T0=T3-T2
C     AND (X0,Y0) ARE THE VALUES AT T0 OF QUADRATICS PASSING THROUGH
C     (T1,X1), (T2,X2), (T3,X3) AND (T1,Y1), (T2,Y2), (T3,Y3)
C     RESPECTIVELY.  THIS ENABLES THE SLOPE AT (X1,Y1) TO BE
C     CALCULATED IN THE SAME WAY AS FOR INTERIOR POINTS.
C     A SIMILAR STRATEGY IS EMPLOYED AT THE OTHER END-POINT.
C
C     CONSIDER NEXT THE CASE OF A CLOSED CURVE.  THE SLOPE AT THE
C     FIRST POINT IS NOT ESTIMATED UNTIL THE LAST POINT IS KNOWN,
C     SO THAT A SMOOTH CLOSED CURVE CAN BE GENERATED.
C
C     IF TWO SUCCESSIVE POINTS DIFFER IN THEIR X-COORDS AND Y-COORDS
C     BY LESS THAN TOLX AND TOLY RESPECTIVELY, THE SECOND POINT
C     IS IGNORED.
C
C     ROUTINE CREATED - SEPTEMBER 1979
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C         X,Y - ON ENTRY, X,Y SPECIFY THE COORDS OF THE NEXT
C               DATA POINT.
C
C         GX,GY - ON ENTRY, GX,GY SPECIFY THE SLOPE (IE DX/DT,DY/DT)
C                 AT (X,Y) IF ICODE1=1.
C
C         TOLX,TOLY - ON ENTRY, TOLX,TOLY SPECIFIES THE DIFFERENCE IN
C                     X- ,Y- COORDS CONSIDERED AS INSIGNIFICANT.
C                     IF (X,Y) DIFFER BY LESS THAN TOLX,TOLY FROM
C                     THE PREVIOUS POINT, THEN (X,Y) IS IGNORED.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  GX, GY, TOLX, TOLY, X, Y
C     .. Scalars in Common ..
C      DOUBLE PRECISION  GX1, GX2, GXA, GXB, GXC, GY1, GY2, GYA, GYB,
C     *                  GYC, TP, TQ, X1, X2, XA, XB, XC, Y1, Y2,
C     *                  YA, YB, YC
C     .. Local Scalars ..
      DOUBLE PRECISION  GXNEW, GYNEW, SXBEG, SXEND, SXP, SXQ, SYBEG,
     *                  SYEND, SYP, SYQ, XNEW, XP, XQ, YNEW, YP, YQ
      INTEGER           K, MNEW
      LOGICAL           LDIFF
C     .. External Subroutines ..
      EXTERNAL          J06CDX
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, MAX, SQRT
C     .. Executable Statements ..
C
C     THE COORDS OF THE POINT ARE STORED IN XNEW,YNEW.
C     THE VALUE OF ICODE1 SPECIFIES WHETHER SLOPE INFORMATION
C     IS TO BE ESTIMATED (ICODE1=0) OR IS TO BE SUPPLIED BY
C     THE USER (ICODE1=1).  THE VALUE OF ICODE1 IS STORED, AND
C     IF APPROPRIATE THE USER-SUPPLIED SLOPE INFORMATION IS
C     ALSO STORED.  K IS USED AS A FLAG - K=1 NORMALLY, BUT IS SET
C     TO 2 AND 3 WHEN PROCESSING THE END-POINT OF A CLOSED CURVE.
C     KK IS SET TO 1 AND ALTERED TO 0 IF POINT IS DISTINCT FROM
C     ITS PREDECESSOR.
C
      XNEW = X
      YNEW = Y
      K = 1
      KK = 1
      MNEW = ICODE1
      IF (MNEW.EQ.0) GO TO 20
      GXNEW = GX
      GYNEW = GY
   20 CONTINUE
C
C     IF POINT IS FIRST POINT ON CURVE, ITS COORDS ARE STORED AND
C     THE POINT COUNTER IS SET TO 1.  THE VALUE OF ICODE2 SPECIFIES
C     THE SLOPE ESTIMATION TECHNIQUE AND WHETHER THE CURVE IS OPEN
C     OR CLOSED.  IF ABS(ICODE2)=1, THE BUTLAND METHOD IS USED.
C     IF ABS(ICODE2)=2, THE MCCONALOGUE METHOD IS USED.  IF ICODE2.GT.0,
C     THE CURVE IS OPEN. IF ICODE2.LT.0, THE CURVE IS CLOSED.  THE VALUE
C     OF ICODE2 IS STORED IN METH.
C
      IF (ABS(ICODE2).NE.1 .AND. ABS(ICODE2).NE.2) GO TO 40
      XC = XNEW
      YC = YNEW
      MC = MNEW
      NPT = 1
      METH = ICODE2
      IF (MC.EQ.0) GO TO 260
      GXC = GXNEW
      GYC = GYNEW
      GO TO 260
C
C     Ignore point if not distinct from previous point. Increment point
C     counter NPT, and update X, Y, M and G values. The chord length
C     between points A and B is kept in TP, and between B and C in TQ.
C
   40 CONTINUE
      LDIFF = .FALSE.
      IF (ABS(XNEW-XC).LE.TOLX .AND. ABS(YNEW-YC).LE.TOLY) GO TO 180
      LDIFF = .TRUE.
      NPT = NPT + 1
      IF (K.EQ.1) KK = 0
      IF (NPT.EQ.2) GO TO 60
      XA = XB
      YA = YB
      MA = MB
      TP = TQ
      IF (NPT.LE.3 .AND. MA.EQ.0) GO TO 60
      GXA = GXB
      GYA = GYB
C
   60 CONTINUE
      XB = XC
      YB = YC
      MB = MC
      IF (MB.EQ.0) GO TO 80
      GXB = GXC
      GYB = GYC
C
   80 CONTINUE
      XC = XNEW
      YC = YNEW
      MC = MNEW
      IF (MC.EQ.0) GO TO 100
      GXC = GXNEW
      GYC = GYNEW
C
  100 CONTINUE
      XQ = XC - XB
      YQ = YC - YB
      TQ = 1.0D0
      IF (ABS(METH).EQ.2) TQ = SQRT(XQ*XQ+YQ*YQ)
      TQ = MAX(TQ,100.0D0*X02AKF_J06)
      IF (NPT.EQ.2) GO TO 180
      XP = XB - XA
      YP = YB - YA
C
C     CALCULATE SLOPE OF CURVE AT PREVIOUS POINT (XB,YB)
C
      IF (MB.EQ.1) GO TO 120
      SXP = XP/TP
      SYP = YP/TP
      SXQ = XQ/TQ
      SYQ = YQ/TQ
      CALL J06CDX(TP,TQ,SXP,SYP,SXQ,SYQ,METH,GXB,GYB)
  120 CONTINUE
C
C     IF POINT IS THIRD POINT ON CURVE, SPECIAL ACTION IS TAKEN.
C     IF CURVE IS OPEN, AN ESTIMATE OF SLOPE AT FIRST POINT IS MADE.
C     IF CURVE IS CLOSED, A RECORD OF INFORMATION AT THE FIRST
C     TWO DATA POINTS IS KEPT AND USED LATER TO ESTIMATE THE
C     SLOPE AT THE FIRST POINT SO THAT A SMOOTH CLOSED CURVE
C     IS GENERATED.
C
      IF (NPT.NE.3) GO TO 180
      IF (METH.LT.0) GO TO 140
      IF (MA.EQ.1) GO TO 180
      SXBEG = 2.0D0*SXP - SXQ
      SYBEG = 2.0D0*SYP - SYQ
      CALL J06CDX(TQ,TP,SXBEG,SYBEG,SXP,SYP,METH,GXA,GYA)
      GO TO 180
C
  140 CONTINUE
      X1 = XA
      Y1 = YA
      M1 = MA
      IF (MA.EQ.0) GO TO 160
      GX1 = GXA
      GY1 = GYA
C
  160 CONTINUE
      X2 = XB
      Y2 = YB
      GX2 = GXB
      GY2 = GYB
  180 CONTINUE
C
C     IF POINT IS THE LAST POINT ON THE CURVE SPECIAL ACTION IS TAKEN
C
      IF (ICODE2.NE.9 .OR. NPT.LE.2) GO TO 260
C
C     If curve is open, the slope at the last point is estimated
C     Ensure that all the variables have been calculated first
C
      IF (METH.LT.0) GO TO 200
      IF (MC.EQ.1) GO TO 260
      IF ( .NOT. LDIFF) THEN
         TP = TQ
         XQ = XC - XB
         YQ = YC - YB
         TQ = 1.0D0
         IF (ABS(METH).EQ.2) TQ = SQRT(XQ*XQ+YQ*YQ)
         TQ = MAX(TQ,100.0D0*X02AKF_J06)
         XP = XB - XA
         YP = YB - YA
         SXP = XP/TP
         SYP = YP/TP
         SXQ = XQ/TQ
         SYQ = YQ/TQ
      END IF
      SXEND = 2.0D0*SXQ - SXP
      SYEND = 2.0D0*SYQ - SYP
      CALL J06CDX(TQ,TP,SXQ,SYQ,SXEND,SYEND,METH,GXC,GYC)
      GO TO 260
C
C     IF CURVE IS CLOSED, THE SLOPES AT THE LAST AND FIRST POINTS
C     ARE ESTIMATED
C
  200 CONTINUE
      IF (K.EQ.3) GO TO 260
      IF (K.EQ.2) GO TO 240
C
C     PICK UP FIRST POINT AS THOUGH IT WERE NEXT POINT ON CURVE, SO
C     THAT SLOPE AT LAST POINT CAN BE ESTIMATED
C
      XNEW = X1
      YNEW = Y1
      MNEW = M1
      K = 2
      IF (M1.EQ.0) GO TO 220
      GXNEW = GX1
      GYNEW = GY1
  220 CONTINUE
C
C     TRANSFER POINT A TO POINT 1
C
      X1 = XA
      Y1 = YA
      M1 = MA
      T1 = TP
C
C     IF THERE ARE ONLY THREE POINTS IN THE CURVE, THEN POINT A
C     IS THE FIRST POINT ON THE CURVE AND SPECIAL ACTION IS NEEDED.
C     FIRST KK IS SET TO 1 WHICH WILL MEAN THAT IN J06CDY, THE
C     FIRST OF TEH FOUR POINTS AT THE END OF PROCESSIG A CLOSED
C     CURVE IS SKIPPED. ALSO ITS SLOPE MAY NOT BE KNOWN IF
C     DERIVATIVES ARE NOT SUPPLIED.
C
      IF (NPT.EQ.3) THEN
         KK = 1
         IF (M1.EQ.0) GO TO 40
      END IF
C
      GX1 = GXA
      GY1 = GYA
      GO TO 40
C
C     PICK UP SECOND POINT AS THOUGH IT WERE NEXT POINT IN SEQUENCE
C     SO THAT SLOPE AT FIRST POINT CAN BE ESTIMATED
C
  240 CONTINUE
      XNEW = X2
      YNEW = Y2
      MNEW = 1
      K = 3
      GXNEW = GX2
      GYNEW = GY2
C
C     TRANSFER POINT A TO POINT 2
C
      X2 = XA
      Y2 = YA
      T2 = TP
      GX2 = GXA
      GY2 = GYA
      GO TO 40
  260 CONTINUE
      RETURN
      END
C
C********************************************************************
C
c simfit version of j06cdx

      SUBROUTINE J06CDX(TP,TQ,SXP,SYP,SXQ,SYQ,METH,GX,GY)
      use module_j06sav, only : x02ajf_j06, x02akf_j06
C
C     CALCULATES THE SLOPE AT A DATA POINT BY EITHER THE BUTLAND
C     METHOD (METH=1) OR THE MCCONALOGUE METHOD (METH=2).
C
C     IN THE BUTLAND METHOD, THE VALUE OF GX (IE DX/DT) IS
C     CALCULATED AS -
C
C          1/GX = 0.5*(1/SXP + 1/SXQ)
C
C     WHERE SXP=(XB-XA)/TP, AND SXQ=(XC-XB)/TQ,
C     WHERE (XB,YB) IS THE CURRENT POINT AND (XA,YA), (XC,YC) ARE
C     ITS PREDECESSOR AND SUCCESSOR RESPECTIVELY.  TP,TQ ARE
C     THE PARAMETER LENGTHS BETWEEN THE POINTS.  GY IS CALCULATED
C     SIMILARLY.
C
C     ROUTINE CREATED - SEPTEMBER 1979
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     IN THE MCCONALOGUE METHOD, THE VALUE OF GX IS CALCULATED AS
C     THE SLOPE OF A QUADRATIC AT TP WHICH PASSES THROUGH THE
C     POINTS (0,XA), (TP,XB), AND (TP+TQ,XC).  GY IS CALCULATED
C     SIMILARLY.
C
C     PARAMETERS -
C
C         TP,TQ - ON ENTRY, TP,TQ CONTAIN PARAMETER LENGTHS TO
C                 PREVIOUS POINT AND NEXT POINT RESPECTIVELY.
C
C         SXP,SYP,SXQ,SYQ - ON ENTRY, THESE CONTAIN THE SLOPES OF
C                           THE X- AND Y-COORDS AS EXPLAINED ABOVE.
C
C         METH - ON ENTRY, METH SPECIFIES METHOD TO BE USED.
C                METH=1  BUTLAND METHOD
C                METH=2  MCCONALOGUE METHOD
C
C         GX,GY - ON EXIT CONTAIN THE ESTIMATED SLOPE (IE DX/DT,DY/DT).
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  GX, GY, SXP, SXQ, SYP, SYQ, TP, TQ
      INTEGER           METH
C     .. Local Scalars ..
      DOUBLE PRECISION  AGX, AGY, SMALL, TPTQ
C     .. Intrinsic Functions ..
      INTRINSIC         ABS
C     .. Executable Statements ..
C
      IF (ABS(METH).EQ.2) GO TO 20
C
C     BUTLAND METHOD
C
      GX = 0.0D0
      GY = 0.0D0
      SMALL = 100.0D0*X02AKF_J06
      IF (SXP*SXQ.GT.SMALL) GX = 2.0D0*SXP*SXQ/(SXP+SXQ)
      IF (SYP*SYQ.GT.SMALL) GY = 2.0D0*SYP*SYQ/(SYP+SYQ)
      RETURN
C
C     MCCONALOGUE METHOD
C
   20 CONTINUE
      TPTQ = 1.0D0/(TP+TQ)
      GX = (TQ*SXP+TP*SXQ)*TPTQ
      GY = (TQ*SYP+TP*SYQ)*TPTQ
C
C     TREAT CASE OF BOTH COMPONENTS EQUAL TO ZERO.
C     THIS WILL OCCUR FOR EXAMPLE IF (XA,YA)=(XC,YC).
C     IN THIS CASE SET SLOPE SO AS TO CREATE A LOOP
C
      AGX = (TQ*ABS(SXP)+TP*ABS(SXQ))*TPTQ
      IF (ABS(GX).GT.2.0D0*AGX*X02AJF_J06) RETURN
      AGY = (TQ*ABS(SYP)+TP*ABS(SYQ))*TPTQ
      IF (ABS(GY).GT.2.0D0*AGY*X02AJF_J06) RETURN
      GX = SYP
      GY = -SXP
      RETURN
      END
C
C ********************************************************************
C 