C 
C
      SUBROUTINE CONTR2$(ICOLOR, KMODE, L, M, N, NMAX, NOUT_PS,
     +                   HTS, Y_SCALE, SURFCE,
     +                   CONVAL, HARD_COPY, HPGL, PS, UNUSED)
C
C ACTION : Draw a contour
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/9/95
C          This subroutine is developed from an original program CONTR2 
C          20/05/2007 added INTENTS
C
C          ICOLOR = colour
C          L = dimension of heights HTS
C          M = vertical dimension (x)
C          N = horizontal dimension (y)
C          SURFCE = z(x,y) as a regular rectangular grid
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: KMODE, L, M, N, NMAX, NOUT_PS
      INTEGER,          INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN)    :: HTS(L), SURFCE(NMAX,N), 
     +                                    Y_SCALE
      LOGICAL,          INTENT (IN)    :: CONVAL, HARD_COPY, HPGL, PS
      LOGICAL,          INTENT (INOUT) :: UNUSED(NMAX,N)
C
C Locals
C
      INTEGER    I, II, IA, IIA, I1, J, JJ, JA, JJA, J1, K, KCON, M1, N1
      DOUBLE PRECISION ONE, FSCALE
      PARAMETER (ONE = 1.0D+00, FSCALE = 0.675D+00)
      DOUBLE PRECISION H
      LOGICAL    FOUND, OPCONT
      EXTERNAL   PUTFAT$
      EXTERNAL   CONTR3$
C
C Set up fonts
C
      IF (CONVAL.AND.PS) WRITE (NOUT_PS,100) FSCALE
C
C Set up constants
C
      M1 = M - 1
      N1 = N - 1
      FOUND = .FALSE.
C
C Main loop to extract contour height and process
C
      DO 70 K = 1, L
         KCON = K
         H = HTS(K)
C
C Set up UNUSED
C
         DO 15 J = 2, N1
            DO 10 I = 2, M
               UNUSED(I,J) = SURFCE(I - 1,J).LT.H .AND. SURFCE(I,J).GE.H
   10       CONTINUE
   15    CONTINUE
C
C Search for open contours on edge J = 1
C
         OPCONT = .TRUE.
         J = 1
         IA = -1
         JA = 0
         DO 20 I = 2, M
            IF (SURFCE(I - 1,J).LT.H .AND. SURFCE(I,J).GE.H) THEN
               FOUND = .TRUE.
               II = I
               IIA = IA
               JJ = J
               JJA = JA
               CALL CONTR3$(ICOLOR, II, IIA, JJ, JJA, KCON, KMODE, M, N,
     +                      NMAX, NOUT_PS,
     +                      H, SURFCE, Y_SCALE,
     +                      CONVAL, HARD_COPY, HPGL, OPCONT, PS, UNUSED)
            ENDIF
   20    CONTINUE
C
C Search for open contours on edge I = M
C
         I = M
         IA = 0
         JA = -1
         DO 30 J = 2, N
            IF (SURFCE(I,J - 1).LT.H .AND. SURFCE(I,J).GE.H) THEN
               FOUND = .TRUE.
               II = I
               IIA = IA
               JJ = J
               JJA = JA
               CALL CONTR3$(ICOLOR, II, IIA, JJ, JJA, KCON, KMODE, M, N,
     +                      NMAX, NOUT_PS,
     +                      H, SURFCE, Y_SCALE,
     +                      CONVAL, HARD_COPY, HPGL, OPCONT, PS, UNUSED)
            ENDIF
   30    CONTINUE
C
C Search for open contours on edge J = N
C
         J = N
         IA = 1
         JA = 0
         DO 40 I1 = 1, M1
            I = M - I1
            IF (SURFCE(I + 1,J).LT.H .AND. SURFCE(I,J).GE.H) THEN
               FOUND = .TRUE.
               II = I
               IIA = IA
               JJ = J
               JJA = JA
               CALL CONTR3$(ICOLOR, II, IIA, JJ, JJA, KCON, KMODE, M, N,
     +                      NMAX, NOUT_PS,
     +                      H, SURFCE, Y_SCALE,
     +                      CONVAL, HARD_COPY, HPGL, OPCONT, PS, UNUSED)
            ENDIF
   40    CONTINUE
C
C Search for open contours on edge I = 1
C
         I = 1
         IA = 0
         JA = 1
         DO 50 J1 = 1, N1
            J = N - J1
            IF (SURFCE(I,J + 1).LT.H .AND. SURFCE(I,J).GE.H) THEN
               FOUND = .TRUE.
               II = I
               IIA = IA
               JJ = J
               JJA = JA
               CALL CONTR3$(ICOLOR, II, IIA, JJ, JJA, KCON, KMODE, M, N,
     +                      NMAX, NOUT_PS,
     +                      H, SURFCE, Y_SCALE, 
     +                      CONVAL, HARD_COPY, HPGL, OPCONT, PS, UNUSED)
            ENDIF
   50    CONTINUE
C
C Search for closed contours
C
         IA = -1
         JA = 0
         OPCONT = .FALSE.
         DO 65 J1 = 2, N1
            J = N - J1 + 1
            DO 60 I1 = 1, M1
               I = M - I1 + 1
               IF (UNUSED(I,J)) THEN
                  FOUND = .TRUE.
                  II = I
                  IIA = IA
                  JJ = J
                  JJA = JA
                  CALL CONTR3$(ICOLOR, II, IIA, JJ, JJA, KCON, KMODE,
     +                         M, N, NMAX, NOUT_PS,
     +                         H, SURFCE, Y_SCALE, 
     +                         CONVAL, HARD_COPY, HPGL, OPCONT, PS,
     +                         UNUSED)
               ENDIF
   60       CONTINUE
   65    CONTINUE
   70 CONTINUE
      IF (.NOT.FOUND) THEN
         CALL PUTFAT$('Data are not suitable for a contour plot')
      ENDIF
      IF (CONVAL .AND. PS) WRITE (NOUT_PS,100) ONE/FSCALE 
C
C Format statement (THIS MUST NOT BE TRANSLATED)
C      
  100 FORMAT ('% scale the font sizes',
     +       /'/tc-size tc-size ',F4.2,' mul def')
      END
C  
C