C  
C
      SUBROUTINE CONTR3$(ICOLOR, I, IA, J, JA, KCON, KMODE, M, N,
     +                   NMAX, NOUT_PS,
     +                   H, SURFCE, Y_SCALE, 
     +                   CONVAL, HARD_COPY, HPGL, OPCONT, PS, UNUSED)
C
C ACTION : Trace a contour from CONTR2
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/9/95
C          Developed from 100 on in original version of CONTR2  
C          20/05/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: KCON, KMODE, M, N, NMAX,
     +                                    NOUT_PS 
      INTEGER,          INTENT (INOUT) :: I, IA, ICOLOR, J, JA
      DOUBLE PRECISION, INTENT (IN)    :: H, SURFCE(NMAX,N), Y_SCALE
      LOGICAL,          INTENT (IN)    :: CONVAL, HARD_COPY, HPGL,
     +                                    OPCONT, PS
      LOGICAL,          INTENT (INOUT) :: UNUSED(NMAX,N)
C
C Locals
C
      INTEGER    IC, ID, JC, JD
      INTEGER    I2, I3, I4, J2, J3, J4, KB
      DOUBLE PRECISION HALF, ONE
      DOUBLE PRECISION T, X, XDIFF, Y, YDIFF, Z, ZA, ZB, ZC, ZD
      PARAMETER (HALF = 0.5D+00, ONE = 1.0D+00)
      LOGICAL    FRSTPT, LASTPT, RIGHT
      EXTERNAL   CONTR4$
C
C Branch point 100 in original version of CONTR2
C 100 CONTINUE
C
      IC = I
      JC = J
      ID = IA
      JD = JA
      FRSTPT = .TRUE.
      LASTPT = .FALSE.
      XDIFF = M - ONE
      YDIFF = N - ONE
      Z = SURFCE(I,J)
      I2 = I + IA
      J2 = J + JA
      ZA = SURFCE(I2,J2)
C
C Find where contour crosses the line by inverse linear interploation
C
  110 CONTINUE
      T = (Z - H)/(Z - ZA)
      X = J - ONE + T*JA
      Y = M - I - T*IA
      IF (OPCONT) GOTO 120
      IF (FRSTPT) GOTO 150
      IF (IA.NE.-1) GOTO 160
      IF (.NOT.UNUSED(I,J)) GOTO 140
      GOTO 150
C
C Edge of mesh ?
C
  120 CONTINUE
      IF (FRSTPT) GOTO 160
      IF (JA.NE.0) GOTO 130
      IF (J.EQ.1 .OR. J.EQ.N) GOTO 140
      IF (IA.NE.-1) GOTO 160
      GOTO 150
  130 CONTINUE
      IF (I.EQ.1 .OR. I.EQ.M) GOTO 140
      GOTO 160
C
C Last point
C
  140 CONTINUE
      LASTPT = .TRUE.
      GOTO 160
C
C Direction of increasing J
C
  150 CONTINUE
      UNUSED(I,J) = .FALSE.
C
C Draw
C
  160 CONTINUE
      X = X/XDIFF
      Y = Y/YDIFF
      CALL CONTR4$(ICOLOR, KCON, KMODE, NOUT_PS, X, Y, Y_SCALE,
     +             CONVAL, FRSTPT, HARD_COPY, HPGL, LASTPT, PS)
      IF (LASTPT) GOTO 230
      FRSTPT = .FALSE.
      I3 = I + JA
      J3 = J - IA
      I4 = I + IA + JA
      J4 = J - IA + JA
      ZB = SURFCE(I3,J3)
      ZC = SURFCE(I4,J4)
      ZD = 0.25D+00*(Z + ZA + ZB + ZC)
      IF (ZD.GE.H) GOTO 190
      RIGHT = .TRUE.
      T = HALF*(Z - H)/(Z - ZD)
      X = J - ONE + T*(JA - IA)
      Y = M - I - T*(IA + JA)
      X = X/XDIFF
      Y = Y/YDIFF
      CALL CONTR4$(ICOLOR, KCON, KMODE, NOUT_PS, X, Y, Y_SCALE,
     +             CONVAL, FRSTPT, HARD_COPY, HPGL, LASTPT, PS)
      IF (ZB.LT.H) GOTO 200
  170 CONTINUE
      T = HALF*(ZB - H)/(ZB - ZD)
      X = J3  - ONE + T*(IA + JA)
      Y = M - I3 + T*(JA - IA)
      X = X/XDIFF
      Y = Y/YDIFF
      CALL CONTR4$(ICOLOR, KCON, KMODE, NOUT_PS, X, Y, Y_SCALE,
     +             CONVAL, FRSTPT, HARD_COPY, HPGL, LASTPT, PS)
      IF (.NOT.RIGHT) GOTO 200
      IF (ZC.LT.H) GOTO 210
  180 CONTINUE
      T = HALF*(ONE + (ZD - H)/(ZD - ZC))
      X = J - ONE + T*(JA - IA)
      Y = M - I - T*(IA + JA)
      X = X/XDIFF
      Y = Y/YDIFF
      CALL CONTR4$(ICOLOR, KCON, KMODE, NOUT_PS, X, Y, Y_SCALE,
     +             CONVAL, FRSTPT, HARD_COPY, HPGL, LASTPT, PS)
      IF (RIGHT) GOTO 220
      IF (ZB.LT.H) GOTO 170
      GOTO 210
  190 CONTINUE
      RIGHT = .FALSE.
      T = HALF*(ONE + (ZD - H)/(ZD - ZA))
      X = J3 - ONE + T*(IA + JA)
      Y = M - I3 + T*(JA - IA)
      X = X/XDIFF
      Y = Y/YDIFF
      CALL CONTR4$(ICOLOR, KCON, KMODE, NOUT_PS, X, Y, Y_SCALE,
     +             CONVAL, FRSTPT, HARD_COPY, HPGL, LASTPT, PS)
      IF (ZC.LT.H) GOTO 180
      GOTO 220
  200 CONTINUE
      ZA = ZB
      KB = IA
      IA = JA
      JA = -KB
      GOTO 110
  210 CONTINUE
      Z = ZB
      ZA = ZC
      I = I3
      J = J3
      GOTO 110
  220 CONTINUE
      Z = ZC
      I = I4
      J = J4
      KB = JA
      JA = IA
      IA = -KB
      GOTO 110
  230 CONTINUE
      I = IC
      J = JC
      IA = ID
      JA = JD
      END
C  
C