C  
C
      SUBROUTINE CONTR4$(ICOLOR, KCON, KMODE, NOUT_PS,
     +                   X, Y, Y_SCALE,
     +                   CONVAL, FRSTPT, HARD_COPY, HPGL, LASTPT, PS)
C
C ACTION : Draw the contours
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 22/9/95
C          Note the transform X -> Y, 1 - Y -> X for double plot
C          30/10/1998 removed OPCONT and H from argument list
C          20/05/2007 added INTENTS
C          14/10/2013 added call to CONTR1$ for smoothing and increased NMAX to 5000
C
      IMPLICIT  NONE
C
C Argument list
C
      INTEGER,          INTENT (IN)    :: KCON, KMODE, NOUT_PS 
      INTEGER,          INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION, INTENT (IN)    :: X, Y, Y_SCALE
      LOGICAL,          INTENT (IN)    :: CONVAL, FRSTPT, HARD_COPY,
     +                                    HPGL, LASTPT, PS
C
C Locals
C
      INTEGER    NFONT, NGKS, NMAX, NTFONT
      PARAMETER (NGKS = 3, NMAX = 5000, NTFONT = 106)
      INTEGER    I, J, K, L, NPTS, NPTSAV
      DOUBLE PRECISION XVAL(NMAX + 2), YVAL(NMAX + 2)
      DOUBLE PRECISION EPSI1, EPSI2, FIVE, PNT5, PNT9, ONE, XTEMP,
     +                 YTEMP, ZTEMP
      PARAMETER (EPSI1 = 0.025D+00, EPSI2 = 0.015D+00, FIVE = 5.0D+00, 
     +           PNT5 = 0.5D+00, PNT9 = 0.9D+00, ONE = 1.0D+00,
     +           ZTEMP = 0.0D+00)
      DOUBLE PRECISION ANGLE, FSCALE, SLANT, SLANT1, XPT
      PARAMETER (ANGLE = 0.0D+00, FSCALE = 0.675D+00, SLANT = 0.0D+00,
     +           XPT = 1.5D+00)
      DOUBLE PRECISION SIZE1
      CHARACTER  FONT*8, SYMBOL*3, STRNG*3, TYPE1*2
      PARAMETER (FONT = '/Courier', SYMBOL = '000', TYPE1 = 'tc')
      EXTERNAL   POLYLINE$, XYZ2XY$, PLTSTR$, WGBFNT$
      EXTERNAL   CONTR1$
      INTRINSIC  SQRT, NINT, DBLE
      SAVE       L, NPTS, XVAL, YVAL
      DATA       L / 0 /
C
C Transform if required
C
      CALL WGBFNT$(I,
     +             NFONT, SLANT1)
      IF (KMODE.EQ.3) THEN
         CALL XYZ2XY$(ONE - Y, XTEMP, X, YTEMP, ZTEMP)
      ELSE
         XTEMP = X
         YTEMP = Y
      ENDIF
C
C Different action required for the separate cases
C
      IF (FRSTPT) THEN
         IF (KCON.EQ.1) THEN
            L = 0
         ENDIF
         NPTS = 1
         XVAL(1) = XTEMP
         YVAL(1) = YTEMP
      ELSEIF (LASTPT) THEN
         NPTS = NPTS + 1
         IF (NPTS.LT.2) RETURN
         XVAL(NPTS) = XTEMP
         YVAL(NPTS) = YTEMP
         NPTSAV = NPTS
         GOTO 20
      ELSE
         IF (NPTS.LT.NMAX) THEN
            NPTS = NPTS + 1
            XVAL(NPTS) = XTEMP
            YVAL(NPTS) = YTEMP
         ELSE
            NPTSAV = NPTS
            NPTS = 0
            GOTO 20
         ENDIF
      ENDIF
      RETURN
C
C Return unless a contour is finished or we run out of points
C
   20 CONTINUE
C
C Smooth the polylines
C    
      CALL CONTR1$(NPTSAV, NMAX,
     +             XVAL, YVAL) 
      
      IF (NPTSAV.LT.2) THEN
         RETURN
      ELSEIF (CONVAL) THEN
C
C Part 1: choose the fraction of the curve to position the label
C      
         L = L + 1
         IF (L.GT.4) L = 1
         K = NINT(DBLE(L)*DBLE(NPTSAV)/FIVE)
         IF (K.GT.NPTSAV - 1) K = NPTSAV - 1
         IF (K.LT.2) K = 2
         XTEMP = PNT5*(XVAL(K - 1) + XVAL(K))
         YTEMP = PNT5*(YVAL(K - 1) + YVAL(K)) - EPSI2
         IF (KCON.LT.10) THEN
            WRITE (STRNG,'(I1,2X)') KCON
         ELSEIF (KCON.LT.100) THEN   
            WRITE (STRNG,'(I2,1X)') KCON
         ELSE   
            WRITE (STRNG,'(I3)') KCON
         ENDIF 
C
C Part 2: plot the label using EPSI2 to guess the font height 
C           
         SIZE1 = PNT9*FSCALE*XPT
         CALL PLTSTR$(ICOLOR, NTFONT, NFONT, NGKS, NOUT_PS,
     +                ANGLE, SIZE1, SLANT, XTEMP, YTEMP, Y_SCALE,
     +                FONT, STRNG, SYMBOL, TYPE1,
     +                HARD_COPY, HPGL, PS)
C
C Part 3: restore EPSI2 then build and plot the first part of the contour
C     
         YTEMP = YTEMP + EPSI2
         DO I = K - 1, 1, -1
            J = I
            IF (SQRT((XVAL(I) - XTEMP)**2 + (YVAL(I) - YTEMP)**2)
     +         .GE.EPSI1) THEN
               CALL POLYLINE$(J, XVAL, YVAL, ICOLOR)
               GOTO 40
            ENDIF
         ENDDO
         CALL POLYLINE$(K - 1, XVAL, YVAL, ICOLOR)
C
C Part 4: Finally build then plot the second part of the contour
C         
   40    CONTINUE
         DO I = K, NPTSAV
            J = I
            IF (SQRT((XVAL(I) - XTEMP)**2 + (YVAL(I) - YTEMP)**2)
     +         .GE.EPSI1) THEN
               CALL POLYLINE$(NPTSAV - J + 1, XVAL(J), YVAL(J), ICOLOR)
               RETURN
            ENDIF
         ENDDO
         CALL POLYLINE$(NPTSAV - K + 1, XVAL(K), YVAL(K), ICOLOR)
      ELSE
         CALL POLYLINE$(NPTSAV, XVAL, YVAL, ICOLOR)
      ENDIF
      END
c
c