c
c
      subroutine contr5$(isend, itheta, lctemp, ngks,
     +                   xmax, xmin, ymax, ymin)
c
c action: extra contour plotting
c author: w.g.bardsley, university of manchester, u.k., 25/06/2003 
c         20/05/2007 added intents
c         30/01/2008 jsend now a parameter as there were problems calling
c                    MATTIN for files with ncol not equal 2
c
c         isend = 0: initialise
c         isend = 1: edit/install
c         isend = 2: plot
c         itheta: angle of rotation
c         lctemp: background colour
c         ngks: gks transformation number
c         xmax, xmin, ymax, ymin: limits
c
      implicit none
c
c arguments 
c
      integer,          intent (in) :: isend, itheta, lctemp, ngks
      double precision, intent (in) :: xmax, xmin, ymax, ymin
c
c locals
c
      integer    i, j, ncol, nfile, nin, nrow
      integer    jsend, mode, ncmax, nfmax, nrmax
      parameter (jsend = 2, mode = 0, ncmax = 2, nfmax = 10, 
     +           nrmax = 2000)
      integer    jcolor(nfmax), l(nfmax), m(nfmax), n(nfmax)
      integer    icolor, ix, iy, lshade, numdec, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    numbld(30), numpos(20)
      double precision a(nrmax,ncmax), x(nrmax), y(nrmax)
      double precision size1(nfmax), thick(nfmax), xdiff, ydiff
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  fname(nfmax)*1024, text(30)*100, title*80, line*100,
     +           lines(9)*20, symbol(20)*20
      character  trim60*60
      character  nofile*60
      parameter (nofile = 'No file')
      logical    abort, again, first, repeet
      logical    fixcol, fixrow, label
      parameter (fixcol = .true., fixrow = .false., label = .true.)
      logical    border
      parameter (border = .false.)
      external   getnou, mattin, trim60, putfat$, lbox02, putadv$,
     +           getdge, palett$, patch1, gksdrw$, gkssym$
      intrinsic  abs
      save       l, m, n, jcolor, size1, thick, first, fname
      data       first / .true. /
      data       numbld / 30*0 /
      data       numpos / 20*1 /
C
C Data for line/symbol type menu for saving ASCII coordinate files
C
      data lines  / 'No line        ', 'Solid line     ',
     +              'Dashed line    ', 'Dotted line    ',
     +              'Dash-Dotted    ', 'Vector >>>>>   ',
     +              'Vector <<<<<   ', 'Step ( cdf )   ',
     +              'Step(survive)  ' /
      data symbol / 'No symbol      ', 'Point (.)      ',
     +              'Plus (+)       ', 'Cross (X)      ',
     +              'Asterisk (*)   ', 'Circle         ',
     +              'Half-circle    ', 'Full-circle    ',
     +              'Triangle       ', 'Half-triangle  ',
     +              'Full-triangle  ', 'Square         ',
     +              'Half-square    ', 'Full-square    ',
     +              'Diamond        ', 'Half-diamond   ',
     +              'Full-diamond   ', 'Minus          ',
     +              'Male           ', 'Female         ' /
      if (first .or. isend.eq.0) then
c
c initialise
c
         first = .false.
         do i = 1, nfmax
            fname(i) = nofile
            jcolor(i) = 0
            l(i) = 1
            m(i) = 0
            n(i) = 0
            size1(i) = one
            thick(i) = one
         enddo
      endif
      if (isend.eq.1) then
c
c install/edit
c
         repeet = .true.
         do while (repeet)
            write (text,100)
            numdec = 3
            numopt = 4
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                   text)
            if (numdec.le.2) then
c
c create a menu with file names
c
               do i = 1, nfmax
                  text(i) = trim60(fname(i))
               enddo
               nfile = 1
               call lbox02 (icolor, ix, iy, nfile, nfmax, numpos, 
     +                      text)
            endif
            if (numdec.eq.1) then
c
c select a new file
c
               write (line,200)
               call putadv$(line)
               call getnou (nin)
               close (unit = nin)
               ncol = 2
               call mattin (jsend, ncmax, ncol, nin, nrmax, nrow,
     +                      a, x,
     +                      fname(nfile), title,
     +                      abort, fixcol, fixrow, label)
               close (unit = nin)
               if (.not.abort .and. nrow.gt.0) then
                   n(nfile) = nrow
               else
                   n(nfile) = 0
                   fname(nfile) = nofile
               endif
            elseif (numdec.eq.2) then
c
c edit a file
c
               if (n(nfile).le.0) then
                  write (line,300)
                  call putfat$(line)
               else
                  again = .true.
                  do while (again)
                     write (text,400)
                     numopt = 6
                     numdec = numopt
                     call lbox02 (icolor, ix, iy, numdec, numopt,
     +                            numpos,
     +                            text)
                     if (numdec.eq.1) then
                        i = l(nfile) + 1
                        numopt = 9
                        call lbox02 (icolor, ix, iy, i, numopt, numpos,
     +                               lines)
                        l(nfile) = i - 1
                     elseif (numdec.eq.2) then
                        i = m(nfile) + 1
                        numopt = 20
                        call lbox02 (icolor, ix, iy, i, numopt, numpos,
     +                               symbol)
                        m(nfile) = i - 1
                     elseif (numdec.eq.3) then
                        call palett$(jcolor(nfile), mode)
                     elseif (numdec.eq.4) then
                        write (line,500) nfile
                        call getdge (thick(nfile), zero, line)
                     elseif (numdec.eq.5) then
                        write (line,600) nfile
                        call getdge (size1(nfile), zero, line)
                     elseif (numdec.eq.numopt) then
                        again = .false.
                     endif
                  enddo
               endif
            elseif (numdec.eq.numopt - 1) then
               write (text,700)
               i = 20
               numbld(1) = 1
               call patch1 (icolor, ix, iy, lshade, numbld, i,
     +                      text, border)
               numbld(1) = 0
            elseif (numdec.eq.numopt) then
               repeet = .false.
            endif
         enddo
      elseif (isend.eq.2) then
c
c plot
c
         xdiff = xmax - xmin
         if (abs(xdiff).le.zero) return
         ydiff = ymax - ymin
         if (abs(ydiff).le.zero) return
         do i = 1, nfmax
            if (n(i).gt.0 .and. (l(i).ne.0 .or. m(i).ne.0)) then
               call getnou (nin)
               open (unit = nin, file = fname(i))
               read (nin,'(a)') title
               read (nin,*) n(i), j
               do j = 1, n(i)
                  read (nin,*) a(j,1), a(j,2)
               enddo
               close (unit = nin)
               if (itheta.eq.0) then
                  do j = 1, n(i)
                     x(j) = (a(j,2) - xmin)/xdiff
                     y(j) = one - (a(j,1) - ymin)/ydiff
                  enddo
               elseif (itheta.eq.90) then
                  do j = 1, n(i)
                     x(j) = (a(j,1) - xmin)/xdiff
                     y(j) = (a(j,2) - ymin)/ydiff
                  enddo
               elseif (itheta.eq.180) then
                  do j = 1, n(i)
                     x(j) = one - (a(j,2) - xmin)/xdiff
                     y(j) = (a(j,1) - ymin)/ydiff
                  enddo
               elseif (itheta.eq.270) then
                  do j = 1, n(i)
                     x(j) = one - (a(j,1) - xmin)/xdiff
                     y(j) = one - (a(j,2) - ymin)/ydiff
                  enddo
               else
                  return
               endif
               if (l(i).ne.0) call gksdrw$(jcolor(i), ngks, l(i), n(i),
     +                                     thick(i), x, y)
               if (m(i).ne.0) call gkssym$(jcolor(i), ngks, lctemp,
     +                                     m(i), n(i), one, one,
     +                                     size1(i), thick(i),
     +                                     x, one, zero, y)
            endif
         enddo
      elseif (isend.ne.0) then
         write (line,800)
         call putfat$(line)
      endif
c
c format statements
c      
  100 format (
     + 'Install an X,Y overlay file'
     +/'Edit X,Y overlay appearance'
     +/'Help'
     +/'Apply')
  200 format (
     +'Now supply a file with X and Y data to overlay on the contours')
  300 format (
     + 'File selected has not yet been installed')
  400 format (
     + 'Line type'
     +/'Symbol type'
     +/'Colour'
     +/'Line thickness'
     +/'Symbol size'
     +/'Apply')
  500 format (
     +'Line thickness required for overlay number',i3)
  600 format (
     +'Symbol size required for overlay number',i3)
  700 format (
     + 'Adding x,y overlays to contour diagrams'
     +/
     +/'It may be necessary to plot extra sets of coordinates as'
     +/'overlays to a contour diagram of some function z = f(x,y).'
     +/
     +/'An example would be plotting the progress of optimizing an'
     +/'objective function near the solution point to visualize the'
     +/'trajectory of iterations.'
     +/
     +/'To do this you must install overlay files consisting of'
     +/'the coordinates to be plotted in two columns, that is:'
     +/'column 1 = x and column 2 = y.'
     +/
     +/'Any coordinates supplied must be contained within the region'
     +/'defined by the main contour diagram.'
     +/
     +/'Once a set of overlay files has been installed you can edit'
     +/'interactively whether to display or suppress and you can'
     +/'choose line types, line thicknesses, plotting symbols, and'
     +/'colours')
  800 format ('ISEND out of range in call to CONTR5$')
      end
c
c
