C
C
      SUBROUTINE COPYFL$ (MODE,
     +                    FILE1, FILE2,
     +                    ABORT)
C
C ACTION : Copy, edit, etc. a SIMFIT data file depending on MODE
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/9/98
C          06/10/1998 added error indicators
C          14/08/1999 replaced w_editor by editor
C          03/02/2005 increased dimensions
C          22/06/2006 introduced allocatable array, TITLE*1024, I2FILE, 
C                     and output format 1P,50E13.5  
C          20/09/2006 corrected error declaring FILE2 as (OUT)
C          19/09/2011 now calls X_COPYFL
C            
C This is a special version of COPYFL using PUTFAT$ instead of PUTFAT so that
C it can also be called directly from executing graphics procedurers.     
C
C Note: FILE2 is output in strict simfit format irrespective of the format 
C       for FILE1 (also MODE = 5 overwrites FILE1) but the line width in
C       FILE1 is restricted to 1024 characters
C
C       MODE: (input/unchanged) as follows:
C             MODE = 1: Copy FILE1 to named file  FILE2
C             MODE = 2: Copy FILE1 to temporary   FILE2
C             MODE = 3: Copy FILE1 to named file  FILE2 ... after editing
C             MODE = 4: Copy FILE1 to temporary   FILE2 ... after editing
C             MODE = 5: Copy FILE1 to temporary   FILE2 ... after editing
C                       Then FILE1 overwritten by FILE2 ... edit/replace
C       FILE1: (input/unchanged unless MODE = 5) input file
C       FILE2: (output) output file
C       ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: MODE
      CHARACTER (LEN = *), INTENT (IN)    :: FILE1
      CHARACTER (LEN = *), INTENT (INOUT) :: FILE2
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      EXTERNAL X_COPYFL
      CALL X_COPYFL (MODE,
     +               FILE1, FILE2,
     +               ABORT)
      END
C
C
