c
c
      subroutine crplot (ncol, nrmax, nrow, 
     +                   x,
     +                   plot_columns)
c
c action: plot columns or rows of a matrix x(nrmax,ncol)
c author: w.g.bardsley, university of manchester, u.k., 18/10/2010
c         02/11/2010 added sizes and thick to argument list to symbol
c         24/11/2010 replaced editi1 by calls to rboxes
c         04/12/2010 increased nmax to 15 (subsequently increased to 20)
c         23/09/2011 added call to symbol with jsend = 4 to restore defaults
c
c arguments ...
c ---------
c         ncol: number of columns in x
c        nrmax: leading dimension of x
c         nrow: number of rows in x
c            x: matrix for plotting
c plot_columns: plot columns if .true. otherwise plot rows
c
c allocated variables ...
c -------------------
c     j_col: selects the type of plot for columns (1 for x, 2 for y, 3 for z)
c     j_row: selects the type of plot for rows    (1 for x, 2 for y, 3 for z)
c    jfiles: colours
c    lfiles: line types
c    mfiles: symbol types
c      temp: double precision version of j_col or j_row
c    fnames: temporary files
c left_axis: plot at left axis
c 
      implicit none
c
c arguments
c          
      integer,          intent (in) :: ncol, nrmax, nrow
      double precision, intent (in) :: x(nrmax,ncol) 
      logical,          intent (in) :: plot_columns
c
c allocatable 
c      
      integer,                allocatable :: j_col(:), j_row(:)
      integer,                allocatable :: jfiles(:), lfiles(:),
     +                                       mfiles(:) 
      character (len = 1024), allocatable :: fnames(:)
      character (len = 20),   allocatable :: captions(:)
      logical,                allocatable :: left_axis(:)
c
c locals
c     
      integer    i, icount, ierr, j, itest, n, nb, nx, ny, nz
      integer    len200, nout
      integer    isend, jsend, nmax, n2
      parameter (isend = 1, jsend = 4, nmax = 20, n2 = 2) 
      integer    i_col(nmax), i_row(nmax)
      integer    jtype(nmax), ktype(nmax), ltype(nmax), mtype(nmax)
      integer    n_across, n_down, n_header
      parameter (n_across = 4, n_header = 4)
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 8,  numsta = 9, numtxt = numsta + numopt - 1)
      integer    numbld(30)
      double precision sizes(nmax), thick(nmax)
      character (len = 50) titles(4), titles_c(4), titles_r(4),
     +           question(4)
      character (len = 7) ptype
      character (len = 1) blank
      character (len = 100) text(30)
      character (len = 12) form12, ncol12, nrow12, nx12, ny12, nz12
      character (len = 80) advice(n_header)
      character (len = 20) word20
      parameter (blank = ' ')
      logical    first, repeet
      logical    askif, there
      parameter (askif = .false.)
      external   putfat, form12, symbol, lstbox, getstr$, gettmp,
     +           deleet, dbplot, getnou, patch2, len200, rboxes
      save       first, i_col, i_row, titles_c, titles_r
      data       first / .true. /
      data       numbld / 30*0 /
      data       i_col / nmax*2 /
      data       i_row / nmax*2 / 
      data       titles_c / 'Columns', 
     +                      'X-legend',
     +                      'Y-legend',
     +                      'Z-legend' /
      data       titles_r / 'Rows', 
     +                      'X-legend',
     +                      'Y-legend',
     +                      'Z-legend' /
      data       question / 'Edit the plot title',
     +                      'Edit the X-axis legend',  
     +                      'Edit the Y-axis legend (LHS)',  
     +                      'Edit the Z-axis legend (RHS)' / 
c
c check input data
c     
      if (nrmax.lt.2 .or. nrow.gt.nrmax .or. ncol.lt.2) then
         call putfat ('Dimension error or matrix too small to plot')
         return
      endif 
c
c first time round make column/row 1 the default
c      
      if (first) then
         i_col(1) = 1
         i_row(1) = 1
      endif   
c
c allocate
c      
      ierr = 0
      if (allocated(j_col)) deallocate(j_col, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(j_row)) deallocate(j_row, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(jfiles)) deallocate(jfiles, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(lfiles)) deallocate(lfiles, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(mfiles)) deallocate(mfiles, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(fnames)) deallocate(fnames, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(left_axis)) deallocate(left_axis, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(captions)) deallocate(captions, stat = ierr)
      if (ierr.ne.0) return        
 
      if (plot_columns) then
         ptype = 'Columns'
         n = ncol
      else
         ptype = 'Rows'
         n = nrow
      endif
      
      allocate (j_col(n), stat = ierr)
      if (ierr.ne.0) return
      allocate (j_row(n), stat = ierr)
      if (ierr.ne.0) return   
      allocate (jfiles(n - 1), stat = ierr)
      if (ierr.ne.0) return 
      allocate (lfiles(n - 1), stat = ierr)
      if (ierr.ne.0) return   
      allocate (mfiles(n - 1), stat = ierr)
      if (ierr.ne.0) return   
      allocate (fnames(n - 1), stat = ierr)
      if (ierr.ne.0) return
      allocate (left_axis(n), stat = ierr)
      if (ierr.ne.0) return
      allocate (captions(n), stat = ierr)
      if (ierr.ne.0) return  
c
c retrieve current symbol data 
c        
      call symbol (isend, jtype, ktype, ltype, mtype,
     +             sizes, thick)  
c
c initialise
c         
      do i = 1, n - 1
         if (i.le.nmax) then
            j_col(i) = i_col(i)
            j_row(i) = i_row(i)
            jfiles(i) = jtype(i)
            lfiles(i) = ltype(i)
            mfiles(i) = mtype(i)
         else
            j_col(i) = 0
            j_row(i) = 0
            jfiles(i) = 0
            lfiles(i) = 1
            mfiles(i) = 1
         endif     
         fnames(i) = blank
      enddo 
      if (n.le.nmax) then
         j_col(n) = i_col(n)
         j_row(n) = i_row(n)
      else
         j_col(n) = 0
         j_row(n) = 0
      endif      
    
c
c main loop
c          
      repeet = .true.
      do while (repeet)
c
c work out the items to be plotted
c
        icount = 0
        nb = 0
        nx = 0
        ny = 0
        nz = 0
        do i = 1, n
           if (plot_columns) then
             itest = j_col(i)
           else
             itest = j_row(i)
           endif      
           if (itest.eq.1) then
c
c a row/column has been selected as x
c            
              nx = nx + 1
              nb = i
           elseif (itest.eq.2) then
c
c a row/column has been selected as y
c          
              icount = icount + 1
              left_axis(icount) = .true.
              ny = ny + 1
           elseif (itest.eq.3) then
c
c a row/column has been selected as z
c          
              icount = icount + 1
              left_axis(icount) = .false.
              nz = nz + 1
           endif
        enddo 
c
c work out the values as left justified integers
c                      
        ncol12 = form12(ncol)
        nrow12 = form12(nrow)
        nx12 = form12(nx)
        ny12 = form12(ny)
        nz12 = form12(nz)
c
c create the menu
c        
        i = len200(ptype)
        write (text,100) ptype(1:i), nrow12, ncol12, nx12, ny12, nz12,
     +                   ptype, ptype(1:i) 
        numbld(1) = 4
        numdec = 1
c
c display the menu
c        
        call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +               text) 
        numbld(1) = 0
        if (numdec.eq.1) then
c
c numdec = 1: request a plot
c          
           if (nx.lt.1) then
              call putfat ('X has not been selected')
           elseif (nx.gt.1) then
              call putfat ('More than one X variable has been selected')   
           elseif (ny + nz.lt.1) then
              call putfat ('No Y or Z variables have been selected')
           else 
c
c assign titles
c                 
              do i = 1, 4
                if (plot_columns) then
                   titles(i) = titles_c(i)
                else   
                   titles(i) = titles_r(i)
                endif
              enddo 
              if (plot_columns) then
c
c create temporary files for columns
c                
                 icount = 0
                 do i = 1, n
                    if (j_col(i).eq.2 .or. j_col(i).eq.3) then
                       icount = icount + 1
                       call gettmp (j, 
     +                              fnames(icount))
                       call getnou (nout) 
                       open (unit = nout, file = fnames(icount))
                       write (nout,'(a)') 'Temporary file'
                       write (nout,'(2i6)') nrow, n2
                       do j = 1, nrow
                          write (nout,'(1p,2e13.5)') x(j,nb), x(j,i)
                       enddo
                       close (unit = nout) 
                    endif                                  
                 enddo
              else
c
c create temporary files for rows
c                
                 icount = 0
                 do i = 1, n
                    if (j_row(i).eq.2 .or.j_row(i).eq.3) then
                      icount = icount + 1
                      call gettmp (j, 
     +                             fnames(icount))
                      call getnou (nout) 
                      open (unit = nout, file = fnames(icount))
                      write (nout,'(a)') 'Temporary file'
                      write (nout,'(2i6)') ncol, n2
                      do j = 1, ncol
                         write (nout,'(1p,2e13.5)') x(nb,j), x(i,j)
                      enddo
                      close (unit = nout) 
                    endif                                  
                 enddo
              endif
c
c call the plotting routine
c              
              call dbplot (jfiles, lfiles, mfiles, icount,
     +                     fnames, titles,
     +                     left_axis)
c
c delete the temporary files
c     
              do i = 1, icount
                 call deleet (fnames(i),
     +                        askif, there)
              enddo                                          
           endif   
        elseif (numdec.eq.2) then 
c
c numdec = 2: assign items to x, y, z, or suppressed
c          
           n_down = n
           if (plot_columns) then 
              advice(1) = 'Tick box 1 to select the column to use as x'
              advice(2) = 'Tick box 2 for columns to plot as y (LHS)' 
              advice(3) = 'Tick box 3 for columns to plot as z (RHS)' 
              advice(4) = 'Tick box 4 to suppress plotting' 
              do i = 1, n
                 word20 = 'column '//form12(i)
                 captions(i) = word20
              enddo
              call rboxes (j_col, n_across, n_down, n_header,
     +                     advice, captions)                   
           else
              advice(1) = 'Tick box 1 to select the row to use as x'
              advice(2) = 'Tick box 2 for rows to plot as y (LHS)' 
              advice(3) = 'Tick box 3 for rows to plot as z (RHS)' 
              advice(4) = 'Tick box 4 to suppress plotting' 
              do i = 1, n
                 word20 = 'row '//form12(i)
                 captions(i) = word20
              enddo
              call rboxes (j_row, n_across, n_down, n_header,
     +                     advice, captions)   
           endif    
           do j = 1, min(n,nmax)
              if (plot_columns) then
                 i_col(j) = j_col(j)
              else   
                 i_row(j) = j_row(j)
              endif 
           enddo                
        elseif (numdec.lt.numopt - 1) then
c
c edit the title and legends
c        
           i = numdec - 2
           if (plot_columns) then
              call getstr$ (question(i), titles_c(i))
           else    
              call getstr$ (question(i), titles_r(i))
           endif  
        elseif (numdec.eq.numopt - 1) then
c
c help
c           
           if (plot_columns) then 
              write (text,200)
           else
              write (text,300)
           endif      
           numbld(1) = 1
           numbld(10) = 1
           i = 19
           call patch2 (numbld, i,
     +                 text)   
           numbld(1) = 0       
           numbld(10) = 0       
        elseif (numdec.eq.numopt) then
c
c exit the loop
c        
           repeet = .false.
        endif   
        numbld(1) = 0       
      enddo 
c
c restore current symbol data 
c        
      call symbol (jsend, jtype, ktype, ltype, mtype,
     +             sizes, thick)           
c
c deallocate
c
      deallocate(j_col, stat = ierr)
      deallocate(j_row, stat = ierr)
      deallocate(jfiles, stat = ierr)
      deallocate(lfiles, stat = ierr)
      deallocate(mfiles, stat = ierr)
      deallocate(mfiles, stat = ierr)
      deallocate(left_axis, stat = ierr)
      deallocate(captions, stat = ierr)
c
c format statements
c      
  100 format (
     + 'Plotting selected',1x,a,1x,'from a Matrix'
     +/
     +/'Number of rows =',1x,a
     +/'Number of columns =',1x,a
     +/'Number of items assigned to x =',1x,a
     +/'Number of items assigned to y =',1x,a
     +/'Number of items assigned to z =',1x,a
     +/
     +/'Plot the selected',1x,a
     +/'Select',1x,a,1x,'to be plotted'
     +/'Edit/Save the plot title'
     +/'Edit/Save the x-axis legend'
     +/'Edit/Save the y-axis legend (i.e. left_hand)'
     +/'Edit/Save the z-axis legend (i.e. right_hand)'
     +/'Help' 
     +/'Exit ... Quit plotting this matrix')  
  200 format (
     + 'Plotting selected columns'
     +/     
     +/'This procedure is designed for situations where a matrix has' 
     +/'a special structure: one column is an independent variable, and' 
     +/'the other columns are to be plotted as functions of this' 
     +/'independent variable. If the columns have variable scales you' 
     +/'can choose to plot some columns as y(x), i.e. using the left' 
     +/'hand scale and some as z(x), i.e. using the right hand scale.' 
     +/
     +/'Choose [Select items to be plotted] then proceed as follows.' 
     +/
     +/'1.`Choose the column to be used as the x variable by ticking'
     +/'  `box 1 for the column selected.' 
     +/'  `There can only be one x variable.' 
     +/'2.`Tick box 2 for the columns to be plotted with the left hand' 
     +/'  `scale. Tick box 3 for columns to be plotted with the right' 
     +/'  `hand scale. Tick box 4 for any columns to be left out, then' 
     +/'  `finally press [Apply] to activate the selection.' 
     +/'3.`Edit the title and legends as required then plot.') 
  300 format (
     + 'Plotting selected rows'
     +/     
     +/'This procedure is designed for situations where a matrix has' 
     +/'a special structure: one row is an independent variable, and' 
     +/'the other rows are to be plotted as functions of this' 
     +/'independent variable. If the rows have variable scales you' 
     +/'can choose to plot some rows as y(x), i.e. using the left' 
     +/'hand scale and some as z(x), i.e. using the right hand scale.' 
     +/
     +/'Choose [Select items to be plotted] then proceed as follows.' 
     +/
     +/'1.`Choose the row to be used as the x variable by ticking'
     +/'  `box 1 for the row selected.' 
     +/'  `There can only be one x variable.' 
     +/'2.`Tick box 2 for rows to be plotted with the left hand' 
     +/'  `scale. Tick box 3 for rows to be plotted with the right' 
     +/'  `hand scale. Tick box 4 for any rows to be left out, then' 
     +/'  `finally press [Apply] to activate the selection.' 
     +/'3.`Edit the title and legends as required then plot.')      
      end
c
c      
         
