C
C
      SUBROUTINE DBPLOT$(JFILES, LFILES, MFILES, NFILES,
     +                   FILES, TITLES,
     +                   LEFT_AXIS)
C
C ACTION  : Supply coordinate files and create a two-scale x,y,z graph
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           04/10/2010 derived from SMPLOT$ 
C           02/11/2010 added SIZE and WIDE to argumebnt list to SYMBOL
C           11/11/2010 corrected the test required to call SMPLOT
C           01/12/2010 added call to LABELS
C           31/12/2010 added call to TXTKEY
C           19/01/2011 no longer deletes files supplied 
C           23/04/2011 now calls LABELS with dimension = 20
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C           26/09/2011 made IFILL, IHUE, and FACTOR dimension NXTRA = NWORDS
C           25/08/2014 ensured arguments are saved/restored for calls to W_SYMBOL
C
C           JFILES: (input/unchanged) = JCOLOR vector (colours)
C           LFILES: (input/unchanged) = L vector (line types)
C           MFILES: (input/unchanged) = M vector (symbol types)
C           NFILES: (input/unchanged) = number of files
C            FILES: (input/unchanged) = FSAV (coordinate files)
C           TITLES: (input/unchanged) = title, x-, y-, z-legends
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NFILES
      INTEGER,             INTENT (IN) :: JFILES(NFILES), 
     +                                    LFILES(NFILES),
     +                                    MFILES(NFILES)
      CHARACTER (LEN = *), INTENT (IN) :: FILES(NFILES), TITLES(4)
      LOGICAL,             INTENT (IN) :: LEFT_AXIS(NFILES) 
C
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4,
     +           NIN, N_LEFT, NMAX, NWORDS, NXTRA
      PARAMETER (NGRAFS = 300, NGRAF2 = 2*NGRAFS, NGRAF3 = 3*NGRAFS,
     +           NGRAF4 = 4*NGRAFS, KPANEL = NGRAFS, NIN = 3,
     +           NWORDS = 2000, NXTRA = NWORDS)
      INTEGER    ISEND, JSEND
      PARAMETER (ISEND = 1, JSEND = 4)
      INTEGER    N0, N1, N20, N40
      PARAMETER (N0 = 0, N1 = 1, N20 = 20, N40 = 40)
      INTEGER    JCOLOR(NGRAFS), L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    J_SAV(20), K_SAV(20), L_SAV(20), M_SAV(20)
      INTEGER    I, NCOL, NMAX1, NROW
      INTEGER    IFILL(NXTRA), IHUE(NXTRA)
      DOUBLE PRECISION SIZE(NGRAFS), WIDE(5*NGRAFS)
      DOUBLE PRECISION SIZE_SAV(20), WIDE_SAV(20)
      DOUBLE PRECISION FACTOR(NXTRA)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40,
     +           VECTORS(60)*40 
      CHARACTER  TITLES_COPY(4)*50
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GKSGRF$, SYMBOL, ISITMF, TMPDEL, SMPLOT$, LABELS,
     +           TXTKEY
      EXTERNAL   DEFGKS$, PLTOBJ$

C
C Check data supplied to make sure there are some Y and/or Z data sets
C
      IF (NFILES.LT.N1) RETURN
      N_LEFT = N0  
      DO I = N1, NFILES  
         IF (LEFT_AXIS(I)) N_LEFT = N_LEFT + N1
      ENDDO
      IF (N_LEFT.EQ.NFILES) THEN
C
C All the plots are intended for the Y i.e. LH axis
C        
         CALL SMPLOT$(JFILES, LFILES, MFILES, NFILES,
     +                FILES, TITLES)
         RETURN
      ELSEIF (N_LEFT.EQ.N0) THEN
C
C All the plots are intended for the Z i.e. RH axis so, to avoid confusion,
C the Y and Z legends are interchanged before calling SMPLOT$ which
C will plot against the LH axis, although this can be moved interactively
C to the RH side if required by swapping Y and Z axes from the menu
C      
         TITLES_COPY(1) = TITLES(1)    
         TITLES_COPY(2) = TITLES(2)    
         TITLES_COPY(3) = TITLES(4)    
         TITLES_COPY(4) = TITLES(3)
         CALL SMPLOT$(JFILES, LFILES, MFILES, NFILES,
     +                FILES, TITLES_COPY)
         RETURN    
      ENDIF        
C
C Initialise plotting surface
C      
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Allocate workspaces
C
      NMAX = NWORDS
      DO I = N1, NFILES
         CALL ISITMF (NCOL, NROW,
     +                FILES(I))
         IF (NROW.GT.NMAX) NMAX = NROW
      ENDDO
C
C Initialise all the array variables (except for coordinates)
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N1
         M(I) = N1
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
      DO I = N1, NXTRA
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
      ENDDO  
C
C Retrieve the default arguments using ISEND = 1
C
      CALL LABELS (ISEND, IHUE, IFILL,
     +             LABEL1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO                
      CALL SYMBOL (ISEND, J_SAV, K_SAV, L_SAV, M_SAV,
     +             SIZE_SAV, WIDE_SAV)
      DO I = N1, N20
         JCOLOR(I) = J_SAV(I)
         L(I) = L_SAV(I)
         M(I) = M_SAV(I)
      ENDDO   
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE) 
C
C Copy the data supplied into the arguments to GKSGRF$ then call GKSGRF$
C
      NFILE1 = NFILES
      DO I = N1, NFILE1
         JCOLOR(I) = JFILES(I)
         L(I) = LFILES(I)
         M(I) = MFILES(I)
         FSAV(I) = FILES(I)
         YAXIS(I) = LEFT_AXIS(I)
      ENDDO
C
C Install the new arguments using JSEND = 4
C
      CALL SYMBOL (JSEND, JCOLOR, K_SAV, L, M,
     +             SIZE_SAV, WIDE_SAV)      
      BAR_CHART = .FALSE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .TRUE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.

      NMAX1 = NMAX
      
      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE, 
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete all temporary files of the type f$123456.tmp used for plotting 
C
      CALL TMPDEL (NFILES,
     +             FSAV1) 
C
C Restore the default arguments using JSEND = 4
C
      CALL SYMBOL (JSEND, J_SAV, K_SAV, L_SAV, M_SAV,
     +             SIZE_SAV, WIDE_SAV)             
      END
C
C
