C
C DECGKS$
C =======
C
C Controls the SIMPLOT main window (not surfaces)
C
C INIT_1$ has been called to set up the window, then FINISH_2$ is
C called to close it down and return NPRESS to control further action
C
      SUBROUTINE DECGKS$(NPRESS,
     +                   XCLIP, YCLIP,
     +                   ABORT, FIRST, GSAVE)
C
C ACTION : Decide options after displaying a GKS plot
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,26/1/92
C          15/12/1993 Added call to PCX
C          01/02/1994 Added calls to DBOS menu type routines
C          23/06/1994 Masked off lower RHS legend
C          28/10/1994 Extensively rewritten
C          20/11/1994 PS added
C          30/11/1994 Added PCX to SAVE since removed from argument list
C          26/01/1995 Removed MONO and VIDEO
C          04/11/1996 Added XCLIP, YCLIP
C          21/05/1997 Extensive revision for win32 version
C          08/01/1998 Introduced HANDL2 = ictrl, HANDL5 = xres, HANDL6 = yres
C                     so a bit map can be displayed while GKSSTY is called
C                     for menus
C          07/08/1998 removed topmost
C          19/09/1999 overhauled mechanism for displaying screen bit map
C                     during calls to the menus
C          29/10/2000 suppressed intermediate display of screen bitmap
C          03/10/2000 removed .bmp file options and simplified
C          13/11/2000 NPRESS = 23 now prints directly and NPRESS = 22
C                     invokes PostScript directly
C          19/02/2007 introduced CLOSE_PRINTER and INTENTS 
C          14/06/2007 removed defngks.ins and introduced GKSGET and GKSPUT routines 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: NPRESS
      DOUBLE PRECISION, INTENT (INOUT) :: XCLIP(2), YCLIP(2)
      LOGICAL,          INTENT (IN)    :: FIRST, GSAVE    
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, IFAIL, ISEND, CLOSE_PRINTER 
      INTEGER    HANDL1, NOUT_PS
      INTEGER    N0, N1, N2, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N5 = 5, N6 = 6)
      CHARACTER  FNAME*1024
      LOGICAL    DOTMAT, HARD_COPY, PCL, PS
      LOGICAL    YES
      EXTERNAL   WGB2PS$, FINISH_2$, PUTADV$, DEFGKS$ 
      EXTERNAL   GETGKS_EPS, GETGKS_HND, GETGKS_LGL, PUTGKS_LGL
      EXTERNAL   CLOSE_PRINTER
      SAVE       FNAME
      IF (GSAVE) IFAIL = 1!to silence ftn95...GSAVE is not used now
      IF (FIRST) THEN
C
C First time set up defaults then RETURN
C        
         CALL DEFGKS$
         RETURN
      ENDIF
C
C Now called after the graph has been created
C                   
      CALL GETGKS_LGL (N1,
     +                 DOTMAT)
      CALL GETGKS_LGL (N5,
     +                 PCL)
      CALL GETGKS_EPS (NOUT_PS,
     +                 PS)    
      IF (PS) THEN
C
C PostScript file has been created
C
         CALL WGB2PS$(IFAIL, NOUT_PS,
     +                XCLIP, YCLIP, 
     +               'CLOSE', FNAME)
         PS = .FALSE. 
         CALL PUTGKS_LGL (N6,
     +                    PS)    
         NPRESS = 0
         RETURN
      ELSEIF (PCL) THEN
C
C PCL output has taken place to printer
C                  
         ISEND = 1
         CALL GETGKS_HND (ISEND, HANDL1)
         IFAIL = CLOSE_PRINTER (HANDL1)
         IF (IFAIL.EQ.1) THEN
            CALL PUTADV$(
     +'The plot has been copied to the printer (or file)')
         ELSE
            CALL PUTADV$('The printer cannot be closed ... Investigate')
         ENDIF  
         PCL = .FALSE.
         CALL PUTGKS_LGL (N5,
     +                    PCL)         
         NPRESS = 0
         RETURN
      ELSEIF (DOTMAT) THEN
C
C DOTMAT = .TRUE. this should not happen with this version
C
         DOTMAT = .FALSE.   
         CALL PUTGKS_LGL (N1,
     +                    DOTMAT)         
         NPRESS = 0
         RETURN
      ENDIF
C
C Now call FINISH_2 to get the next decision
C        
      DOTMAT = .FALSE.
      DO I = 1, 6 
         ISEND = I
         CALL PUTGKS_LGL (ISEND,
     +                    DOTMAT)         
      ENDDO
      
      CALL FINISH_2$(NPRESS, YES)

      IF (NPRESS.EQ.22) THEN
C
C PostScript
C
         CALL WGB2PS$(IFAIL, NOUT_PS,
     +                XCLIP, YCLIP,
     +               'OPEN', FNAME)
         IF (IFAIL.EQ.N0) THEN
            HARD_COPY = .TRUE.
            CALL PUTGKS_LGL (N2,
     +                       HARD_COPY)             
            PS = .TRUE.  
            CALL PUTGKS_LGL (N6,
     +                       PS)            
            ABORT = .FALSE.
            NPRESS = 21
         ELSE
            HARD_COPY = .FALSE. 
            CALL PUTGKS_LGL (N2,
     +                       HARD_COPY)
            PS = .FALSE. 
            CALL PUTGKS_LGL (N6,
     +                       PS)   
            NPRESS = 0
         ENDIF
      ELSEIF (NPRESS.EQ.23) THEN
C
C PCL printer
C                            
         CALL GETGKS_LGL (N2,
     +                    HARD_COPY)
         CALL GETGKS_LGL (N5,
     +                    PCL)                
         IF (.NOT.HARD_COPY .AND. .NOT.PCL) NPRESS = 0
      ENDIF
      END
C
C
