c
c
      subroutine defkey (isend, jsend,
     +                   key,
     +                   store) 
c
c action: define or retrieve a character key
c author: w.g.bardsley, university of manchester, u.k., 29/12/2010
c
c isend = 1: titles
c isend = 2: panels
c isend = 3: labels
c isend = 4: x_tic labels
c
c Advice about keys in subroutines deflab, deflbl, defkey, and txtkey 
c -------------------------------------------------------------------
c deflab ... Re-initialises changes made to the keys by
c            any previous calls to defkey for n =< 20 then
c            passes the new values on to deflbl.
c            Note that deflab cancels any existing changes made by defkey
c deflbl ... Passively writes the arguments supplied to the configuration
c            file w_labels.cfg. 
c defkey ... Overwrites current keys but has lower priority than deflab.
c            Note that in normal use then defkey will override default keys
c            but calls to deflab take priority and will re-initialise keys.
c            So calls to defkey made after calls to deflab will change the
c            current keys but not the defaults.
c txtkey ... This uses keys altered by defkey after calls to deflab to 
c            temporarily override the defaults.  
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: isend, jsend
      character (len = *), intent (inout) :: key
      logical,             intent (in)    :: store 
c
c locals
c      
      integer   i, n
      external  savchr$   
      intrinsic len
c
c make sure key is always defined if store = .false.
c      
      if (.not.store) then
         n = len(key)
         do i = 1, n
            key(i:i) = '0'
         enddo   
      endif
c
c if 1 =< isend =< 4 call savchr$
c      
      if (isend.ge.1 .and. isend.le.4) then
         call savchr$ (isend, jsend,
     +                 key,
     +                 store)
      endif
      end
c
c                