c
c
      subroutine deflab (isend, n,
     +                   text,
     +                   store)
c
c action: call deflbl for n elements where 1 =< n =< nmax
c author: w.g.bardsley, university of manchester, u.k., 13/02/2011
c         25/04/2011 increased nmax to 20 
c         10/07/2011 added isend = 5 and 6, and re-initialises keys 
c         16/09/2011 removed modulw and added calls to savpnl$
c
c Advice about keys in subroutines deflab, deflbl, defkey, and txtkey 
c -------------------------------------------------------------------
c deflab ... Re-initialises changes made to the keys by
c            any previous calls to defkey for n =< 20 then
c            passes the new values on to deflbl.
c            Note that deflab cancels any existing changes made by defkey
c deflbl ... Passively writes the arguments supplied to the configuration
c            file w_labels.cfg. 
c defkey ... Overwrites current keys but has lower priority than deflab.
c            Note that in normal use then defkey will override default keys
c            but calls to deflab take priority and will re-initialise keys.
c            So calls to defkey made after calls to deflab will change the
c            current keys but not the defaults.
c txtkey ... This uses keys altered by defkey after calls to deflab to 
c            temporarily override the defaults.  
c 
c isend: isend = 1 ... use/install default plot-labels
c        isend = 2 ... use/install default panel-labels 
c        isend = 3 ... use/install default plot-label keys
c        isend = 4 ... use/install default panel-label keys 
c        isend = 5 ... use/install default X-tic-labels 
c        isend = 6 ... use/install default X_tic-label keys 
c  text: isend = 1 ... contains/returns default plot-labels
c        isend = 2 ... contains/returns default panel-labels 
c        isend = 3 ... contains/returns default plot-label keys
c        isend = 4 ... contains/returns default panel-label keys 
c        isend = 5 ... contains/returns default X_tic-labels 
c        isend = 6 ... contains/returns default X_tic-label keys 
c store: store = .true. store text
c        store = .false. retrieve text
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: isend, n
      character (len = *), intent (inout) :: text(n)     
      logical,             intent (in)    :: store
c
c locals
c      
      integer    i, j,  k 
      integer    nmax
      parameter (nmax = 20)
      character (len = 40) labels(nmax), x_pskeys
      character (len = 40) labvec_1, psymb_1, wordy_1
      character (len = 100) line 
      logical    labvec_1_new, psymb_1_new, wordy_1_new 
      logical    store1
      parameter (store1 = .false.)
      external   putfat$, deflbl, x_pskeys, savpnl$
c
c check n
c      
      if (n.lt.1 .or. n.gt.nmax) then
         write (line,100) nmax
         call putfat$ (line)
         return
      endif
c
c get current defaults
c     
      call deflbl (isend,
     +             labels,
     +             store1)
      if (store) then
         do i = 1, n
            k = i
            if (isend.eq.3 .or. isend.eq.4 .or. isend.eq.6) then
               labels(i) = x_pskeys(text(i))
            else   
               labels(i) = text(i)
            endif   
            if (isend.eq.3) then
               labvec_1 = labels(i)
               labvec_1_new = .false.
               j = 1
               call savpnl$(j, k, 
     +                      labvec_1, labvec_1_new,
     +                      store)              
            elseif (isend.eq.4) then
               psymb_1 = labels(i)
               psymb_1_new = .false.
               j = 2
               call savpnl$(j, k, 
     +                      psymb_1, psymb_1_new,
     +                      store)
            elseif (isend.eq.6) then
               wordy_1 = labels(i)
               wordy_1_new = .false.
               j = 3
               call savpnl$(j, k, 
     +                      wordy_1, wordy_1_new,
     +                      store)
            endif   
                  
         enddo 
         call deflbl (isend,
     +                labels,
     +                store)
      else
         do i = 1, n
            text(i) = labels(i)
         enddo
      endif 
c
c format statement
c                  
  100 format ('deflab must be called with 1=< n =<',i3)       
      end
c
c      