c
c
      subroutine deflbl (isend,
     +                   text,
     +                   store) 
c
c action: store/retrieve 20 default plot-labels, panel-labels, or associated character keys     
c author: w.g.bardsley, university of manchester, u.k., 31/12/2010
c         23/04/2011 increased dimension to 20
c         06/07/2011 added wordx_1 and vectors_1 in call to labels, added x_pskeys and deleted txtkey
c
c isend: isend = 1 ... use default plot-labels
c        isend = 2 ... use default panel-labels 
c        isend = 3 ... use default plot-label keys
c        isend = 4 ... use default panel-label keys 
c        isend = 5 ... use default X-tic labels   
c        isend = 6 ... use default X-tic label keys   
c  text: isend = 1 ... contains/returns default plot-labels
c        isend = 2 ... contains/returns default panel-labels 
c        isend = 3 ... contains/returns default plot-label keys
c        isend = 4 ... contains/returns default panel-label keys 
c        isend = 5 ... contains/returns default X_tic labels 
c        isend = 6 ... contains/returns default X_tic keys
c store: store = .true. store text
c        store = .false. retrieve text
c
c Advice about keys in subroutines deflab, deflbl, defkey, and txtkey 
c -------------------------------------------------------------------
c deflab ... Re-initialises changes made to the keys by
c            any previous calls to defkey for n =< 20 then
c            passes the new values on to deflbl.
c            Note that deflab cancels any existing changes made by defkey
c deflbl ... Passively writes the arguments supplied to the configuration
c            file w_labels.cfg. 
c defkey ... Overwrites current keys but has lower priority than deflab.
c            Note that in normal use then defkey will override default keys
c            but calls to deflab take priority and will re-initialise keys.
c            So calls to defkey made after calls to deflab will change the
c            current keys but not the defaults.
c txtkey ... This uses keys altered by defkey after calls to deflab to 
c            temporarily override the defaults.  
c
      implicit none
c
c arguments
c       
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: text(20)
      logical,             intent (in)    :: store
c
c locals
c      
      integer    i, jcolor(20), jfill(20)
      integer    jsend_1, jsend_4
      parameter (jsend_1 = 1, jsend_4 = 4)
      character (len = 40) label_1(20), panel_1(20), 
     +                     wordx_1(20), vectors_1(60)
      character (len = 40) x_pskeys
      external   labels
      external   x_pskeys
c
c check that isend is in range
c      
      if (isend.lt.1 .or. isend.gt.6) return 
c
c retrieve the defaults
c        
      call labels (jsend_1, jcolor, jfill,
     +             label_1, panel_1, wordx_1, vectors_1)
c
c store/retrieve depending on the input arguments isend and store
c      
      if (store) then
         if (isend.eq.1) then
            call labels (jsend_4, jcolor, jfill,
     +                   text, panel_1, wordx_1, vectors_1)
         elseif (isend.eq.2) then
            call labels (jsend_4, jcolor, jfill,
     +                   label_1, text, wordx_1, vectors_1)
         elseif (isend.eq.3) then
            do i = 1, 20
               vectors_1(i) = x_pskeys(text(i))
            enddo  
            call labels (jsend_4, jcolor, jfill,
     +                   label_1, panel_1, wordx_1, vectors_1)    
         elseif (isend.eq.4) then
            do i = 1, 20
               vectors_1(i + 20) = x_pskeys(text(i))
            enddo  
            call labels (jsend_4, jcolor, jfill,
     +                   label_1, panel_1, wordx_1, vectors_1)    
         elseif (isend.eq.5) then
            call labels (jsend_4, jcolor, jfill,
     +                   label_1, panel_1, text, vectors_1)    
          elseif (isend.eq.6) then
            do i = 1, 20
               vectors_1(i + 40) = x_pskeys(text(i))
            enddo  
            call labels (jsend_4, jcolor, jfill,
     +                   label_1, panel_1, wordx_1, vectors_1)    
         endif
      else
         do i = 1, 20
            if (isend.eq.1) then
               text(i) = label_1(i)
            elseif (isend.eq.2) then
               text(i) = panel_1(i)
            elseif (isend.eq.3) then
               text(i) = vectors_1(i)
            elseif (isend.eq.4) then
               text(i) = vectors_1(i + 20)  
            elseif (isend.eq.5) then
               text(i) = wordx_1(i)
            else
               text(i) = vectors_1(i + 40)              
            endif
         enddo
      endif
      end
c
c               
               
                              
      


      