C
C
      SUBROUTINE DEFOLT$(ISHAPE,
     +                   KANGLE, KCOLOR, KPANEL, LCOLOR,
     +                   MTRANS, MTSAV, MXDROP, MXTIC, MYTIC, MZTIC,
     +                   NCFONT, NFILES, NFSAV, NGRAFS, NKCOL, NLOG,
     +                   NTFONT, NTYPE1, NTYPE2, NTYPE3, NWORDS, NXFONT,
     +                   NY, NYFONT, NZ,
     +                   DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   PSCALE,
     +                   SIZE, SPC, SPT, SPX, SPY, THICK, WIDE,
     +                   XCLIP,
     +                   XPC, XPDRAG, XPMAX, XPMIN, XPT, XPX, XPY,
     +                   YCLIP, YDROP,
     +                   YMAX3, YMAX4, YMIN3, YMIN4, YPDRAG, YPMAX,
     +                   YPMIN, YSCALE, ZSCALE,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   PTITLE, QTITLE,
     +                   WORDX, WORDY, XTITLE, YTITLE, ZTITLE,
     +                   BAR_CHART, BORDER, BRAY_CURTIS, CENTRE,
     +                   EXTEND_LINES,
     +                   GRATICULE, MONO, MONO_SAV, NATLOG, NUMBRX,
     +                   PANEL_LINES, PANEL_SYMBOLS,
     +                   PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ, PIE_CHART, PLOT_LABELS,
     +                   PLOT_TITLE, PLOTX, PLOTY, PLOTZ,
     +                   POWERX, POWERY, POWERZ, PSHOW, ROTATE,
     +                   SHOW_BACKGROUND, SHOW_QUADRANTS,
     +                   SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                   SWAP_YZ, THREE_D, TWO_PLOTS,
     +                   VIDEO, VIDEO_SAV, XGRID, XTOINT, YGRID, YTOINT,
     +                   YVERT,  ZTOINT)
C
C
C ACTION : Defaults for SIMPLOT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/6/95
C          14/07/1997 win32 version
C          22/07/1999 adjusted for extended transformation scheme
C          01/02/2000 transformed NATLOG into NATLOG(NLOG)
C          18/02/2000 added DRAGTI, DRAGXL, DRAGYL, DRAGZL, PCENTX,
C                     PCENTY, PCENTZ
C          23/02/2000 added PHIGHX, PHIGHY, PHIGHZ
C          10/04/2001 set KCOLOR(6) = 21, KCOLOR(7) = 22
C          20/07/2001 added SHOW_XAXIS
C          10/08/2001 added BRAY_CURTIS and PLOT_LABELS
C          15/08/2001 added MXDROP and YDROP
C          08/09/2001 added THREE_D
C          05/04/2002 added extra code to initialise ARRAYY in /CHECKMATE
C          07/01/2003 redimenioned WIDE(5*GRAFS)
C          15/10/2004 added call to SYMBOL to initialise KCOLOR
C          21/10/2004 added SHOW_BACKGROUND and SHOW_QUADRANTS
C          12/11/2004 set LCOLOR = KCOLOR(8) after call to SYMBOL
C          19/08/2005 added EXTEND_LINES 
C          20/05/2007 added INTENTS 
C          30/07/2009 added calls to GRFLGL$, GFRTIC$, and GRFSIG$
C          26/08/2009 new version of GRFSIG$
C          21/10/2009 improved version of GRFSIG$  
C          02/11/2010 added SIZE and WIDE to argument list to SYMBOL
C          01/12/2010 deleted PLINE from argument list
C          28/12/2010 deleted PSYM, LABEL and LABVEC from argument list 
C          20/01/2011 added calls to SAVCHR$ to imitialise QTITLE and ARRAYQ
C          08/02/2011 added call to GRFLGL to set BORDER 
C          11/02/2011 added call to GRFLGL to set PANEL_LINES and PANEL_SYMBOLS
C          24/04/2011 increased dimensions to 20 in call to SYMBOL
C
C          Note: FIRST is not set to .FALSE. in this version so it
C                forces re-initialisation         
C
      IMPLICIT    NONE
C
C Argument list
C
      INTEGER,             INTENT (IN)    :: NGRAFS, NKCOL, NLOG,
     +                                       NWORDS, KPANEL
      INTEGER,             INTENT (INOUT) :: ISHAPE,
     +                                       KANGLE, KCOLOR(NKCOL),
     +                                       LCOLOR, MTRANS, MTSAV,
     +                                       MXDROP, MXTIC, MYTIC,
     +                                       MZTIC, NCFONT, NFILES,
     +                                       NFSAV, NTYPE1, NTYPE2,
     +                                       NTYPE3, NTFONT, NXFONT,
     +                                       NY, NYFONT, NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: DRAGTI, DRAGXL, DRAGYL,
     +                                       DRAGZL, PSCALE,
     +                                       SIZE(NGRAFS), SPC, SPT,
     +                                       SPX, SPY, THICK,
     +                                       WIDE(5*NGRAFS), XCLIP(2),
     +                                       XPC, XPDRAG, XPMAX, XPMIN,
     +                                       XPT, XPX, XPY, YCLIP(2),
     +                                       YDROP, YMAX3, YMAX4, YMIN3,
     +                                       YMIN4, YPDRAG, YPMAX,
     +                                       YPMIN, YSCALE, ZSCALE
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAYQ, ARRAYT(0:15),
     +                                       ARRAYX(0:15), ARRAYY(0:15),
     +                                       ARRAYZ(0:15),
     +                                       PTITLE(0:15),
     +                                       QTITLE,
     +                                       WORDX(NWORDS),
     +                                       WORDY(NWORDS),
     +                                       XTITLE(0:15), YTITLE(0:15),
     +                                       ZTITLE(0:15)
      LOGICAL,             INTENT (INOUT) :: BAR_CHART, PIE_CHART,
     +                                       TWO_PLOTS
      LOGICAL,             INTENT (OUT)   :: BORDER,
     +                                       PANEL_LINES, PANEL_SYMBOLS
      LOGICAL,             INTENT (INOUT) :: BRAY_CURTIS,
     +                                       CENTRE, EXTEND_LINES,
     +                                       GRATICULE, MONO, MONO_SAV,
     +                                       NATLOG(NLOG), NUMBRX,
     +                                       PCENTX, PCENTY, PCENTZ,
     +                                       PHIGHX, PHIGHY, PHIGHZ,
     +                                       PLOT_LABELS, 
     +                                       PLOT_TITLE,
     +                                       PLOTX(NWORDS), 
     +                                       PLOTY(NWORDS),
     +                                       PLOTZ(NWORDS),
     +                                       POWERX, POWERY, POWERZ,
     +                                       PSHOW(KPANEL), ROTATE,
     +                                       SHOW_BACKGROUND,
     +                                       SHOW_QUADRANTS,
     +                                       SHOW_XAXIS, SHOW_YAXIS,
     +                                       SHOW_ZAXIS,
     +                                       SWAP_YZ, THREE_D, 
     +                                       VIDEO, VIDEO_SAV, XGRID,
     +                                       XTOINT, YGRID, YTOINT,
     +                                       YVERT, ZTOINT
C
C Locals
C
      INTEGER    JSEND, NLGL
      PARAMETER (JSEND = 3, NLGL = 12) 
      INTEGER    ISEND, KSEND, NSYMB
      PARAMETER (ISEND = 1, KSEND = 0, NSYMB = 200)
      INTEGER    JTEMP(20), LTEMP(20), MTEMP(20)
      INTEGER    I, J, JCOUNT, K, KCOUNT, LEN200, NFIG, NSIG
      INTEGER    NGRAF2, NGRAF3, NGRAF4
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BIGNUM, X02AME$
      CHARACTER  SYMB*(NSYMB)
      LOGICAL    LGLVAR(NLGL)
      LOGICAL    FIRST, SETUP
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   X02AME$, GRFSIG$, GRFLGL$, GRFTIC$, SAVCHR$
      EXTERNAL   LEN200, SYMBOL
      INTRINSIC  LEN
      SAVE       FIRST, JCOUNT, KCOUNT
      DATA       JCOUNT, KCOUNT / 0, 0 /
      DATA       FIRST / .TRUE. /
C
C First time round initialise everything
C
      IF (FIRST) THEN
C********FIRST = .FALSE.! THIS MUST REMAIN COMMENTED OUT FOR THIS VERSION        
         KANGLE = 1
         MTSAV = 10
         MXDROP = 40
         NCFONT = 102
         NFILES = 0
         NFSAV = 0
         NTFONT = 106
         NXFONT = 106
         NYFONT = 106
C
C Drag factors to fine tune title and legends
C
         DRAGTI = ZERO
         DRAGXL = ZERO
         DRAGYL = ZERO
         DRAGZL = ZERO
         YDROP = 0.05D+00
C
C Labels for x-axis
C
         DO I = 1, NWORDS
            WRITE (WORDX(I),200) I
            WORDY(I) = '000000000000000000000000000000'
            PLOTX(I) = .TRUE.
            PLOTY(I) = .TRUE.
            PLOTZ(I) = .TRUE.
         ENDDO
C
C Data for information panel
C
         DO I = 1, KPANEL
            PSHOW(I) = .FALSE.
         ENDDO
C
C Line and symbol types and colours
C
         NGRAF2 = 2*NGRAFS
         NGRAF3 = 3*NGRAFS
         NGRAF4 = 4*NGRAFS
         DO I = 1, NGRAFS
            SIZE(I) = ONE
            WIDE(I) = ONE
            WIDE(I + NGRAFS) = ONE
            WIDE(I + NGRAF2) = ONE
            WIDE(I + NGRAF3) = ONE
            WIDE(I + NGRAF4) = ONE
         ENDDO
         CALL SYMBOL (ISEND, JTEMP, KCOLOR, LTEMP, MTEMP,
     +                SIZE, WIDE)
         LCOLOR = KCOLOR(8)
         SPC = ZERO
         SPT = ZERO
         SPX = ZERO
         SPY = ZERO
         THICK = ONE
         XPC = 1.2D+00
         XPT = 1.5D+00
         XPX = 1.3D+00
         XPY = 1.3D+00
         XCLIP(1) = ZERO
         XCLIP(2) = ONE
         YCLIP(1) = ZERO
         YCLIP(2) = ONE
C
C Titles and legends
C
         PTITLE(0) = 'Original Axes'
         PTITLE(1) = 'Reversed Axes'
         PTITLE(2) = 'Dixon Plot'
         PTITLE(3) = 'Single Reciprocal Plot'
         PTITLE(4) = 'Lineweaver-Burk Plot'
         PTITLE(5) = 'Scatchard Plot'
         PTITLE(6) = 'Eadie-Hofstee Plot'
         PTITLE(7) = 'Hanes Plot'
         PTITLE(8) = 'X-semilog Plot'
         PTITLE(9) = 'Y-semilog Plot'
         PTITLE(10) = 'Log-Log Plot'
         PTITLE(11) = 'Hill Plot'
         PTITLE(12) = 'Dilution Curve'
         PTITLE(13) = 'Reverse Y-semilog'
         PTITLE(14) = 'Reverse X-semilog'
         PTITLE(15) = 'Reverse Log-Log'
         I = 1
         J = 6
         CALL SAVCHR$(I, J, 
     +                QTITLE,
     +                STORE)        
         XTITLE(0) = 'x'
         XTITLE(1) = 'y'
         XTITLE(2) = 'x'
         XTITLE(3) = '1/x'
         XTITLE(4) = '1/x'
         XTITLE(5) = 'y'
         XTITLE(6) = 'y/x'
         XTITLE(7) = 'x'
         XTITLE(8) = 'log x'
         XTITLE(9) = 'x'
         XTITLE(10) = 'log x'
         XTITLE(11) = 'log x'
         XTITLE(12) = 'log[1/x]'
         XTITLE(13) = 'log[y]'
         XTITLE(14) = 'y'
         XTITLE(15) = 'log[y]'
         YTITLE(0) = 'y'
         YTITLE(1) = 'x'
         YTITLE(2) = '1/y'
         YTITLE(3) = 'y'
         YTITLE(4) = '1/y'
         YTITLE(5) = 'y/x'
         YTITLE(6) = 'y'
         YTITLE(7) = 'x/y'
         YTITLE(8) = 'y'
         YTITLE(9) = 'log y'
         YTITLE(10) = 'log y'
         YTITLE(11) = 'log[y/(A-y)]'
         YTITLE(12) = 'y'
         YTITLE(13) = 'x'
         YTITLE(14) = 'log[x]'
         YTITLE(15) = 'log[x]'
C
C Next 3 loops and code using SYMB are over-kill but seem to be needed for
C ftn95 in /checkmate which still has difficulty with character functions
C
         DO I = 0, 15
            ZTITLE(I) = 'E'
            ARRAYT(I) = '0'
            ARRAYX(I) = '0'
            ARRAYY(I) = '0'
            ARRAYZ(I) = '0'
         ENDDO
         DO I = 1, NSYMB
            SYMB(I:I) = '0'
         ENDDO
         DO I = 0, 15
            J = LEN200(PTITLE(I))
            K = LEN(PTITLE(I))
            IF (J.GT.1 .AND. J.LE.K) ARRAYT(I)(1:J) = SYMB(1:J)
            J = LEN200(XTITLE(I))
            K = LEN(XTITLE(I))
            IF (J.GT.1 .AND. J.LE.K) ARRAYX(I)(1:J) = SYMB(1:J)
            J = LEN200(YTITLE(I))
            K = LEN(YTITLE(I))
            IF (J.GT.1 .AND. J.LE.K) ARRAYY(I)(1:J) = SYMB(1:J)
            J = LEN200(ZTITLE(I))
            K = LEN(ZTITLE(I))
            IF (J.GT.1 .AND. J.LE.K) ARRAYZ(I)(1:J) = SYMB(1:J)
         ENDDO
         I = 1
         J = 5
         CALL SAVCHR$(I, J,
     +                ARRAYQ,
     +                STORE)           
         BRAY_CURTIS = .FALSE.
         CENTRE = .TRUE.
         EXTEND_LINES = .TRUE.
         GRATICULE = .FALSE.
         PLOT_LABELS = .FALSE.
         PLOT_TITLE = .TRUE.
C
C Overall format
C
         ISHAPE = 1
         PSCALE = ONE
         ZSCALE = ONE
         XPDRAG = ZERO
         YPDRAG = ZERO
         POWERX = .FALSE.
         POWERY = .FALSE.
         POWERZ = .FALSE.
         MONO = .FALSE.
         MONO_SAV = .FALSE.
         DO I = 1, NLOG
            NATLOG(I) = .FALSE.
         ENDDO
         NATLOG(10) = .TRUE.
         NUMBRX = .TRUE.
         PCENTX = .FALSE.
         PCENTY = .FALSE.
         PCENTZ = .FALSE.
C
C Set tic marks, significant figures for axes labels and logical variables
C 
         CALL GRFTIC$(JSEND, MXTIC,
     +                'X')
         CALL GRFTIC$(JSEND, MYTIC,
     +                'Y')
         CALL GRFTIC$(JSEND, MZTIC,
     +                'Z')         
         PHIGHX = .TRUE.
         PHIGHY = .TRUE.
         PHIGHZ = .TRUE.
         NFIG = 3
         NSIG = 2
         DO I = 0, 23
            J = I
            CALL GRFSIG$(ISEND, J, NFIG, NSIG,
     +                   'X')
            CALL GRFSIG$(ISEND, J, NFIG, NSIG,
     +                   'Y')
            CALL GRFSIG$(ISEND, J, NFIG, NSIG,
     +                   'Z')
            CALL GRFSIG$(KSEND, J, NFIG, NSIG,
     +                   'X')
            CALL GRFSIG$(KSEND, J, NFIG, NSIG,
     +                   'Y')
            CALL GRFSIG$(KSEND, J, NFIG, NSIG,
     +                   'Z')     
         ENDDO
         ROTATE = .FALSE.
         SHOW_BACKGROUND = .TRUE.
         SHOW_XAXIS = .TRUE.
         SHOW_YAXIS = .TRUE.
         SHOW_ZAXIS = .TRUE.
         SWAP_YZ = .FALSE.
         THREE_D = .FALSE.
         VIDEO = .FALSE.
         VIDEO_SAV = .FALSE.
         XTOINT = .FALSE.
         YTOINT = .FALSE.
         YVERT = .FALSE.
         ZTOINT = .FALSE.
         CALL GRFLGL$(JSEND, NLGL,
     +                LGLVAR)
         XGRID = LGLVAR(4)
         YGRID = LGLVAR(5)
         SHOW_QUADRANTS = LGLVAR(6) 
         PANEL_LINES = LGLVAR(10)
         PANEL_SYMBOLS = LGLVAR(11)
         BORDER = LGLVAR(12)
      ENDIF
C
C Check whether to re-use previous defaults if not a bar/pie chart
C
      IF (BAR_CHART) THEN
         JCOUNT = 0
         KCOUNT = 0
         SETUP = .FALSE.
      ELSEIF (PIE_CHART) THEN
         JCOUNT = 0
         KCOUNT = 0
         SETUP = .FALSE.
      ELSEIF (TWO_PLOTS) THEN
         JCOUNT = JCOUNT + 1
         KCOUNT = 0
      ELSE
         JCOUNT = 0
         KCOUNT = KCOUNT + 1
      ENDIF
      IF (JCOUNT.GT.1 .OR. KCOUNT .GT.1) THEN
         SETUP = .TRUE.
      ELSE
         SETUP = .FALSE.
      ENDIF
C
C Re-initialise not set-up
C
      IF (.NOT.SETUP) THEN
         CALL GRFTIC$(JSEND, MXTIC,
     +                'X')
         CALL GRFTIC$(JSEND, MYTIC,
     +                'Y')
         CALL GRFTIC$(JSEND, MZTIC,
     +                'Z')  
         ISHAPE = 1
         ZSCALE = ONE
         THICK = ONE
         DO I = 1, NLOG
            NATLOG(I) = .FALSE.
         ENDDO
         NATLOG(10) = .TRUE.
         NUMBRX = .TRUE.
         ROTATE = .FALSE.
         XTOINT = .FALSE.
         YTOINT = .FALSE.
         YVERT = .FALSE.
         ZTOINT = .FALSE.
         CALL GRFLGL$(JSEND, NLGL,
     +                LGLVAR)
         XGRID = LGLVAR(4)
         YGRID = LGLVAR(5)
      ENDIF
C
C The next parameters and counters must always be initialised
C
      MTRANS = 0
      NFILES = 0
      NTYPE1 = 0
      NTYPE2 = 0
      NTYPE3 = 0
      NY = 0
      NZ = 0
C
C BIGNUM used so YMAX3, YMAX4, YMIN3, YMIN4 can be re-set by GKSFIL$
C
      IF (BAR_CHART .OR. PIE_CHART) THEN
         BIGNUM = ONE
      ELSE
        BIGNUM = ONE/X02AME$()
      ENDIF
      XPMAX = ONE
      XPMIN = ZERO
      YMAX3 = - BIGNUM
      YMAX4 = - BIGNUM
      YMIN3 = BIGNUM
      YMIN4 = BIGNUM
      YPMAX = ONE
      YPMIN = ZERO
      YSCALE = ONE
C
C Special action if BAR_CHART
C
      IF (BAR_CHART) MXTIC = - 1
C
C Special action if TWO_PLOTS
C
      IF (TWO_PLOTS) THEN
         YTITLE(0) = 'y-LHS'
         ARRAYY(0) = '00000'
         ZTITLE(0) = 'y-RHS'
         ARRAYZ(0) = '00000'
      ENDIF
C
C Make sure ISHAPE, PSCALE, ZSCALE consistent
C
      IF (PLOT_TITLE) THEN
         ZSCALE = ONE
      ELSE
         ZSCALE = 0.9D+00
      ENDIF
      IF (ISHAPE.EQ.1) THEN
         PSCALE = ONE
      ELSEIF (ISHAPE.EQ.2) THEN
         PSCALE = 0.75D+00
         ZSCALE = 1.3333D+00*ZSCALE
      ELSEIF (ISHAPE.EQ.3) THEN
         PSCALE = 0.5D+00
         ZSCALE = 2.0D+00*ZSCALE
      ELSE
         PSCALE = ONE
      ENDIF
C
C Format statements
C      
C 100 FORMAT ('Label',I3)
  200 FORMAT ('Text',I3)
      END
C
C
