c
c
      subroutine dgplot (ilc, iuc, iord, n, nrmax,
     +                   cd, thresh, x,
     +                   ptitle, wordx, xtitle, ytitle)
c
c action: plot a dendrogram
c author: w.g.bardsley, university of manchester, U.K, 20/07/2001
c         derived from dendr1 
c         20/05/2007 added intents 
c         05/06/2007 added fname and sim256
c         20/12/2007 added nwmax = 2000 
c
c         After calling g03ecf$ the arguments are used to construct
c         an x array of succesive dendrogram hooks which are then
c         written to a file with the title %simfitdendrogramfile%.
c         smplot$ then calls the simplot plotting routines which
c         work out that a dendrogram is required from the title
c         of the file
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: n, nrmax
      integer,             intent (in)    :: ilc(n - 1), iuc(n - 1),
     +                                       iord(n)
      double precision,    intent (in)    :: cd(n - 1), thresh
      double precision,    intent (inout) :: x(nrmax,3)
      character (len = *), intent (in)    :: ptitle, wordx(n), xtitle,
     +                                       ytitle
c
c locals
c
      integer    i, j, k, l
      integer    ifail, nout
      integer    nmax, nwmax, n1, n2, n3, n4
      parameter (nmax = 3, nwmax = 2000, n1 = 1, n2 = 2, n3 = 3,
     +           n4 = 4)
      integer    jfiles(nmax), lfiles(nmax), mfiles(nmax), nfiles
      double precision zero, half
      parameter (zero = 0.0d+00, half = 0.5d+00)
      character  filex*1024, filey*1024, fname*1024, sim256*1024,
     +           title*80
      character  labfil*12 
c---------------------------------------------------------------------------------
c this next parameter must NOT be translated as it is the labels file for simplot
c      
      parameter (labfil = 'f$labels.tmp') 
c---------------------------------------------------------------------------------      
      character  files(nmax)*1024, titles(4)*80
      logical    askif, notyet, there
      parameter (askif = .false.)
      external   getnou, gettmp, deleet, putfat, sim256
      external   smplot$
      intrinsic  dble
      data       jfiles , lfiles, mfiles
     +         / nmax*0, nmax*1, nmax*0 /
c
c Open a temporary file and connect to a temporary unit
c
      call gettmp (ifail, 
     +             filex)
      call getnou (nout)
      open (unit = nout, file = filex)
c---------------------------------------------------
c The file title identifies the file type to simplot
c The next lines MUST NOT BE TRANSLATED
c
      if (n.le.nwmax) then
         title = '%simfitdendrogramfile%'  
      else
         title = '%simfitdendrogramfile%no_labels%'
      endif      
c---------------------------------------------------      
      write (nout,100) title
      write (nout,200) n4*(n - n1), n2
c
c Define x(i,1) = position of item i and initialise x(i,2) and x(i,3)
c
      do i = n1, n
         notyet = .true.
         do l = n1, n
            if (notyet) then
               if (i.eq.iord(l)) then
c
c The item has been encountered in the ordered list so assign
c
                  x(i,1) = dble(l)
                  notyet = .false.
               endif
            endif
         enddo
         x(i,n2) = zero
         x(i,n3) = zero
      enddo
c
c Go through the merge list generating the polylines
c
      do i = n1, n - n1
         j = ilc(i)
         k = iuc(i)
         x(j,n3) = cd(i)
         x(k,n3) = cd(i)
         write (nout,300) x(j,n1), x(j,n2)
         write (nout,300) x(j,n1), x(j,n3)
         write (nout,300) x(k,n1), x(k,n3)
         write (nout,300) x(k,n1), x(k,n2)
         x(j,n2) = x(j,n3)
         x(k,n2) = x(k,n3)
         x(j,n1) = half*(x(j,n1) + x(k,n1))
         x(k,n1) = x(j,n1)
      enddo
      write (nout,400) n1
      write (nout,100) 'Default Line'
c
c Create the dendrogram labels file
c
      close (unit = nout)  
      fname = sim256(labfil)
      call deleet (fname,
     +             askif, there)
      if (there) then
         call putfat ('You must attrib -r f$labels.tmp then delete')
      else
         open (unit = nout, file = fname)
         do i = 1, n
            write (nout,100) wordx(iord(i))
         enddo
         close (unit = nout)
      endif
      nfiles = n1
      files(nfiles) = filex
      if (thresh.gt.zero) then
         call gettmp (ifail,
     +                filey)
         open (unit = nout, file = filey)
         write (nout,100) 'Threshold file'
         write (nout,200) n, n2
         do i = 1, n
            write (nout,300) dble(i), thresh
         enddo
         close (unit = nout)
         nfiles = nfiles + n1
         files(nfiles) = filey
         lfiles(nfiles) = n2
      endif
      titles(1) = ptitle
      titles(2) = xtitle
      titles(3) = ytitle
      titles(4) = ' '
      call smplot$(jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      call deleet (filex,
     +             askif, there)
      if (thresh.gt.zero) call deleet (filey,
     +                                 askif, there) 
c
c format statements
c      
  100 format (a)
  200 format (2i6)
  300 format (1p,2e12.4)
  400 format (i3)
      end
c
c
