C
C
      SUBROUTINE DIVIDE (N,
     +                   X, XSTART, XSTOP)
C
C ACTION : Divide the interval XSTART to XSTOP for graphics etc. by
C          clustering 1/NDIV of points at beginning and end of FRAC*INTERVAL
C          for log transforms, asymptotes etc. e.g.:-
C          NDIV = 4   ... 1/4 of points in each cluster
C          FRAC = 0.1 ... 0.1 of range  in each cluster
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 16/6/92
C          23/02/1994 edited 
c          22/03/2007 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N  
      DOUBLE PRECISION, INTENT (IN)    :: XSTART, XSTOP 
      DOUBLE PRECISION, INTENT (INOUT) :: X(N)
C
C Locals
C      
      INTEGER    NDIV
      PARAMETER (NDIV = 4)
      INTEGER    I, NSTART, NSTOP
      DOUBLE PRECISION FRAC, ONE, XMIN
      PARAMETER (FRAC = 0.1D+00, ONE = 1.0D+00, XMIN = 1.0D-50)
      DOUBLE PRECISION DELTA, XDIFF
      EXTERNAL   PUTADV, PUTFAT
      INTRINSIC  EXP, LOG, MOD, DBLE
C
C First check that N and XSTART, XSTOP make sense
C
      XDIFF = XSTOP - XSTART
      IF (XDIFF.LE.XMIN) THEN
         CALL PUTFAT ('Xstop - Xstart too small in DIVIDE algorithm')
         RETURN
      ENDIF
      IF (MOD(N, NDIV).NE.0) THEN
         CALL PUTADV (
     +'DIVIDE algorithm needs N a multiple of 4 so linear spacing used')         
         DELTA = (XSTOP - XSTART)/(DBLE(N) - ONE)
         X(1) = XSTART
         DO I = 2, N - 1
            X(I) = X(I - 1) + DELTA
         ENDDO
         X(N) = XSTOP
         RETURN
      ENDIF
      IF (N.LT.8) THEN
         CALL PUTADV (
     +'DIVIDE algorithm requires N >= 8 so linear spacing used')          
         DELTA = (XSTOP - XSTART)/(DBLE(N) - ONE)
         X(1) = XSTART
         DO I = 2, N - 1
            X(I) = X(I - 1) + DELTA
         ENDDO
         X(N) = XSTOP
         RETURN
      ENDIF
C
C Now define X(1), X(NSTART), X(NSTOP) and X(N)
C
      DELTA = FRAC*XDIFF
      NSTART = N/NDIV
      NSTOP = (NDIV - 1)*NSTART + 1
      X(1) = XSTART
      X(NSTART) = XSTART + DELTA
      X(NSTOP) = XSTOP - DELTA
      X(N) = XSTOP
C
C Do linear or logarithmic partition of first interval
C
      IF (XSTART.LE.XMIN) THEN
         DELTA = FRAC*XDIFF/(DBLE(NSTART) - ONE)
         DO I = 1, NSTART - 2
            X(I + 1) = X(I) + DELTA
         ENDDO
      ELSE
         DELTA = (LOG(X(NSTART)) - LOG(X(1)))/(DBLE(NSTART) - ONE)
         X(1) = LOG(X(1))
         DO I = 1, NSTART - 2
            X(I + 1) = X(I) + DELTA
         ENDDO
         DO I = 1, NSTART - 1
            X(I) = EXP(X(I))
         ENDDO
      ENDIF
C
C Do linear partition of middle section
C
      DELTA = (X(NSTOP) - X(NSTART))/(DBLE((NDIV - 2)*NSTART) + ONE)
      DO I = NSTART + 1, NSTOP - 1
         X(I) = X(I - 1) + DELTA
      ENDDO
C
C Do linear partition of last interval
C
      DELTA = FRAC*XDIFF/(DBLE(NSTART) - ONE)
      DO I = NSTOP + 1, N - 1
         X(I) = X(I - 1) + DELTA
      ENDDO
      END
C
C
