
C
C *********************************************************************
C *  Subroutine: DoAxis$    Finding  Axis PARAMETER                   *
C *********************************************************************
C
      SUBROUTINE DOAXIS$ (MXTIC, NLDIG,
     +                    XMAX, XMIN)
C      
C AUTHOR : S. Bonakdar, Bonn, Germany (1994)
C            (2009) converted from FTN77 to FTN95 with some modifications 
C       06/08/2009 added INTENTS
C       12/08/2009 minor editing by w.g.b 
C       01/09/2009 minor modification to fit to simplot by s.b.
c                  - values of QLMAXV and QLMINV set to 10.0 and 1/10.0
C                  - variable NMAX removed and N2, N30 and N300 added
c                  - in LGDIFF : N3 increased to N300, because of errors
c                    duo to numerical rounding errors !!! 
c                  - old calculation of magnitude replaced with that 
c                    of simplot from mr. w.g.b
C       02/09/2009 calculation of magnitude removed to soubroutine MAGNTD$
C       06/09/2009 set xmin=zero in case xmin=xmax = const. (constant .ne. zero)
C       21/10/2009 new version from Samad with minor editing by w.g.b
C       02/11/2009 new W.G.B version with traps to prevent infinite loops and
C                  added EXPAND$ to deal with swap-round and potential equality
C       04/11/2009 added KCOUNT so all loops are now trapped and also trapped
C                  cases with MXTIC < 1, MXTIC > 6, NLDIG < 1, and NLDIG > 7
c-----------------
C       05/11/2009 minor modification to enable to plot numbers with magnitude
C                  from  -200 <= NXMAG <= 200 with calculating automatically 
c                  MXTIC, NLDIG by samad b.
c                  problem with AINT(..) or DBLE(NINT(..)) could be solved 
c                  in using of combination of both of them !
C
C                  some of modification (ICOUNT, KCOUNT..), from mr. w.g.b are
c                  are deactivated. they may now be not neccessary !! s.b.
c       06/11/2009 added calls to GIVEIN$, restored my code for ICOUNT, JCOUNT,
c                  KCOUNT so there never be any infinite loops under any 
C                  circumstances, and restored the code to default using 
C                  GIVEIN$ if the range expands to more than 50%
C       11/11/2209 allowed the case MXTIC = 7    
C       18/03/2010 added OK1 and OK2 to protect NINT(.) from overflow           
c
C *********************************************************************
C *              MXTIC    No. axis division = (Xmax-Xmin)/QLINC       *
C *              NLDIG    No. of decimal digits of labels             *
C *              QLINC    axis division-Increment                     *
C *              QLMIN    minimal value for axis division             *
C *              QSCALE   Scale factor for xmax and xmin (= 10**NXMAG)*
C *              XMAX     MAXIMAL X-Value                             *
C *              XMIN     MINIMAL X-Value                             *
C *********************************************************************
C
C  Given extreme values XMAX, XMIN, and the need for a scale with MXTIC
C  marks, calculates value for the lowest scale mark (XMIN) and
C  step length (QLINC) and highest scale mark (XMAX).
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (OUT)   :: MXTIC, NLDIG  
      DOUBLE PRECISION, INTENT (INOUT) :: XMAX, XMIN
C
C Local variables
C
      INTEGER    ICOUNT, JCOUNT, KCOUNT
      INTEGER    I, LGDIFF, NXMAG
      INTEGER    N0, N1, N3, N4, N7, N9, N20, N30    
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N4 = 4, 
     +           N7 = 7, N9 = 9, N20 = 20, N30 = 30)
      DOUBLE PRECISION QSCALE, QBASE, QMIN, QMAX, QMINML, QMAXML
      DOUBLE PRECISION QI, QM, QMA, QINCA,QLMINV,QLMAXV,  
     +                 QINC, QLINC  
      DOUBLE PRECISION FACTOR(4)
      DOUBLE PRECISION XMIN0, XMAX0
      DOUBLE PRECISION ZERO, ONE, TWO, FIVE, SEVEN, TEN, TEN_9
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FIVE = 5.0D+00, SEVEN = 7.0D+00, TEN = 10.0D+00,
     +           TEN_9 = TEN**N9)
      DOUBLE PRECISION EPS4, EPS3
      PARAMETER (EPS4 = ONE/(TEN**N4), EPS3 = ONE/(TEN**N3))
      DOUBLE PRECISION EPS  ! EPS is set to 10**(-N30) !!
      PARAMETER (EPS = ONE/(TEN**N30))
! see below      
C$$$$$$       PARAMETER (QLMAXV = TEN**N1,  QLMINV = ONE/(TEN**N1))
      DOUBLE PRECISION EPSI, EXPAND, P9REP
      PARAMETER (EPSI = 1.0D-200, EXPAND = 1.5D+00,
     +           P9REP = ONE - EPS)   ! **** new <<<<<<<<<<<<<<<<<<<<      
C$$$$$$      +           P9REP = 0.9999999D+00)
      PARAMETER (QLMAXV = EXPAND*TEN**N1, QLMINV = ONE/(EXPAND*TEN**N1)) ! **** new <<<<<<<<<<<<<<<<<<<<                      
      LOGICAL    XSCALE  
      LOGICAL    OK1, OK2
      EXTERNAL   MAGNTD$, EXPAND$, GIVEIN$
      INTRINSIC  ABS, MAX, MIN, DBLE
      DATA       FACTOR / ONE, TWO, FIVE, TEN /
C
c******   	  print*,' *** DOAXIS$ '

      QSCALE = ONE
C
C ** FIND MINIMUM AND MAXIMUM X'S WHEN XSCALE IS DEFAULT
C
C$$$$$$       XSCALE = .true. ! this makes not good scalling!
      XSCALE = .false.
C
C ** SAVE XMIN, XMAX AND calculate NEW SCALED VALUES
c

c
c w.g.b this next code is suppressed because it screws up the call to EXPAND$
c******      IF (ABS(XMAX - XMIN).LE.EPSI) THEN
C --- for cases xmin = xmax = const. but .NE. Zero,e.g. = (+/-)1.234*10**NXMAG!
C     for this case          
c******         XMIN = ZERO  
C$$$$$$          XMAX = XMAX  !!
c******      ENDIF   
c
    
C 
C w.g.b. ... call EXPAND$ to swap if wrong way round and deal with equality
C
      CALL EXPAND$ (XMAX, XMIN)
C        
C Save entry values (after possible expansion by EXPAND$)
C  
      XMIN0 = XMIN
      XMAX0 = XMAX
C      
C --- set default for magnitude 
C --- in case of (+/-)1.234 * 10**NXMAG or (+/-)0.1234 * 10**NXMAG 
C   
C$$$$$$       NXMAG = 0  
   
      CALL MAGNTD$ (NXMAG,
     +              XMAX, XMIN)                     
     
C$$$$$$       print*,' *** default for magnitude ', NXMAG, XMAX, XMIN           
C 
C======================================================
C

      ICOUNT = N0
 7777 CONTINUE
 
      ICOUNT = ICOUNT + N1
      IF (ICOUNT.GT.N20) THEN
C        
C****         write (*,'(a,i6)') 'icount =', icount
C
         CALL GIVEIN$ (MXTIC, NLDIG,
     +                 XMAX, XMAX0, XMIN, XMIN0)
         RETURN
      ENDIF    
      
      XMIN = XMIN0/QSCALE
      XMAX = XMAX0/QSCALE

      QMIN = MIN(XMIN,XMAX)
      QMAX = MAX(XMIN,XMAX)
C      
      IF (ABS(QMAX - QMIN).LE.EPSI) THEN
          QMIN = QMIN - ONE
          QMAX = QMAX + ONE
          XMIN = QMIN
          XMAX = QMAX
      ENDIF  

      IF (ABS(QMAX - QMIN).GT.ZERO) THEN
         LGDIFF = NINT(LOG10(ABS(QMAX - QMIN))) - N3    
      ELSE
         LGDIFF = -N1      
      ENDIF
      QBASE  = TEN**LGDIFF
C     
      JCOUNT = N0
      DO13: DO
      
         JCOUNT = JCOUNT + N1
         IF (JCOUNT.GT.N20) THEN
C           
C****            write (*,'(a,i6)') 'jcount =', jcount
C
            CALL GIVEIN$ (MXTIC, NLDIG,
     +                    XMAX, XMAX0, XMIN, XMIN0)
            RETURN
         ENDIF
         
         DO I = N1, N3   ! N4: has same effect as N1!
            QINC   = FACTOR(I)*QBASE
!**** new  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 
!--- to plot numbers with magnitude from -200 <= NXMAG <= 200 
            IF (ABS(QMIN/QINC).LE.TEN_9) then
               OK1 = .TRUE.
            ELSE
               OK1 = .FALSE.
            ENDIF
            IF (ABS(QMAX/QINC).LE.TEN_9) then
               OK2 = .TRUE.
            ELSE
               OK2 = .FALSE.
            ENDIF                            
            if ( ABS(NXMAG) .LE. N30 .AND. OK1 .AND. OK2) then
                QMINML = DBLE(NINT(QMIN/QINC))    
                QMAXML = DBLE(NINT(QMAX/QINC))
            else
            	QMINML = AINT(QMIN/QINC)
            	QMAXML = AINT(QMAX/QINC)            
            endif
!*****************************************
            IF ((QMINML - EPS4)*QINC.GT.QMIN) QMINML = QMINML - ONE 
            IF ((QMAXML + EPS4)*QINC.LT.QMAX) QMAXML = QMAXML + ONE 
            IF (QMAXML - QMINML.LE.SEVEN) EXIT DO13 
         ENDDO
         QBASE  = QBASE*TEN
         LGDIFF = LGDIFF + N1
      ENDDO DO13
      QMIN = QMINML*QINC
      QMAX = QMAXML*QINC
C
      IF (.NOT.XSCALE) THEN
         XMIN = QMIN
         XMAX = QMAX
      ELSE
         IF(QMIN + EPS3*QINC .LT. MIN(XMIN,XMAX)) QMIN = QMIN + QINC  
      ENDIF
C
C=================================================================
C ** look for the smalest and bigest Tic-mark
C
      QI    = QINC * P9REP     
      QM    = QMIN
      QMA   = ABS(QM)
      QINCA = ABS(QINC)
C----------------------------------------------------------------- 
!**** new  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C$$$$$$       IF ((QMA .LT. QLMINV .AND. QMA .GT. EPS .AND. QINCA .LT.TEN*QMA) 
C$$$$$$      +                      .OR. QMA .GT. QLMAXV) THEN
!
! --- EPS   replaced with EPSI
      IF ((QMA .LT. QLMINV .AND. QMA .GT. EPSI.AND. QINCA .LT.TEN*QMA)       !**** new
     +                      .OR. QMA .GT. QLMAXV) THEN     
!    old calculation of magnitude replaced with that 
!    of simplot from mr. w.g.b
C
C Find magnitude of numbers on X-Axis.
C 
         CALL MAGNTD$ (NXMAG,
     +                 XMAX, XMIN)
C         
C calculate X-Axis scaling factor (Exponent)
C
         QSCALE = TEN**NXMAG
         GOTO 7777
      END IF
C-----------------------------------------------------------------    
      KCOUNT = N0    
      DO
        
         KCOUNT = KCOUNT + N1
         IF (KCOUNT.GT.N20) THEN
C           
C****            write (*,'(a,i6)') 'kcount =', kcount
C
            CALL GIVEIN$ (MXTIC, NLDIG,
     +                    XMAX, XMAX0, XMIN, XMIN0)
            RETURN
         ENDIF
         
         QM = QM + QI 
!**** new  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
! EPS6 removed !  
         IF (QM.GT.XMAX) EXIT
C$$$$$$          IF (QM.GT.XMAX + EPS6) EXIT           
      ENDDO
        
      QMA = ABS(QM)
!**** new  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C$$$$$$       IF ((QMA.LT.QLMINV .AND. QMA.GT.EPS .AND. QINCA .LT. TEN*QMA) 
C$$$$$$      +                    .OR. QMA.GT.QLMAXV) THEN
!
! --- EPS   replaced with EPSI
      IF ((QMA.LT.QLMINV .AND. QMA.GT.EPSI .AND. QINCA .LT. TEN*QMA)      !**** new
     +                    .OR. QMA.GT.QLMAXV) THEN     
C
C Find magnitude of numbers on X-Axis.
C 
         CALL MAGNTD$ (NXMAG, 
     +                 XMAX, XMIN)
C         
C calculate X-Axis scaling factor (Exponent)
C
         QSCALE = TEN**NXMAG
C         
         GOTO 7777
      END IF
c 
C=================================================================
C --- NLDIG = MAX (1,-LGDIFF)  at last 1 digit after decimal point!
      NLDIG = MAX (N1,-LGDIFF)
      QLINC = QINC
C
C --- calculate number of axis division 
C
      MXTIC = NINT((XMAX - XMIN)/QLINC) 
      IF (MXTIC == 0) MXTIC = 1  ! for cases like (XMAX - XMIN)= 0
C
C ---  redefine XMIN, XMAX
C
      XMIN = XMIN*QSCALE
      XMAX = XMAX*QSCALE
C
C w.g.b. ... Make sure all data will be plotted and range is not too large
C
      IF (XMIN.GT.XMIN0) XMIN = XMIN0
      IF (XMAX.LT.XMAX0) XMAX = XMAX0
c
C Samad: the following statements removed, because of wrong division in some cases
C w.g.b: retained this code to trap over expansion of plotting range
C
       IF (XMAX - XMIN.GT.EXPAND*(XMAX0 - XMIN0)) THEN 
          CALL GIVEIN$ (MXTIC, NLDIG,
     +                  XMAX, XMAX0, XMIN, XMIN0)
          RETURN
       ENDIF   
C      
C Final checks
C
      
      IF (NLDIG.LT.N1 .OR. NLDIG.GT.N7 .OR.
     +    MXTIC.LT.N1 .OR. MXTIC.GT.N7) THEN  
          CALL GIVEIN$ (MXTIC, NLDIG,
     +                  XMAX, XMAX0, XMIN, XMIN0)
       ENDIF
            
      END       
C
C
C------------------------------------------------------------------------------------
C
C
      SUBROUTINE MAGNTD$ (NXMAG,
     +                    XMAX, XMIN)
C
C action: find order of magnitude of numbers for plotting      
C author: w.g.bardsley, university of manchester, U.K., 01/10/2009
C         This uses write/read and is more robust than previous versions
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (OUT) :: NXMAG  
      DOUBLE PRECISION, INTENT (IN)  :: XMAX, XMIN
C
C Local variables
C
      INTEGER    IOS, N, NTEMP
      DOUBLE PRECISION XTEMP 
      CHARACTER (LEN = 8) WORD8
      CHARACTER (LEN = 1) MINUS, PLUS
      PARAMETER (MINUS = '-', PLUS = '+')
      INTRINSIC  ABS, INDEX
C
C initialise NXMAG
C   
      NXMAG = 0
C 
C Write largest absolute value to WORD8 
C      
      XTEMP = MAX(ABS(XMAX),ABS(XMIN))
      WRITE (WORD8,'(1P,E8.1)') XTEMP
C
C Check for negative 
C      
      N = INDEX(WORD8,MINUS)
      IF (N.GT.0) THEN
         READ (WORD8(N:8),*,IOSTAT=IOS) NTEMP
         IF (IOS.EQ.0) THEN
            NXMAG = NTEMP
            RETURN
         ENDIF   
      ENDIF   
C
C Must be positive
C      
      N = INDEX(WORD8(N:8),PLUS) 
      IF (N.GT.0) THEN
         READ (WORD8(N:8),*,IOSTAT = IOS) NTEMP
         IF (IOS.EQ.0) NXMAG = NTEMP
      ENDIF     
      END  
C
C
C----------------------------------------------------------------------
C
C
      subroutine expand$ (xmax, xmin)
c
c action: expand xmax - xmin range for plotting if necessary
c author: w.g.bardsley, university of manchester, U.K., 02/11/2009
c         difmin is the minimum distance to check for potential equality
c         04/11/2009 This version does not allow xmax or xmin values to 
c                    change sign unless xmax = xmin = zero to within difmin 
c         18/03/2010 replaced difmin by vvsmall in first test and increased
c                    trial expansion ranges
c
      implicit none
c
c arguments
c          
      double precision, intent (inout) :: xmax, xmin
c
c locals
c       
      double precision xtemp 
      double precision difmin, zero, one, small, vsmall, vvsmall
      parameter (difmin = 5.0d-200, zero = 0.0d+00, one = 1.0d+00, 
     +           small = 1.0d-02, vsmall = 1.0d-06, vvsmall = 1.0d-10) 
      intrinsic  max
c
c first of all swap if wrong way round
c
      if (xmin.gt.xmax) then
         xtemp = xmin
         xmin = xmax
         xmax = xtemp
      endif
c
c then check if action is needed, otherwise return
c         
      if (xmax - xmin.ge.vvsmall) return
c
c the values may be approximately equal so check some possibilities
c
      if (xmin.ge.-difmin .and. xmax.le.difmin) then
c
c case 1: they must equal zero within error so fix limits both ways
c =======
c      
         xmin = -vsmall
         xmax = vsmall         
      elseif (xmin.ge.zero) then
c 
c case 2: positive values so try expanding upwards (and possibly downwards)
c =======
c      
         xtemp = max(small*xmax,difmin)
         xmax = xmax + xtemp
         xtemp = max(small*xmin,difmin)
         if (xmin - xtemp.ge.zero) xmin = xmin - xtemp 
      elseif (xmax.le.zero) then
c
c case 3: negative values so try expanding downwards (and possibly upwards)
c =======
c      
         xtemp = max(-small*xmin,difmin)
         xmin = xmin - xtemp
         xtemp = max(-small*xmax,difmin)
         if (xmax + xtemp.le.zero) xmax = xmax + xtemp 
      else   
c
c case 4: opposite signs
c =======
c
         xtemp = max(small*xmax,difmin)
         xmax = xmax + xtemp
         xtemp = max(-small*xmin,difmin)
         xmin = xmin - xtemp
      endif  
c
c Final check (this should never be necessary)
c            
      if (xmax - xmin.le.difmin) then
         if (xmin.ge.zero) then
            xmax = xmax + one
         elseif (xmax.le.zero) then
            xmin = xmin - one
         else
            xmin = xmin - one
            xmax = xmax + one
         endif         
      endif
      end
c
c          
c --------------------------------------------------------------------
c                  
c
      subroutine givein$ (mxtic, nldig,
     +                    xmax, xmax0, xmin, xmin0)
c
c author: w.g.bardsley, university of manchester, u.k, 06/11/2009
c action: give in and restore plotting range to original values  
c         
c mxtic: returned as 1  
c nldig: returned to guarantee a total of 5 digits
c  xmax: returned as xmax0
c  xmin: returned as xmin0
c
      implicit none
c
c arguments
c      
      integer,          intent (out) :: mxtic, nldig 
      double precision, intent (in)  :: xmax0, xmin0
      double precision, intent (out) :: xmax, xmin 
c
c locals
c      
      integer    nxmag
      integer    nbot, ntop
      parameter (nbot = -2, ntop = 3)
      external   magntd$ 
c      
c      write (*,'(2i6,1p,4e13.5)') mxtic, nldig, xmax, xmax0, xmin, xmin0
c

c
c initialise mxtic, xmax, xmin
c      
      xmax = xmax0
      xmin = xmin0
      mxtic = 1
c
c get the order of magnitude
c      
      call magntd$(nxmag,
     +             xmax, xmin)
      if (nxmag.lt.nbot .or. nxmag.gt.ntop) then
c
c numbers of the form 1.2345*10**(nxmag)
c                    
          nldig = 4
      else     
c
c numbers of the form 0.012345 to 1234.5
c
         nldig = 4 - nxmag     
      endif
      end
c
c         