C
C
      SUBROUTINE EBPLOT$(ISEND, NOBS, NSET, NVEC,
     +                   XVEC,
     +                   LABELS_TRUE, TITLES)
C
C ACTION  : Supply a vector then create an errorbar barchart
C           by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Derived from BWPLOT$ 21/04/2002
C           18/11/2002 provided choice for symbols instead of bars
C           07/01/2003 redimensioned WIDE(5*NGRAFS)
C           13/10/2004 minor editing
C           11/07/2005 increased NMAX from 500 to 2000
C           22/10/2005 corrected error when isend = 1 and when plotting
C                      as standard error bars joined up
C           22/06/2006 introduced allocatables and I2FILE for header dimensions  
C           20/05/2007 added INTENTS
C           01/01/2008 added NXTRA 
C           15/01/2008 redimensioned NMAX = 10000
C           28/01/2008 removed X, ..., YT for argument list to GKSGRF$
C           30/06/2009 now deletes FSAV(1) and FSAV1(1) as they may be renamed
C           06/12/2010 added call to LABELS
C           31/12/2010 added call to TXTKEY
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C
C           ISEND: (input/unchanged) use labels as follows:
C                   ISEND = 1: configuration labels
C                   ISEND = 2: labels from file
C            NOBS: (input/unchanged) observations per set(i), NOBS(i) >= 2
C            NSET: (input/unchanged) no. of sets of data
C            NVEC: (input/unchanged) no. of items, NVEC >= sum NOBS(i)
C            XVEC: (input/unchanged) vector of values i = 1, NVEC
C          LABELS: (input/unchanged) used as labels if ISEND = 2
C          TITLES: (input/unchanged) as follows:
C                   title, x-legend, y-legend, z-legend(unused)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NSET, NVEC
      INTEGER,             INTENT (IN) :: ISEND, NOBS(NSET)
      DOUBLE PRECISION,    INTENT (IN) :: XVEC(NVEC)
      CHARACTER (LEN = *), INTENT (IN) :: LABELS_TRUE(NSET), TITLES(4)
C
C Local allocatable workspaces
C                 
      DOUBLE PRECISION, ALLOCATABLE :: XSAV(:), YLSAV(:), YSAV(:),
     +                                 YHSAV(:)   
C
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4,
     +           NIN, NMAX, NWORDS, NXTRA
      PARAMETER (NIN = 3, NGRAFS = 300, NGRAF2 = 2*NGRAFS,
     +           NGRAF3 = 3*NGRAFS, NGRAF4 = 4*NGRAFS,
     +           NMAX = 2000,
     +           NWORDS = 2000, KPANEL = NGRAFS, NXTRA = NWORDS)
      INTEGER    JSEND
      PARAMETER (JSEND = 1)
      INTEGER    N0, N1, N2, N4, N5, N9, N20, N40
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N5 = 5, N9 = 9,
     +           N20 = 20, N40 = 40)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 4)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT), NUMTXT
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS),
     +           L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    I, ICOUNT, IERR, IFAIL, IOS, J, NCOL, NMAX1, NOUT, NROW
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS), WIDE(5*NGRAFS), 
     +                 ZLH, ZMAX, ZMED, ZMIN, ZUH
      DOUBLE PRECISION ONE, HALF, ZERO
      PARAMETER (ONE = 1.0D+00, HALF = 0.5D+00, ZERO = 0.0D+00)
      CHARACTER  FILEX*1024
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40,
     +           LINE*100
      CHARACTER  TEMP(4)*20, TEXT(30)*100, VECTORS(60)*40
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ASKIF, BORDER, STORE, REPEET, THERE
      PARAMETER (ASKIF = .FALSE., BORDER = .FALSE., STORE = .FALSE.)
      EXTERNAL   GKSGRF$, DELEET, GETTMP, GETNOU, LBOX02, PATCH1,
     +           I2FILE, LABELS, TXTKEY
      EXTERNAL   DEFGKS$, PLTOBJ$, PUTFAT$, ERRBAR$
      INTRINSIC  MAX
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check the data supplied
C                         
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT$('ISEND out of range in call to EBPLOT$')
         RETURN
      ENDIF
      IF (NSET.LT.N1 .OR. NVEC.LT.N4) THEN
         CALL PUTFAT$(
     +'Must have at least 1 item for an error bar barchart')
         RETURN
      ENDIF
      ICOUNT = N0
      DO I = N1, NSET
         ICOUNT = ICOUNT + NOBS(I)
         IF (NOBS(I).LT.N2) THEN
            CALL PUTFAT$(
     +'Must have at least 2 items/sample for an error bar barchart')
            RETURN
         ENDIF
      ENDDO
      IF (ICOUNT.GT.NVEC) THEN
         CALL PUTFAT$(
     +'NOBS, NSET, and NVEC inconsistent in call to EBPLOT')
         RETURN
      ENDIF
C
C Allocate workspaces
C                    
      IERR = N0
      IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      IF (ALLOCATED(YLSAV)) DEALLOCATE(YLSAV, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(YHSAV)) DEALLOCATE(YHSAV, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      
      NMAX1 = MAX(NMAX,NSET)
      
      ALLOCATE(XSAV(NMAX1), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(YLSAV(NMAX1), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(YSAV(NMAX1), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(YHSAV(NMAX1), STAT = IERR)
      IF (IERR.NE.N0) RETURN
C
C Generate error bar data
C
      CALL GETNOU (NOUT)
      CALL GETTMP (IFAIL,
     +             FILEX)
      IF (IFAIL.NE.N0) RETURN
      OPEN (UNIT = NOUT, FILE = FILEX)
      WRITE (NOUT,'(A)') 'Original data'
      CALL I2FILE (NOUT, ICOUNT, N2)
      ICOUNT = N0
      DO I = N1, NSET
         DO J = N1, NOBS(I)
            ICOUNT = ICOUNT + N1
            WRITE (NOUT,'(I6,1P,E13.5)') I, XVEC(ICOUNT)
         ENDDO
      ENDDO
      CLOSE (UNIT = NOUT)
C
C Generate the error bars
C
      CALL ERRBAR$(FILEX)
      CALL GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NOUT)
         CALL DELEET (FILEX,
     +                ASKIF, THERE)
         DEALLOCATE(XSAV, STAT = IERR)
         DEALLOCATE(YLSAV, STAT = IERR)
         DEALLOCATE(YSAV, STAT = IERR)
         DEALLOCATE(YHSAV, STAT = IERR)
         RETURN
      ENDIF
      READ (NOUT,'(A)',IOSTAT=IOS) LINE
      IF (IOS.EQ.N0) READ (NOUT,*,IOSTAT=IOS) NROW, NCOL
      IF (IOS.NE.N0 .OR. NROW.NE.NSET .OR. NCOL.NE.N4) THEN
         CLOSE (UNIT = NOUT)
         LINE = 'Error in file returned to EBPLOT$ by ERRBAR$'
         CALL PUTFAT$(LINE)
         CALL DELEET (FILEX,
     +                ASKIF, THERE)
         DEALLOCATE(XSAV, STAT = IERR)
         DEALLOCATE(YLSAV, STAT = IERR)
         DEALLOCATE(YSAV, STAT = IERR)
         DEALLOCATE(YHSAV, STAT = IERR)
         RETURN
      ENDIF
C
C Save the error bar data
C
      DO I = N1, NSET
         READ (NOUT,*,IOSTAT=IOS) XSAV(I), YLSAV(I), YSAV(I), YHSAV(I)
         IF (IOS.NE.N0 .OR. YSAV(I).GT.YHSAV(I) .OR.
     +                      YLSAV(I).GT.YSAV(I)) THEN
            CLOSE (UNIT = NOUT)
            CALL PUTFAT$('Error in file returned to EBPLOT$ by ERRBAR$')
            CALL DELEET (FILEX, ASKIF, THERE)
            DEALLOCATE(XSAV, STAT = IERR)
            DEALLOCATE(YLSAV, STAT = IERR)
            DEALLOCATE(YSAV, STAT = IERR)
            DEALLOCATE(YHSAV, STAT = IERR)
            RETURN
         ENDIF
      ENDDO
      CLOSE (UNIT = NOUT)
C
C Initialise gks and graphical objects
C
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Initialise all the array variables even though they are not to be used
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N0
         M(I) = N0
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
      CALL LABELS (JSEND, IHUE, IFILL,
     +             LABEL1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO         
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE)      
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100)
         NUMDEC = NUMOPT - N1
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.N1) THEN
C
C Create an error bar barchart type of file
C
            CALL GETNOU (NOUT)
            OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
            IF (IOS.NE.N0) THEN
               CLOSE (UNIT = NOUT)
               CALL DELEET (FILEX,
     +                      ASKIF, THERE)
               RETURN
            ENDIF
            WRITE (NOUT,'(A)') TITLES(1)
            WRITE (NOUT,'(2I6)') NSET, N9
            DO I = N1, NSET
               IF (YSAV(I).GE.ZERO) THEN
                  ZMIN = ZERO
                  ZLH = ZERO
                  ZMED = ZERO
                  ZUH = YSAV(I)
                  ZMAX = YHSAV(I)
               ELSE
                  ZMIN = YLSAV(I)
                  ZLH = YSAV(I)
                  ZMED = ZERO
                  ZUH = ZERO
                  ZMAX = ZERO
               ENDIF
               WRITE (NOUT,'(1P,9E11.3)') XSAV(I), ZMIN, ZLH, ZMED, ZUH,
     +                                    ZMAX, ONE, HALF, ZERO
            ENDDO
            WRITE (NOUT,'(I6)') NSET + N2
            WRITE (NOUT,'(A)') 'begin{labels}'
            IF (ISEND.EQ.N1) THEN
               DO I = N1, NSET
                  IF (I.LE.9) THEN
                     WRITE (NOUT,'(I1)') I
                  ELSEIF (I.LE.99) THEN    
                     WRITE (NOUT,'(I2)') I
                  ELSE   
                     WRITE (NOUT,'(I5)') I
                  ENDIF   
               ENDDO
            ELSE
               DO I = N1, NSET
                  WRITE (NOUT,'(A)') LABELS_TRUE(I)
               ENDDO
            ENDIF
            WRITE (NOUT,'(A)') 'end{labels}'
            CLOSE (UNIT = NOUT)
            L(N1) = N0
            M(N1) = N0
            BAR_CHART = .TRUE.
C
C The title must be as set in TITLES(1) for bar charts
C
            DO I = 1, 4
               TEMP(I) = TITLES(I)
            ENDDO
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write an error bar file
C
            CALL GETNOU (NOUT)
            OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
            IF (IOS.NE.N0) THEN
               CLOSE (UNIT = NOUT)
               CALL DELEET (FILEX,
     +                      ASKIF, THERE)
               RETURN
            ENDIF
            WRITE (NOUT,'(A)') 'Error bars'
            WRITE (NOUT,'(2I6)') NSET, N4
            DO I = N1, NSET
               WRITE (NOUT,'(1P,4E11.3)') XSAV(I), YLSAV(I),
     +                                    YSAV(I), YHSAV(I)
            ENDDO
            WRITE (NOUT,'(I6)') N1
            WRITE (NOUT,'(A)') 'Default line'
            CLOSE (UNIT = NOUT)
            L(N1) = N1
            M(N1) = N5
            BAR_CHART = .FALSE.
            DO I = 1, 4
               TEMP(I) = TITLES(I)
            ENDDO
C
C The title is arbitrary for ordinary error bar plots
C
            TEMP(1) = 'Data & Error-Bars'
         ENDIF
         IF (NUMDEC.LT.NUMOPT - N1) THEN
C
C Proceed to plotting
C
            NFILE1 = N1
            FSAV(N1) = FILEX
            FSAV1(N1) = FILEX
            LIB_FILE = .FALSE.
            PIE_CHART = .FALSE.
            SUPPLY_XY = .TRUE.
            TWO_PLOTS = .FALSE.
            TYPE_IN = .FALSE.
            VECTOR_FIELD = .FALSE.

            CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +                   NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE,
     +                   FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +                   TSAV, TEMP, WORDX, WORDY,
     +                   BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +                   PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +                   SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +                   VECTOR_FIELD, YAXIS)
            CALL DELEET (FSAV(1),
     +                   ASKIF, THERE)
            CALL DELEET (FSAV1(1),
     +                   ASKIF, THERE) 
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Help
C
            WRITE (TEXT,200)
            NUMBLD(N1) = N1
            NUMTXT = 20
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(N1) = N0
         ELSE
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF

      ENDDO 
C
C Delete all temporary files used for plotting
C
      CLOSE (UNIT = NOUT)
      CALL DELEET (FILEX,
     +             ASKIF, THERE)
      CALL DELEET (FSAV(1),
     +             ASKIF, THERE)
      CALL DELEET (FSAV1(1),
     +             ASKIF, THERE) 
C
C Deallocate workspaces
C      
      DEALLOCATE(XSAV, STAT = IERR)
      DEALLOCATE(YLSAV, STAT = IERR)
      DEALLOCATE(YSAV, STAT = IERR)
      DEALLOCATE(YHSAV, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     + 'Plot as a bar chart'
     +/'Plot as lines/symbols'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'Advanced plotting options'
     +/
     +/'The data columns selected (and transformed if requested) can'
     +/'now be plotted in either bar chart or line and symbol format'
     +/'by transferring to the advanced plotting mode.'
     +/
     +/'The data columns have been analysed and the appropriate column'
     +/'means and standard deviations have been used to generate error'
     +/'bars that are valid under the assumption that the data values'
     +/'are normally distributed. If the data are counts, percentages,'
     +/'proportions, etc. the data will not be normally distributed'
     +/'and so the error bars will simply give some indication of'
     +/'variability and they will not define central confidence'
     +/'regions.'
     +/
     +/'By selecting the [Data] option you can alter the fill style,'
     +/'colour, symbol type, error bar type, line width, etc. Also, in'
     +/'the advanced mode, you can add text, arrows, graphical objects,'
     +/'information panels, etc. before saving graphics files, copying'
     +/'to the clipboard, or printing hard copy.')
      END
C
C
