
C
C
      SUBROUTINE EDITPS_ADVISE (ABORT, FIRST)
C
C Action: Advise user as follows: FIRST = .TRUE.  show main menu, tutorial if requested, then return
C                                  ABORT = .TRUE.  to stop or
C                                  ABORT = .FALSE. to carry on
C                                  FIRST = .FALSE. just show the tutorial then return
C                                  ABORT = .FALSE.                      
C Author: w.g.bardsley, university of manchester, u.k., 07/01/2009
C    
C
      IMPLICIT   NONE
C
C Arguments
C      
      LOGICAL, INTENT (OUT) :: ABORT
      LOGICAL, INTENT (IN)  :: FIRST
C
C Locals
C      
      INTEGER    ISEND, ICOUNT
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 7, NUMHDR = 12, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      INTEGER    JCOLOR, JMAX
      PARAMETER (JCOLOR = 9, JMAX = 30)
      INTEGER    JUMBLD(JMAX), NUMTXT
      CHARACTER  HEADER(NUMHDR)*63, OPTION(NUMOPT)*15
      CHARACTER  TEXT(JMAX)*100
      LOGICAL    FRAME, NEXT, REPEET
      LOGICAL    UPDOWN
      PARAMETER (UPDOWN = .TRUE.)
      EXTERNAL   TITLES, TUTOR1, HELP_EDITPS
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       JUMBLD / JMAX*0 /
      DATA       NUMBLD / 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
      DATA       NUMPOS / 1, 1, 1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            ICOUNT = 0
            WRITE (HEADER,100)
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ICOUNT.EQ.0 .AND. ISEND.EQ.1) THEN
            CALL HELP_EDITPS ('editps') 
         ELSEIF (ISEND.EQ.1) THEN
            WRITE (TEXT,200)
            NUMTXT = 23
            FRAME = .FALSE.
            JUMBLD(1) = 1
            NEXT = .TRUE.
            CALL TUTOR1 (JCOLOR, JUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)           
            WRITE (TEXT,300)
            NUMTXT = 25
            FRAME = .FALSE.
            JUMBLD(1) = 1
            NEXT = .TRUE.
            CALL TUTOR1 (JCOLOR, JUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            JUMBLD(1) = 0
            WRITE (TEXT,400)
            NUMTXT = 25
            FRAME = .FALSE.
            JUMBLD(1) = 1
            CALL TUTOR1 (JCOLOR, JUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            JUMBLD(1) = 0
            WRITE (TEXT,500)
            NUMTXT = 23
            FRAME = .FALSE.
            JUMBLD(1) = 1
            JUMBLD(17) = 1
            CALL TUTOR1 (JCOLOR, JUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            JUMBLD(1) = 0
            JUMBLD(17) = 0
            WRITE (TEXT,600)
            NUMTXT = 23
            FRAME = .FALSE.
            JUMBLD(1) = 1
            JUMBLD(12) = 1
            CALL TUTOR1 (JCOLOR, JUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            JUMBLD(1) = 0
            JUMBLD(12) = 0
            WRITE (TEXT,700)
            NUMTXT = 23
            FRAME = .FALSE.
            JUMBLD(1) = 1
            NEXT = .FALSE.
            CALL TUTOR1 (JCOLOR, JUMBLD, NUMTXT, TEXT, FRAME, NEXT,
     +                   UPDOWN)
            JUMBLD(1) = 0
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
      ICOUNT = ICOUNT + 1
  100 FORMAT (
     + 'Package    `Simdem'
     +/'Procedure  `DLL version of the Simfit PostScript editor Editps'
     +/'Actions    `1. Edit/view/print/plot sets of Simfit .eps files.'
     +/'           `2. Change size/shape/orientation/fonts/text, etc.'
     +/'           `3. Make multi-column collages from .eps files'
     +/'           `4. Create inlays, i.e. figures within figures'
     +/'           `5. Write .png, .pdf, etc., files from .eps files'
     +/'Details    `a) Help tutorial with the Simfit program Editps'
     +/'           `b) w_readme files distributed with Simfit'
     +/'           `c) Manual from https://www.simfit.org.uk'
     +/'Auxiliaries`Can use Ghostscript DLLs or Ghostscript and Gsview'
     +/'Author     `W.G.Bardsley, University of Manchester, U.K.')
  200 format (
     + 'Summary'
     +/
     +/'This program provides access to the Editps procedures so you'
     +/'can edit, rotate, resize, shear, print, collect into collages,'
     +/'insert graphs within graphs, create raw PostScript, transform'
     +/'PostScript into .svg, .png, .pdf, .jpg, .tif, .pcx, .bmp,'
     +/'create special effects, etc.' 
     +/
     +/'These functions can only work properly if you have Ghostscript,'
     +/'and a PostScript viewer, and Simfit is configured to use these.'
     +/'If you do not have a PostScript printer you should configure'
     +/'Simfit to use your PostScript viewer, e.g. Gsview, as the main'
     +/'PostScript printer driver.'
     +/
     +/'Some procedures will work with any encapsulated PostScript file'
     +/'with a correct BoundingBox (like Simfit PostScript files) but,'
     +/'before use, you should create several standard size Simfit .eps'
     +/'files and add them to your project archive, or library file to'
     +/'demonstrate the possibilities.'
     +/
     +/'Details can be read from the help tutorial of w_editps.exe, the'
     +/'w_readme files, or the Simfit reference manual, distributed'
     +/'with Simfit from http://www.simfit.org.uk.')
  300 FORMAT (
     + 'About Encapsulated PostScript files (*.eps)'
     +/
     +/'1)`A PostScript file can have any number of pages, but special'
     +/'  `conventions apply to files which consist of just one page.'
     +/
     +/'2)`A one page PostScript file can be transformed into an eps'
     +/'  `file by several transformations, including adding the size'
     +/'  `of the page used as a BoundingBox, so that several eps files'
     +/'  `can be printed on the same page to make a composite page.'
     +/
     +/'3)`Simfit PostScript files conform to this standard so they'
     +/'  `can be used to make collages, overlays and insets.'
     +/
     +/'4)`To see eps files on screen or drive a non-PostScript printer'
     +/'  `requires a PostScript interpreter such as Ghostscript, and a'
     +/'  `front end such as GSview.'
     +/
     +/'5)`You must install Ghostscript and a PS-viewer like GSview and'
     +/'  `configure Simfit to interface with them so you can:-'
     +/'  `a) view eps files which is vital when using this program'
     +/'  `b) read the Simfit manuals on screen'
     +/'  `c) drive non-PostScript printers from Simfit eps files'
     +/'  `d) transform ps files into eps files'
     +/'  `e) transform eps files into png, pdf, tif, jpg, bmp, etc.'
     +/'  `f) add previews to see Simfit graphs in a word processor.')
  400 FORMAT (
     + 'What the Simfit program Editps can do'
     +/
     +/'1) `This program reads in PostScript files created from Simfit'
     +/'   `and other plotting packages for re-sizing and grouping.'
     +/'   `(The text editing option will only work on Simfit PS files'
     +/'   `but the other functions work with any standard .eps files.)'
     +/
     +/'2) `It edits a file to change overall position, scale, shape,'
     +/'   `orientation, sub-/super-scripts, Greek alphabet, etc.'
     +/
     +/'3) `It takes in a number of files then groups them together to'
     +/'   `drive-a-printer/make-a-file. You can add a caption to each'
     +/'   `individual graph, and also an overall title and description'
     +/'   `of the plots can be added, e.g. to make a collective graph'
     +/'   `for publication.'
     +/
     +/'5) `If the option to stack ps files in 1,2 or 3 column mode is'
     +/'   `selected the figures will be automatically re-sized, but if'
     +/'   `the free style mode is selected then the files will be over'
     +/'   `printed (in ascending order, without re-sizing) so you can'
     +/'   `create overlays/insets/collages, etc. of arbitrary shape.'
     +/
     +/'6) `You can alter the left hand margin, top of page and overall'
     +/'   `magnification factor when stacking in 1,2 or 3 column mode'
     +/'   `to accomodate alternative paper sizes (default A4).')
  500 FORMAT (
     + 'Option 1 (Editing:) Extensive editing of just one file.'
     +/
     +/'When you have selected a ps file you can change the margins to'
     +/'suit your paper size by setting up translation parameters which'
     +/'move the bottom left hand corner to the position required. Then'
     +/'you can scale up the sizes of the X and Y axes independently to'
     +/'the required size. If you scale X and Y differently, the aspect'
     +/'ratio will change (circles will become ellipses,etc.). Then you'
     +/'can rotate about the bottom left hand corner if required (e.g.'
     +/'90 degrees for portrait/landscape) but note that rotation and'
     +/'scaling matrices do not commute, e.g. R*S generates shearing.'
     +/'If the file is a Simfit ps file, you can also edit the title or'
     +/'legends, etc. to change letters or introduce subscripts, super-'
     +/'scripts, Greek letters or special symbols (like pound or dollar'
     +/'signs or mathematical symbols such as integrals).'
     +/
     +/'Option 2 (Stacking:) stacking files in 1, 2 or 3 column mode.'
     +/
     +/'A caption will be put under each sub-graph (if there is space)'
     +/'and an overall title will be added to the bottom of the graph.'
     +/'You can type in extra lines of text which will be wrapped round'
     +/'in ragged right style at the bottom of the graph if there is'
     +/'sufficient space. Type in blanks to suppress this feature.')
  600 FORMAT (
     + 'Option 3 (Overlay:): collages, overlays and insets.'
     +/
     +/'The idea of this option is to make a (large?) main master graph'
     +/'file and one or more subsidiary (small?) inset files, using the'
     +/'re-sizing features of Option 1. Then make PostScript files from'
     +/'your desk-top publishing package with any equations, or special'
     +/'text, information boxes, pictures, logos, etc. that you want to'
     +/'include using Option 3. Since any eps files can be accessed by'
     +/'Option 3 (e.g. histology slides, scanned photographs, bit maps)'
     +/'you can create any overall collage from individual eps files.'
     +/
     +/'Advice on special Postscript fonts.'
     +/
     +/'If you learn some elementary PostScript and use text editors to'
     +/'edit Simfit PostScript files you will soon be able to make many'
     +/'alterations to the fonts such as changing shape, size, position'
     +/'or introducing exotic fonts and special effects as available on'
     +/'your printer. You must observe the syntax rules as follows. All'
     +/'parentheses must be paired as in (x) or cancelled by the escape'
     +/'character \. Note that \( means (, \) means ), \\ means \.  You'
     +/'can use octal codes such as \243 for pound \277 for upside down'
     +/'question mark \264 in Symbol for multiply, etc.  Details are in'
     +/'the Simfit manual, w_readme.? files, and simfonts.ps.')
  700 FORMAT (
     + 'How to do the editing that Editps cannot do'
     +/
     +/'There will always be some editing you want to do that cannot be'
     +/'done in Editps. For instance, Simfit only supports the standard'
     +/'PostScript fonts such as Times-Roman, Times-Bold, Times-Italic,'
     +/'Times-BoldItalic, Helvetica, Helvetica-Bold,  Helvetic-Oblique,'
     +/'Helvetica-BoldOblique, Symbol and ZapfDingbats. (Symbol-Bold is'
     +/'manufactured on the fly). If you want to use any other PS fonts'
     +/'then you will have to edit the file.Here are some other typical'
     +/'editing functions that you may want to do for yourself.'
     +/
     +/'a) Change an individual font or font size, say for a title.'
     +/'b) Change the overall line thickness, say for a slide.'
     +/'c) Change the colour of a selected feature, say the background.'
     +/'d) Change a dashed line into a dotted or continuous line.'
     +/'e) Change circles into squares or suppress a chosen symbol.'
     +/
     +/'To do all these and similar editing, you will need to read the'
     +/'file into a text editor, such as Notepad or Emacs, then make'
     +/'such changes yourself. Read the script at the top of the file'
     +/'to understand the functions then edit the data accordingly. If'
     +/'you edit a text string make sure that the corresponding key is'
     +/'edited and is as long as the string (a very common mistake).')
 
      END
C
C
