
C
C
      SUBROUTINE EDITPS_COL12N (IXCAPT, IYCAPT, NFILES, NHIGH, NIN,
     +                          NMAX, NOUT, NTITLE, NWIDE,
     +                          X_MARGIN, Y_HEIGHT, Z_SCALE,
     +                          CAPTSAV, CAPTION, FNAME, LEGEND, TITLE,
     +                          TXTCPY, TXTNEW)
C
C ACTION: Stack EPS files in 1, 2, 3, 4 or 5 column mode
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         17/05/2000 Extensive editing as follows:
C                    SAVED and initialised NLEG
C                    Introduced PSCHOP and PSCURL
C                    Introduced CAPTSAV and PSCAPS
C                    Removed restriction on displaying captions
C                    New spacing algorithm: 1/2 YSPACE for no caption
C                                           3/2 YSPACE for caption
C         04/06/2000 added 4 and 5 column modes
C         08/07/2000 added formatting to captions and title
C         25/02/2001 added NFILES to argument list
C         01/02/2008 added INTENTS
C         07/01/2009 re-named EDITPS_COL12N
C         30/09/2018 NSTACK increased from 6 to 20 to handle more rows but
C                    had to restore back to 6 as this caused problems 
C         17/03/2021 added %%BeginDocument and %%EndDocument
C         20/03/2021 commented out the extra DSC comments
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NIN, NMAX, NOUT, 
     +                                       NWIDE 
      INTEGER,             INTENT (INOUT) :: NFILES, NTITLE
      INTEGER,             INTENT (INOUT) :: IXCAPT(NMAX),
     +                                       IYCAPT(NMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: X_MARGIN, Y_HEIGHT, 
     +                                       Z_SCALE  
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTSAV(NMAX),
     +                                       CAPTION(NMAX),
     +                                       LEGEND(NHIGH),
     +                                       TITLE(NTITLE),
     +                                       TXTCPY(NHIGH),
     +                                       TXTNEW(10*NHIGH)          
C
C Locals
C     
      INTEGER    N0, N1, N2, N3, N4, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      INTEGER    NMIN, NSTACK
      PARAMETER (NMIN = - 1000000, NSTACK = 6)
      INTEGER    LEN200
      INTEGER    I, IADD1, IADD2, IADD3, IADD4, IADD5, ICOUNT, IOS,
     +           J, K, L, NCAPS, NCLIP, NCOLS, NLEG, NNEW,
     +           NROWS, NSTART
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, NUMOPT = 16)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    IX1BB, IX2BB, IY1BB, IY2BB
      INTEGER    JFONT, KFONT
      INTEGER    NLINES
      DOUBLE PRECISION XSPACE, YSPACE
      PARAMETER (XSPACE = 8.0D+00, YSPACE = 12.0D+00)
      DOUBLE PRECISION ONE, TWO, THREE, FOUR, FIVE
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, FIVE = 5.0D+00)
      DOUBLE PRECISION HALF, HALFP1, ONEP3
      PARAMETER (HALF = 0.5D+00, HALFP1 = 1.50D+00,
     +           ONEP3 = 1.333333D+00)
      DOUBLE PRECISION DD, DI, DN, RATIO
      DOUBLE PRECISION X, XDIFF, XTEMP, XSCALE, X1, X2,
     +                 Y, YDIFF, YTEMP, YSCALE, Y1, Y2
      DOUBLE PRECISION PNT01, PNT25, PNT35, PNT75, PNT95
      PARAMETER (PNT01 = 0.01D+00, PNT25 = 0.25D+00, PNT35 = 0.35D+00,
     +           PNT75 = 0.75D+00, PNT95 = 0.95D+00)
      DOUBLE PRECISION F12, F14, F72
      PARAMETER (F12 = 12.0D+00, F14 = 14.0D+00, F72 = 72.0D+00)
      DOUBLE PRECISION FCLIP
      CHARACTER  LINE*120, TEXT(30)*100
      CHARACTER  CLIPRAT*32
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  CHOSEN*15
      LOGICAL    COLUMN_1, COLUMN_2, COLUMN_3, COLUMN_4, COLUMN_5
      LOGICAL    ABORT, CENTRE, FIRST, IWARNU, JUMP, NEWDAT
      PARAMETER (FIRST = .FALSE., IWARNU = .TRUE.)
      LOGICAL    FULL, SHOW_CAPTION, SHOW_TITLE
      PARAMETER (FULL = .FALSE.)
      EXTERNAL   EDITPS_ADVISE, EDITPS_LPTCOM, EDITPS_PS2PLT,
     +           EDITPS_PSCHOP, EDITPS_PSCURL, EDITPS_PSCAPS      
      EXTERNAL   LBOX02, YESNO2, GETDGE, TRIML1, LEN200, EDITTX, PUTADV
      EXTERNAL   STRCHK$, STRPRN$, PSCODE$
      EXTERNAL   ISITPS
      INTRINSIC  MIN, NINT, DBLE, MOD
      SAVE       NCOLS, NCLIP, NLEG, CENTRE
      DATA       NCOLS, NCLIP / 1, 1 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NLEG / 0 /
      DATA       CENTRE / .TRUE. /
C
C SECTION 1: Read in possible files and check them
C ==========
C
      CALL EDITPS_PS2PLT (NFILES, NHIGH, NIN, NLEG, NMAX, NWIDE,
     +                    CAPTION, FNAME, LEGEND, TITLE,
     +                    FULL)
      IF (NFILES.LT.1) THEN
         RETURN
      ELSE
         NEWDAT = .TRUE.
         CALL EDITPS_PSCAPS (NFILES, 
     +                       CAPTSAV, CAPTION,
     +                       NEWDAT)
      ENDIF
C
C SECTION 2: Main branch point to decide on action required
C ==========
C
      NUMDEC = N1
   20 CONTINUE
      IF (NCLIP.EQ.1) THEN
         FCLIP = PNT75
         CLIPRAT = ' [Horizontal windows, y:x = 3:4]'
      ELSEIF (NCLIP.EQ.2) THEN
         FCLIP = ONE
         CLIPRAT = ' [Square windows, y:x = 1:1]'
      ELSEIF (NCLIP.EQ.3) THEN
         FCLIP = ONEP3
         CLIPRAT = ' [Vertical windows, y:x = 4:3]'
      ENDIF
      IF (CENTRE) THEN
         CHOSEN = ' [Centralised]'
      ELSE
         CHOSEN = ' [Non-central]'
      ENDIF
C
C The main menu
C
      SHOW_CAPTION = .FALSE.
      SHOW_TITLE = .FALSE.
      NUMDEC = NCOLS
      WRITE (TEXT,100) X_MARGIN, Y_HEIGHT, Z_SCALE, CLIPRAT, CHOSEN
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NUMDEC.LE.5) NCOLS = NUMDEC
      IF (NUMDEC.EQ.1) THEN
         ICOUNT = MIN(NMAX, NSTACK, NFILES)
         COLUMN_1 = .TRUE.
         COLUMN_2 = .FALSE.
         COLUMN_3 = .FALSE.
         COLUMN_4 = .FALSE.
         COLUMN_5 = .FALSE.
      ELSEIF (NUMDEC.EQ.2) THEN
         ICOUNT = MIN(NMAX, N2*NSTACK, NFILES)
         COLUMN_1 = .FALSE.
         COLUMN_2 = .TRUE.
         COLUMN_3 = .FALSE.
         COLUMN_4 = .FALSE.
         COLUMN_5 = .FALSE.
      ELSEIF (NUMDEC.EQ.3) THEN
         ICOUNT = MIN(NMAX, N3*NSTACK, NFILES)
         COLUMN_1 = .FALSE.
         COLUMN_2 = .FALSE.
         COLUMN_3 = .TRUE.
         COLUMN_4 = .FALSE.
         COLUMN_5 = .FALSE.
      ELSEIF (NUMDEC.EQ.4) THEN
         ICOUNT = MIN(NMAX, N4*NSTACK, NFILES)
         COLUMN_1 = .FALSE.
         COLUMN_2 = .FALSE.
         COLUMN_3 = .FALSE.
         COLUMN_4 = .TRUE.
         COLUMN_5 = .FALSE.
      ELSEIF (NUMDEC.EQ.5) THEN
         ICOUNT = MIN(NMAX, N5*NSTACK, NFILES)
         COLUMN_1 = .FALSE.
         COLUMN_2 = .FALSE.
         COLUMN_3 = .FALSE.
         COLUMN_4 = .FALSE.
         COLUMN_5 = .TRUE.
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Edit captions
C
         NEWDAT = .FALSE.
         CALL EDITPS_PSCAPS (NFILES, 
     +                       CAPTSAV, CAPTION, 
     +                       NEWDAT)
         GOTO 20
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Edit plot title
C
         CALL EDITTX (NTITLE, NLINES, NWIDE,
     +                TITLE)
         DO I = 1, NLINES
            CALL STRCHK$(TITLE(I))
         ENDDO
         GOTO 20
      ELSEIF (NUMDEC.EQ.8) THEN
C
C Edit the text
C
         CALL EDITTX (NHIGH, NLEG, NWIDE,
     +                LEGEND)
         IF (NLEG.GT.0) THEN
            DO I = 1, NLEG
               CALL STRCHK$(LEGEND(I))
            ENDDO
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.9) THEN
C
C Set X-margin
C
         WRITE (LINE,200) X_MARGIN
         CALL GETDGE (X_MARGIN, PNT01, 
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.10) THEN
C
C Set Y-height
C
         WRITE (LINE,300) Y_HEIGHT
         CALL GETDGE (Y_HEIGHT, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.11) THEN
C
C Set scale factor
C
         WRITE (LINE,400) Z_SCALE
         CALL GETDGE (Z_SCALE, PNT01, 
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.12) THEN
C
C Set the clipping type
C
         WRITE (TEXT,500)
         CALL LBOX02 (ICOLOR, IX, IY, NCLIP, N3, NUMPOS, 
     +                TEXT)
         GOTO 20
      ELSEIF (NUMDEC.EQ.13) THEN
C
C Set centralising parameter
C
         CENTRE = .NOT.CENTRE
         GOTO 20
      ELSEIF (NUMDEC.EQ.14) THEN
C
C Show PS codes
C
         CALL PSCODE$
         GOTO 20
      ELSEIF (NUMDEC.EQ.15) THEN
C
C Help
C
         CALL EDITPS_ADVISE (ABORT, FIRST)
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
         LINE =
     +'This action releases current selected files ... Proceed ?'
         ABORT = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE, 
     +                ABORT)
         IF (ABORT) THEN
            RETURN
         ELSE
            GOTO 20
         ENDIF
      ENDIF
C
C Calculate further parameters as required
C ICOUNT = no. items to be plotted
C NSTART = item where right shift may be required for centering
C CENTRE = .TRUE./FALSE. Note: NSTART > ICOUNT implies no centering
C NCOLS = no. columns
C NROWS = no. of rows
C
      IF (ICOUNT.LT.NFILES) CALL PUTADV (
     +'Truncated ... Must be =< 20 stacking rows (use more columns ?)')
      IF (CENTRE .AND. NCOLS.GT.N1) THEN
         I = MOD(ICOUNT,NCOLS)
         IF (I.EQ.N0) THEN
            NSTART = ICOUNT + N1
         ELSE
            NROWS = ICOUNT/NCOLS + N1
            IF (NROWS.GT.N1) THEN
               NSTART = (NROWS - N1)*NCOLS + N1
            ELSE
               NSTART = ICOUNT + N1
            ENDIF
         ENDIF
      ELSE
         NSTART = ICOUNT + N1
      ENDIF
C
C SECTION 3: Calculate PostScript parameters ... First X and Y
C ==========
C
      X = X_MARGIN*F72
      Y = Y_HEIGHT*F72
C
C Now XDIFF etc. which depend on COLUMN_1, COLUMN_2 and COLUMN_3
C

      IF (COLUMN_1) THEN
         IF (ICOUNT.LT.3) THEN
            X = (ONE + PNT35)*X
            XDIFF = (FIVE + PNT25)*F72*Z_SCALE
         ELSE
            X = (ONE + PNT95)*X
            XDIFF = FOUR*F72*Z_SCALE
         ENDIF
         YDIFF = FCLIP*XDIFF
         IX1BB = NINT(X)
         IX2BB = NINT(X + XDIFF)
         NCAPS = N0
         DO I = N1, ICOUNT
            IF (CAPTION(I).NE.BLANK) NCAPS = NCAPS + N1
         ENDDO
         DN = DBLE(NCAPS)
         DI = DBLE(ICOUNT)
         DD = DN*HALFP1 + (DI - DN)*HALF
         IY1BB = NINT(Y - DI*YDIFF - DD*Z_SCALE*YSPACE)
      ELSEIF (COLUMN_2) THEN
         XDIFF = THREE*F72*Z_SCALE
         YDIFF = FCLIP*XDIFF
         IX1BB = NINT(X)
         IX2BB = NINT(X + TWO*XDIFF + Z_SCALE*XSPACE)
         NCAPS = N0
         IADD1 = N1
         DO WHILE (IADD1.LE.ICOUNT)
            IADD2 = IADD1 + N1
            IF (IADD2.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR. CAPTION(IADD2).NE.BLANK)
     +             NCAPS = NCAPS + N1
            ELSE
               IF (CAPTION(IADD1).NE.BLANK) NCAPS = NCAPS + N1
            ENDIF
            IADD1 = IADD2 + N1
         ENDDO
         DN = DBLE(NCAPS)
         IF (ICOUNT.LT.N2) THEN
            DI = ONE
         ELSEIF (MOD(ICOUNT,N2).EQ.N0) THEN
            DI = DBLE(ICOUNT/N2)
         ELSE
            DI = DBLE(ICOUNT/N2) + ONE
         ENDIF
         DD = DN*HALFP1 + (DI - DN)*HALF
         IY1BB = NINT(Y - DI*YDIFF - DD*Z_SCALE*YSPACE)
      ELSEIF (COLUMN_3) THEN
         XDIFF = TWO*F72*Z_SCALE
         YDIFF = FCLIP*XDIFF
         IX1BB = NINT(X)
         IX2BB = NINT(X + THREE*XDIFF + TWO*Z_SCALE*XSPACE)
         NCAPS = N0
         IADD1 = N1
         DO WHILE (IADD1.LE.ICOUNT)
            IADD2 = IADD1 + N1
            IADD3 = IADD2 + N1
            IF (IADD3.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK .OR.
     +             CAPTION(IADD3).NE.BLANK) NCAPS = NCAPS + N1
            ELSEIF (IADD2.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK) NCAPS = NCAPS + N1
            ELSE
               IF (CAPTION(IADD1).NE.BLANK) NCAPS = NCAPS + N1
            ENDIF
            IADD1 = IADD3 + N1
         ENDDO
         DN = DBLE(NCAPS)
         IF (ICOUNT.LT.N3) THEN
           DI = ONE
         ELSEIF (MOD(ICOUNT,N3).EQ.N0) THEN
            DI = DBLE(ICOUNT/N3)
         ELSE
            DI = DBLE(ICOUNT/N3) + ONE
         ENDIF
         DD = DN*HALFP1 + (DI - DN)*HALF
         IY1BB = NINT(Y - DI*YDIFF - DD*Z_SCALE*YSPACE)
      ELSEIF (COLUMN_4) THEN
         XDIFF = TWO*F72*Z_SCALE
         YDIFF = FCLIP*XDIFF
         IX1BB = NINT(X)
         IX2BB = NINT(X + FOUR*XDIFF + THREE*Z_SCALE*XSPACE)
         NCAPS = N0
         IADD1 = N1
         DO WHILE (IADD1.LE.ICOUNT)
            IADD2 = IADD1 + N1
            IADD3 = IADD2 + N1
            IADD4 = IADD3 + N1
            IF (IADD4.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK .OR.
     +             CAPTION(IADD3).NE.BLANK .OR.
     +             CAPTION(IADD4).NE.BLANK) NCAPS = NCAPS + N1
            ELSEIF (IADD3.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK .OR.
     +             CAPTION(IADD3).NE.BLANK) NCAPS = NCAPS + N1
            ELSEIF (IADD2.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK) NCAPS = NCAPS + N1
            ELSE
               IF (CAPTION(IADD1).NE.BLANK) NCAPS = NCAPS + N1
            ENDIF
            IADD1 = IADD4 + N1
         ENDDO
         DN = DBLE(NCAPS)
         IF (ICOUNT.LT.N4) THEN
           DI = ONE
         ELSEIF (MOD(ICOUNT,N4).EQ.N0) THEN
            DI = DBLE(ICOUNT/N4)
         ELSE
            DI = DBLE(ICOUNT/N4) + ONE
         ENDIF
         DD = DN*HALFP1 + (DI - DN)*HALF
         IY1BB = NINT(Y - DI*YDIFF - DD*Z_SCALE*YSPACE)
      ELSEIF (COLUMN_5) THEN
         XDIFF = TWO*F72*Z_SCALE
         YDIFF = FCLIP*XDIFF
         IX1BB = NINT(X)
         IX2BB = NINT(X + FIVE*XDIFF + FOUR*Z_SCALE*XSPACE)
         NCAPS = N0
         IADD1 = N1
         DO WHILE (IADD1.LE.ICOUNT)
            IADD2 = IADD1 + N1
            IADD3 = IADD2 + N1
            IADD4 = IADD3 + N1
            IADD5 = IADD4 + N1
            IF (IADD5.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK .OR.
     +             CAPTION(IADD3).NE.BLANK .OR.
     +             CAPTION(IADD4).NE.BLANK .OR.
     +             CAPTION(IADD5).NE.BLANK) NCAPS = NCAPS + N1
            ELSEIF (IADD4.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK .OR.
     +             CAPTION(IADD3).NE.BLANK .OR.
     +             CAPTION(IADD4).NE.BLANK) NCAPS = NCAPS + N1
            ELSEIF (IADD3.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK .OR.
     +             CAPTION(IADD3).NE.BLANK) NCAPS = NCAPS + N1
            ELSEIF (IADD2.LE.ICOUNT) THEN
               IF (CAPTION(IADD1).NE.BLANK .OR.
     +             CAPTION(IADD2).NE.BLANK) NCAPS = NCAPS + N1
            ELSE
               IF (CAPTION(IADD1).NE.BLANK) NCAPS = NCAPS + N1
            ENDIF
            IADD1 = IADD5 + N1
         ENDDO
         DN = DBLE(NCAPS)
         IF (ICOUNT.LT.N5) THEN
           DI = ONE
         ELSEIF (MOD(ICOUNT,N5).EQ.N0) THEN
            DI = DBLE(ICOUNT/N5)
         ELSE
            DI = DBLE(ICOUNT/N5) + ONE
         ENDIF
         DD = DN*HALFP1 + (DI - DN)*HALF
         IY1BB = NINT(Y - DI*YDIFF - DD*Z_SCALE*YSPACE)
      ENDIF
C
C Now correct the Bounding Box parameters for title and trailing text
C
      SHOW_TITLE = .FALSE.
      DO I = 1, NTITLE
         IF (TITLE(I).NE.BLANK) THEN
            SHOW_TITLE = .TRUE.
            IY1BB = IY1BB - NINT(Z_SCALE*YSPACE)
         ENDIF
      ENDDO
      IY1BB = IY1BB - (NLEG + N1)*NINT(Z_SCALE*YSPACE)
      IY2BB = NINT(Y)
      JFONT = NINT(F14*Z_SCALE)
      KFONT = NINT(F12*Z_SCALE)
C
C SECTION 4: Main loop to drive printer or write file as required
C ==========
C
      CALL EDITPS_LPTCOM (NOUT, 
     +                    'OPEN',
     +                    ABORT)
      IF (ABORT) GOTO 20
C
C SECTION 5: Inform user that the collage is being created/printed
C ==========
C
C Bounding Box and other coordinates then switch off showpage
C
      WRITE (NOUT,600) IX1BB, IY1BB, IX2BB, IY2BB
C
C SECTION 6: Loop over each file selected
C ==========
C
      DO I = N1, ICOUNT
C
C Define current coordinates
C
         IF (COLUMN_1) THEN
            XTEMP = X
            IF (I.EQ.1) THEN
               YTEMP = Y - YDIFF
            ELSE
               IF (CAPTION(I - 1).EQ.BLANK) THEN
                  JUMP = .FALSE.
               ELSE
                  JUMP = .TRUE.
               ENDIF
               IF (JUMP) THEN
                  YTEMP = YTEMP - YDIFF - HALFP1*Z_SCALE*YSPACE
               ELSE
                  YTEMP = YTEMP - YDIFF - HALF*Z_SCALE*YSPACE
               ENDIF
            ENDIF
         ELSEIF (COLUMN_2) THEN
            IF (I.EQ.1) THEN
               XTEMP = X
               YTEMP = Y - YDIFF
            ELSEIF (I.EQ.3 .OR. I.EQ.5 .OR. I.EQ.7 .OR.
     +              I.EQ.9 .OR. I.EQ.11) THEN
               XTEMP = X
               IF (I.EQ.3) THEN
                  IF (CAPTION(1).EQ.BLANK .AND.
     +                CAPTION(2).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.5) THEN
                  IF (CAPTION(3).EQ.BLANK .AND.
     +                CAPTION(4).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.7) THEN
                  IF (CAPTION(5).EQ.BLANK .AND.
     +                CAPTION(6).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.9) THEN
                  IF (CAPTION(7).EQ.BLANK .AND.
     +                CAPTION(8).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.11) THEN
                  IF (CAPTION(9).EQ.BLANK .AND.
     +                CAPTION(10).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ENDIF
               IF (JUMP) THEN
                  YTEMP = YTEMP - YDIFF - HALFP1*Z_SCALE*YSPACE
               ELSE
                  YTEMP = YTEMP - YDIFF - HALF*Z_SCALE*YSPACE
               ENDIF
            ELSE
               XTEMP = X + XDIFF + Z_SCALE*XSPACE
            ENDIF
         ELSEIF (COLUMN_3) THEN
            IF (I.EQ.1) THEN
               XTEMP = X
               YTEMP = Y - YDIFF
            ELSEIF (I.EQ.4 .OR. I.EQ.7 .OR. I.EQ.10 .OR. I.EQ.13 .OR.
     +              I.EQ.16) THEN
               XTEMP = X
               IF (I.EQ.4) THEN
                  IF (CAPTION(1).EQ.BLANK .AND.
     +                CAPTION(2).EQ.BLANK .AND.
     +                CAPTION(3).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.7) THEN
                  IF (CAPTION(4).EQ.BLANK .AND.
     +                CAPTION(5).EQ.BLANK .AND.
     +                CAPTION(6).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.10) THEN
                  IF (CAPTION(7).EQ.BLANK .AND.
     +                CAPTION(8).EQ.BLANK .AND.
     +                CAPTION(9).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.13) THEN
                  IF (CAPTION(10).EQ.BLANK .AND.
     +                CAPTION(11).EQ.BLANK .AND.
     +                CAPTION(12).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.16) THEN
                  IF (CAPTION(13).EQ.BLANK .AND.
     +                CAPTION(14).EQ.BLANK .AND.
     +                CAPTION(15).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ENDIF
               IF (JUMP) THEN
                  YTEMP = YTEMP - YDIFF - HALFP1*Z_SCALE*YSPACE
               ELSE
                  YTEMP = YTEMP - YDIFF - HALF*Z_SCALE*YSPACE
               ENDIF
            ELSE
               XTEMP = XTEMP + XDIFF + Z_SCALE*XSPACE
            ENDIF
         ELSEIF (COLUMN_4) THEN
            IF (I.EQ.1) THEN
               XTEMP = X
               YTEMP = Y - YDIFF
            ELSEIF (I.EQ.5 .OR. I.EQ.9 .OR. I.EQ.13 .OR. I.EQ.17 .OR.
     +              I.EQ.21) THEN
               XTEMP = X
               IF (I.EQ.5) THEN
                  IF (CAPTION(1).EQ.BLANK .AND.
     +                CAPTION(2).EQ.BLANK .AND.
     +                CAPTION(3).EQ.BLANK .AND.
     +                CAPTION(4).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.9) THEN
                  IF (CAPTION(5).EQ.BLANK .AND.
     +                CAPTION(6).EQ.BLANK .AND.
     +                CAPTION(7).EQ.BLANK .AND.
     +                CAPTION(8).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.13) THEN
                  IF (CAPTION(9).EQ.BLANK .AND.
     +                CAPTION(10).EQ.BLANK .AND.
     +                CAPTION(11).EQ.BLANK .AND.
     +                CAPTION(12).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.17) THEN
                  IF (CAPTION(13).EQ.BLANK .AND.
     +                CAPTION(14).EQ.BLANK .AND.
     +                CAPTION(15).EQ.BLANK .AND.
     +                CAPTION(16).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.21) THEN
                  IF (CAPTION(17).EQ.BLANK .AND.
     +                CAPTION(18).EQ.BLANK .AND.
     +                CAPTION(19).EQ.BLANK .AND.
     +                CAPTION(20).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ENDIF
               IF (JUMP) THEN
                  YTEMP = YTEMP - YDIFF - HALFP1*Z_SCALE*YSPACE
               ELSE
                  YTEMP = YTEMP - YDIFF - HALF*Z_SCALE*YSPACE
               ENDIF
            ELSE
               XTEMP = XTEMP + XDIFF + Z_SCALE*XSPACE
            ENDIF
         ELSEIF (COLUMN_5) THEN
            IF (I.EQ.1) THEN
               XTEMP = X
               YTEMP = Y - YDIFF
            ELSEIF (I.EQ.6 .OR. I.EQ.11 .OR. I.EQ.16 .OR. I.EQ.21 .OR.
     +              I.EQ.26) THEN
               XTEMP = X
               IF (I.EQ.6) THEN
                  IF (CAPTION(1).EQ.BLANK .AND.
     +                CAPTION(2).EQ.BLANK .AND.
     +                CAPTION(3).EQ.BLANK .AND.
     +                CAPTION(4).EQ.BLANK .AND.
     +                CAPTION(5).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.11) THEN
                  IF (CAPTION(6).EQ.BLANK .AND.
     +                CAPTION(7).EQ.BLANK .AND.
     +                CAPTION(8).EQ.BLANK .AND.
     +                CAPTION(9).EQ.BLANK .AND.
     +                CAPTION(10).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.16) THEN
                  IF (CAPTION(11).EQ.BLANK .AND.
     +                CAPTION(12).EQ.BLANK .AND.
     +                CAPTION(13).EQ.BLANK .AND.
     +                CAPTION(14).EQ.BLANK .AND.
     +                CAPTION(15).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.21) THEN
                  IF (CAPTION(16).EQ.BLANK .AND.
     +                CAPTION(17).EQ.BLANK .AND.
     +                CAPTION(18).EQ.BLANK .AND.
     +                CAPTION(19).EQ.BLANK .AND.
     +                CAPTION(20).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ELSEIF (I.EQ.26) THEN
                  IF (CAPTION(21).EQ.BLANK .AND.
     +                CAPTION(22).EQ.BLANK .AND.
     +                CAPTION(23).EQ.BLANK .AND.
     +                CAPTION(24).EQ.BLANK .AND.
     +                CAPTION(25).EQ.BLANK) THEN
                     JUMP = .FALSE.
                  ELSE
                     JUMP = .TRUE.
                  ENDIF
               ENDIF
               IF (JUMP) THEN
                  YTEMP = YTEMP - YDIFF - HALFP1*Z_SCALE*YSPACE
               ELSE
                  YTEMP = YTEMP - YDIFF - HALF*Z_SCALE*YSPACE
               ENDIF
            ELSE
               XTEMP = XTEMP + XDIFF + Z_SCALE*XSPACE
            ENDIF
         ENDIF
C
C Translate XTEMP for centering if required, i.e.  I = NSTART < ICOUNT
C
         IF (I.EQ.NSTART) THEN
            XTEMP = XTEMP +
     +     (XDIFF + Z_SCALE*XSPACE)*DBLE(NROWS*NCOLS - ICOUNT)/TWO
         ENDIF
C
C Open file and find the Bounding Box coordinates
C
         OPEN (UNIT = NIN, FILE = FNAME(I))
         CALL ISITPS (NIN, X1, X2, Y1, Y2, ABORT, IWARNU)
         REWIND (UNIT = NIN)
C
C Re-scale the old file
C
         RATIO = (Y2 - Y1)/(X2 - X1)
         IF (RATIO.LE.FCLIP) THEN
            XSCALE = XDIFF/(X2 - X1)
         ELSE
            XSCALE = FCLIP*XDIFF/(Y2 - Y1)
         ENDIF
         YSCALE = XSCALE
         WRITE (NOUT,700) (XTEMP - X1*XSCALE), (YTEMP - Y1*YSCALE)
         WRITE (NOUT,900) XSCALE, YSCALE
         IOS = 0
C
C Read in from NIN and write out to NOUT until EOF
C
         READ (NIN,800,END=40,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.0) GOTO 40
         DO WHILE (IOS.EQ.0)
            READ (NIN,800,END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            CALL TRIML1 (LINE)
            IF (LINE(1:14).NE.'%%BoundingBox:') WRITE (NOUT,800) LINE
         ENDDO
C
C Close down the file on NIN
C
   40    CONTINUE
         WRITE (NOUT,1000)
         CLOSE (UNIT = NIN)
C
C Write out the caption
C
         J = LEN200(CAPTION(I))
         IF (J.GE.1) THEN
            SHOW_CAPTION = .TRUE.
            IXCAPT(I) = NINT(XTEMP)
            IYCAPT(I) = NINT(YTEMP - Z_SCALE*YSPACE)
         ELSE
            IXCAPT(I) = NMIN
            IYCAPT(I) = NMIN
         ENDIF
      ENDDO
C
C SECTION 7: Loop has gone through all files so switch showpage on again
C ==========
C
      WRITE (NOUT,1200)
      IF (COLUMN_1) THEN
C
C Extra space
C
         IF (CAPTION(ICOUNT).NE.BLANK) THEN
            YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
         ELSE
            YTEMP = YTEMP - Z_SCALE*YSPACE
         ENDIF
      ELSEIF (COLUMN_2) THEN
C
C Extra space
C
         IF (ICOUNT.EQ.N1 .OR. MOD(ICOUNT,N2).EQ.N1) THEN
            IF (CAPTION(ICOUNT).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSE
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ENDIF
      ELSEIF (COLUMN_3) THEN
C
C Extra space
C
         IF (ICOUNT.EQ.N1 .OR. MOD(ICOUNT,N3).EQ.N1) THEN
            IF (CAPTION(ICOUNT).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSEIF (ICOUNT.EQ.N2 .OR. MOD(ICOUNT,N3).EQ.N2) THEN
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSE
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N2).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ENDIF
      ELSEIF (COLUMN_4) THEN
C
C Extra space
C
         IF (ICOUNT.EQ.N1 .OR. MOD(ICOUNT,N4).EQ.N1) THEN
            IF (CAPTION(ICOUNT).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSEIF (ICOUNT.EQ.N2 .OR. MOD(ICOUNT,N4).EQ.N2) THEN
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSEIF (ICOUNT.EQ.N3 .OR. MOD(ICOUNT,N4).EQ.N3) THEN
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N2).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSE
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N2).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N3).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ENDIF
      ELSEIF (COLUMN_5) THEN
C
C Extra space
C
         IF (ICOUNT.EQ.N1 .OR. MOD(ICOUNT,N5).EQ.N1) THEN
            IF (CAPTION(ICOUNT).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSEIF (ICOUNT.EQ.N2 .OR. MOD(ICOUNT,N5).EQ.N2) THEN
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSEIF (ICOUNT.EQ.N3 .OR. MOD(ICOUNT,N5).EQ.N3) THEN
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N2).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSEIF (ICOUNT.EQ.N4 .OR. MOD(ICOUNT,N5).EQ.N4) THEN
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N2).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N3).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ELSE
            IF (CAPTION(ICOUNT).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N1).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N2).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N3).NE.BLANK .OR.
     +          CAPTION(ICOUNT - N4).NE.BLANK) THEN
               YTEMP = YTEMP - FIVE*Z_SCALE*YSPACE/TWO
            ELSE
               YTEMP = YTEMP - Z_SCALE*YSPACE
            ENDIF
         ENDIF
      ENDIF
C
C Write the TITLE and LEGEND to NOUT then close down NOUT
C
      IF (SHOW_CAPTION .OR. SHOW_TITLE .OR. NLEG.GT.N0) THEN
C
C Initialise STRPRN$ to print strings
C
         CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                BLANK, 'OPEN')
C
C Initialise PSCURL to print {commands}
C
         L = 0
         CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
      ENDIF
      IF (SHOW_TITLE) THEN
C
C Chop out {commands} from TITLE
C
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') '%collage title'
         WRITE (NOUT,'(A)') BLANK
         K = 1
         TXTCPY(K) = '{roman}{increase}{increase}{bold}'
         DO I = 1, NTITLE
            K = K + 1
            TXTCPY(K) = TITLE(I)
         ENDDO
         K = K + 1
         TXTCPY(K) = '{roman}{decrease}{decrease}{newline}'
         K = K + 1
         DO I = K, NHIGH
            TXTCPY(I) = BLANK
         ENDDO
         CALL EDITPS_PSCHOP (NHIGH, NNEW, TXTNEW, TXTCPY)
         DO I = 1, NNEW
            LINE = TXTNEW(I)
            L = LEN200(LINE)
            IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +          L.GT.2) THEN
C
C Print {command} using PSCURL
C
               CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
            ELSE
C
C Print ragged right using STRPRN$
C
               CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                      TXTNEW(I), BLANK)
            ENDIF
         ENDDO
      ENDIF
      IF (NLEG.GT.N0) THEN
C
C Chop out {commands} from LEGEND
C
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') '%collage legend'
         WRITE (NOUT,'(A)') BLANK
         CALL EDITPS_PSCHOP (NHIGH, NNEW, TXTNEW, LEGEND)
         DO I = N1, NNEW
            LINE = TXTNEW(I)
            L = LEN200(LINE)
            IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +          L.GT.2) THEN
C
C Print {command} using PSCURL
C
               CALL EDITPS_PSCURL (KFONT, L, NOUT,
     +                             LINE)
            ELSE
C
C Print ragged right using STRPRN$
C
               CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                      TXTNEW(I), BLANK)
            ENDIF
         ENDDO
      ENDIF
      IF (SHOW_CAPTION) THEN
C
C Chop out {commands} from CAPTION
C
         WRITE (NOUT,'(A)') BLANK
         WRITE (NOUT,'(A)') '%collage captions'
         WRITE (NOUT,'(A)') BLANK
         DO J = N1, ICOUNT
            IF (IXCAPT(J).GT.NMIN .AND. IYCAPT(J).GT.NMIN) THEN
               K = 1
               TXTCPY(K) = '{roman}'
               K = K + N1
               TXTCPY(K) = CAPTION(J)
               K = K + N1
               DO I = K, NHIGH
                  TXTCPY(I) = BLANK
               ENDDO
               CALL EDITPS_PSCHOP (NHIGH, NNEW, TXTNEW, TXTCPY)
               WRITE (NOUT,1100) IXCAPT(J), IYCAPT(J)
               DO I = N1, NNEW
                  LINE = TXTNEW(I)
                  L = LEN200(LINE)
                  IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +                L.GT.2) THEN
C
C Print {command} using PSCURL
C
                     CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
                  ELSE
C
C Print ragged right using STRPRN$
C
                    CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                            TXTNEW(I), BLANK)
                 ENDIF
               ENDDO
            ENDIF
         ENDDO
      ENDIF
      WRITE (NOUT,1300)
C
C SECTION 8: Drive the printer by copying the file on NOUT if NUMDEC < 7
C ==========
C
      CALL EDITPS_LPTCOM (NOUT,
     +                    'CLOSE',
     +                    ABORT)
C
C Return to main branch point
C
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'Stack (1-column mode) then print/view/file'
     +/'Stack (2-column mode) then print/view/file'
     +/'Stack (3-column mode) then print/view/file'
     +/'Stack (4-column mode) then print/view/file'
     +/'Stack (5-column mode) then print/view/file'
     +/'Edit captions'
     +/'Edit collage title'
     +/'Edit collage text'
     +/'Set value for X-margin [',F8.3,' in]'
     +/'Set value for Y-height [',F8.3,' in]'
     +/'Set value for Scaling [',F8.3,']'
     +/'Set value for Aspect ratio',A
     +/'Change centralising status',A
     +/'Display PostScript fonts and octal codes'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'New X-margin required ( > 0.01 ): Current value =',F8.4)
  300 FORMAT (
     + 'New Y-height required ( > 0.01 ): Current value =',F8.4)
  400 FORMAT (
     + 'New scaling factor required ( > 0.01 ): Current value =',F8.4)
  500 FORMAT (
     + 'Horizontal windows, y:x = 3:4'
     +/'Square widows, y:x = 1:1'
     +/'Vertical windows, y:x = 4:3')
  600 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
c*** +/'%%BeginDocument'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: w.g.bardsley@gmail.com'
     +/'%%Title: editps/simfit (7.8.5)'
     +/'%%EndComments'
     +/'save %save before switching off showpage'
     +/'/switchoffshowpage 20 dict def'
     +/'switchoffshowpage begin'
     +/'/showpage {} def')
  700 FORMAT ('save'
     +/2F10.2,' translate')
  800 FORMAT (A)
  900 FORMAT (2F10.2,' scale')
 1000 FORMAT ('restore')
 1100 FORMAT (2I8,' moveto')
 1200 FORMAT (
     +'end %end of switchoffshowpage dictionary'
     +/'restore %restore to switch showpage back on')
 1300 FORMAT (
c****+/'%%EndDocument'
     +/'showpage')
      END
C
C
