C
C
      SUBROUTINE EDITPS_DECIDE (ISEND)
C
C Choose action
C
      IMPLICIT   NONE
C
C Argument
C      
      INTEGER, INTENT (INOUT) :: ISEND
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT, N1, N2
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 15,
     +           NSTART = 11, NTEXT = NSTART + NUMOPT - 1,
     +           N1 = 1, N2 = 2)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TAB_TOP, TAB_MID, TAB_BOT
      PARAMETER (TAB_TOP = .FALSE., TAB_MID = .FALSE.,
     +           TAB_BOT = .FALSE.)
      LOGICAL    ABORT, AGAIN, FIRST
      PARAMETER (FIRST = .FALSE.)
      EXTERNAL   EDITPS_ADVISE, PSCODE$
      EXTERNAL   LBOX01
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      AGAIN = .TRUE.
      WRITE (TEXT,100)
      DO WHILE (AGAIN)
         NUMBLD(1) = 4
         IF (ISEND.LT.1) THEN
            ISEND = 1
         ELSEIF (ISEND.GT.NUMOPT) THEN
            ISEND = NUMOPT
         ENDIF      
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, ISEND, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         IF (ISEND.EQ.NUMOPT - N2) THEN
            CALL PSCODE$
            AGAIN = .TRUE.
         ELSEIF (ISEND.EQ.NUMOPT - N1) THEN
            CALL EDITPS_ADVISE (ABORT, FIRST)
            AGAIN = .TRUE.
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'EDITPS transformations using *.eps files'
     +/
     +/'Edit:     `Rotates or re-sizes, but editing plot titles'
     +/'          `and legends only works with Simfit files.'
     +/'Stack:    `Automatically re-sizes/rearranges into k-column'
     +/'          `collages with sub-plot labels and extra text.'
     +/'Overlay:  `Can re-size/drag-drop into arbitrary collages.'
     +/'Create:   `Writes your typed-in data into a .eps file.'
     +/'Transform:`Makes targets without altering source files.'
     +/
     +/'Edit: 1 file (rotate/re-size/view/print)'
     +/'Stack: n files/library (ordered collage)'
     +/'Overlay: n files/library (arbitrary collage)'
     +/'Create: .eps file from text'
     +/'Transform: .eps into .pdf file'
     +/'Transform: .eps into .png file'
     +/'Transform: .eps into .jpg file'
     +/'Transform: .eps into .xps file'
     +/'Transfrom: .eps into .bmp file'
     +/'Transform: .eps into .pcx file'
     +/'Transform: .eps into .tif file'
     +/'Transform: .eps into .svg file'
     +/'View: PostScript fonts/codes'
     +/'Help'
     +/'Quit ... Exit program EDITPS')
      END
C
C
