C
C
      SUBROUTINE EDITPS_DRIVER
C
C
C VERSION: New DLL version of EDITPS 
C          This a stand_alone version that is no longer consistent with
C          EDITPS_ADVISE or EDITPS_DECIDE so these are now redundant
C ACTION : Gather together SIMFIT ps files
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Derived from EDITPS 07/01/2009
C          04/04/2009 added PS2SVG
C          30/09/2018 increased NMAX from 50 to 100 
C          01/01/2019 new independent self-contained version 
C                     not using EDITPS_ADVISE or EDITPS_DECIDE
C          14/03/2021 increased NMAX to 300
C                     
C
      IMPLICIT   NONE
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 15,
     +           NSTART = 11, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      LOGICAL    TAB_TOP, TAB_MID, TAB_BOT
      PARAMETER (TAB_TOP = .FALSE., TAB_MID = .FALSE.,
     +           TAB_BOT = .FALSE.)
      INTEGER    NIN, NOUT
      INTEGER    NMAX, N0, N1, N2
      PARAMETER (NMAX = 300, N0 = 0, N1 = 1, N2 = 2)
      INTEGER    NHIGH, NWIDE
      PARAMETER (NHIGH = 2*NMAX + 4, NWIDE = 100)
      INTEGER    NTITLE
      PARAMETER (NTITLE = 5)
      INTEGER    ISEND, NFILES, NSAV1, NSAV2
      INTEGER    IXCAPT(NMAX), IYCAPT(NMAX)
      DOUBLE PRECISION W_START, X_START, Y_START, Z_START
      PARAMETER (W_START = 5.50D+00, X_START = 1.125D+00,
     +           Y_START = 10.75D+00, Z_START = 1.0D+00)
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BBOXX(N2,NMAX + N1), BBOXY(N2,NMAX + N1),
     +                 XTRANS(NMAX + N1),
     +                 YTRANS(NMAX + N1), ZSCALE(NMAX + N1)
      DOUBLE PRECISION X_MARGIN, Y_HEIGHT, Z_SCALE
      DOUBLE PRECISION XX_MARGIN, YY_HEIGHT, ZZ_SCALE, ZZ_WIDE
      CHARACTER (LEN = NWIDE) CAPTION(NMAX), LEGEND(NHIGH),
     +                        TITLE(NTITLE),
     +                        CAPTSAV(NMAX), TXTNEW(10*NHIGH),
     +                        TXTCPY(NHIGH),
     +                        OLDTXT(NHIGH), NEWTXT(10*NHIGH),
     +                        XTRA2(NHIGH), XTRA3(10*NHIGH)
      CHARACTER (LEN = 1024) FNAME1(NMAX), FNAME2(NMAX), FNAME3, XTRA1
      CHARACTER (LEN = 100 ) TEXT(NTEXT)
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    AGAIN, THERE  
      LOGICAL    ASKIF, SUPPLY
      PARAMETER (ASKIF = .FALSE., SUPPLY = .FALSE.)
      EXTERNAL   EDITPS_COL12N, EDITPS_REPLOT, EDITPS_TXT2PS,
     +           EDITPS_RESIZE, HELP_EDITPS, PSCODE$
      EXTERNAL   PS2JPG, PS2PCX, PS2BMP, PS2TIF, PS2PNG, PS2PDF, DELEET,
     +           PS2SVG, PS2XPS  
      EXTERNAL   LBOX01     
      EXTERNAL   GETTMP, GETNOU
      EXTERNAL   F$SIMFIT_TMP
      SAVE       X_MARGIN, Y_HEIGHT, Z_SCALE
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
         CALL F$SIMFIT_TMP ('editps')
         NFILES = N0
         NSAV1 = N0
         NSAV2 = N0
         X_MARGIN = X_START
         Y_HEIGHT = Y_START
         Z_SCALE = Z_START
         XX_MARGIN = X_START
         YY_HEIGHT = Y_START
         ZZ_SCALE = Z_START
         ZZ_WIDE = W_START
         XTRANS(N1) = ZERO
         YTRANS(N1) = ZERO
         ZSCALE(N1) = ONE
         DO ISEND = N2, NMAX + N1
            XTRANS(ISEND) = XTRANS(ISEND - N1) + HALF
            YTRANS(ISEND) = XTRANS(ISEND - N1) + HALF
            ZSCALE(ISEND) = ONE
         ENDDO
         DO ISEND = N1, NMAX
            IXCAPT(ISEND) = - N1
            IYCAPT(ISEND) = - N1
            CAPTION(ISEND) = BLANK
            WRITE (CAPTSAV(ISEND),'(A,I3)') 'Figure', ISEND
         ENDDO
         DO ISEND = N1, NHIGH
            LEGEND(ISEND) = BLANK
            OLDTXT(ISEND) = BLANK
            XTRA2(ISEND) = BLANK
            TXTCPY(ISEND) = BLANK
         ENDDO
         DO ISEND = N1, 10*NHIGH
            TXTNEW(ISEND) = BLANK
            NEWTXT(ISEND) = BLANK
            XTRA3(ISEND) = BLANK
         ENDDO
         XTRA2(N1) = 'Page ?'
         DO ISEND = N1, NTITLE
            TITLE(ISEND) = BLANK
         ENDDO
         CALL GETNOU (NOUT)
         OPEN (UNIT = NOUT, STATUS = 'SCRATCH')
         CALL GETNOU (NIN)
         CLOSE (UNIT = NOUT)
C
C The main loop
C
      AGAIN = .TRUE.
      ISEND = 14
      DO WHILE (AGAIN)
         WRITE (TEXT,100)
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, ISEND, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         IF (ISEND.EQ.1) THEN
C
C  Edit mode
C
            CLOSE (UNIT = NIN) 
            CLOSE (UNIT = NOUT) 
            CALL EDITPS_RESIZE (NIN, NOUT)
         ELSEIF (ISEND.EQ.2) THEN
C
C Stack mode
C
            NFILES = NSAV1
            CLOSE (UNIT = NIN) 
            CLOSE (UNIT = NOUT)             
            CALL EDITPS_COL12N (IXCAPT, IYCAPT, NFILES, NHIGH, NIN, 
     +                          NMAX, NOUT, NTITLE, NWIDE,
     +                          X_MARGIN, Y_HEIGHT, Z_SCALE,
     +                          CAPTSAV, CAPTION, FNAME1, LEGEND, TITLE,
     +                          TXTCPY, TXTNEW)
             NSAV1 = NFILES
         ELSEIF (ISEND.EQ.3) THEN
C
C Overlay mode
C
            CALL GETTMP (ISEND, XTRA1)
            ISEND = 3
            NFILES = NSAV2
            CLOSE (UNIT = NIN) 
            CLOSE (UNIT = NOUT)             
            CALL EDITPS_REPLOT (NHIGH, NIN, NFILES, NMAX, NOUT, NWIDE,
     +                          BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE,
     +                          CAPTION, FNAME2, LEGEND, XTRA1, XTRA2,
     +                          XTRA3)
            NSAV2 = NFILES
            CALL DELEET (XTRA1,
     +                   ASKIF, THERE)           
         ELSEIF (ISEND.EQ.4) THEN
C
C Create mode
C
            CLOSE (UNIT = NOUT) 
            CALL EDITPS_TXT2PS (NHIGH, NOUT, NWIDE,
     +                          XX_MARGIN, YY_HEIGHT, ZZ_SCALE, ZZ_WIDE,
     +                          OLDTXT, NEWTXT)
         ELSEIF (ISEND.EQ.5) THEN
C
C Transform to PDF
C
            CALL PS2PDF (FNAME3,
     +                   SUPPLY)            
         ELSEIF (ISEND.EQ.6) THEN
C
C Transform to PNG
C         
            CALL PS2PNG (FNAME3,
     +                   SUPPLY)            
         ELSEIF (ISEND.EQ.7) THEN
C
C Transform to JPG
C         
            CALL PS2JPG (FNAME3,
     +                   SUPPLY)             
         ELSEIF (ISEND.EQ.8) THEN
C
C Transform to XPS
C         
            CALL PS2XPS (FNAME3,
     +                   SUPPLY)            
         ELSEIF (ISEND.EQ.9) THEN
C
C Transform to BMP
C         
            CALL PS2BMP (FNAME3,
     +                   SUPPLY)             
         ELSEIF (ISEND.EQ.10) THEN
C
C Transform to PCX
C         
            CALL PS2PCX (FNAME3,
     +                   SUPPLY) 
         ELSEIF (ISEND.EQ.11) THEN
C
C Transform to TIF
C         
            CALL PS2TIF (FNAME3,
     +                   SUPPLY)  
         ELSEIF (ISEND.EQ.12) THEN
C
C Transform to SVG
C         
            CALL PS2SVG (FNAME3,
     +                   SUPPLY) 
               
         ELSEIF (ISEND.EQ.13) THEN
C
C CALL PSCODE$
C         
            CALL PSCODE$
         ELSEIF (ISEND.EQ.14) THEN
C
C CALL HELP_EDITPS
C         
            CALL HELP_EDITPS ('editps')  
         ELSE
C
C Quit
C           
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C format statement
C      
  100 FORMAT (
     + 'Program EDITPS: transformations using *.eps files'
     +/
     +/'Edit:     `Rotates or re-sizes, but editing plot titles'
     +/'          `and legends only works with Simfit files.'
     +/'Stack:    `Automatically re-sizes/rearranges into k-column'
     +/'          `collages with sub-plot labels and extra text.'
     +/'Overlay:  `Can re-size/drag-drop into arbitrary collages.'
     +/'Create:   `Writes your typed-in data into a .eps file.'
     +/'Transform:`Makes targets without altering source files.'
     +/
     +/'Edit: 1 file (rotate/re-size/view/print)'
     +/'Stack: n files/library (ordered collage)'
     +/'Overlay: n files/library (arbitrary collage)'
     +/'Create: .eps file from text'
     +/'Transform: .eps into .pdf file'
     +/'Transform: .eps into .png file'
     +/'Transform: .eps into .jpg file'
     +/'Transform: .eps into .xps file'
     +/'Transfrom: .eps into .bmp file'
     +/'Transform: .eps into .pcx file'
     +/'Transform: .eps into .tif file'
     +/'Transform: .eps into .svg file'
     +/'View: PostScript fonts/codes'
     +/'Help'
     +/'Quit ... Exit program EDITPS')      
      END
C
C
