C
C
      SUBROUTINE EDITPS_LPTCOM (NOUT, 
     +                          INFO,
     +                          ABORT)
C
C ACTION : Hardcopy/view/save-file
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 29/3/98
C
C          07/04/2003 added quotes around filename passed to GSVIEW
C          16/08/2003 deleted reference to printer 4
C          17/11/2003 deleted reference to printer 3 and replaced
C                     STARTP and quotes etc. by call to RUN_GSVIEW
C          02/02/2008 added INTENTS
C          07/01/2009 renamed EDITPS_LPTCOM 
C          07/10/2013 extensively revised and added EPSPDF
C
C          INFO = 'OPEN ': decide from a menu then open a temporary file
C          INFO = 'PDF  ': prepare a temporary file for viewing in Acrobat Reader
C          INFO = 'VIEW ': prepare a temporary file for viewing in GSview
C          INFO = 'FILE ': prepare a file for saving
C          INFO = 'CLOSE': close NOUT
C
C          After one of these options there is a return to create the
C          file and the NUMDEC is saved so that on the next entry
C          the hardcopy, etc. results
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NOUT
      CHARACTER (LEN = *), INTENT (IN)  :: INFO
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 4, NUMSTA = 13, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(30)
      INTEGER    JSEND, N10
      PARAMETER (JSEND = 1, N10 = 10)
      INTEGER    L
      CHARACTER (LEN = 1024) FILEX, TNAME, USRDR
      CHARACTER (LEN = 100 ) TEXT(30)
      CHARACTER (LEN = 5   ) INFO1
      LOGICAL    OK
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   LSTBOX, OFILES, EPSPDF, DELEET, RUN_GSVIEW,
     +           DOTEPS, TRIML1, UCASE1, USRDIR, X_OKCVAL 
      SAVE       NUMDEC, FILEX
      DATA       NUMBLD / 30*0 /
      ABORT = .FALSE.
      INFO1 = INFO
      CALL TRIML1 (INFO1)
      CALL UCASE1 (INFO1)
      IF (INFO1.EQ.'OPEN ') THEN
C
C Decide what to do from the menu
C
         ABORT = .TRUE.
         WRITE (TEXT,100)
         NUMBLD(1) = 4
         NUMDEC = 2
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1 ... Open a file to contain the final PostScript
C
            CLOSE (UNIT = NOUT)
            CALL OFILES (JSEND, NOUT, 
     +                   TNAME,
     +                   ABORT)
            IF (.NOT.ABORT) CALL DOTEPS (TNAME,
     +                                   ABORT)
            IF (ABORT) CLOSE (UNIT = NOUT)
         ELSEIF (NUMDEC.LE.3) THEN
C
C NUMDEC = 2, 3 ... Open temporary file to write/copy-to-printer
C
            CALL USRDIR (L,
     +                   USRDR)
            FILEX = USRDR(1:L)//'tempfile.eps'            
            CLOSE (UNIT = NOUT)
            OPEN (UNIT = NOUT, FILE = FILEX)
            ABORT = .FALSE.
         ELSE
C
C NUMDEC = 4 ... Return to main program
C
            ABORT = .TRUE.
         ENDIF
         RETURN
       ELSEIF (INFO1.EQ.'PDF  ') THEN
C
C By pass the menu and go directly to creating a temporary file for Acrobat Reader
C

         CALL USRDIR (L,
     +                USRDR)
         FILEX = USRDR(1:L)//'tempfile.eps'     
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = FILEX)
         ABORT = .FALSE.
         NUMDEC = 3
         RETURN   
      ELSEIF (INFO1.EQ.'VIEW ') THEN
C
C By pass the menu and go directly to creating a temporary file for GSview
C

         CALL USRDIR (L,
     +                USRDR)
         FILEX = USRDR(1:L)//'tempfile.eps'     
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = FILEX)
         ABORT = .FALSE.
         NUMDEC = 2
         RETURN
      ELSEIF (INFO1.EQ.'FILE ') THEN
C
C By pass the menu and go directly to creating a file for saving
C
         CLOSE (UNIT = NOUT)
         CALL OFILES (JSEND, NOUT,
     +                TNAME, 
     +                ABORT)
         IF (.NOT.ABORT) CALL DOTEPS (TNAME, 
     +                                ABORT)
         IF (ABORT) CLOSE (UNIT = NOUT)
         NUMDEC = 1
         RETURN
      ELSEIF (INFO1.EQ.'CLOSE') THEN
C
C Close because the routine was called with 'CLOSE'
C      
         CLOSE (UNIT = NOUT)
         IF (NUMDEC.EQ.4) NUMDEC = 0
      ELSE
C
C As for 'CLOSE' but left in for possible future error reporting
C        
         CLOSE (UNIT = NOUT)
         IF (NUMDEC.EQ.4) NUMDEC = 0     
      ENDIF
C
C View or copy file to port
C
      IF (NUMDEC.EQ.2 .OR. NUMDEC.EQ.3) THEN
         CLOSE (UNIT = NOUT)
         IF (NUMDEC.EQ.2) THEN
            CALL X_OKCVAL (N10,
     +                     OK)
            IF (OK) THEN            
               CALL RUN_GSVIEW (FILEX)
            ELSE 
               CALL EPSPDF (FILEX)
            ENDIF     
         ELSEIF (NUMDEC.EQ.3) THEN
            CALL EPSPDF (FILEX)
         ENDIF
         CALL DELEET (FILEX, 
     +                ASKIF, THERE)
      ENDIF
      
C
C Format statement
C     
  100 FORMAT (
     + 'PostScript Options'
     +/
     +/'If you have Ghostscript installed you can now open'
     +/'the plot in your PDF Viewer (e.g. Acrobat Reader),'
     +/'or in your PostScript Viewer (e,g GSview) in order'
     +/'to View, Print, or Save As...'
     +/
     +/'A more versatile option is to create an EPS file in'
     +/'order to archive the plot in a compact form that can'
     +/'be used retropectively to create other graphics files'
     +/'such as PNG, SVG, PDF, JPG, TIF, BMP, or PCX.'
     +/
     +/'Create an EPS File'
     +/'View/Print/Save As ... EPS'
     +/'View/Print/Save As ... PDF'
     +/'Cancel')
      END
C
C
