C

C
C
      SUBROUTINE EDITPS_PS2LIB (NFILES, NIN, NSMALL, 
     +                          FSAV,
     +                          ABORT)
C
C ACTION: Use a library file to read in a set of PS files
C         Returns PS files in FSAV(NFILES)
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         10/01/2000 derived from LIBFIL
C         29/11/2001 added VU2CHK and FNLIB
C         08/01/2007 added call to SIMDIR
C         24/07/2007 changed SIMDIR to DEMDIR and trapped blank lines 
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITPS_PS2LIB 
C         21/04/2009 edited for the SIMDEM EDITPS [Demo] button
C
C         ABORT = .TRUE. if library file not usable
C         If NSMALL = 1 then just return a PS file  
C
C NFILES: (output) number of EPS files selected
C    NIN: (input/unchanged) unconnected unit for reading files
C NSMALL: (input/unchanged) dimension
C   FSAV: (output) Postscript files
C  ABORT: (output) error indicator
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NIN, NSMALL  
      INTEGER,             INTENT (OUT) :: NFILES 
      CHARACTER (LEN = *), INTENT (OUT) :: FSAV(NSMALL)
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    N0, N1, N3
      PARAMETER (N0 = 0, N1 = 1, N3 = 3)
      INTEGER    I, IADD1, IOS, ISEND, K, L, LEN200
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER  LINE*100, TITLE*100
      CHARACTER  FNAME*1024, FNLIB*1024, SIMFIT*1024, TEMP*1024
      CHARACTER  AUX256*1024
      CHARACTER  BLANK*1, BSLASH*1
      PARAMETER (BLANK = ' ', BSLASH = '\')
      LOGICAL    IWARNU, YES
      PARAMETER (IWARNU = .FALSE.)
      EXTERNAL   CHECKF, OFILES, PUTADV, PUTFAT, TXT2FN, ISITPS, VU2CHK,
     +           DEMDIR, TRIML1, LEN200, AUX256      
      INTRINSIC  INDEX   
C
C Part 1: First initialise ABORT and NFILES
C ======
C
      ABORT = .TRUE.
      NFILES = N0
      IF (NSMALL.LT.N1) RETURN
      DO I = N1, NSMALL
         FSAV(I) = BLANK
      ENDDO   
C
C Part 2: Check that the file seems to be a library file
C ======
C
      ISEND = N3
      CLOSE (UNIT = NIN)
      CALL OFILES (ISEND, NIN, 
     +             FNAME,
     +             ABORT)
      CLOSE (UNIT = NIN)
      IF (ABORT) RETURN
C
C Is it PS file ? ... if so then return silently
C
      OPEN (UNIT = NIN, FILE = FNAME)
      CALL ISITPS (NIN, 
     +             X1, X2, Y1, Y2, 
     +             ABORT, IWARNU)
      CLOSE (UNIT = NIN)
      IF (.NOT.ABORT) THEN
         NFILES = N1
         FSAV(N1) = FNAME
         RETURN
      ENDIF
      IF (NSMALL.EQ.N1) RETURN
C
C Is it a library file ?
C
      OPEN (UNIT = NIN, FILE = FNAME)
      FNLIB = FNAME
      READ (NIN,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.N0) THEN  
         WRITE (LINE,100)
         CALL PUTFAT (LINE) 
         CLOSE (UNIT = NIN)
         CALL VU2CHK (FNLIB)
         RETURN
      ENDIF
      CLOSE (UNIT = NIN)
      CALL CHECKF (FNAME, TITLE, 
     +             ABORT)
      IF (ABORT) THEN
         RETURN
      ELSE
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)',IOSTAT=IOS) TITLE
      ENDIF
C
C Read in the file names
C
      IADD1 = N0
      IOS = N0
      DO WHILE (IOS.EQ.N0 .AND. IADD1.LT.NSMALL)
         ABORT = .TRUE.
         READ (NIN,'(A)',IOSTAT=IOS) FNAME
         IF (IOS.EQ.N0) THEN
            IF (FNAME.EQ.BLANK) THEN
               IOS = - N1
            ELSE   
               CALL TXT2FN (FNAME, 
     +                      ABORT)
               IF (ABORT) THEN                
                  WRITE (LINE,200)
                  CALL PUTFAT (LINE)
                  WRITE (LINE,300) I + N1
                  CALL PUTADV (LINE)
                  CLOSE (UNIT = NIN)
                  CALL VU2CHK (FNLIB)
                  RETURN
               ELSE
                  IADD1 = IADD1 + N1
                  FSAV(IADD1) = FNAME
               ENDIF
            ENDIF   
         ENDIF
      ENDDO
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
C
C Part 3: Check for files existing and PS format
C ======
C
      IF (IADD1.LE.N0) THEN    
         WRITE (LINE,400)
         CALL PUTFAT (LINE) 
         CALL VU2CHK (FNLIB)
         RETURN
      ENDIF 
      CALL DEMDIR (L,
     +             SIMFIT)       
      DO I = N1, IADD1
         CLOSE (UNIT = NIN)
         INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
         IF (L.GT.0 .AND. .NOT.YES .AND. 
     +       INDEX(FSAV(I),BSLASH).LT.N1) THEN
            TEMP = FSAV(I)
            CALL TRIML1 (TEMP)
            K = LEN200(TEMP)
            FSAV(I) = SIMFIT(N1:L)//TEMP(N1:K)
            INQUIRE (FILE = FSAV(I), EXIST = YES, IOSTAT = IOS)
         ELSEIF (.NOT.YES) THEN
            TEMP = AUX256 (FSAV(I)) 
            INQUIRE (FILE = TEMP, EXIST = YES, IOSTAT = IOS)
            IF (YES .AND. IOS.EQ.N0) FSAV(I) = TEMP   
         ENDIF   
         IF (YES .AND. IOS.EQ.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV(I))
            CALL ISITPS (NIN,
     +                   X1, X2, Y1, Y2, 
     +                   ABORT, IWARNU)
            CLOSE (UNIT = NIN)   
            IF (ABORT) THEN
               WRITE (LINE,300) I
               CALL PUTFAT (LINE)
               CLOSE (UNIT = NIN)
               RETURN
            ENDIF
            NFILES = NFILES + N1
            FSAV(NFILES) = FSAV(I)
         ELSE
            IOS = N1 
            WRITE (LINE,500)
            CALL PUTFAT (LINE)
         ENDIF
         IF (IOS.NE.N0) THEN
            WRITE (LINE,300) I + N1
            CALL PUTADV (LINE)
            ABORT = .TRUE.
            CLOSE (UNIT = NIN)
            CALL VU2CHK (FNLIB)
            RETURN
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
      CLOSE (UNIT = NIN)
C
C Set ABORT = .FALSE. if at least one file is satisfactory
C
      IF (NFILES.GT.N0) ABORT = .FALSE.
C
C Format statements
C      
  100 FORMAT (
     +'EDITPS_PS2LIB error: Title not defined in library file')
  200 FORMAT (
     +'EDITPS_PS2LIB error: File inconsistent with Operating System')
  300 FORMAT (
     +'EDITPS_PS2LIB error: File missing or not PS/EPS at line',I4)
  400 FORMAT (
     +'EDITPS_PS2LIB error: No files in library file')
  500 FORMAT (
     +'EDITPS_PS2LIB error: File referenced in library file not found')
      END
C
C
