C
C
      SUBROUTINE EDITPS_PS2PLT (ICOUNT, NHIGH, NIN, NLEG, NMAX, NWIDE,
     +                          CAPTION, FNAME, LEGEND, TITLE,
     +                          FULL)
C
C ACTION : Read in possible files and check them
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          10/01/2000 added PS2LIB to allow library files
C          24/02/2001 added PFILES
C          02/02/2008 added INTENTS 
C          07/01/2009 renamed EDITPS_PS2PLT  
C          30/03/2010 enlarged menu for format 100   
C
C          ICOUNT = no. of files selected
C          If NMAX = 1 then just select 1 file
C
C          FULL = .TRUE. then also ask for caption/title/text
C          There is now no need to call with FULL = .TRUE. as a
C          better mechanism is used. Code is retained just in case.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NIN, NMAX,
     +                                       NWIDE
      INTEGER,             INTENT (INOUT) :: ICOUNT, NLEG
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTION(NMAX),
     +                                       LEGEND(NHIGH),
     +                                       TITLE
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NMAX)
      LOGICAL,             INTENT (IN)    :: FULL
C
C Locals
C
      INTEGER    ICOLOR, ISEND, ITYPE, IX, IY, LSHADE, NOUT10,
     +           NSTART, NTEXT, NUMDEC, NUMOPT, N0, N1, N2, N3, N4
      PARAMETER (ICOLOR = 9, ISEND = 3, ITYPE = 6, IX = 4, IY = 4,
     +           LSHADE = 1, NOUT10 = 10, 
     +           N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    I, IPREV, NFILES, NMAX1, NBEGIN
      DOUBLE PRECISION X1, X2, Y1, Y2
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1, QUEST*1, TNAME*1024
      PARAMETER (BLANK = ' ', QUEST = '?')
      LOGICAL    IHELPU
      LOGICAL    ABORT, ACCEPT(200), FIRST, FRAME, IWARNU, YES
      PARAMETER (IWARNU = .TRUE., FRAME = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   OFILES, GETTXT, PUTADV, YESNO2, EDITTX, LBOX01,
     +           PATCH1, PFILES
      EXTERNAL   STRCHK$
      EXTERNAL   ISITPS, EDITPS_PS2LIB
      SAVE       IHELPU
      DATA       IHELPU / .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise. Note that ICOUNT is zeroised if only 1 file is required.
C
      IF (NMAX.EQ.N1) ICOUNT = N0
      NFILES = N0
      NMAX1 = NMAX
      NBEGIN = N1
      FIRST = .TRUE.
      YES = .TRUE.
C
C Main loop
C
      DO WHILE (ICOUNT.LT.NMAX .AND. YES)
         IF (NMAX.GT.N1) THEN
C
C If more than 1 file expected and first time then try options
C
            IF (FIRST) THEN
               FIRST = .FALSE.
               WRITE (TEXT,100)
               NUMDEC = 4
               NUMBLD(1) = 4
               NUMOPT = 5
               NSTART = 14
               NTEXT = NSTART + NUMOPT - 1
               CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC,
     +                      NUMOPT, NUMPOS, NSTART, NTEXT, 
     +                      TEXT,
     +                      BORDER, FLASH, HIGH)
               IF (NUMDEC.LE.N2) ICOUNT = N0
            ENDIF
            IF (NUMDEC.LE.N2) THEN
               CLOSE (UNIT = NIN)
               CALL EDITPS_PS2LIB (NFILES, NIN, NMAX1,
     +                             FNAME(NBEGIN), 
     +                             ABORT)
               CLOSE (UNIT = NIN)
               IF (ABORT) THEN
C
C Return with no files ... not a PS or library file
C
                  ICOUNT = N0
                  RETURN
               ELSEIF (NFILES.EQ.N1) THEN
C
C Just 1 PS file so carry on with 1 file at a time
C
                  ICOUNT = ICOUNT + N1
                  NBEGIN = NBEGIN + N1
                  NMAX1 = N1
C
C Next code for FULL = .TRUE. is probably redundant
C
                  IF (FULL) THEN
                     WRITE (LINE,100) 
                     CALL GETTXT (LINE,
     +                            CAPTION(ICOUNT))
                     IF (CAPTION(ICOUNT).EQ.QUEST)
     +                   CAPTION(ICOUNT) = BLANK
                     CALL STRCHK$(CAPTION(ICOUNT))
                  ENDIF
               ELSE
C
C The library file referenced NFILES PS files so set ICOUNT then return
C
                  ICOUNT = NFILES
                  RETURN
               ENDIF
            ELSEIF (NUMDEC.EQ.N3) THEN
C
C Multi-selection by project then return whatever the outcome
C
               CLOSE (UNIT = NIN)
               CLOSE (UNIT = NOUT10)
               IPREV = ITYPE
               NFILES = ICOUNT
               CALL PFILES (IPREV, ITYPE, NFILES, NIN, NMAX, NOUT10,
     +                      FNAME,
     +                      ACCEPT)
               ICOUNT = NFILES
               CLOSE (UNIT = NIN)
               CLOSE (UNIT = NOUT10)
               RETURN
            ELSEIF (NUMDEC.EQ.N4) THEN
C
C Help
C
               FIRST = .TRUE.
               WRITE (TEXT,200)
               NTEXT = 21
               NUMBLD(1) = N1
               CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                      TEXT,
     +                      FRAME)
            ELSE
C
C Cancel
C
               RETURN
            ENDIF
         ELSE
C
C Just select 1 file
C
            NUMDEC = N2
            IF (IHELPU) THEN
               IHELPU = .FALSE. 
               CALL PUTADV (
     +'Input an EPSF standard PostScript file (like simfig1.ps)')
            ENDIF
            CLOSE (UNIT = NIN)
            CALL OFILES (ISEND, NIN,
     +                   TNAME, 
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               CALL ISITPS (NIN,
     +                      X1, X2, Y1, Y2,
     +                      ABORT, IWARNU)
               IF (.NOT.ABORT) THEN
                  ICOUNT = N1
                  FNAME(ICOUNT) = TNAME
C
C Next code for FULL = .TRUE. is probably redundant
C
                  IF (FULL) THEN
                     WRITE (LINE,300) ICOUNT
                     CALL GETTXT (LINE, 
     +                            CAPTION(ICOUNT))
                     IF (CAPTION(ICOUNT).EQ.QUEST)
     +                   CAPTION(ICOUNT) = BLANK
                     CALL STRCHK$(CAPTION(ICOUNT))
                  ENDIF
                  RETURN
               ELSE
                  ICOUNT = N0
               ENDIF
            ENDIF
         ENDIF
         CLOSE (UNIT = NIN)
C
C See if the user wants to try again
C
         IF (YES .AND. ICOUNT.LT.NMAX .AND. NUMDEC.NE.4) THEN
            CALL YESNO2 (ICOLOR, IX, IY,
     +     'Do you want to select another ps file ?',
     +                   YES)
         ENDIF
      ENDDO
C
C Warn if no files have been selected
C
      IF (ICOUNT.LT.N1) THEN
         CALL PUTADV (
     +  'You must have at least one file for this option')
         RETURN
      ENDIF
C
C Next code for FULL = .TRUE. is probably redundant
C Get title and legends ... note STRCHK$ to check for parentheses
C
      IF (FULL) THEN
         WRITE (TEXT,400)
         NUMDEC = 3
         NUMBLD(1) = 4
         NUMOPT = 4
         NSTART = 11
         NTEXT = NSTART + NUMOPT - 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.1 .OR. NUMDEC.EQ.3) THEN
            CALL GETTXT ('Short overall plot title (< 72 characters ?)',
     +                    TITLE)
            CALL STRCHK$(TITLE)
            IF (TITLE.EQ.QUEST) TITLE = BLANK
         ELSE
            TITLE = BLANK
         ENDIF
         IF (NUMDEC.EQ.2 .OR. NUMDEC.EQ.3) THEN
            CALL EDITTX (NHIGH, NLEG, NWIDE,
     +                   LEGEND)
            IF (NLEG.GT.N0) THEN
               DO I = 1, NLEG
                  CALL STRCHK$(LEGEND(I))
               ENDDO
            ENDIF
         ELSE
            NLEG = N0
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Selecting Encapsulated PostScript files'
     +/
     +/'Most EDITPS options work with any encapsulated'
     +/'PostScript files having correct BoundingBoxes, but'
     +/'there are exceptions. For instance editing titles'
     +/'and legends only works with SIMFIT files. Also,'
     +/'stacking files into a collage with a chosen number of'
     +/'columns only works optimally if all files have identical'
     +/'aspect ratios, e.g. x:y = 4:3, or 1:1, or 2:1, say and'
     +/'have Portrait orientation and the same size. For such'
     +/'collages, set the SIMFIT PostScript control to output'
     +/'files in Portrait format using default parameters.'
     +/
     +/'Input a library file'
     +/'Input n files individually'
     +/'Input n files as a project'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'Selecting Encapsulated PostScript files (.ps, .eps)'
     +/
     +/'This program now requires you to input a set of Postscript'
     +/'files to compose a figure. All files must conform to the'
     +/'EPSF convention and must have correct BoundingBoxes.'
     +/'The possible ways to supply such files are as follows.'
     +/'1)`Supply a library file created by program MAKLIB with a'
     +/'  `list of all the files required. This is the best method.'
     +/'2)`You select individual files using the SIMFIT single file'
     +/'  `selection procedure. This technique should be used when'
     +/'  `you only need a few files that have been recently created'
     +/'  `by SIMFIT and that can therefore be taken from the Files'
     +/'  `Created List. Files are tested individually for conformance'
     +/'  `to the EPSF standard as they are selected.'
     +/'3)`You open a multiselection project. This technique generates'
     +/'  `an archive file (p_current.cfg) with all the files you have'
     +/'  `recently selected and is ideal when you wish to select sets'
     +/'  `of files from a set of stored files. Files are tested after'
     +/'  `a project set has been selected, but the current project set'
     +/'  `can be edited and selections can be added to the archive.'
     +/'  `This is a very powerful technique for experienced users')
  300 FORMAT (
     +'Short caption (< 50 characters ?) to go underneath plot',I3)
  400 FORMAT (
     + 'Adding a title and text to the collage'
     +/
     +/'You can specify a title and/or text to be placed underneath'
     +/'the collage. If you want a title it will consist of just one'
     +/'line in a large bold font. If you want any extra text, just'
     +/'fill in the editor as required. However, make no attempt to'
     +/'justify the text as this program transforms what you type'
     +/'into ragged right PostScript format with a width that depends'
     +/'upon the dimensions of the collage.'
     +/
     +/'Title only'
     +/'Text only'
     +/'Title and text'
     +/'Nothing')
      END
C
C
