C
C
      SUBROUTINE EDITPS_PSADD1 (ISEND, IX1BB, IX2BB, IY1BB, IY2BB,
     +                          NHIGH, NOUT, NWIDE, FNAME,
     +                          LEGEND, TXTNEW,
     +                          EXTRA)
C
C ACTION: Create a PS text file
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 18/05/2000
C         17/11/2003 replaced STARTP by RUN_GSVIEW
C         02/02/2008 added INTENTS 
C         07/01/2009 renamed EDITPS_PSADD1
C         20/03/2021 added %%BeginDocument and %%EndDocument
C         20/03/2021 commented out the extra DSC comments
C
C         ISEND = 1: View
C         ISEND = 2: Edit
C         ISEND = 3: X_margin
C         ISEND = 4: Y_margin
C         ISEND = 5: Width
C         ISEND = 6: Z_scale
C         ISEND = 7: PScodes
C         ISEND = 8: Help
C         ISEND = 9: include
C         ISEND = 10: suppress
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NHIGH, NOUT,
     +                                       NWIDE
      INTEGER,             INTENT (INOUT) :: IX1BB, IX2BB, 
     +                                       IY1BB, IY2BB
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      CHARACTER (LEN = *), INTENT (INOUT) :: LEGEND(NHIGH),
     +                                       TXTNEW(10*NHIGH)      
      LOGICAL,             INTENT (INOUT) :: EXTRA
C
C Locals
C      
      INTEGER    N0, N1, N2, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N10 = 10)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, NUMOPT = 10)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    JFONT, KFONT
      INTEGER    I, J, L, LEN200, NLEG, NNEW
      DOUBLE PRECISION X_MARGIN, Y_MARGIN, Z_SCALE, Z_WIDE
      DOUBLE PRECISION YSPACE, YSTOP
      PARAMETER       (YSPACE = 16.0D+00, YSTOP = 36.0D+00)
      DOUBLE PRECISION X, XDIFF, Y, YTEMP
      DOUBLE PRECISION PNT01
      PARAMETER (PNT01 = 0.01D+00)
      DOUBLE PRECISION F12, F14, F72
      PARAMETER (F12 = 12.0D+00, F14 = 14.0D+00, F72 = 72.0D+00)
      CHARACTER  LINE*120, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, AGAIN, FILE, FIRST, OK, READY
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    WRAP, WRAP1
      PARAMETER (WRAP1 = .TRUE.)
      EXTERNAL   LBOX02, GETDGE, EDITTX, PUTADV, LEN200
      EXTERNAL   STRCHK$, STRPRN$, PSCODE$
      EXTERNAL   EDITPS_ADVISE, EDITPS_PSCHOP, EDITPS_PSCURL
      EXTERNAL   RUN_GSVIEW, X_OKCVAL, EPSPDF
      INTRINSIC  NINT, DBLE
      SAVE       NLEG, X_MARGIN, Y_MARGIN, Z_WIDE, Z_SCALE, READY
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NLEG / 0 /
      DATA       X_MARGIN, Y_MARGIN / 3.5D+00, 0.5D+00 /
      DATA       Z_WIDE / 2.0D+00 /
      DATA       Z_SCALE / 1.0D+00 /
      DATA       READY / .FALSE. /
      IF (ISEND.LT.N1 .OR. ISEND.GT.NUMOPT) THEN
         RETURN
      ELSE
         NUMDEC = ISEND
      ENDIF
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         IF (ISEND.LT.NUMOPT - N2) THEN
            WRITE (TEXT,100) X_MARGIN, Y_MARGIN, Z_WIDE, Z_SCALE
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C View
C
            IF (READY) THEN
               CALL X_OKCVAL (N10,
     +                        OK)
               IF (OK) THEN                
                  CALL RUN_GSVIEW (FNAME)
               ELSE
                  CALL EPSPDF (FNAME)
               ENDIF      
            ELSE
               CALL PUTADV ('File has not yet been created')
            ENDIF
            FILE = .FALSE.
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Edit
C
            CALL EDITTX (NHIGH, NLEG, NWIDE, LEGEND)
            IF (NLEG.GT.N0) THEN
               DO I = N1, NLEG
                 CALL STRCHK$(LEGEND(I))
                ENDDO
            ENDIF
            FILE =.TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C X_margin
C
            WRITE (LINE,200) 'X-start (in)', X_MARGIN
            CALL GETDGE (X_MARGIN, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Y-margin
C
            WRITE (LINE,200) 'Y-start (in)', Y_MARGIN
            CALL GETDGE (Y_MARGIN, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Linewidth
C
            WRITE (LINE,200) 'Linewidth (in)', Z_WIDE
            CALL GETDGE (Z_WIDE, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Scale
C
            WRITE (LINE,200) 'Scaling factor', Z_SCALE
            CALL GETDGE (Z_SCALE, PNT01, LINE)
            FILE = .TRUE.
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Show pscodes
C
            CALL PSCODE$
            FILE = .FALSE.
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Help
C
            CALL EDITPS_ADVISE (ABORT, FIRST)
            FILE = .FALSE.
            NUMDEC = 2
         ELSE
C
C Proceed
C
            IF (NUMDEC.EQ.NUMOPT - N1) THEN
               EXTRA = .TRUE.
            ELSE
               EXTRA = .FALSE.
            ENDIF
            AGAIN = .FALSE.
            FILE = .TRUE.
         ENDIF
C
C Calculate PostScript parameters ... First X and Y
C
         IF (FILE) THEN
            X = X_MARGIN*F72
            Y = DBLE(NLEG + N2)*Z_SCALE*YSPACE + Y_MARGIN*F72
C
C Now XDIFF etc.
C

            YTEMP = Y - Z_SCALE*YSPACE
            XDIFF = Z_WIDE*F72*Z_SCALE
            IX1BB = NINT(X)
            IX2BB = NINT(X + XDIFF)
            IY2BB = NINT(Y)
            IY1BB = IY2BB - (NLEG + N2)*NINT(Z_SCALE*YSPACE)
            JFONT = NINT(F14*Z_SCALE)
            KFONT = NINT(F12*Z_SCALE)
C
C Main loop to drive printer or write file as required
C
            CLOSE (UNIT = NOUT)
            OPEN (UNIT = NOUT, FILE = FNAME)
C
C Bounding Box and other coordinates
C
            WRITE (NOUT,300) IX1BB, IY1BB, IX2BB, IY2BB
            WRAP = WRAP1
            IF (WRAP) THEN
C
C Initialise STRPRN$ to print strings
C
               CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                      BLANK, 'OPEN')
C
C Initialise PSCURL to print {commands}
C
               L = 0
               CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
C
C Chop out {commands}
C
               CALL EDITPS_PSCHOP (NHIGH, NNEW, TXTNEW, LEGEND)
               DO I = 1, NNEW
                  LINE = TXTNEW(I)
                  L = LEN200(LINE)
                  IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +                L.GT.2) THEN
C
C Print {command} using PSCURL
C
                     CALL EDITPS_PSCURL (KFONT, L, NOUT, LINE)
                  ELSE
C
C Print ragged right using STRPRN$
C
                     CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP),
     +                            NOUT, TXTNEW(I), BLANK)
                  ENDIF
               ENDDO
            ELSE
               DO I = 1, NLEG
                  IF (LEGEND(I).NE.BLANK .AND. YTEMP.GE.YSTOP) THEN
                     J = LEN200(LEGEND(I))
                     WRITE (NOUT,400) KFONT, NINT(X), NINT(YTEMP),
     +                                 LEGEND(I)(1:J)
                  ENDIF
                  YTEMP = YTEMP - Z_SCALE*YSPACE
               ENDDO
            ENDIF
            WRITE (NOUT,500)
C
C Close the file
C
            CLOSE (UNIT = NOUT)
C
C Return to main branch point
C
            READY = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'View'
     +/'Edit'
     +/'Set X-start [',F8.3,' in]'
     +/'Set Y-start [',F8.3,' in]'
     +/'Set line width [',F8.3,' in]'
     +/'Set scale factor [',F8.3,']'
     +/'Display PS fonts and octal codes'
     +/'Help'
     +/'Accept (include extra file in overlay)'
     +/'Cancel (exclude extra file from overlay)')
  200 FORMAT (
     + 'New ',A,' required ( > 0.01 ): Current value =',F8.4)
  300 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
c****+/'%%BeginDocument'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: w.g.bardsley@gmail.com'
     +/'%%Title: editps/simfit (Version 7.8.5)'
     +/'%%EndComments')
  400 FORMAT (
     +'/Times-Roman findfont',I5,' scalefont setfont'
     +/2I8,' moveto'
     +/'(',A,') show')
  500 FORMAT (
     +'showpage')
c****+/'%%EndDocument')
      END
C
C
