C
C
      SUBROUTINE EDITPS_PSCAPS (NFILES,
     +                          CAPTSAV, CAPTION,
     +                          NEWDAT)
C
C ACTION: Edit collage captions
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 18/05/2000
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITPS_PSCAPS
C         16/08/2018 edited to make editing users captions easier
C
C  NFILES: number of files in the collage
C CAPTSAV: user-defined captions
C CAPTION: automatic captions
C  NEWDAT: initialise CAPTSAV and CAPTION to BLANK then return      
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTSAV(NFILES),
     +                                       CAPTION(NFILES)      
      LOGICAL,             INTENT (IN)    :: NEWDAT
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N26, N50, N96
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N26 = 26,
     +           N50 = 50, N96 = 96)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 8)
      INTEGER    NUMPOS(N50)
      INTEGER    I, L, NDEC, NEXT, NFP1, NUMDEC
      INTEGER    LEN200
      CHARACTER (LEN = 100) TEXT(N50), LINE
      CHARACTER (LEN = 72 ) WORD72
      CHARACTER (LEN = 70 ) PREFIX
      CHARACTER (LEN = 11 ) CIPHER(N5)
      CHARACTER (LEN = 10 ) SELEKT
      CHARACTER (LEN = 2  ) WORD2
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ', SELEKT = '[Selected]')
      LOGICAL    AGAIN, REPEET
      EXTERNAL   GETSTR, LBOX02, LEN200, TRIML1, PUTADV
      EXTERNAL   STRCHK$
      INTRINSIC  CHAR, MIN
      SAVE       CIPHER, PREFIX, NEXT
      DATA       NUMPOS / N50*N1 /
      DATA       CIPHER / N4*BLANK, N1*SELEKT /
      DATA       PREFIX / 'Fig.' /
      DATA       NEXT / N1 /
      IF (NEWDAT) THEN
C
C Initialise if NEWDAT = .TRUE.
C
         DO I = N1, N4
            CIPHER(I) = BLANK
         ENDDO
         CIPHER(N5) = SELEKT
         DO I = N1, NFILES
            CAPTION(I) = BLANK
            WRITE (CAPTSAV(I),200) 'Figure', I 
         ENDDO
         NEXT = N1
         RETURN
      ENDIF
C
C o/w User chooses from a menu
C
      AGAIN = .TRUE.
      NUMDEC = NUMOPT
      DO WHILE (AGAIN)
         L = LEN200(PREFIX)
         IF (L.GT.N0) THEN
            WORD72 = '['//PREFIX(N1:L)//']'
         ELSE
            WORD72 = BLANK
         ENDIF
         WRITE (TEXT,100) (CIPHER(I), I = N1, N4), WORD72, CIPHER(N5)
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         AGAIN = .TRUE.
         IF (NFILES.GT.N26) THEN
            IF (NUMDEC.EQ.N3 .OR. NUMDEC.EQ.N4) THEN
               CALL PUTADV ('There are only 26 letters in the alphabet')
            ENDIF
         ENDIF
         IF (NUMDEC.GE.N2.AND.NUMDEC.LE.N5 .OR. NUMDEC.EQ.N7) THEN
            DO I = N1, N5
               CIPHER(I) = BLANK
            ENDDO
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Edit users captions
C
            REPEET = .TRUE.
            DO WHILE (REPEET) 
               IF (NEXT.GE.NFILES) NEXT = N1
               DO I = N1, NFILES
                  TEXT(I) = CAPTSAV(I)
               ENDDO 
               NFP1 = NFILES + N1
               TEXT(NFP1) = 'Apply'
               NDEC = NEXT
               CALL LBOX02 (ICOLOR, IX, IY, NDEC, NFP1, NUMPOS,
     +                      TEXT)
               IF (NDEC.LE.NFILES) THEN
                  NEXT = NDEC + N1
                  I = NDEC
                  WRITE (LINE,'(A,I3)') 'Caption required for figure', I 
                  CALL GETSTR (LINE, CAPTSAV(I))
                  CALL STRCHK$(CAPTSAV(I))
               ELSE
                  REPEET = .FALSE.   
               ENDIF
               NUMDEC = NUMOPT
            ENDDO
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Users captions
C
            DO I = N1, NFILES
               CAPTION(I) = CAPTSAV(I)
            ENDDO
            CIPHER(N1) = SELEKT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Prefix-capitals
C
            L = LEN200(PREFIX)
            DO I = N1, MIN(N26,NFILES)
               IF (L.GT.N0) THEN
                  WRITE (CAPTION(I),300) PREFIX(N1:L), CHAR(64 + I)
               ELSE
                  WRITE (CAPTION(I),400) CHAR(64 + I)
               ENDIF
            ENDDO
            CIPHER(N2) = SELEKT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Prefix-letters
C
            L = LEN200(PREFIX)
            DO I = N1, MIN(N26,NFILES)
               IF (L.GT.N0) THEN
                  WRITE (CAPTION(I),300) PREFIX(N1:L), CHAR(N96 + I)
               ELSE
                  WRITE (CAPTION(I),400) CHAR(N96 + I)
               ENDIF
            ENDDO
            CIPHER(N3) = SELEKT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Pre-fix numbers
C
            L = LEN200(PREFIX)
            DO I = N1, NFILES
               WRITE (WORD2,500) I
               CALL TRIML1 (WORD2)
               IF (L.GT.N0) THEN
                  WRITE (CAPTION(I),300) PREFIX(N1:L), WORD2
               ELSE
                  WRITE (CAPTION(I),400) WORD2
               ENDIF
            ENDDO
            CIPHER(N4) = SELEKT
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C Edit prefix
C
            CALL GETSTR ('New prefix required', PREFIX)
            CALL STRCHK$(PREFIX)
            DO I = N1, N4
               CIPHER(I) = BLANK
            ENDDO
            DO I = N1, NFILES
               CAPTION(I) = BLANK
            ENDDO
            CIPHER(N5) = SELEKT
            CALL PUTADV (
     +'Now choose the caption type required for this new prefix')
            AGAIN = .TRUE.
            DO I = N1, N5
               IF (CIPHER(I).NE.BLANK) THEN
                  IF (I.LT.N5) THEN
                     NUMDEC = I + N1
                  ELSE
                     NUMDEC = N7
                  ENDIF
               ENDIF
            ENDDO
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C Suppress captions
C
            DO I = N1, NFILES
               CAPTION(I) = BLANK
            ENDDO
            CIPHER(N5) = SELEKT
            NUMDEC = NUMOPT
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Create/Edit/View your own captions'
     +/'Use your own captions ',A
     +/'Use prefix-capitals ',A
     +/'Use prefix-lower case ',A
     +/'Use prefix-numbers ',A
     +/'Edit caption prefix ',A
     +/'Suppress all captions ',A
     +/'Apply')
  200 FORMAT (A,I3)
  300 FORMAT (A,1X,A)
  400 FORMAT (A)
  500 FORMAT (I2)
      END
C
C