C

C
C
      SUBROUTINE EDITPS_PSCHOP (NMAX, NNEW, 
     +                          TXTNEW, TXTOLD)
C
C ACTION: Chop a string into pieces at {anything} for PS printing
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 11/05/2000
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITPS_PSCHOP
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NMAX
      INTEGER,             INTENT (OUT)   :: NNEW
      CHARACTER (LEN = *), INTENT (IN)    :: TXTOLD(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TXTNEW(10*NMAX)
C
C Locals
C      
      INTEGER    I, IADD1, L, NSTART, NSTOP
      INTEGER    NBIG
      PARAMETER (NBIG = 500)
      CHARACTER  STRNG*100, TEMP*100, TXTCPY(NBIG)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      INTRINSIC  INDEX, LEN
C
C Initialise NNEW then copy the text except for blank lines
C
      NNEW = 0
      IADD1 = 0
      DO I = 1, NMAX
         IF (TXTOLD(I).NE.BLANK) THEN
            IADD1 = IADD1 + 1
            TXTCPY(IADD1) = TXTOLD(I)
         ENDIF
      ENDDO
C
C Return if no blank lines
C
      IF (IADD1.EQ.0) RETURN
C
C Parse the strings
C
      L = LEN(TXTOLD(1))
      DO I = 1, IADD1
         STRNG = TXTCPY(I)
         NSTART = INDEX(STRNG, '{')
         NSTOP = INDEX(STRNG, '}')
         DO WHILE (NSTOP.GT.NSTART)
            IF (NSTART.GT.1) THEN
               TEMP = STRNG(1:NSTART - 1)
               IF (TEMP.NE.BLANK) THEN
                  NNEW = NNEW + 1
                  TXTNEW(NNEW) = TEMP
               ENDIF
            ENDIF
            NNEW = NNEW + 1
            TXTNEW(NNEW) = STRNG(NSTART:NSTOP)
            IF (NSTOP.LT.L) THEN
               TEMP = STRNG(NSTOP + 1:L)
               STRNG = TEMP
               NSTART = INDEX(STRNG, '{')
               NSTOP = INDEX(STRNG, '}')
            ELSE
               STRNG = BLANK
               NSTART = 0
               NSTOP = 0
            ENDIF
         ENDDO
         IF (STRNG.NE.BLANK) THEN
            NNEW = NNEW + 1
            TXTNEW(NNEW) = STRNG
         ENDIF
      ENDDO
      END
C
C
