
C
C
      SUBROUTINE EDITPS_REPLOT (NHIGH, NIN, NFILES, NMAX, NOUT, NWIDE,
     +                          BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE,
     +                          CAPTION, FNAME, LEGEND, XTRA1, XTRA2,
     +                          XTRA3)
C
C ACTION : Stack PostScript files in free-style mode
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          12/06/2000 added PSADD1
C          02/02/2008 added INTENTS
C          07/01/2009 renamed EDITPS_REPLOT
C          20/03/2021 added %%BeginDocument and %%EndDocument
C          20/03/2021 commented out extra DSC comments
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NIN, NMAX,
     +                                       NOUT, NWIDE
      INTEGER,             INTENT (INOUT) :: NFILES
      DOUBLE PRECISION,    INTENT (INOUT) :: BBOXX(2,NMAX + 1), 
     +                                       BBOXY(2,NMAX + 1),
     +                                       XTRANS(NMAX + 1),
     +                                       YTRANS(NMAX + 1), 
     +                                       ZSCALE(NMAX + 1)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: CAPTION(NMAX),
     +                                       LEGEND(NHIGH)
      CHARACTER (LEN = *), INTENT (INOUT) :: XTRA1
      CHARACTER (LEN = *), INTENT (INOUT) :: XTRA2(NHIGH),
     +                                       XTRA3(10*NHIGH)
C
C Locals
C      
      INTEGER    I, IBOT, IMID, IOS, ISEND, ITOP, NLEG
      INTEGER    IXBB1, IXBB2, IYBB1, IYBB2, NFILE1
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 10)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION XTEMP1, XTEMP2, X1, X2, YTEMP1, YTEMP2, Y1, Y2
      DOUBLE PRECISION XADD, XDIFF, YADD, YDIFF
      DOUBLE PRECISION XSAV, YSAV, ZSAV
      DOUBLE PRECISION F72, ZERO, ONE
      PARAMETER (F72 = 72.0D+00, ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  LINE*120, TEXT(NUMOPT)*100, TITLE*1
      LOGICAL    ABORT, EXTRA
      LOGICAL    FIRST, FULL, IWARNU
      PARAMETER (FIRST = .FALSE., FULL = .FALSE., IWARNU = .TRUE.)
      EXTERNAL   EDITPS_LPTCOM, EDITPS_PS2PLT, EDITPS_ADVISE 
      EXTERNAL   TRIML1, YESNO2, LBOX02, GETJM1, GETD01, W_PLOTSQ
      EXTERNAL   ISITPS, EDITPS_PSADD1
      INTRINSIC  NINT, DBLE
      SAVE       IMID
      DATA       IMID / 1 /
      DATA       NUMPOS / NUMOPT*1 /
C
C SECTION 1: Read in possible files and check them
C ==========
C
      CALL EDITPS_PS2PLT (NFILES, NHIGH, NIN, NLEG, NMAX, NWIDE,
     +                    CAPTION, FNAME, LEGEND, TITLE,
     +                    FULL)
      IF (NFILES.LT.1) RETURN
      DO I = N1, NFILES
C
C Open file and find BoundingBox coordinates
C
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME(I))
         CALL ISITPS (NIN, XTEMP1, XTEMP2, YTEMP1, YTEMP2, ABORT,
     +                IWARNU)
         CLOSE (UNIT = NIN)
C
C Make corrections for the scaling factors
C
         BBOXX(N1,I) = XTEMP1
         BBOXX(N2,I) = XTEMP2
         BBOXY(N1,I) = YTEMP1
         BBOXY(N2,I) = YTEMP2
      ENDDO
C
C Create the extra text file but suppress it
C
      ISEND = 10
      CALL EDITPS_PSADD1 (ISEND, IXBB1, IXBB2, IYBB1, IYBB2,
     +                    NHIGH, NOUT, NWIDE,
     +                    XTRA1, XTRA2, XTRA3,
     +                    EXTRA)
      NFILE1 = NFILES + N1
      XSAV = XTRANS(NFILE1)
      YSAV = YTRANS(NFILE1)
      ZSAV = ZSCALE(NFILE1)
      XTRANS(NFILE1) = ZERO
      YTRANS(NFILE1) = ZERO
      ZSCALE(NFILE1) = ONE
      BBOXX(N1,NFILE1) = DBLE(IXBB1)
      BBOXX(N2,NFILE1) = DBLE(IXBB2)
      BBOXY(N1,NFILE1) = DBLE(IYBB1)
      BBOXY(N2,NFILE1) = DBLE(IYBB2)
      FNAME(NFILE1) = XTRA1
      NFILE1 = NFILES
C
C SECTION 2: Main loop to drive printer or write file as required
C ==========
C
   20 CONTINUE
      WRITE (TEXT,100)
      NUMDEC = NUMOPT - 4
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
      IF (NUMDEC.EQ.NUMOPT) THEN
         LINE = 'This action will release selected files ... Proceed ?'
         ABORT = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, LINE, ABORT)
         IF (ABORT) THEN
            NFILE1 = NFILES + N1
            XTRANS(NFILE1) = XSAV
            YTRANS(NFILE1) = YSAV
            ZSCALE(NFILE1) = ZSAV
            RETURN
         ELSE
            GOTO 20
         ENDIF
      ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
         CALL EDITPS_ADVISE (ABORT, FIRST)
         GOTO 20
      ELSEIF (NUMDEC.LT.NUMOPT - 6) THEN
         IF (NFILE1.GT.1) THEN
            WRITE (LINE,200)
            IBOT = N1
            ITOP = NFILE1
            IF (IMID.LT.IBOT .OR. IMID.GT.ITOP) IMID = IBOT
            CALL GETJM1 (IBOT, IMID, ITOP, LINE)
         ELSE
            IMID = N1
         ENDIF
         IF (NUMDEC.EQ.1) THEN
            WRITE (LINE,300) XTRANS(IMID)
            CALL GETD01 (XTRANS(IMID), LINE)
         ELSEIF (NUMDEC.EQ.2) THEN
            WRITE (LINE,400) YTRANS(IMID)
            CALL GETD01 (YTRANS(IMID), LINE)
         ELSE
            WRITE (LINE,500) ZSCALE(IMID)
            CALL GETD01 (ZSCALE(IMID), LINE)
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT - 5) THEN
         ISEND = N2
         CALL EDITPS_PSADD1 (ISEND, IXBB1, IXBB2, IYBB1, IYBB2,
     +                       NHIGH, NOUT, NWIDE,
     +                       XTRA1, XTRA2, XTRA3,
     +                       EXTRA)
         BBOXX(N1,NFILES + N1) = DBLE(IXBB1)
         BBOXX(N2,NFILES + N1) = DBLE(IXBB2)
         BBOXY(N1,NFILES + N1) = DBLE(IYBB1)
         BBOXY(N2,NFILES + N1) = DBLE(IYBB2)
         IF (EXTRA) THEN
            NFILE1 = NFILES + N1
         ELSE
            NFILE1 = NFILES
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.LT.NUMOPT - 4) THEN
         CALL W_PLOTSQ (NFILE1, 
     +                  BBOXX, BBOXY, XTRANS, YTRANS, ZSCALE)
         NUMDEC = NUMOPT - 4
         GOTO 20
      ENDIF
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      IF (NUMDEC.EQ.NUMOPT - 4) THEN
         CALL EDITPS_LPTCOM (NOUT, 'VIEW', ABORT)
      ELSEIF (NUMDEC.EQ.NUMOPT - 3) THEN
         CALL EDITPS_LPTCOM (NOUT, 'PDF', ABORT)
      ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
         CALL EDITPS_LPTCOM (NOUT, 'FILE', ABORT)
      ENDIF
      IF (ABORT) GOTO 20
C
C SECTION 3: Bounding Box and other coordinates then switch off showpage
C =========
C
      DO I = 1, NFILE1
C
C Make corrections for the scaling factors
C
         XADD = F72*XTRANS(I)
         YADD = F72*YTRANS(I)
         XTEMP1 = BBOXX(N1,I)
         XTEMP2 = BBOXX(N2,I)
         YTEMP1 = BBOXY(N1,I)
         YTEMP2 = BBOXY(N2,I)
         XDIFF = ZSCALE(I)*(XTEMP2 - XTEMP1)
         YDIFF = ZSCALE(I)*(YTEMP2 - YTEMP1)
         XTEMP1 = XTEMP1 + XADD
         XTEMP2 = XTEMP1 + XDIFF
         YTEMP1 = YTEMP1 + YADD
         YTEMP2 = YTEMP1 + YDIFF
C
C Find the extreme positions for the overall BoundingBox
C
         IF (I.EQ.1) THEN
            X1 = XTEMP1
            X2 = XTEMP2
            Y1 = YTEMP1
            Y2 = YTEMP2
         ELSE
            IF (XTEMP1.LT.X1) X1 = XTEMP1
            IF (XTEMP2.GT.X2) X2 = XTEMP2
            IF (YTEMP1.LT.Y1) Y1 = YTEMP1
            IF (YTEMP2.GT.Y2) Y2 = YTEMP2
         ENDIF
      ENDDO
C
C Write the overall BoundingBox coordinates to the file
C
      WRITE (NOUT,600) NINT(X1), NINT(Y1), NINT(X2), NINT(Y2)
C
C SECTION 4: Loop over each file selected
C ==========
C
      DO I = 1, NFILE1
C
C Open file and discard first line
C
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME(I))
         READ (NIN,700) LINE
C
C Save, translate then scale each file
C
         XADD =  F72*XTRANS(I) + BBOXX(N1,I)*(ONE - ZSCALE(I))
         YADD =  F72*YTRANS(I) + BBOXY(N1,I)*(ONE - ZSCALE(I))
         WRITE (NOUT,800) NINT(XADD), NINT(YADD),
     +                    ZSCALE(I), ZSCALE(I)
         IOS = 0
C
C Read in from NIN and write out to NOUT until EOF
C
         DO WHILE (IOS.EQ.0)
            READ (NIN,700,END=40,ERR=40,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 40
            CALL TRIML1 (LINE)
            IF (LINE(1:14).NE.'%%BoundingBox:') WRITE (NOUT,700) LINE
         ENDDO
C
C Restore then close down the file on NIN
C
   40    CONTINUE
         WRITE (NOUT,900)
         CLOSE (UNIT = NIN)
      ENDDO
C
C SECTION 5: Loop has gone through all files so switch showpage on again
C ==========
C
      WRITE (NOUT,1000)
C
C SECTION 8: Drive the printer by copying the file on NOUT
C ==========
C
      CALL EDITPS_LPTCOM (NOUT,
     +                    'CLOSE',
     +                    ABORT)
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'X-translation (numerical editing)'
     +/'Y-translation (numerical editing)'
     +/'Scaling factor (numerical editing)'
     +/'Translate/Scale (graphical editing)'
     +/'Edit/Include/Suppress extra text'
     +/'View/Print/Save As (PS driver)'
     +/'View/Print/Save As (PDF reader)'
     +/'Create an EPS file'
     +/'Help'
     +/'Cancel')
  200 FORMAT ('Number of the file for editing')
  300 FORMAT ('Value for X-translation in inches: current value =',F8.3)
  400 FORMAT ('Value for Y-translation in inches: current value =',F8.3)
  500 FORMAT ('Value for scaling factor: current value =',F8.3)
  600 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
c****+/'%%BeginDocument'
     +/'%%BoundingBox:',4I6
     +/'%%Creator: w.g.bardsley@gmail.com'
     +/'%%Title: editps/simfit (7.8.5)'
     +/'%%EndComments'
     +/'save %save before switching off showpage'
     +/'/switchoffshowpage 20 dict def'
     +/'switchoffshowpage begin'
     +/'/showpage {} def')
  700 FORMAT (A)
  800 FORMAT ('save ',2I6,' translate',2f8.3,' scale')
  900 FORMAT ('restore')
 1000 FORMAT (
     +'end %end of switchoffshowpage dictionary'
     +/'restore %restore to switch showpage back on'
     +/'showpage')
c****+/'%%EndDocument')
      END
C
C
