C
C
C
C
      SUBROUTINE EDITPS_TXT2PS (NHIGH, NOUT, NWIDE,
     +                          X_MARGIN, Y_HEIGHT, Z_SCALE, Z_WIDE,
     +                          LEGEND, TXTNEW)
C
C ACTION: Create a PS text file
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 18/05/2000
C         02/02/2008 added INTENTS
C         07/01/2009 renamed EDITS_TXT2PS 
C         20/03/2021 added %%BeginDocument and %%EndDocument
C         20/03/2021 commented out extra DSC comments
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHIGH, NOUT, NWIDE
      DOUBLE PRECISION,    INTENT (INOUT) :: X_MARGIN, Y_HEIGHT,
     +                                       Z_SCALE, Z_WIDE
      CHARACTER (LEN = *), INTENT (INOUT) :: LEGEND(NHIGH),
     +                                       TXTNEW(10*NHIGH)
C
C Locals
C      
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, NUMOPT = 9)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    IX1BB, IX2BB, IY1BB, IY2BB
      INTEGER    JFONT, KFONT
      INTEGER    I, J, L, LEN200, NLEG, NNEW
      DOUBLE PRECISION YSPACE, YSTOP
      PARAMETER       (YSPACE = 16.0D+00, YSTOP = 36.0D+00)
      DOUBLE PRECISION X, XDIFF, Y, YTEMP
      DOUBLE PRECISION PNT01
      PARAMETER (PNT01 = 0.01D+00)
      DOUBLE PRECISION F12, F14, F72
      PARAMETER (F12 = 12.0D+00, F14 = 14.0D+00, F72 = 72.0D+00)
      CHARACTER  LINE*120, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, FIRST
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    WRAP, WRAP1
      PARAMETER (WRAP1 = .TRUE.)
      EXTERNAL   LBOX02, GETDGE, LEN200, EDITTX
      EXTERNAL   STRCHK$, STRPRN$, PSCODE$
      EXTERNAL   EDITPS_ADVISE, EDITPS_LPTCOM
      EXTERNAL   EDITPS_PSCHOP, EDITPS_PSCURL
      INTRINSIC  NINT
      SAVE       NLEG
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NLEG / 0 /
      NUMDEC = N2
   20 CONTINUE
      WRITE (TEXT,100) X_MARGIN, Y_HEIGHT, Z_WIDE, Z_SCALE
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NUMDEC.EQ.2) THEN
         CALL EDITTX (NHIGH, NLEG, NWIDE,
     +                LEGEND)
         IF (NLEG.GT.0) THEN
            DO I = 1, NLEG
               CALL STRCHK$(LEGEND(I))
            ENDDO
         ENDIF
         GOTO 20
      ELSEIF (NUMDEC.EQ.3) THEN
         WRITE (LINE,200) X_MARGIN
         CALL GETDGE (X_MARGIN, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.4) THEN
         WRITE (LINE,300) Y_HEIGHT
         CALL GETDGE (Y_HEIGHT, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.5) THEN
         WRITE (LINE,400) Z_WIDE
         CALL GETDGE (Z_WIDE, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.6) THEN
         WRITE (LINE,500) Z_SCALE
         CALL GETDGE (Z_SCALE, PNT01,
     +                LINE)
         GOTO 20
      ELSEIF (NUMDEC.EQ.7) THEN
         CALL PSCODE$
         GOTO 20
      ELSEIF (NUMDEC.EQ.8) THEN
         CALL EDITPS_ADVISE (ABORT, FIRST)
         GOTO 20
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
         RETURN
      ENDIF
C
C Calculate PostScript parameters ... First X and Y
C
      X = X_MARGIN*F72
      Y = Y_HEIGHT*F72
C
C Now XDIFF etc.
C

      YTEMP = Y - NINT(Z_SCALE*YSPACE)
      XDIFF = Z_WIDE*F72
      IX1BB = NINT(X)
      IX2BB = NINT(X + XDIFF)
      IY1BB = NINT(Y)
      IY1BB = IY1BB - (NLEG + N1)*NINT(Z_SCALE*YSPACE)
      IY2BB = NINT(Y)
      JFONT = NINT(F14*Z_SCALE)
      KFONT = NINT(F12*Z_SCALE)
C
C Main loop to drive printer or write file as required
C
      CALL EDITPS_LPTCOM (NOUT, 'OPEN', ABORT)
      IF (ABORT) GOTO 20
C
C Bounding Box and other coordinates
C
      WRITE (NOUT,600) IX1BB, IY1BB, IX2BB, IY2BB
      WRAP = WRAP1
      IF (WRAP) THEN
C
C Initialise STRPRN$ to print strings
C
         CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                BLANK, 'OPEN')
C
C Initialise PSCURL to print {commands}
C
         L = 0
         CALL EDITPS_PSCURL (KFONT, L, NOUT,
     +                       LINE)
C
C Chop out {commands}
C
         CALL EDITPS_PSCHOP (NHIGH, NNEW,
     +                       TXTNEW, LEGEND)
         DO I = 1, NNEW
            LINE = TXTNEW(I)
            L = LEN200(LINE)
            IF (LINE(1:1).EQ.'{' .AND. LINE(L:L).EQ.'}' .AND.
     +          L.GT.2) THEN
C
C Print {command} using PSCURL
C
               CALL EDITPS_PSCURL (KFONT, L, NOUT,
     +                             LINE)
            ELSE
C
C Print ragged right using STRPRN$
C
               CALL STRPRN$(JFONT, IX1BB, IX2BB, NINT(YTEMP), NOUT,
     +                      TXTNEW(I), BLANK)
            ENDIF
         ENDDO
      ELSE
         DO I = 1, NLEG
            IF (LEGEND(I).NE.BLANK .AND. YTEMP.GE.YSTOP) THEN
               J = LEN200(LEGEND(I))
               WRITE (NOUT,700) KFONT, NINT(X), NINT(YTEMP),
     +                           LEGEND(I)(1:J)
            ENDIF
            YTEMP = YTEMP - Z_SCALE*YSPACE
         ENDDO
      ENDIF
      WRITE (NOUT,800)
C
C Drive the printer by copying the file on NOUT
C
      CALL EDITPS_LPTCOM (NOUT,
     +                    'CLOSE',
     +                    ABORT)
C
C Return to main branch point
C
      GOTO 20
C
C Format statements
C      
  100 FORMAT (
     + 'Print/view/file'
     +/'Edit the text'
     +/'Set X-margin [',F8.3,' in]'
     +/'Set Y-height [',F8.3,' in]'
     +/'Set line width[',F8.3,' in]'
     +/'Set scaling factor [',F8.3,']'
     +/'Display PS fonts and octal codes'
     +/'Help'
     +/'Cancel')
  200 FORMAT (
     + 'New X-margin required ( > 0.01 ): Current value =',F8.4)
  300 FORMAT (
     + 'New Y-height required ( > 0.01 ): Current value =',F8.4)
  400 FORMAT (
     + 'New line width required ( > 0.01 ): Current value =',F8.4)
  500 FORMAT (
     + 'New scaling factor required ( > 0.01 ): Current value =',F8.4)
  600 FORMAT (
     + '%!PS-Adobe-3.0 EPSF-3.0'
c****+/'%%BeginDocument'     
     +/'%%BoundingBox:',4I6
     +/'%%Creator: w.g.bardsley@gmail.com'
     +/'%%Title: editps/simfit (7.8.5)'
     +/'%%EndComments')
  700 FORMAT (
     +'/Times-Roman findfont',I5,' scalefont setfont'
     +/2I8,' moveto'
     +/'(',A,') show')
  800 FORMAT (
     +'showpage')
c****+/'%%EndDocument')     
      END
C
C
