c
c
      subroutine elips1 (n,
     +                   resul, x, y)
c
c action: plot a bivariate contour after a previous call to G02CAF
c author: w.g.bardsley, University of manchester, U.K., 02/05/2005
c         13/03/2007 removed % after 95% 
c         23/03/2007 added intents
c
c             n: (input/unchanged) dimension
c         resul: (input/unchanged) as from a previous call to G02CAF
c                xbar = resul(1) ... sample mean for X
c                ybar = resul(2) ... sample mean for Y
c                xsig = resul(3) ... sample standard deviation for X
c                ysig = resul(4) ... sample standard deviation for Y
c                   r = resul(5) ... sample correlation coefficient
c             x: (input/unchanged) x-data
c             y: (input/unchanged) y-data
c
      implicit   none
c
c arguments
c
      integer,          intent (in) :: n
      double precision, intent (in) :: resul(5), x(n), y(n)
c
c locals
c
      integer    isend
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 5,
     +           numtxt = 20)
      integer    numbld(30), numpos(numopt)
      integer    ngraf
      parameter (ngraf = 120)
      double precision alpha, p, r,
     +                 xbar, xgraf(ngraf), xsig,
     +                 ybar, ygraf(ngraf), ysig
      double precision one, pcent, p1, p2
      parameter (one = 1.0d+00, pcent = 100.0d+00, p1 = 10.0d+00,
     +           p2 = 99.9d+00)
      character  ptitle*70, xtitle*10, ytitle*10
      parameter (xtitle = 'x', ytitle = 'y')
      character  line*100, text(30)*100
      logical    abort, repeet
      logical    border
      parameter (border = .false.)
      external   elips2, getdm1, putfat, lbox02, patch1
      save       alpha
      data       alpha / 0.05d+00 /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
c
c copy the arguments from resul
c
      xbar = resul(1)
      ybar = resul(2)
      xsig = resul(3)
      ysig = resul(4)
      r = resul(5)
c
c main loop
c
      repeet = .true.
      do while (repeet)
         p = pcent*(one - alpha)
         write (text,100) p
         numdec = numopt - 1
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                text)
         if (numdec.le.2) then
c
c plot
c
            isend = numdec
            if (isend.eq.1) then
               write (ptitle,200) p
            else
               write (ptitle,300) p
            endif
            call elips2 (isend, n, ngraf,
     +                   alpha, r,
     +                   x, xbar, xgraf, xsig,
     +                   y, ybar, ygraf, ysig,
     +                   ptitle, xtitle, ytitle,
     +                   abort)
            if (abort) then
               write (line,400)
               call putfat (line)
            endif
         elseif (numdec.eq.3) then
c
c change alpha
c
            write (line,500)
            call getdm1 (p1, p, p2, line)
            alpha = one - p/pcent
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,600)
            numbld(1) = 1
            numbld(7) = 1
            numbld(12) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
            numbld(7) = 0
            numbld(12) = 0
         else
c
c cancel
c
            repeet = .false.
         endif
      enddo  
c
c format statements
c      
  100 format (
     + 'Plot mean confidence ellipse'
     +/'Plot data confidence ellipse'
     +/'Change percent significance (',f8.2,'%)'
     +/'Help'
     +/'Cancel')
  200 format ('Mean',f8.2,'% confidence ellipse')
  300 format ('Data',f8.2,'% confidence ellipse')
  400 format ('n < 3, r out of range, or variance of X or Y too small')
  500 format ('Percentage significance required (usually 95)')
  600 format (
     + 'Probability contours for a bivariate normal distribution'
     +/
     +/'The contours of equal probability for a bivariate normal'
     +/'distribution are ellipses, and it can be useful to plot such'
     +/'contours overlayed on the X,Y data for two reasons.'
     +/
     +/'Visualising a 95% confidence region for the mean'
     +/'This will only be useful for small samples (say n < 20), as the'
     +/'axes-lengths vary inversely with sample size n. The ellipses'
     +/'will contains the true mean with 95% probability under H0.'
     +/
     +/'Visualising a 95% confidence region for the data'
     +/'This plots a region that will contain an additional measurement'
     +/'with 95% probability under H0. It is more useful as it lets you'
     +/'visualise how closely the swarm of x,y points suggest a bell-'
     +/'shaped probability surface. More importantly, if the variables'
     +/'X and Y are uncorrelated, the major and minor axes of the'
     +/'ellipses will be parallel to the plot axes, and inclination'
     +/'away from this orientation indicates significant correlation.'
     +/'This ellipse does not shrink as the sample size increases.')
      end
c
c
