c
c
      subroutine elips2 (isend, n, ngraf,
     +                   alpha, r,
     +                   x, xbar, xgraf, xsig,
     +                   y, ybar, ygraf, ysig,
     +                   ptitle, xtitle, ytitle,
     +                   abort)
c
c action: plot a bivariate confidence contour
c author: w.g.bardsley, University of manchester, U.K., 02/05/2005 
c         23/03/2007 added intents
c
c         isend: (input/unchanged) isend = 1: mean confidence region
c                                  isend = 2: data confidence envelope
c             n: (input/unchanged) dimension of original data (n > 2)
c         ngraf: (input/unchanged) dimension of graph coordinates (ngraf > 3)
c         alpha: (input/unchanged) significance level (0 < alpha < 1)
c             r: (input/unchanged) correlation coefficent for original x,y-data
c                                  (0 < r < 1)
c             x: (input/unchanged) x-data
c          xbar: (input/unchanged) mean of original x-data
c         xgraf: (output) ellipse coordinates
c          xsig: (input/unchanged) sample sigma for original x-data
c             y: (input/unchanged) y-data
c          ybar: (input/unchanged) mean of original y-data
c         ygraf: (output) ellipse coordinates
c          ysig: (input/unchanged) sample sigma for original y-data
c        ptitle: (input/unchanged) plot title
c        xtitle: (input/unchanged) plot x-title
c        ytitle: (input/unchanged) plot y-title
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: isend, n, ngraf
      double precision,    intent (in)  :: alpha, r,
     +                                     x(n), xbar, xsig,
     +                                     y(n), ybar, ysig 
      double precision,    intent (out) :: xgraf(ngraf), ygraf(ngraf)
      character (len = *), intent (in)  :: ptitle, xtitle, ytitle
      logical,             intent (out) :: abort
c
c locals
c
      integer    i
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      parameter (l1 = 0, l2 = 1, l3 = 0, l4 = 0,
     +           m1 = 5, m2 = 0, m3 = 0, m4 = 0,
     +           n3 = 2, n4 = 2)
      double precision x3(2), x4(2), y3(2), y4(2)
      double precision zero
      parameter (zero = 0.0d+00)
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   elips3, gks004
c
c get the coordinates
c
      call elips3 (isend, n, ngraf,
     +             alpha, r,
     +             xbar, xgraf, xsig,
     +             ybar, ygraf, ysig,
     +             abort)
      if (abort) return
c
c initialise dummy arrays then define n1 and n2 and plot
c
      do i = 1, 2
         x3(i) = zero
         x4(i) = zero
         y3(i) = zero
         y4(i) = zero
      enddo
      n1 = n
      n2 = ngraf
      call gks004 (l1, l2, l3, l4,
     +             m1, m2, m3, m4,
     +             n1, n2, n3, n4,
     +             x, xgraf, x3, x4,
     +             y, ygraf, y3, y4,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave)
      end
c
c
